/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.mvc.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.sys.api.annotation.AntiRefresh;
import com.byh.sys.api.annotation.UserOptLogger;
import com.byh.sys.api.dto.treatmentItem.CheckSameFlagDto;
import com.byh.sys.api.dto.treatmentItem.OutTreatmentItemDto;
import com.byh.sys.api.dto.treatmentItem.SysTreatmentItemDto;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.SysTreatmentItemService;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/sysTreatmentItem"})
public class SysTreatmentItemController {
    @Autowired
    private CommonRequest commonRequest;
    @Autowired
    private SysTreatmentItemService sysTreatmentItemService;

    @ApiOperation(value="\u6821\u9a8c\u662f\u5426\u5b58\u5728\u5f85\u7f34\u8d39\u7684\u8bca\u7597\u9879\u76ee")
    @PostMapping(value={"/checkToBePaidItems"})
    public ResponseData checkToBePaidItems(@RequestBody OutTreatmentItemDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        return ResponseData.success((Object)this.sysTreatmentItemService.checkToBePaidItems(dto));
    }

    @PostMapping(value={"/checkSameFlag"})
    @ApiOperation(value="\u786e\u8ba4\u8bca\u7597\u9879\u76ee\u4e4b\u4e2d\u662f\u5426\u5b58\u5728\u76f8\u540c\u7684\u6536\u8d39\u9879\u76ee")
    public ResponseData checkSameFlag(@RequestBody CheckSameFlagDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        return ResponseData.success((Object)this.sysTreatmentItemService.checkSameFlag(dto));
    }

    @PostMapping(value={"/importTreatmentItemExcel"})
    @ApiOperation(value="\u5bfc\u5165\u8bca\u7597\u9879\u76eeExcel")
    @UserOptLogger(operation="\u8bca\u7597\u9879\u76ee\u6a21\u5757")
    public ResponseData importTreatmentItemExcel(@RequestPart(value="file") MultipartFile file) throws Exception {
        Integer tenantId = this.commonRequest.getTenant();
        Integer userId = this.commonRequest.getUserId();
        String userName = this.commonRequest.getUserName();
        this.sysTreatmentItemService.importTreatmentItemExcel(file, tenantId, userId, userName);
        return ResponseData.success((Object)"\u5bfc\u5165\u6210\u529f");
    }

    @PostMapping(value={"/exportTreatmentItemExcel"})
    @ApiOperation(value="\u5bfc\u51fa\u8bca\u7597\u9879\u76ee\u3001\u8bca\u7597\u6536\u8d39\u5173\u8054")
    public void exportTreatmentItemExcel(HttpServletResponse response) {
        Integer tenantId = this.commonRequest.getTenant();
        this.sysTreatmentItemService.exportTreatmentItemExcel(response, tenantId);
    }

    @PostMapping(value={"/insert"})
    @ApiOperation(value="\u65b0\u589e\u8bca\u7597\u9879\u76ee\uff0c\u5e76\u65b0\u589e\u5bf9\u5e94\u7684\u6536\u8d39\u9879\u76ee\u5173\u8054\u4fe1\u606f")
    @UserOptLogger(operation="\u8bca\u7597\u9879\u76ee\u6a21\u5757")
    public ResponseData insert(@RequestBody SysTreatmentItemDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        dto.setCreateId(this.commonRequest.getUserId());
        dto.setCreateName(this.commonRequest.getUserName());
        this.sysTreatmentItemService.insert(dto);
        return ResponseData.success().save();
    }

    @PutMapping(value={"/update"})
    @ApiOperation(value="\u7f16\u8f91\u8bca\u7597\u9879\u76ee")
    @UserOptLogger(operation="\u8bca\u7597\u9879\u76ee\u6a21\u5757")
    public ResponseData update(@RequestBody SysTreatmentItemDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        dto.setUpdateId(this.commonRequest.getUserId());
        dto.setUpdateName(this.commonRequest.getUserName());
        this.sysTreatmentItemService.update(dto);
        return ResponseData.success().update();
    }

    @PostMapping(value={"/list/update"})
    @ApiOperation(value="\u6279\u91cf\u7f16\u8f91\u8bca\u7597\u9879\u76ee")
    @UserOptLogger(operation="\u8bca\u7597\u9879\u76ee")
    public ResponseData updateList(@RequestBody List<SysTreatmentItemDto> dtoList) {
        for (SysTreatmentItemDto sysTreatmentItemDto : dtoList) {
            sysTreatmentItemDto.setTenantId(this.commonRequest.getTenant());
            sysTreatmentItemDto.setUpdateId(this.commonRequest.getUserId());
        }
        this.sysTreatmentItemService.updateList(dtoList);
        return ResponseData.success().update();
    }

    @DeleteMapping(value={"/list/delete"})
    @ApiOperation(value="\u5220\u9664\u8bca\u7597\u9879\u76ee")
    @UserOptLogger(operation="\u8bca\u7597\u9879\u76ee\u6a21\u5757")
    public ResponseData deleteList(@RequestBody Integer[] ids) {
        this.sysTreatmentItemService.deleteListByIds(ids);
        return ResponseData.success().delete();
    }

    @DeleteMapping(value={"/list/deleteDetail"})
    @ApiOperation(value="\u5220\u9664\u8bca\u7597\u9879\u76ee\u5bf9\u5e94\u7684\u6536\u8d39\u9879\u76ee\u5173\u8054\u660e\u7ec6")
    @UserOptLogger(operation="\u8bca\u7597\u9879\u76ee\u6a21\u5757")
    public ResponseData deleteDetailList(@RequestBody Integer[] ids) {
        this.sysTreatmentItemService.deleteDetailListByIds(ids);
        return ResponseData.success().delete();
    }

    @PostMapping(value={"/list/page/select"})
    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5bf9\u5e94\u7684\u8bca\u7597\u9879\u76ee\u5206\u9875\u5217\u8868\u6570\u636e\uff0c\u5e76\u643a\u5e26\u5bf9\u5e94\u7684\u6536\u8d39\u9879\u76ee\u5217\u8868\u4fe1\u606f")
    @AntiRefresh
    public ResponseData selectPageList(@RequestBody SysTreatmentItemDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        Page page = this.sysTreatmentItemService.selectPageList(dto);
        return ResponseData.success((Object)page);
    }

    @PostMapping(value={"/list/select"})
    @ApiOperation(value="\u6839\u636e\u8bca\u7597\u9879\u76ee\u7f16\u53f7\u96c6\u5408\u67e5\u8be2\u5bf9\u5e94\u7684\u8bca\u7597\u9879\u76ee\u5217\u8868\u4fe1\u606f")
    @AntiRefresh
    public ResponseData selectList(@RequestBody Integer[] ids) {
        List list = this.sysTreatmentItemService.selectList(ids);
        return ResponseData.success((Object)list);
    }

    @PostMapping(value={"/list/select/with/chargeItems"})
    @ApiOperation(value="\u6839\u636e\u8bca\u7597\u9879\u76eeid\u96c6\u5408\uff0c\u67e5\u8be2\u51fa\u8bca\u7597\u9879\u76ee\u5217\u8868\u4fe1\u606f\uff0c\u5e76\u643a\u5e26\u5bf9\u5e94\u7684\u6536\u8d39\u9879\u76ee\u5217\u8868\u4fe1\u606f")
    @AntiRefresh
    public ResponseData selectListWithChargeItems(@RequestBody Integer[] ids) {
        List list = this.sysTreatmentItemService.selectListWithChargeItems(ids);
        return ResponseData.success((Object)list);
    }

    @PostMapping(value={"/list/select/byTypes"})
    @ApiOperation(value="\u6839\u636e\u8bca\u7597\u7f16\u53f7ID\u96c6\u5408\uff0c\u7ed3\u5408\u8bca\u7597\u9879\u76ee\u7f16\u7801\u67e5\u8be2\u5bf9\u5e94\u7684\u8bca\u7597\u5217\u8868\u4fe1\u606f\uff0c\u5e76\u643a\u5e26\u5bf9\u5e94\u7684\u6536\u8d39\u9879\u76ee\u5217\u8868\u4fe1\u606f")
    @AntiRefresh
    public ResponseData selectListByTypes(@RequestBody SysTreatmentItemDto dto) {
        List list = this.sysTreatmentItemService.selectListByTypes(dto);
        return ResponseData.success((Object)list);
    }
}

