/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.mvc.controller.drug;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.sys.api.annotation.AntiRefresh;
import com.byh.sys.api.annotation.UserOptLogger;
import com.byh.sys.api.dto.SysDrugDto;
import com.byh.sys.api.dto.drug.SysDrugInDto;
import com.byh.sys.api.excel.listener.DrugListener;
import com.byh.sys.api.excel.listener.DrugVo;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.SysParamEntity;
import com.byh.sys.api.model.drug.SysDrugClassificationMiddleEntity;
import com.byh.sys.api.model.drug.SysDrugEntity;
import com.byh.sys.api.util.BeanUtil;
import com.byh.sys.api.util.EasyExcelUtil;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.api.vo.SysParamVo;
import com.byh.sys.api.vo.drug.ExportDrug;
import com.byh.sys.api.vo.drug.ExportDrugNew;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.SysDictService;
import com.byh.sys.web.service.SysDrugClassificationMiddleService;
import com.byh.sys.web.service.SysDrugService;
import com.byh.sys.web.service.SysParamService;
import enums.ConstantsEnums;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/drug"})
public class SysDrugController {
    private static final Logger log = LoggerFactory.getLogger(SysDrugController.class);
    private static Logger logger = LoggerFactory.getLogger(SysDrugController.class);
    private final SysDrugService sysDrugService;
    private final CommonRequest commonRequest;
    private final SysDrugClassificationMiddleService drugClassificationMiddleService;
    @Autowired
    private SysParamService paramService;
    private final SysDictService sysDictService;

    @ApiOperation(value="\u5bfc\u5165Excel\u66f4\u65b0\u836f\u54c1\u79cd\u7c7b")
    @PostMapping(value={"/importAndUpdateSpecies"})
    public ResponseData importAndUpdateSpecies(@RequestPart(value="file") MultipartFile file) throws Exception {
        this.sysDrugService.importAndUpdateSpecies(file, this.commonRequest.getTenant());
        return ResponseData.success((Object)"\u5bfc\u5165Excel\u66f4\u65b0\u836f\u54c1\u79cd\u7c7b\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u5bfc\u5165\u836f\u54c1\u56fe\u7247")
    @PostMapping(value={"/importDrugImg"})
    public ResponseData importDrugImg(@RequestPart(value="file") MultipartFile file) throws Exception {
        this.sysDrugService.importDrugImg(file, this.commonRequest.getTenant());
        return ResponseData.success((Object)"\u5bfc\u5165\u836f\u54c1\u56fe\u7247\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u5bfc\u5165\u5904\u65b9\u6d41\u8f6c\u836f\u54c1")
    @PostMapping(value={"/importDualDrug"})
    public ResponseData importDualDrug(@RequestPart(value="file") MultipartFile file) throws Exception {
        this.sysDrugService.importDualDrug(file, this.commonRequest.getTenant());
        return ResponseData.success((Object)"\u5bfc\u5165\u836f\u54c1\u56fe\u7247\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u5bfc\u5165\u66f4\u65b0\u5904\u65b9\u6d41\u8f6c\u836f\u54c1")
    @PostMapping(value={"/importUpdateDualDrug"})
    public ResponseData importUpdateDualDrug(@RequestPart(value="file") MultipartFile file) throws Exception {
        this.sysDrugService.importUpdateDualDrug(file, this.commonRequest.getTenant());
        return ResponseData.success((Object)"\u5bfc\u5165\u836f\u54c1\u56fe\u7247\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u5c06\u540c\u5584\u5802\u7684\u836f\u54c1\u8fdb\u884c\u836f\u623f\u5bfc\u5165\u64cd\u4f5c")
    @PostMapping(value={"/drugInventory"})
    @UserOptLogger(operation="\u836f\u54c1\u7ba1\u7406")
    public ResponseData drugInventory(@RequestBody SysDrugInDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        dto.setUserId(this.commonRequest.getUserId());
        this.sysDrugService.drugInventory(dto);
        return ResponseData.success((Object)"\u836f\u623f\u5165\u5e93\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u5206\u9875", httpMethod="GET", notes="\u5206\u9875")
    @GetMapping(value={"/pageList"})
    @AntiRefresh
    public ResponseData pageList(Page page, SysDrugDto dto) {
        Integer tenantId = this.commonRequest.getTenant();
        dto.setTenantId(tenantId);
        return ResponseData.success((Object)this.sysDrugService.pageList(page, dto));
    }

    @ApiOperation(value="\u5305\u542b\u6d41\u8f6c\u836f\u54c1\u7684\u5206\u9875", httpMethod="GET", notes="\u5206\u9875")
    @GetMapping(value={"/queryDrugPageContainLZ"})
    @AntiRefresh
    public ResponseData queryDrugPageContainLZ(Page page, SysDrugDto dto) {
        Integer tenantId = this.commonRequest.getTenant();
        dto.setTenantId(tenantId);
        return ResponseData.success((Object)this.sysDrugService.queryDrugPageContainLZ(page, dto));
    }

    @ApiOperation(value="\u91c7\u8d2d\u5355\u836f\u54c1\u5206\u9875", httpMethod="GET", notes="\u91c7\u8d2d\u5355\u836f\u54c1\u5206\u9875")
    @GetMapping(value={"/pageListByPurchase"})
    @AntiRefresh
    public ResponseData pageListByPurchase(Page page, SysDrugDto dto) {
        Integer tenantId = this.commonRequest.getTenant();
        dto.setTenantId(tenantId);
        return ResponseData.success((Object)this.sysDrugService.pageListByPurchase(page, dto));
    }

    @ApiOperation(value="\u836f\u54c1\u6a21\u5757 \u5bfc\u51fa", httpMethod="GET", notes="\u836f\u54c1\u6a21\u5757 \u5bfc\u51fa")
    @GetMapping(value={"/exportDrug"})
    @AntiRefresh
    public void exportDrug(HttpServletResponse response, SysDrugDto dto) {
        Integer tenantId = this.commonRequest.getTenant();
        String excelName = "\u836f\u54c1\u76ee\u5f55";
        String sheetName = "";
        if ("1".equals(dto.getDrugsType())) {
            sheetName = "\u4e2d\u6210\u836f\u76ee\u5f55";
        } else if ("2".equals(dto.getDrugsType())) {
            sheetName = "\u897f\u836f\u76ee\u5f55";
        } else if ("3".equals(dto.getDrugsType())) {
            sheetName = "\u4e2d\u836f\u76ee\u5f55";
        }
        SysParamEntity sysParamEntity = new SysParamEntity();
        sysParamEntity.setName("exportDrug");
        sysParamEntity.setTenantId(tenantId);
        SysParamVo sysParamVo = this.paramService.sysParamSelectByName(sysParamEntity);
        if (sysParamVo != null && "on".equals(sysParamVo.getValue())) {
            List records = this.sysDrugService.queryDrugByExport(dto);
            List exportList = BeanUtil.copyList((List)records, ExportDrugNew.class);
            EasyExcelUtil.exportExcelSheet((HttpServletResponse)response, (String)excelName, (String)sheetName, (Object)new ExportDrugNew(), (List)exportList, null);
        } else {
            dto.setTenantId(tenantId);
            Page page = new Page();
            page.setCurrent(1L);
            page.setSize(-1L);
            IPage sysDrugEntityIPage = this.sysDrugService.pageList(page, dto);
            List records = sysDrugEntityIPage.getRecords();
            List exportList = BeanUtil.copyList((List)records, ExportDrug.class);
            EasyExcelUtil.exportExcelSheet((HttpServletResponse)response, (String)excelName, (String)sheetName, (Object)new ExportDrug(), (List)exportList, null);
        }
    }

    @UserOptLogger(operation="\u836f\u54c1\u7ba1\u7406")
    @PostMapping(value={"/saveUpdate"})
    @Transactional(rollbackFor={BusinessException.class})
    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539", httpMethod="POST", notes="\u65b0\u589e\u6216\u4fee\u6539")
    public ResponseData saveUpdates(@RequestBody SysDrugEntity entity) {
        Integer classificationId;
        Integer tenantId = this.commonRequest.getTenant();
        entity.setTenantId(tenantId);
        entity.setSignNo(this.commonRequest.getSignNo());
        entity.setUserId(this.commonRequest.getUserId());
        entity.setUserName(this.commonRequest.getUserName());
        this.sysDrugService.saveUpdates(entity);
        if (entity.getClassificationId() != null && 0 != (classificationId = entity.getClassificationId())) {
            SysDrugClassificationMiddleEntity drugClassMiddleEntity = new SysDrugClassificationMiddleEntity();
            drugClassMiddleEntity.setClassificationId(classificationId);
            drugClassMiddleEntity.setDrugId(entity.getId());
            drugClassMiddleEntity.setTenantId(tenantId);
            SysDrugClassificationMiddleEntity one = (SysDrugClassificationMiddleEntity)this.drugClassificationMiddleService.getOne((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(SysDrugClassificationMiddleEntity::getDrugId, (Object)entity.getId())).eq(SysDrugClassificationMiddleEntity::getTenantId, (Object)tenantId));
            if (StrUtil.isEmptyIfStr((Object)one)) {
                this.drugClassificationMiddleService.save((Object)drugClassMiddleEntity);
            } else {
                this.drugClassificationMiddleService.update((Object)drugClassMiddleEntity, (Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(SysDrugClassificationMiddleEntity::getDrugId, (Object)entity.getId())).eq(SysDrugClassificationMiddleEntity::getTenantId, (Object)tenantId));
            }
        }
        return ResponseData.success();
    }

    @GetMapping(value={"/details"})
    @ApiOperation(value="\u8be6\u60c5", httpMethod="GET", notes="\u8be6\u60c5")
    public ResponseData details(SysDrugEntity entity) {
        Integer tenantId = this.commonRequest.getTenant();
        entity.setTenantId(tenantId);
        return ResponseData.success((Object)this.sysDrugService.details(entity));
    }

    @PostMapping(value={"/drugIdDetails"})
    @ApiOperation(value="\u901a\u8fc7\u836f\u54c1id \u8be6\u60c5", httpMethod="POST", notes="\u901a\u8fc7\u836f\u54c1id \u8be6\u60c5")
    public ResponseData<SysDrugEntity> drugIdDetails(@RequestBody SysDrugEntity entity) {
        SysDrugEntity one = (SysDrugEntity)this.sysDrugService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugEntity::getId, (Object)entity.getId())).eq(SysDrugEntity::getTenantId, (Object)this.commonRequest.getTenant())).eq(SysDrugEntity::getStatus, (Object)"0")).eq(SysDrugEntity::getDelFlag, (Object)ConstantsEnums.DEL_FLAG_ZERO.getValue()));
        return ResponseData.success((Object)one);
    }

    @PostMapping(value={"/newDrugIdDetails"})
    @ApiOperation(value="\u901a\u8fc7\u836f\u54c1id \u8be6\u60c5", httpMethod="POST", notes="\u9632\u6b62null\u503c\u5e8f\u5217\u5316\u9519\u8bef")
    public ResponseData<SysDrugEntity> newDrugIdDetails(@RequestBody SysDrugEntity entity) {
        SysDrugEntity one = (SysDrugEntity)this.sysDrugService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugEntity::getId, (Object)entity.getId())).eq(SysDrugEntity::getTenantId, (Object)this.commonRequest.getTenant())).eq(SysDrugEntity::getStatus, (Object)"0")).eq(SysDrugEntity::getDelFlag, (Object)ConstantsEnums.DEL_FLAG_ZERO.getValue()));
        if (one == null) {
            return ResponseData.error((String)"\u5f53\u524d\u836f\u54c1\u5df2\u88ab\u836f\u623f\u7981\u7528\uff01");
        }
        return ResponseData.success((Object)one);
    }

    @PostMapping(value={"drugIds"})
    @ApiOperation(value="\u6279\u91cf\u836f\u54c1id \u96c6\u5408", httpMethod="POST", notes="\u6279\u91cf\u836f\u54c1id \u96c6\u5408")
    public ResponseData<SysDrugEntity> drugIds(@RequestBody List<String> ids) {
        List list = this.sysDrugService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(SysDrugEntity::getId, ids)).eq(SysDrugEntity::getTenantId, (Object)this.commonRequest.getTenant())).eq(SysDrugEntity::getDelFlag, (Object)ConstantsEnums.DEL_FLAG_ZERO.getValue()));
        if (!StrUtil.isEmptyIfStr((Object)list)) {
            list.forEach(a -> {
                a.setDrugsId(a.getId());
                a.setDrugType(a.getDrugsType());
            });
        }
        return ResponseData.success((Object)list);
    }

    @PostMapping(value={"drugInternalCodes"})
    @ApiOperation(value="\u6279\u91cf\u836f\u54c1\u5185\u90e8\u7f16\u7801id \u96c6\u5408", httpMethod="POST", notes="\u6279\u91cf\u836f\u54c1\u5185\u90e8\u7f16\u7801id \u96c6\u5408")
    public ResponseData<SysDrugEntity> drugInternalCodes(@RequestBody List<String> internalCodes) {
        List list = this.sysDrugService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(SysDrugEntity::getInternalCode, internalCodes)).eq(SysDrugEntity::getTenantId, (Object)this.commonRequest.getTenant())).eq(SysDrugEntity::getDelFlag, (Object)ConstantsEnums.DEL_FLAG_ZERO.getValue()));
        return ResponseData.success((Object)list);
    }

    @UserOptLogger(operation="\u836f\u54c1\u6a21\u5757")
    @PostMapping(value={"/removeSysDrug"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", httpMethod="POST", notes="\u6279\u91cf\u5220\u9664")
    public ResponseData removeSysDrug(@ApiParam(value="\u4e3b\u952e\u96c6\u5408", required=true) @RequestBody String[] ids) {
        return ResponseData.success((Object)this.sysDrugService.removeSysDrug(ids));
    }

    @UserOptLogger(operation="\u836f\u54c1\u6a21\u5757")
    @PostMapping(value={"/drugStatus"})
    @ApiOperation(value="\u542f\u52a8/\u6682\u505c", httpMethod="POST", notes="\u542f\u52a8/\u6682\u505c")
    public ResponseData drugStatus(@RequestBody SysDrugEntity entity) {
        entity.setTenantId(this.commonRequest.getTenant());
        return ResponseData.success((Object)this.sysDrugService.drugStatus(entity));
    }

    @PostMapping(value={"/import"})
    @ApiOperation(value="[\u4e2d\u836f]\u666e\u901a\u5bfc\u5165 Excel", httpMethod="POST", notes="[\u4e2d\u836f]\u666e\u901a\u5bfc\u5165 Excel")
    public ResponseData importX(@RequestPart(value="file") MultipartFile file) throws IOException {
        List userList = EasyExcelUtil.importExcel((MultipartFile)file, (Object)new DrugVo(), (Object)new DrugListener());
        List sysDrugEntities = BeanUtil.copyList((List)userList, SysDrugEntity.class);
        this.sysDrugService.saveBatch((Collection)sysDrugEntities, 1000);
        return ResponseData.success((Object)userList);
    }

    public SysDrugController(SysDrugService sysDrugService, CommonRequest commonRequest, SysDrugClassificationMiddleService drugClassificationMiddleService, SysDictService sysDictService) {
        this.sysDrugService = sysDrugService;
        this.commonRequest = commonRequest;
        this.drugClassificationMiddleService = drugClassificationMiddleService;
        this.sysDictService = sysDictService;
    }
}

