/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.sys.api.dto.material.reportCount.SysReportCountDto;
import com.byh.sys.api.enums.ReportErrorEnum;
import com.byh.sys.api.enums.SysDrugEnum;
import com.byh.sys.api.excel.SysReportCountDetailExcel;
import com.byh.sys.api.excel.SysReportCountExcel;
import com.byh.sys.api.model.base.BaseEntity;
import com.byh.sys.api.model.dict.SysDictValueEntity;
import com.byh.sys.api.util.BeanUtil;
import com.byh.sys.api.util.DateUtils;
import com.byh.sys.api.util.EasyExcelUtil;
import com.byh.sys.api.util.ExceptionUtils;
import com.byh.sys.api.vo.report.MSInventoryVo;
import com.byh.sys.api.vo.report.OutGiveDrugReportVo;
import com.byh.sys.api.vo.report.OutPrescriptionReportVo;
import com.byh.sys.api.vo.report.PSInventoryVo;
import com.byh.sys.api.vo.report.SysDrugPharmacyDispensingiExcel;
import com.byh.sys.api.vo.report.SysOutPatientGiveDrugDetailVo;
import com.byh.sys.api.vo.report.SysPrescriptionDetailVo;
import com.byh.sys.api.vo.report.SysReportCountDetailVo;
import com.byh.sys.api.vo.report.SysReportCountInDetailExcel;
import com.byh.sys.api.vo.report.SysReportCountOutDetailExcel;
import com.byh.sys.api.vo.report.SysReportCountVo;
import com.byh.sys.api.vo.report.SysReportDrugSaleVo;
import com.byh.sys.data.repository.SysDictValueMapper;
import com.byh.sys.data.repository.SysOutPatientGiveDrugDetailMapper;
import com.byh.sys.data.repository.SysParamMapper;
import com.byh.sys.data.repository.SysReportCountMapper;
import com.byh.sys.web.service.ReportCountService;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReportCountServiceImpl
implements ReportCountService {
    private static final Logger log = LoggerFactory.getLogger(ReportCountServiceImpl.class);
    @Resource
    private SysReportCountMapper sysReportCountMapper;
    @Resource
    private SysDictValueMapper sysDictValueMapper;
    @Autowired
    private SysOutPatientGiveDrugDetailMapper sysOutPatientGiveDrugDetailMapper;
    @Autowired
    private SysParamMapper sysParamMapper;

    public IPage<SysReportCountVo> getMaterialIn(Page page, SysReportCountDto dto) {
        IPage list = this.sysReportCountMapper.getMaterialIn(page, dto);
        return list;
    }

    public IPage<SysReportCountVo> getMaterialOut(Page page, SysReportCountDto dto) {
        IPage list = this.sysReportCountMapper.getMaterialOut(page, dto);
        return list;
    }

    public List<SysReportCountExcel> getMaterialOutExcel(SysReportCountDto dto) {
        List list = this.sysReportCountMapper.getMaterialOutExcel(dto);
        return list;
    }

    public IPage<SysReportCountDetailVo> getMaterialInDetail(Page page, SysReportCountDto dto) {
        IPage list = this.sysReportCountMapper.getMaterialInDetail(page, dto);
        return list;
    }

    public List<SysReportCountDetailExcel> getMaterialInDetailExcel(SysReportCountDto dto) {
        List list = this.sysReportCountMapper.getMaterialInDetailExcel(dto);
        return list;
    }

    public IPage<SysReportCountDetailVo> getMaterialOutDetail(Page page, SysReportCountDto dto) {
        IPage list = this.sysReportCountMapper.getMaterialOutDetail(page, dto);
        return list;
    }

    public List<SysReportCountDetailExcel> getMaterialOutDetailExcel(SysReportCountDto dto) {
        List list = this.sysReportCountMapper.getMaterialOutDetailExcel(dto);
        return list;
    }

    public IPage<SysReportCountDetailVo> getDrugPharmacyDispensing(Page page, SysReportCountDto dto) {
        IPage list = this.sysReportCountMapper.getDrugPharmacyDispensing(page, dto);
        return list;
    }

    public IPage<SysReportCountDetailVo> getDrugPharmacyIn(Page page, SysReportCountDto dto) {
        IPage list = this.sysReportCountMapper.getDrugPharmacyIn(page, dto);
        return list;
    }

    public IPage<SysReportCountDetailVo> getDrugPharmacyOut(Page page, SysReportCountDto dto) {
        IPage list = this.sysReportCountMapper.getDrugPharmacyOut(page, dto);
        return list;
    }

    public IPage<SysReportCountDetailVo> getDrugPharmacyInDetail(Page page, SysReportCountDto dto) {
        IPage list = this.sysReportCountMapper.getDrugPharmacyInDetail(page, dto);
        return list;
    }

    public IPage<SysReportCountDetailVo> getDrugPharmacyOutDetail(Page page, SysReportCountDto dto) {
        IPage list = this.sysReportCountMapper.getDrugPharmacyOutDetail(page, dto);
        return list;
    }

    public IPage<MSInventoryVo> getMaterialPSInventory(Page page, SysReportCountDto dto) {
        String moveDays = DateUtils.getMoveDays((String)dto.getStartTime(), (int)1, (int)-1);
        dto.setBeforeTime(moveDays);
        IPage list = this.sysReportCountMapper.getMaterialPSInventory(page, dto);
        return list;
    }

    public IPage<PSInventoryVo> getDrugPSInventory(Page page, SysReportCountDto dto) {
        if (null == dto.getStartTime() || dto.getStartTime().isEmpty()) {
            dto.setStartTime(DateUtils.dateFormat((Date)new Date(), (String)"yyyy-MM-dd"));
        }
        if (null == dto.getEndTime() || dto.getEndTime().isEmpty()) {
            dto.setEndTime(DateUtils.dateFormat((Date)new Date(), (String)"yyyy-MM-dd"));
        }
        String moveDays = DateUtils.getMoveDays((String)dto.getStartTime(), (int)1, (int)-1);
        dto.setBeforeTime(moveDays);
        IPage list = this.sysReportCountMapper.getDrugPSInventory(page, dto);
        return list;
    }

    public IPage<OutGiveDrugReportVo> outPatientGiveDrugDetail(Page<SysOutPatientGiveDrugDetailVo> page, SysReportCountDto dto) {
        IPage list = this.sysOutPatientGiveDrugDetailMapper.sysOutPatientGiveDrugDetailSelect(page, dto);
        return list;
    }

    public void outPatientGiveDrugDetailExport(HttpServletResponse response, Page page, SysReportCountDto dto) {
        IPage list = this.sysOutPatientGiveDrugDetailMapper.sysOutPatientGiveDrugDetailSelect(page, dto);
        List excels = list.getRecords();
        String excelName = "\u5357\u660c\u4f17\u5eb7\u533b\u9662\u836f\u623f\u95e8\u8bca\u53d1\u836f\u660e\u7ec6";
        String sheetName = "\u5357\u660c\u4f17\u5eb7\u533b\u9662\u836f\u623f\u95e8\u8bca\u53d1\u836f\u660e\u7ec6";
        try {
            EasyExcelUtil.exportExcel((HttpServletResponse)response, (String)excelName, (String)sheetName, (List)excels, (Object)new OutGiveDrugReportVo());
        }
        catch (Exception e) {
            e.printStackTrace();
            ExceptionUtils.createException((Logger)log, (boolean)true, (String)SysDrugEnum.SYS_DRUG_PHARMACY_SIMPLE_EXPORT_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_SIMPLE_EXPORT_ERROR.getName());
        }
    }

    private void selectOrExportRange(SysReportCountDto dto) {
        ExceptionUtils.createException((Logger)log, (null == dto.getStartTime() || "".equals(dto.getStartTime()) ? 1 : 0) != 0, (String)"500", (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        ExceptionUtils.createException((Logger)log, (null == dto.getEndTime() || "".equals(dto.getEndTime()) ? 1 : 0) != 0, (String)"500", (String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        String startTimeStr = dto.getStartTime().replaceAll("/", "-");
        String endTimeStr = dto.getEndTime().replaceAll("/", "-");
        Date startTime = DateUtils.stringTimeToDate((String)startTimeStr, (String)"yyyy-MM-dd");
        Date endTime = DateUtils.stringTimeToDate((String)endTimeStr, (String)"yyyy-MM-dd");
        Long days = DateUtils.computedDiffDays((Date)startTime, (Date)endTime);
        dto.setStartTime(startTimeStr);
        dto.setEndTime(endTimeStr);
        ExceptionUtils.createException((Logger)log, (days > 31L ? 1 : 0) != 0, (String)ReportErrorEnum.REPORT_SELECT_OUT_RANGE_DAY.getCode(), (String)ReportErrorEnum.REPORT_SELECT_OUT_RANGE_DAY.getName());
    }

    public IPage<OutPrescriptionReportVo> prescriptionDetail(Page<OutPrescriptionReportVo> page, SysReportCountDto dto) {
        page.setOptimizeCountSql(false);
        this.selectOrExportRange(dto);
        IPage list = this.sysReportCountMapper.prescriptionDetail(page, dto);
        return list;
    }

    public void prescriptionDetailExport(HttpServletResponse response, Page page, SysReportCountDto dto) {
        page.setCurrent(1L);
        page.setSize(-1L);
        this.selectOrExportRange(dto);
        IPage list = this.sysReportCountMapper.prescriptionDetail(page, dto);
        String excelName = "\u5904\u65b9\u660e\u7ec6\u660e\u7ec6";
        String sheetName = "\u5904\u65b9\u660e\u7ec6\u660e\u7ec6";
        try {
            EasyExcelUtil.exportExcel((HttpServletResponse)response, (String)excelName, (String)sheetName, (List)list.getRecords(), (Object)new OutPrescriptionReportVo());
        }
        catch (Exception e) {
            e.printStackTrace();
            ExceptionUtils.createException((Logger)log, (boolean)true, (String)SysDrugEnum.SYS_DRUG_PHARMACY_SIMPLE_EXPORT_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_SIMPLE_EXPORT_ERROR.getName());
        }
    }

    public void getDrugPSInventoryExport(HttpServletResponse response, Page page, SysReportCountDto dto) {
        IPage list = this.getDrugPSInventory(page, dto);
        List excels = list.getRecords();
        String excelName = "\u8fdb\u9500\u5b58\u6c47\u603b";
        String sheetName = "\u8fdb\u9500\u5b58\u6c47\u603b";
        try {
            EasyExcelUtil.exportExcel((HttpServletResponse)response, (String)excelName, (String)sheetName, (List)excels, (Object)new PSInventoryVo());
        }
        catch (Exception e) {
            e.printStackTrace();
            ExceptionUtils.createException((Logger)log, (boolean)true, (String)SysDrugEnum.SYS_DRUG_PHARMACY_SIMPLE_EXPORT_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_SIMPLE_EXPORT_ERROR.getName());
        }
    }

    public void getDrugPharmacyInOutDetailExport(HttpServletResponse response, Page page, SysReportCountDto dto) {
        if ("2".equals(dto.getInOutDetailExportType())) {
            IPage list = this.getDrugPharmacyInDetail(page, dto);
            List excels = BeanUtil.copyList((List)list.getRecords(), SysReportCountInDetailExcel.class);
            String excelName = "\u5165\u5e93\u660e\u7ec6\u5bfc\u51fa";
            String sheetName = "\u5165\u5e93\u660e\u7ec6\u5bfc\u51fa";
            try {
                EasyExcelUtil.exportExcel((HttpServletResponse)response, (String)excelName, (String)sheetName, (List)excels, (Object)new SysReportCountInDetailExcel());
            }
            catch (Exception e) {
                e.printStackTrace();
                ExceptionUtils.createException((Logger)log, (boolean)true, (String)SysDrugEnum.SYS_DRUG_PHARMACY_SIMPLE_EXPORT_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_SIMPLE_EXPORT_ERROR.getName());
            }
        } else if ("1".equals(dto.getInOutDetailExportType())) {
            IPage list = this.getDrugPharmacyOutDetail(page, dto);
            List excels = BeanUtil.copyList((List)list.getRecords(), SysReportCountOutDetailExcel.class);
            String excelName = "\u51fa\u5e93\u660e\u7ec6\u5bfc\u51fa";
            String sheetName = "\u51fa\u5e93\u660e\u7ec6\u5bfc\u51fa";
            try {
                EasyExcelUtil.exportExcel((HttpServletResponse)response, (String)excelName, (String)sheetName, (List)excels, (Object)new SysReportCountOutDetailExcel());
            }
            catch (Exception e) {
                e.printStackTrace();
                ExceptionUtils.createException((Logger)log, (boolean)true, (String)SysDrugEnum.SYS_DRUG_PHARMACY_SIMPLE_EXPORT_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_SIMPLE_EXPORT_ERROR.getName());
            }
        }
    }

    public void getDrugPharmacyDispensingExport(HttpServletResponse response, Page page, SysReportCountDto dto) {
        IPage list = this.sysReportCountMapper.getDrugPharmacyDispensing(page, dto);
        List excels = BeanUtil.copyList((List)list.getRecords(), SysDrugPharmacyDispensingiExcel.class);
        String excelName = "\u53d1\u836f\u6c47\u603b";
        String sheetName = "\u53d1\u836f\u6c47\u603b";
        try {
            EasyExcelUtil.exportExcel((HttpServletResponse)response, (String)excelName, (String)sheetName, (List)excels, (Object)new SysDrugPharmacyDispensingiExcel());
        }
        catch (Exception e) {
            e.printStackTrace();
            ExceptionUtils.createException((Logger)log, (boolean)true, (String)SysDrugEnum.SYS_DRUG_PHARMACY_REPORT_EXPORT_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_REPORT_EXPORT_ERROR.getName());
        }
    }

    public IPage<SysReportDrugSaleVo> drugSale(Page page, SysReportCountDto dto) {
        this.selectOrExportRange(dto);
        IPage p = this.sysReportCountMapper.drugSale(page, dto);
        return p;
    }

    public SysReportDrugSaleVo drugSaleCount(SysReportCountDto dto) {
        this.selectOrExportRange(dto);
        SysReportDrugSaleVo p = this.sysReportCountMapper.drugSaleCount(dto);
        return p;
    }

    public void drugSaleExport(HttpServletResponse response, Page page, SysReportCountDto dto) {
        IPage list = this.sysReportCountMapper.drugSale(page, dto);
        SysReportDrugSaleVo sysReportDrugSaleVo = this.sysReportCountMapper.drugSaleCount(dto);
        list.getRecords().add(sysReportDrugSaleVo);
        list.setRecords(list.getRecords());
        String excelName = "\u836f\u54c1\u9500\u552e";
        String sheetName = "\u836f\u54c1\u9500\u552e";
        try {
            EasyExcelUtil.exportExcel((HttpServletResponse)response, (String)excelName, (String)sheetName, (List)list.getRecords(), (Object)new SysReportDrugSaleVo());
        }
        catch (Exception e) {
            e.printStackTrace();
            ExceptionUtils.createException((Logger)log, (boolean)true, (String)SysDrugEnum.SYS_DRUG_PHARMACY_REPORT_EXPORT_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_REPORT_EXPORT_ERROR.getName());
        }
    }

    public void evalDictValue(SysReportCountDto dto, List<SysOutPatientGiveDrugDetailVo> list, List<SysPrescriptionDetailVo> list2) {
        block7: {
            Map<String, List<SysDictValueEntity>> properMap;
            Map<String, List<SysDictValueEntity>> feeMap;
            Map<String, List<SysDictValueEntity>> drugTypeMap;
            block6: {
                List drugTypeList = this.sysDictValueMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDictValueEntity::getTenantId, (Object)dto.getTenantId())).eq(SysDictValueEntity::getType, (Object)"drug_type")).eq(BaseEntity::getDelFlag, (Object)"0"));
                List feeList = this.sysDictValueMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDictValueEntity::getTenantId, (Object)dto.getTenantId())).eq(SysDictValueEntity::getType, (Object)"settlement_method")).eq(BaseEntity::getDelFlag, (Object)"0"));
                List properList = this.sysDictValueMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDictValueEntity::getTenantId, (Object)dto.getTenantId())).eq(SysDictValueEntity::getType, (Object)"bottle_properties")).eq(BaseEntity::getDelFlag, (Object)"0"));
                drugTypeMap = drugTypeList.stream().collect(Collectors.groupingBy(SysDictValueEntity::getValue));
                feeMap = feeList.stream().collect(Collectors.groupingBy(SysDictValueEntity::getValue));
                properMap = properList.stream().collect(Collectors.groupingBy(SysDictValueEntity::getValue));
                if (CollectionUtils.isEmpty(list)) break block6;
                for (SysOutPatientGiveDrugDetailVo record : list) {
                    List<SysDictValueEntity> l1 = drugTypeMap.get(record.getDrugsType());
                    List<SysDictValueEntity> l2 = feeMap.get(record.getSettlementMethod());
                    List<SysDictValueEntity> l3 = properMap.get(record.getDrugProperties());
                    if (!CollectionUtils.isEmpty(l1)) {
                        record.setDrugsType(l1.get(0).getLabel());
                    }
                    if (!CollectionUtils.isEmpty(l2)) {
                        record.setSettlementMethod(l2.get(0).getLabel());
                    }
                    if (CollectionUtils.isEmpty(l3)) continue;
                    record.setDrugProperties(l3.get(0).getLabel());
                }
                break block7;
            }
            if (CollectionUtils.isEmpty(list2)) break block7;
            for (SysPrescriptionDetailVo record : list2) {
                List<SysDictValueEntity> l1 = drugTypeMap.get(record.getDrugsType());
                List<SysDictValueEntity> l2 = feeMap.get(record.getSettlementMethod());
                List<SysDictValueEntity> l3 = properMap.get(record.getDrugProperties());
                if (!CollectionUtils.isEmpty(l1)) {
                    record.setDrugsType(l1.get(0).getLabel());
                }
                if (!CollectionUtils.isEmpty(l2)) {
                    record.setSettlementMethod(l2.get(0).getLabel());
                }
                if (CollectionUtils.isEmpty(l3)) continue;
                record.setDrugProperties(l3.get(0).getLabel());
            }
        }
    }
}

