/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.sys.api.dto.drug.SysDrugInventoryDto;
import com.byh.sys.api.model.drug.inventory.SysDrugInventoryEntity;
import com.byh.sys.api.util.BeanUtil;
import com.byh.sys.api.vo.drug.ExportDrugInventory;
import com.byh.sys.data.repository.SysDrugInventoryMapper;
import com.byh.sys.web.service.SysDrugInventoryService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SysDrugInventoryServiceImpl
extends ServiceImpl<SysDrugInventoryMapper, SysDrugInventoryEntity>
implements SysDrugInventoryService {
    private static final Logger log = LoggerFactory.getLogger(SysDrugInventoryServiceImpl.class);

    public IPage<SysDrugInventoryEntity> pageList(Page<SysDrugInventoryEntity> page, SysDrugInventoryDto dto) {
        IPage drugInventoryEntityIPage = ((SysDrugInventoryMapper)this.baseMapper).pageList(page, dto);
        List records = drugInventoryEntityIPage.getRecords();
        if (ObjectUtil.isNotNull((Object)records)) {
            records.forEach(a -> {
                Integer days = a.getDays();
                if (days >= 0) {
                    a.setDaySum("\u6709\u6548\u671f" + days + "\u5929");
                } else {
                    a.setDaySum("\u5df2\u8fc7\u671f");
                }
            });
        }
        return drugInventoryEntityIPage;
    }

    public List<ExportDrugInventory> exportDrugInventory(SysDrugInventoryDto dto) {
        Page page = new Page();
        page.setCurrent(1L);
        page.setSize(-1L);
        IPage entityIPage = ((SysDrugInventoryMapper)this.baseMapper).pageList(page, dto);
        List records = entityIPage.getRecords();
        List exportDrugInventories = BeanUtil.copyList((List)records, ExportDrugInventory.class);
        return exportDrugInventories;
    }
}

