/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.sys.api.dto.drug.drugPharmacy.SysDrugPharmacySaveDto;
import com.byh.sys.api.dto.drug.drugPharmacyCheck.SysDrugPharmacyCheckDto;
import com.byh.sys.api.dto.drug.drugPharmacyCheck.SysDrugPharmacyCheckExcel;
import com.byh.sys.api.dto.drug.drugPharmacyCheck.SysDrugPharmacyCheckSaveDto;
import com.byh.sys.api.dto.drug.drugPharmacyCheck.SysDrugPharmacyCheckUpdateDto;
import com.byh.sys.api.dto.drug.drugPharmacyCheck.SysDrugPharmacyCheckUpdateStatusDto;
import com.byh.sys.api.dto.drug.drugPharmacyCheckPrescip.SysDrugPharmacyCheckPrescriptionExcel;
import com.byh.sys.api.dto.drug.drugPharmacyCheckPrescip.SysDrugPharmacyCheckPrescriptionSaveDto;
import com.byh.sys.api.dto.drug.drugPharmacyCheckPrescip.SysDrugPharmacyCheckPrescriptionUpdateDto;
import com.byh.sys.api.enums.DictEnums;
import com.byh.sys.api.enums.SysDrugEnum;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.SysUserEntity;
import com.byh.sys.api.model.base.NoIdBaseEntity;
import com.byh.sys.api.model.drug.pharmacy.SysDrugPharmacyCheckEntity;
import com.byh.sys.api.model.drug.pharmacy.SysDrugPharmacyCheckPrescriptionEntity;
import com.byh.sys.api.model.drug.pharmacy.SysDrugPharmacySimpleEntity;
import com.byh.sys.api.util.BeanUtil;
import com.byh.sys.api.util.EasyExcelUtil;
import com.byh.sys.api.util.ExceptionUtils;
import com.byh.sys.api.util.UUIDUtils;
import com.byh.sys.api.vo.drug.SysDrugPharmacyCheckVo;
import com.byh.sys.api.vo.drug.SysDrugPharmacyVo;
import com.byh.sys.data.repository.SysDrugPharmacyCheckMapper;
import com.byh.sys.data.repository.SysDrugPharmacyCheckPrescriptionMapper;
import com.byh.sys.data.repository.SysDrugPharmacyMapper;
import com.byh.sys.data.repository.SysDrugPharmacySimpleMapper;
import com.byh.sys.data.repository.SysUserMapper;
import com.byh.sys.web.call_function.ExtendServiceImpl;
import com.byh.sys.web.call_function.HsUploadExtend;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.SysDrugPharmacyCheckPrescriptionService;
import com.byh.sys.web.service.SysDrugPharmacyCheckService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysDrugPharmacyCheckServiceImpl
implements SysDrugPharmacyCheckService {
    private static final Logger log = LoggerFactory.getLogger(SysDrugPharmacyCheckServiceImpl.class);
    @Resource
    private SysDrugPharmacyCheckMapper sysDrugPharmacyCheckMapper;
    @Resource
    private SysDrugPharmacyCheckPrescriptionMapper sysDrugPharmacyCheckPrescriptionMapper;
    @Autowired
    private CommonRequest commonRequest;
    @Resource
    private SysDrugPharmacySimpleMapper sysDrugPharmacySimpleMapper;
    @Resource
    private SysDrugPharmacyMapper sysDrugPharmacyMapper;
    @Autowired
    private SysDrugPharmacyCheckPrescriptionService sysDrugPharmacyCheckPrescriptionService;
    @Autowired
    @Lazy
    private SysDrugPharmacyCheckService sysDrugPharmacyCheckService;
    @Autowired
    private SysUserMapper sysUserMapper;
    @Autowired
    private HsUploadExtend hsUploadExtend;
    @Autowired
    private ExtendServiceImpl extendServiceImpl;

    @Transactional(rollbackFor={BusinessException.class})
    public SysDrugPharmacyCheckEntity sysDrugPharmacyCheckSave(SysDrugPharmacyCheckSaveDto dto) {
        this.sysDrugPharmacyCheckStatus(dto.getWarehouse());
        BigDecimal rootPurchasePricePl = new BigDecimal(0);
        BigDecimal rootRetailPricePl = new BigDecimal(0);
        String checkId = UUIDUtils.getRandom((int)6, (boolean)true);
        SysDrugPharmacyCheckEntity entity = (SysDrugPharmacyCheckEntity)BeanUtil.copy((Object)dto, SysDrugPharmacyCheckEntity.class);
        entity.setId(checkId);
        entity.setCheckUse(this.commonRequest.getUserId().toString());
        entity.setCheckNumber(Integer.valueOf(dto.getPrescripList().size()));
        entity.setAuditStatus(DictEnums.CHECK_READY.getCode());
        List prescripList = dto.getPrescripList();
        for (SysDrugPharmacyCheckPrescriptionSaveDto n : prescripList) {
            n.setTenantId(dto.getTenantId());
            n.setDrugPharmacyCheckId(checkId);
            n.setId(UUIDUtils.getRandom((int)6, (boolean)true));
            n.setPlNumber(Integer.valueOf(n.getRealityInventory() - n.getBookInventory()));
            n.setPurchasePricePl(new BigDecimal(n.getPlNumber()).multiply(n.getPurchasePrice()));
            rootPurchasePricePl = rootPurchasePricePl.add(n.getPurchasePricePl());
            n.setRetailPricePl(new BigDecimal(n.getPlNumber()).multiply(n.getRetailPrice()));
            rootRetailPricePl = rootRetailPricePl.add(n.getRetailPricePl());
        }
        entity.setPurchasePricePl(rootPurchasePricePl);
        entity.setRetailPricePl(rootRetailPricePl);
        int a = this.sysDrugPharmacyCheckMapper.insert((Object)entity);
        ExceptionUtils.createException((Logger)log, (int)a, (String)SysDrugEnum.SYS_DRUG_PHARMACY_CHECK_INSERT_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_CHECK_INSERT_ERROR.getName());
        this.sysDrugPharmacyCheckPrescriptionMapper.sysDrugPharmacyCheckPrescriptionSaveBatch(prescripList);
        SysDrugPharmacyCheckEntity entry = (SysDrugPharmacyCheckEntity)this.sysDrugPharmacyCheckMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugPharmacyCheckEntity::getId, (Object)checkId)).eq(SysDrugPharmacyCheckEntity::getTenantId, (Object)dto.getTenantId()));
        entry.setPrescripList(prescripList);
        return entry;
    }

    public IPage<SysDrugPharmacyCheckVo> sysDrugPharmacyCheckSelect(Page page, SysDrugPharmacyCheckDto dto) {
        IPage list = this.sysDrugPharmacyCheckMapper.sysDrugPharmacyCheckSelect(page, dto);
        List checkVoList = list.getRecords();
        if (!CollectionUtils.isEmpty((Collection)checkVoList)) {
            List ids = checkVoList.stream().map(SysDrugPharmacyCheckVo::getAuditUse).collect(Collectors.toList());
            List userList = this.sysUserMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(SysUserEntity::getId, ids));
            if (!CollectionUtils.isEmpty((Collection)userList)) {
                Map<Integer, List<SysUserEntity>> userIdMap = userList.stream().collect(Collectors.groupingBy(SysUserEntity::getId));
                for (SysDrugPharmacyCheckVo n : checkVoList) {
                    List<SysUserEntity> sysUserEntities;
                    if ("".equals(n.getAuditUse()) || CollectionUtils.isEmpty(sysUserEntities = userIdMap.get(Integer.parseInt(n.getAuditUse())))) continue;
                    n.setAuditUse(sysUserEntities.get(0).getUserName());
                }
            }
        }
        return list;
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void sysDrugPharmacyCheckUpdate(SysDrugPharmacyCheckUpdateDto dto) {
        BigDecimal rootPurchasePricePl = new BigDecimal(0);
        BigDecimal rootRetailPricePl = new BigDecimal(0);
        SysDrugPharmacyCheckEntity entity = (SysDrugPharmacyCheckEntity)BeanUtil.copy((Object)dto, SysDrugPharmacyCheckEntity.class);
        List list = dto.getPrescripList();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (SysDrugPharmacyCheckPrescriptionUpdateDto n : list) {
                n.setPlNumber(Integer.valueOf(n.getRealityInventory() - n.getBookInventory()));
                n.setPurchasePricePl(new BigDecimal(n.getPlNumber()).multiply(n.getPurchasePrice()));
                rootPurchasePricePl = rootPurchasePricePl.add(n.getPurchasePricePl());
                n.setRetailPricePl(new BigDecimal(n.getPlNumber()).multiply(n.getRetailPrice()));
                rootRetailPricePl = rootRetailPricePl.add(n.getRetailPricePl());
            }
            entity.setPurchasePricePl(rootPurchasePricePl);
            entity.setRetailPricePl(rootRetailPricePl);
            entity.setCheckNumber(Integer.valueOf(list.size()));
            if ("4".equals(dto.getAuditStatus()) || "5".equals(dto.getAuditStatus())) {
                entity.setAuditUse(this.commonRequest.getUserId().toString());
            }
            for (SysDrugPharmacyCheckPrescriptionUpdateDto n : list) {
                n.setTenantId(dto.getTenantId());
                this.sysDrugPharmacyCheckPrescriptionService.sysDrugPharmacyCheckPrescriptionUpdate(n);
            }
        }
        int a = this.sysDrugPharmacyCheckMapper.update((Object)entity, (Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(SysDrugPharmacyCheckEntity::getTenantId, (Object)dto.getTenantId())).eq(SysDrugPharmacyCheckEntity::getId, (Object)dto.getId()));
        ExceptionUtils.createException((Logger)log, (int)a, (String)SysDrugEnum.SYS_DRUG_PHARMACY_CHECK_UPDATE_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_CHECK_UPDATE_ERROR.getName());
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void sysDrugPharmacyCheckDelete(String id) {
        List list = this.sysDrugPharmacyCheckPrescriptionMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugPharmacyCheckPrescriptionEntity::getDrugPharmacyCheckId, (Object)id)).eq(SysDrugPharmacyCheckPrescriptionEntity::getTenantId, (Object)this.commonRequest.getTenant()));
        ExceptionUtils.createException((Logger)log, (boolean)CollectionUtils.isEmpty((Collection)list), (String)SysDrugEnum.SYS_DRUG_PHARMACY_CHECK_PRESCRIPTION_SELECT_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_CHECK_PRESCRIPTION_SELECT_ERROR.getName());
        List ids = list.stream().map(SysDrugPharmacyCheckPrescriptionEntity::getId).collect(Collectors.toList());
        int a = this.sysDrugPharmacyCheckPrescriptionMapper.deleteBatchIds(ids);
        ExceptionUtils.createException((Logger)log, (int)a, (String)SysDrugEnum.SYS_DRUG_PHARMACY_CHECK_PRESCRIPTION_DELETE_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_CHECK_PRESCRIPTION_DELETE_ERROR.getName());
        int b = this.sysDrugPharmacyCheckMapper.deleteById((Serializable)((Object)id));
        ExceptionUtils.createException((Logger)log, (int)b, (String)SysDrugEnum.SYS_DRUG_PHARMACY_CHECK_DELETE_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_CHECK_DELETE_ERROR.getName());
    }

    @Transactional(rollbackFor={BusinessException.class})
    public IPage<SysDrugPharmacyVo> sysDrugPharmacyCheckSearch(Page page, SysDrugPharmacyCheckDto dto) {
        IPage list = this.extendServiceImpl.getDrugCheckSearch(page, dto);
        return list;
    }

    @Transactional(rollbackFor={BusinessException.class})
    public SysDrugPharmacyCheckEntity sysDrugPharmacyCheckUpdateStatus(SysDrugPharmacyCheckUpdateStatusDto dto) {
        Date date = null;
        ExceptionUtils.createException((Logger)log, (boolean)DictEnums.CHECK_ALREADY_CONFIRM.getCode().equals(dto.getAuditStatus()), (String)SysDrugEnum.SYS_DRUG_PHARMACY_CHECK_ALREADY_CONFIRM_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_CHECK_ALREADY_CONFIRM_ERROR.getName());
        SysDrugPharmacyCheckEntity entity = (SysDrugPharmacyCheckEntity)BeanUtil.copy((Object)dto, SysDrugPharmacyCheckEntity.class);
        if (DictEnums.CHECK_ING.getCode().equals(dto.getAuditStatus())) {
            date = new Date();
            entity.setCheckTime(date);
        }
        int a = this.sysDrugPharmacyCheckMapper.update((Object)entity, (Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(SysDrugPharmacyCheckEntity::getId, (Object)entity.getId())).eq(SysDrugPharmacyCheckEntity::getTenantId, (Object)entity.getTenantId()));
        ExceptionUtils.createException((Logger)log, (int)a, (String)SysDrugEnum.SYS_DRUG_PHARMACY_CHECK_UPDATE_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_CHECK_UPDATE_ERROR.getName());
        return entity;
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void sysDrugPharmacyCheckConfirm(String id, Integer tenantId, String warehouse) {
        SysDrugPharmacyCheckEntity entity = new SysDrugPharmacyCheckEntity();
        entity.setAuditStatus(DictEnums.CHECK_ALREADY_CONFIRM.getCode());
        SysUserEntity userInfo = this.commonRequest.getUserInfo();
        if (null != userInfo) {
            entity.setAuditUse(userInfo.getId().toString());
        }
        int a = this.sysDrugPharmacyCheckMapper.update((Object)entity, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(SysDrugPharmacyCheckEntity::getTenantId, (Object)tenantId)).eq(SysDrugPharmacyCheckEntity::getWarehouse, (Object)warehouse)).eq(SysDrugPharmacyCheckEntity::getId, (Object)id));
        ExceptionUtils.createException((Logger)log, (int)a, (String)SysDrugEnum.SYS_DRUG_PHARMACY_CHECK_UPDATE_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_CHECK_UPDATE_ERROR.getName());
        List list = this.sysDrugPharmacyCheckPrescriptionMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugPharmacyCheckPrescriptionEntity::getTenantId, (Object)tenantId)).eq(SysDrugPharmacyCheckPrescriptionEntity::getDrugPharmacyCheckId, (Object)id));
        for (SysDrugPharmacyCheckPrescriptionEntity n : list) {
            if (n.getPlNumber() == 0) continue;
            SysDrugPharmacySimpleEntity simple = (SysDrugPharmacySimpleEntity)this.sysDrugPharmacySimpleMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugPharmacySimpleEntity::getTenantId, (Object)tenantId)).eq(SysDrugPharmacySimpleEntity::getWarehouse, (Object)warehouse)).eq(SysDrugPharmacySimpleEntity::getDrugsId, (Object)n.getDrugsId()));
            if (null == simple) {
                ExceptionUtils.createException((Logger)log, (int)a, (String)SysDrugEnum.SYS_DRUG_PHARMACY_SIMPLE_SELECT_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_SIMPLE_SELECT_ERROR.getName());
            }
            simple.setActualInventory(Integer.valueOf(simple.getActualInventory() + n.getPlNumber()));
            simple.setPurchaseAmount(simple.getPurchaseAmount().add(new BigDecimal(n.getPlNumber()).multiply(n.getPurchasePrice())));
            int b = this.sysDrugPharmacySimpleMapper.update((Object)simple, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(SysDrugPharmacySimpleEntity::getTenantId, (Object)tenantId)).eq(SysDrugPharmacySimpleEntity::getWarehouse, (Object)warehouse)).eq(SysDrugPharmacySimpleEntity::getDrugsId, (Object)n.getDrugsId()));
            ExceptionUtils.createException((Logger)log, (int)b, (String)SysDrugEnum.SYS_DRUG_PHARMACY_UPDATE_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_UPDATE_ERROR.getName());
            ArrayList saveDtoList = new ArrayList();
            this.insertDrugPharmacy(n, saveDtoList, warehouse);
            this.sysDrugPharmacyMapper.sysDrugPharmacySaveBatch(saveDtoList);
            this.hsUploadExtend.medicationInventoryUploadContext(saveDtoList, this.commonRequest.getTenant());
        }
        this.extendServiceImpl.drugCheckPositionShelf(tenantId, warehouse, list);
    }

    private void insertDrugPharmacy(SysDrugPharmacyCheckPrescriptionEntity n, List<SysDrugPharmacySaveDto> saveDtoList, String warehouse) {
        SysDrugPharmacySaveDto saveDto = (SysDrugPharmacySaveDto)BeanUtil.copy((Object)n, SysDrugPharmacySaveDto.class);
        saveDto.setBatchNumber(n.getBatchNumber());
        saveDto.setId(UUIDUtils.getRandom((int)5, (boolean)true));
        saveDto.setInventoryId(n.getId());
        saveDto.setActualInventory(n.getPlNumber());
        saveDto.setPurchaseAmount(new BigDecimal(n.getPlNumber()).multiply(n.getPurchasePrice()));
        saveDto.setInOutType(DictEnums.IN_OUT_TYPE_CHECK.getCode());
        saveDto.setWarehouse(warehouse);
        saveDto.setInOutTime(new Date());
        if (n.getPlNumber() > 0) {
            saveDto.setInOutMethod("14");
        } else if (n.getPlNumber() < 0) {
            saveDto.setInOutMethod("15");
        }
        saveDtoList.add(saveDto);
    }

    public void sysDrugPharmacyCheckStatus(String warehouse) {
        List list = this.sysDrugPharmacyCheckMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugPharmacyCheckEntity::getTenantId, (Object)this.commonRequest.getTenant())).eq(SysDrugPharmacyCheckEntity::getAuditStatus, (Object)DictEnums.CHECK_ING.getCode())).eq(NoIdBaseEntity::getDelFlag, (Object)"0")).eq(SysDrugPharmacyCheckEntity::getWarehouse, (Object)warehouse));
        ExceptionUtils.createException((Logger)log, (!CollectionUtils.isEmpty((Collection)list) ? 1 : 0) != 0, (String)SysDrugEnum.SYS_DRUG_PHARMACY_CHECK_ING_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_CHECK_ING_ERROR.getName());
    }

    public void sysDrugPharmacyCheckExport(HttpServletResponse response, Page page, SysDrugPharmacyCheckDto dto) {
        List list = this.sysDrugPharmacyCheckSelect(page, dto).getRecords();
        ExceptionUtils.createException((Logger)log, (boolean)CollectionUtils.isEmpty((Collection)list), (String)SysDrugEnum.SYS_DRUG_PHARMACY_CHECK_EXPORT_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_CHECK_EXPORT_ERROR.getName());
        SysDrugPharmacyCheckExcel ex = (SysDrugPharmacyCheckExcel)BeanUtil.copy(list.get(0), SysDrugPharmacyCheckExcel.class);
        ex.setRetailPricePlAmount(((SysDrugPharmacyCheckVo)list.get(0)).getRetailPricePl());
        ex.setPurchasePricePlAmount(((SysDrugPharmacyCheckVo)list.get(0)).getPurchasePricePl());
        if (DictEnums.DRUG_PHARMACY_CHECK_TYPE_0.getCode().equals(ex.getCheckType())) {
            ex.setCheckType(DictEnums.DRUG_PHARMACY_CHECK_TYPE_0.getMsg());
        } else if (DictEnums.DRUG_PHARMACY_CHECK_TYPE_1.getCode().equals(ex.getCheckType())) {
            ex.setCheckType(DictEnums.DRUG_PHARMACY_CHECK_TYPE_1.getMsg());
        } else if (DictEnums.DRUG_PHARMACY_CHECK_TYPE_2.getCode().equals(ex.getCheckType())) {
            ex.setCheckType(DictEnums.DRUG_PHARMACY_CHECK_TYPE_2.getMsg());
        }
        BigDecimal retailPriceAmount = new BigDecimal(0);
        List preList = this.sysDrugPharmacyCheckPrescriptionMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(SysDrugPharmacyCheckPrescriptionEntity::getDrugPharmacyCheckId, (Object)dto.getId()));
        List ps = BeanUtil.copyList((List)preList, SysDrugPharmacyCheckPrescriptionExcel.class);
        for (SysDrugPharmacyCheckPrescriptionExcel n : ps) {
            retailPriceAmount = retailPriceAmount.add(new BigDecimal(n.getRealityInventory()).multiply(n.getRetailPrice()));
        }
        ex.setRetailPriceAmount(retailPriceAmount);
        ArrayList<SysDrugPharmacyCheckExcel> excels = new ArrayList<SysDrugPharmacyCheckExcel>();
        excels.add(ex);
        String excelName = "\u836f\u623f\u76d8\u70b9\u660e\u7ec6";
        String sheetName = "\u836f\u623f\u5165\u5e93";
        EasyExcelUtil.customTemplateExport((HttpServletResponse)response, (String)excelName, excels, (List)ps);
    }
}

