/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.byh.sys.api.dto.drug.drugPharmacy.InventoryDataDto;
import com.byh.sys.api.dto.drug.drugPharmacy.SysDrugPharmacyDto;
import com.byh.sys.api.dto.drug.drugPharmacy.SysDrugPharmacySaveDto;
import com.byh.sys.api.dto.drug.drugPharmacy.SysDrugPharmacyUpdateDto;
import com.byh.sys.api.dto.drug.drugPharmacy.UploadDrugSellDto;
import com.byh.sys.api.enums.DelFlagEnum;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.BjHosptialInfoEntity;
import com.byh.sys.api.model.base.BaseEntity;
import com.byh.sys.api.model.dict.SysDictValueEntity;
import com.byh.sys.api.model.drug.pharmacy.SysDrugPharmacyCheckEntity;
import com.byh.sys.api.model.drug.pharmacy.SysDrugPharmacyCheckPrescriptionEntity;
import com.byh.sys.api.model.drug.pharmacy.SysDrugPharmacyEntity;
import com.byh.sys.api.model.drug.pharmacy.SysDrugPharmacySimpleEntity;
import com.byh.sys.api.util.BeanUtil;
import com.byh.sys.api.util.ExceptionUtils;
import com.byh.sys.api.util.UUIDUtils;
import com.byh.sys.api.vo.OutDiagnosisVo;
import com.byh.sys.api.vo.drug.BjHosptialContrast;
import com.byh.sys.api.vo.drug.ExcelTakeStockVo;
import com.byh.sys.api.vo.drug.InventoryData;
import com.byh.sys.api.vo.drug.ProcuremData;
import com.byh.sys.api.vo.drug.SaleData;
import com.byh.sys.api.vo.drug.SysDrugPharmacyVo;
import com.byh.sys.data.repository.BjHosptialInfoMapper;
import com.byh.sys.data.repository.SysDictValueMapper;
import com.byh.sys.data.repository.SysDrugPharmacyCheckMapper;
import com.byh.sys.data.repository.SysDrugPharmacyCheckPrescriptionMapper;
import com.byh.sys.data.repository.SysDrugPharmacyMapper;
import com.byh.sys.data.repository.SysDrugPharmacySimpleMapper;
import com.byh.sys.web.rocket.RocketMQProducer;
import com.byh.sys.web.service.SysDrugPharmacyService;
import com.byh.sys.web.service.impl.SysDrugPharmacyServiceImpl;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.rocketmq.client.producer.SendCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SysDrugPharmacyServiceImpl
implements SysDrugPharmacyService {
    private static final Logger logger = LoggerFactory.getLogger(SysDrugPharmacyServiceImpl.class);
    @Resource
    private SysDrugPharmacyMapper sysDrugPharmacyMapper;
    @Resource
    private RocketMQProducer rocketMQProducer;
    @Resource
    private SysDictValueMapper sysDictValueMapper;
    @Resource
    private BjHosptialInfoMapper bjHosptialInfoMapper;
    @Resource
    private SysDrugPharmacyCheckPrescriptionMapper sysDrugPharmacyCheckPrescriptionMapper;
    @Resource
    private SysDrugPharmacyCheckMapper sysDrugPharmacyCheckMapper;
    @Resource
    private SysDrugPharmacySimpleMapper sysDrugPharmacySimpleMapper;
    private static final String sendDrugStockTopic = "rocketMQ-out-inventoryDataTopic";
    private static final String sendDrugPurchaseTopic = "rocketMQ-out-purchaseDataTopic";
    private static final String sendDrugSellTopic = "rocketMQ-out-saleDataTopic";

    @Transactional(rollbackFor={BusinessException.class})
    public void checkTakeStockByExcel(MultipartFile file, Integer tenantId, Integer userId) {
        Integer createId = 999999;
        String lastDate = "2024-12-22 23:59:59";
        Integer count = 0;
        try {
            InputStream inputStream = file.getInputStream();
            XSSFWorkbook xssfWorkbook = new XSSFWorkbook(inputStream);
            XSSFSheet sheet = xssfWorkbook.getSheetAt(0);
            String checkDateStr = "2024-12-22 12:12:12";
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date checkDate = dateFormat.parse(checkDateStr);
            Integer readCount = 0;
            ArrayList<ExcelTakeStockVo> readyExcelTakeStockVoList = new ArrayList<ExcelTakeStockVo>();
            for (Row row : sheet) {
                Integer n;
                Integer n2;
                if (readCount == 0) {
                    n2 = readCount;
                    n = readCount = Integer.valueOf(readCount + 1);
                    continue;
                }
                n2 = count;
                n = count = Integer.valueOf(count + 1);
                if (count == 99) {
                    System.out.println();
                }
                ExcelTakeStockVo excelTakeStockVo2 = new ExcelTakeStockVo();
                String thirdCode = this.getCellStringValue(row, Integer.valueOf(0));
                excelTakeStockVo2.setThirdCode(thirdCode);
                String drugName = this.getCellStringValue(row, Integer.valueOf(1));
                excelTakeStockVo2.setDrugName(drugName);
                String drugSpec = this.getCellStringValue(row, Integer.valueOf(2));
                excelTakeStockVo2.setDrugSpec(drugSpec);
                String drugUnit = this.getCellStringValue(row, Integer.valueOf(3));
                excelTakeStockVo2.setDrugUnit(drugUnit);
                String manufacturer = this.getCellStringValue(row, Integer.valueOf(4));
                excelTakeStockVo2.setManufacturer(manufacturer);
                BigDecimal purchasePrice = BigDecimal.valueOf(row.getCell(5).getNumericCellValue());
                excelTakeStockVo2.setPurchasePrice(purchasePrice);
                int stockNum = (int)row.getCell(6).getNumericCellValue();
                excelTakeStockVo2.setStockNum(Integer.valueOf(stockNum));
                int realStockNum = (int)row.getCell(8).getNumericCellValue();
                excelTakeStockVo2.setRealStockNum(Integer.valueOf(realStockNum));
                int discrepancyNum = realStockNum - stockNum;
                excelTakeStockVo2.setDiscrepancyNum(Integer.valueOf(discrepancyNum));
                if (discrepancyNum > 0) {
                    excelTakeStockVo2.setTakeStockFlag("14");
                } else {
                    if (discrepancyNum >= 0) continue;
                    excelTakeStockVo2.setTakeStockFlag("15");
                }
                readyExcelTakeStockVoList.add(excelTakeStockVo2);
            }
            if (readyExcelTakeStockVoList.isEmpty()) {
                return;
            }
            List thirdCodes = readyExcelTakeStockVoList.stream().filter(excelTakeStockVo -> StrUtil.isNotEmpty((CharSequence)excelTakeStockVo.getThirdCode())).map(ExcelTakeStockVo::getThirdCode).distinct().collect(Collectors.toList());
            List sysPharmacyList = this.sysDrugPharmacyMapper.selectReadyCheckList(tenantId, lastDate, thirdCodes);
            Map sysPharmacyMap = sysPharmacyList.stream().collect(Collectors.toMap(SysDrugPharmacyEntity::getThirdCode, Function.identity()));
            Map<Boolean, List<ExcelTakeStockVo>> partitioneData = readyExcelTakeStockVoList.stream().collect(Collectors.partitioningBy(excelTakeStockVo -> {
                Integer excelStockNum;
                String thirdCode = excelTakeStockVo.getThirdCode();
                SysDrugPharmacyEntity pharmacy = (SysDrugPharmacyEntity)sysPharmacyMap.get(thirdCode);
                if (pharmacy == null) {
                    return false;
                }
                Integer stockNum = pharmacy.getActualInventory();
                if (!Objects.equals(stockNum, excelStockNum = excelTakeStockVo.getStockNum())) {
                    excelTakeStockVo.setStockNum(stockNum);
                }
                return true;
            }));
            List<ExcelTakeStockVo> takeStockNumErrorList = partitioneData.get(false);
            List<ExcelTakeStockVo> excelTakeStockVoList = partitioneData.get(true);
            List takeStockThirdCodes = excelTakeStockVoList.stream().filter(excelTakeStockVo -> StrUtil.isNotEmpty((CharSequence)excelTakeStockVo.getThirdCode())).map(ExcelTakeStockVo::getThirdCode).collect(Collectors.toList());
            List checkPharmacyList = this.sysDrugPharmacyMapper.selectBatchList(tenantId, lastDate, takeStockThirdCodes, "202401290919222322");
            Map<String, List<SysDrugPharmacyEntity>> checkPharmacyMap = checkPharmacyList.stream().collect(Collectors.groupingBy(SysDrugPharmacyEntity::getThirdCode));
            ArrayList<ExcelTakeStockVo> excelErrorList = new ArrayList<ExcelTakeStockVo>();
            ArrayList<SysDrugPharmacyEntity> successList = new ArrayList<SysDrugPharmacyEntity>();
            String checkId = UUIDUtils.getRandom((int)6, (boolean)true);
            block3: for (ExcelTakeStockVo excelTakeStockVo3 : excelTakeStockVoList) {
                Integer stockNum;
                String thirdCode = excelTakeStockVo3.getThirdCode();
                String takeStockFlag = excelTakeStockVo3.getTakeStockFlag();
                List drugPharmacyList = checkPharmacyMap.getOrDefault(thirdCode, new ArrayList());
                if (drugPharmacyList.isEmpty()) {
                    excelErrorList.add(excelTakeStockVo3);
                    continue;
                }
                Object discrepancyNum = excelTakeStockVo3.getDiscrepancyNum();
                if ("14".equals(takeStockFlag)) {
                    for (SysDrugPharmacyEntity pharmacy2 : drugPharmacyList) {
                        stockNum = pharmacy2.getActualInventory();
                        pharmacy2.setId(UUIDUtils.getRandom((int)6, (boolean)true));
                        pharmacy2.setInOutType("3");
                        pharmacy2.setInOutMethod("14");
                        pharmacy2.setDelFlag("0");
                        pharmacy2.setInOutTime(checkDate);
                        pharmacy2.setCreateId(createId);
                        pharmacy2.setInventoryId(checkId);
                        if (stockNum <= 0) continue;
                        pharmacy2.setActualInventory((Integer)discrepancyNum);
                        pharmacy2.setBookStockNum(excelTakeStockVo3.getStockNum());
                        pharmacy2.setRealStockNum(excelTakeStockVo3.getRealStockNum());
                        BigDecimal purchasePrice = pharmacy2.getPurchasePrice();
                        BigDecimal retailPrice = pharmacy2.getRetailPrice();
                        BigDecimal purchaseAmount = purchasePrice.multiply(BigDecimal.valueOf(((Integer)discrepancyNum).intValue()));
                        BigDecimal retailAmount = retailPrice.multiply(BigDecimal.valueOf(((Integer)discrepancyNum).intValue()));
                        pharmacy2.setPurchaseAmount(purchaseAmount);
                        pharmacy2.setRetailAmount(retailAmount);
                        successList.add(pharmacy2);
                        continue block3;
                    }
                    continue;
                }
                if (!"15".equals(takeStockFlag)) continue;
                for (SysDrugPharmacyEntity pharmacy2 : drugPharmacyList) {
                    BigDecimal retailAmount;
                    BigDecimal purchaseAmount;
                    Integer realStockNum;
                    stockNum = pharmacy2.getActualInventory();
                    Integer checkNum = stockNum + (Integer)discrepancyNum;
                    pharmacy2.setId(UUIDUtils.getRandom((int)6, (boolean)true));
                    pharmacy2.setInOutType("3");
                    pharmacy2.setInOutMethod("15");
                    pharmacy2.setDelFlag("0");
                    pharmacy2.setInOutTime(checkDate);
                    pharmacy2.setCreateId(createId);
                    pharmacy2.setInventoryId(checkId);
                    BigDecimal purchasePrice = pharmacy2.getPurchasePrice();
                    BigDecimal retailPrice = pharmacy2.getRetailPrice();
                    if (checkNum >= 0) {
                        pharmacy2.setActualInventory((Integer)discrepancyNum);
                        pharmacy2.setBookStockNum(Integer.valueOf(Math.abs(stockNum)));
                        realStockNum = stockNum - Math.abs((Integer)discrepancyNum);
                        pharmacy2.setRealStockNum(realStockNum);
                        purchaseAmount = purchasePrice.multiply(BigDecimal.valueOf(((Integer)discrepancyNum).intValue()));
                        retailAmount = retailPrice.multiply(BigDecimal.valueOf(((Integer)discrepancyNum).intValue()));
                        pharmacy2.setPurchaseAmount(purchaseAmount);
                        pharmacy2.setRetailAmount(retailAmount);
                        successList.add(pharmacy2);
                        continue block3;
                    }
                    discrepancyNum = checkNum;
                    pharmacy2.setActualInventory(Integer.valueOf(-Math.abs(stockNum)));
                    pharmacy2.setBookStockNum(Integer.valueOf(Math.abs(stockNum)));
                    realStockNum = stockNum - Math.abs(stockNum);
                    pharmacy2.setRealStockNum(realStockNum);
                    purchaseAmount = purchasePrice.multiply(BigDecimal.valueOf(pharmacy2.getActualInventory().intValue()));
                    retailAmount = retailPrice.multiply(BigDecimal.valueOf(pharmacy2.getActualInventory().intValue()));
                    pharmacy2.setPurchaseAmount(purchaseAmount);
                    pharmacy2.setRetailAmount(retailAmount);
                    successList.add(pharmacy2);
                }
            }
            List drugIds = successList.stream().filter(drugPharmacy -> StrUtil.isNotEmpty((CharSequence)drugPharmacy.getDrugsId())).map(SysDrugPharmacyEntity::getDrugsId).collect(Collectors.toList());
            List drugPharmacySimpleList = this.sysDrugPharmacySimpleMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(SysDrugPharmacySimpleEntity::getDrugsId, drugIds)).eq(SysDrugPharmacySimpleEntity::getWarehouse, (Object)"202401290919222322"));
            Map drugPharmacySimpleMap = drugPharmacySimpleList.stream().collect(Collectors.toMap(SysDrugPharmacySimpleEntity::getDrugsId, Function.identity()));
            ArrayList<String> errorDrugIds = new ArrayList<String>();
            ArrayList<SysDrugPharmacySimpleEntity> errorStockList = new ArrayList<SysDrugPharmacySimpleEntity>();
            for (SysDrugPharmacyEntity pharmacy3 : successList) {
                boolean flag = true;
                String drugId = pharmacy3.getDrugsId();
                SysDrugPharmacySimpleEntity drugPharmacySimple = (SysDrugPharmacySimpleEntity)drugPharmacySimpleMap.get(drugId);
                if (drugPharmacySimple == null) {
                    ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)("\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u5e93\u5b58\u4fe1\u606f\uff01\u836f\u54c1\u7f16\u53f7\uff1a" + drugId));
                }
                Integer discrepancyNum = pharmacy3.getActualInventory();
                Integer stockNum = drugPharmacySimple.getActualInventory();
                Integer newStockNum = stockNum + discrepancyNum;
                if (newStockNum < 0) {
                    errorDrugIds.add(drugId);
                    errorStockList.add(drugPharmacySimple);
                    flag = false;
                }
                if (!flag) continue;
                drugPharmacySimple.setActualInventory(newStockNum);
                this.sysDrugPharmacySimpleMapper.updateById((Object)drugPharmacySimple);
            }
            if (!errorDrugIds.isEmpty()) {
                successList.removeIf(pharmacy -> errorDrugIds.contains(pharmacy.getDrugsId()));
            }
            this.sysDrugPharmacyMapper.insertList(successList);
            ArrayList checkPrescriptionList = new ArrayList();
            successList.stream().map(pharmacy -> {
                SysDrugPharmacyCheckPrescriptionEntity checkPrescription = new SysDrugPharmacyCheckPrescriptionEntity();
                checkPrescription.setId(UUIDUtils.getRandom((int)6, (boolean)true));
                checkPrescription.setDrugPharmacyCheckId(checkId);
                checkPrescription.setDrugsId(pharmacy.getDrugsId());
                checkPrescription.setDrugsName(pharmacy.getDrugsName());
                checkPrescription.setSpecifications(pharmacy.getSpecifications());
                checkPrescription.setBatchNumber(pharmacy.getBatchNumber());
                checkPrescription.setManufacturer(pharmacy.getManufacturer());
                checkPrescription.setEffectiveTime(pharmacy.getEffectiveTime());
                checkPrescription.setTenantId(tenantId);
                checkPrescription.setCreateTime(checkDate);
                checkPrescription.setDelFlag("0");
                BigDecimal purchasePrice = pharmacy.getPurchasePrice();
                BigDecimal retailPrice = pharmacy.getRetailPrice();
                checkPrescription.setPurchasePrice(purchasePrice);
                checkPrescription.setRetailPrice(retailPrice);
                Integer plNumber = pharmacy.getActualInventory();
                checkPrescription.setPlNumber(plNumber);
                BigDecimal purchasePricePl = purchasePrice.multiply(BigDecimal.valueOf(plNumber.intValue()));
                checkPrescription.setPurchasePricePl(purchasePricePl);
                BigDecimal retailPricePl = retailPrice.multiply(BigDecimal.valueOf(plNumber.intValue()));
                checkPrescription.setRetailPricePl(retailPricePl);
                checkPrescription.setBookInventory(pharmacy.getBookStockNum());
                checkPrescription.setRealityInventory(pharmacy.getRealStockNum());
                return checkPrescription;
            }).forEach(checkPrescriptionList::add);
            this.sysDrugPharmacyCheckPrescriptionMapper.insertList(checkPrescriptionList);
            SysDrugPharmacyCheckEntity checkPharmacy = new SysDrugPharmacyCheckEntity();
            checkPharmacy.setId(checkId);
            checkPharmacy.setCheckTime(checkDate);
            checkPharmacy.setInventoryName("\u897f\u836f\u623f");
            checkPharmacy.setWarehouse("202401290919222322");
            checkPharmacy.setCheckNumber(Integer.valueOf(checkPrescriptionList.size()));
            checkPharmacy.setAuditUse("Excel\u6570\u636e\u76d8\u70b9");
            checkPharmacy.setCheckUse("Excel\u6570\u636e\u76d8\u70b9");
            checkPharmacy.setRemarks("Excel\u6570\u636e\u76d8\u70b9");
            checkPharmacy.setAuditStatus("4");
            checkPharmacy.setCheckType("2");
            checkPharmacy.setDelFlag("0");
            checkPharmacy.setTenantId(Integer.valueOf(1));
            BigDecimal purchasePricePl = checkPrescriptionList.stream().filter(checkPrescription -> checkPrescription.getPurchasePricePl() != null).map(SysDrugPharmacyCheckPrescriptionEntity::getPurchasePricePl).reduce(BigDecimal.ZERO, BigDecimal::add);
            checkPharmacy.setPurchasePricePl(purchasePricePl);
            BigDecimal retailPricePl = checkPrescriptionList.stream().filter(checkPrescription -> checkPrescription.getRetailPricePl() != null).map(SysDrugPharmacyCheckPrescriptionEntity::getRetailPricePl).reduce(BigDecimal.ZERO, BigDecimal::add);
            checkPharmacy.setRetailPricePl(retailPricePl);
            BigDecimal retailTotalAmount = checkPrescriptionList.stream().filter(checkPrescription -> checkPrescription.getRetailPrice() != null && checkPrescription.getPlNumber() != null).map(checkPrescription -> checkPrescription.getRetailPrice().multiply(BigDecimal.valueOf(checkPrescription.getRealityInventory().intValue()))).reduce(BigDecimal.ZERO, BigDecimal::add);
            checkPharmacy.setRetailPriceAmount(retailTotalAmount);
            this.sysDrugPharmacyCheckMapper.insert((Object)checkPharmacy);
            ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)"\u6d4b\u8bd5\u884c\u9519\u8bef\uff01");
        }
        catch (Exception e) {
            ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)e.getMessage());
        }
    }

    private String getCellStringValue(Row row, Integer num) {
        String value = Optional.ofNullable(row.getCell(num.intValue())).map(cell -> {
            switch (4.$SwitchMap$org$apache$poi$ss$usermodel$CellType[cell.getCellType().ordinal()]) {
                case 1: {
                    return cell.getStringCellValue();
                }
                case 2: {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                        return dateFormat.format(cell.getDateCellValue());
                    }
                    double numericValue = cell.getNumericCellValue();
                    if (numericValue == (double)((long)numericValue)) {
                        return String.valueOf((long)numericValue);
                    }
                    return String.valueOf(numericValue);
                }
                case 3: {
                    return String.valueOf(cell.getBooleanCellValue());
                }
                case 4: {
                    return cell.getCellFormula();
                }
            }
            return "";
        }).orElse(null);
        return value;
    }

    public void timingUploadDrugSellListByDto(UploadDrugSellDto dto) {
        String startDateStr = dto.getStartDate();
        String endDateStr = dto.getEndDate();
        LocalDate startDate = LocalDate.parse(startDateStr);
        LocalDate endDate = LocalDate.parse(endDateStr);
        Integer intervalDays = 5;
        ArrayList<UploadDrugSellDto> dtoList = new ArrayList<UploadDrugSellDto>();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate currentStart = startDate;
        while (!currentStart.isAfter(endDate)) {
            LocalDate currentEnd = currentStart.plusDays(intervalDays - 1).isAfter(endDate) ? endDate : currentStart.plusDays(intervalDays - 1);
            UploadDrugSellDto drugSellDto = new UploadDrugSellDto();
            drugSellDto.setStartDate(currentStart.format(formatter));
            drugSellDto.setEndDate(currentEnd.format(formatter));
            dtoList.add(drugSellDto);
            currentStart = currentEnd.plusDays(1L);
        }
        for (UploadDrugSellDto drugSellDto : dtoList) {
            this.timingUploadDrugSellList(drugSellDto.getStartDate(), drugSellDto.getEndDate(), startDateStr, endDateStr);
        }
    }

    public void timingUploadDrugSellList(String startDate, String endDate, String startRangeDate, String endRangeDate) {
        Integer tenantId = 1;
        startRangeDate = startRangeDate + " 00:00:00";
        endRangeDate = endRangeDate + " 23:59:59";
        List<String> dictTypes = Arrays.asList("bj_drug_list", "org_code");
        List dictValueList = this.selectDictValueList(dictTypes, tenantId);
        if (!dictValueList.isEmpty()) {
            Map<String, List<SysDictValueEntity>> dictValueMap = dictValueList.stream().collect(Collectors.groupingBy(SysDictValueEntity::getType));
            List bjDrugList = dictValueMap.getOrDefault("bj_drug_list", new ArrayList());
            List orgDictList = dictValueMap.getOrDefault("org_code", new ArrayList());
            if (!bjDrugList.isEmpty() && !orgDictList.isEmpty()) {
                String saleCode = "";
                String saleName = "";
                for (SysDictValueEntity entity2 : orgDictList) {
                    if (!"\u5357\u660c\u4f17\u5eb7\u533b\u9662\u6709\u9650\u516c\u53f8".equals(entity2.getLabel())) continue;
                    saleCode = entity2.getValue();
                    saleName = entity2.getLabel();
                }
                List internalCodes = bjDrugList.stream().map(entity -> {
                    try {
                        return Integer.parseInt(entity.getValue());
                    }
                    catch (NumberFormatException e) {
                        return null;
                    }
                }).filter(Objects::nonNull).collect(Collectors.toList());
                InventoryDataDto dto = new InventoryDataDto();
                dto.setTenantId(tenantId);
                dto.setInternalCodes(internalCodes);
                dto.setStartDate(startDate);
                dto.setEndDate(endDate);
                List saleDataList = this.sysDrugPharmacyMapper.selectSaleData(dto);
                BigDecimal totalNum = saleDataList.stream().filter(saleData -> saleData.getProductQty() != null).map(SaleData::getProductQty).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (!saleDataList.isEmpty()) {
                    LambdaQueryWrapper bjHosptialWrapper = Wrappers.lambdaQuery();
                    bjHosptialWrapper.between(BjHosptialInfoEntity::getSaleDate, (Object)startRangeDate, (Object)endRangeDate);
                    List bjHosptialList = this.bjHosptialInfoMapper.selectList((Wrapper)bjHosptialWrapper);
                    Map<String, List<BjHosptialInfoEntity>> bjHosptailMap = bjHosptialList.stream().collect(Collectors.groupingBy(entity -> entity.getPatientName() + entity.getProductName()));
                    ArrayList<SaleData> errorList = new ArrayList<SaleData>();
                    InventoryDataDto sourceDto = new InventoryDataDto();
                    sourceDto.setTenantId(tenantId);
                    sourceDto.setInternalCodes(internalCodes);
                    List outpatientNos = saleDataList.stream().filter(saleDate -> StrUtil.isNotEmpty((CharSequence)saleDate.getOutpatientNo())).map(SaleData::getOutpatientNo).distinct().collect(Collectors.toList());
                    sourceDto.setOutpatientNos(outpatientNos);
                    List bjHosptialContrastList = this.sysDrugPharmacyMapper.getBjHosptialContrastInfoList(sourceDto);
                    Map<String, List<BjHosptialContrast>> bjHosptialContrastMap = bjHosptialContrastList.stream().collect(Collectors.groupingBy(BjHosptialContrast::getOutpatientNo));
                    List diagnosisVoList = this.sysDrugPharmacyMapper.selectDiagnosisByOutpatientNos(tenantId, outpatientNos);
                    Map<String, List<OutDiagnosisVo>> diagnosisMap = diagnosisVoList.stream().collect(Collectors.groupingBy(OutDiagnosisVo::getOutpatientNo));
                    for (SaleData saleData2 : saleDataList) {
                        String search = saleData2.getPurchaseName() + saleData2.getTradeName();
                        List bjList = bjHosptailMap.getOrDefault(search, new ArrayList());
                        List diagnosisVos = diagnosisMap.getOrDefault(saleData2.getOutpatientNo(), new ArrayList());
                        if (!diagnosisVos.isEmpty()) {
                            OutDiagnosisVo diagnosisVo = (OutDiagnosisVo)diagnosisVos.get(0);
                            String indication = StrUtil.isEmpty((CharSequence)diagnosisVo.getDiagnosis()) ? diagnosisVo.getHsDiagnosis() : diagnosisVo.getDiagnosis();
                            saleData2.setIndication(indication);
                        }
                        if (!bjList.isEmpty()) {
                            String hosptial = ((BjHosptialInfoEntity)bjList.get(0)).getHosptial();
                            saleData2.setPurchaseName(hosptial);
                            String patientId = ((BjHosptialInfoEntity)bjList.get(0)).getPatientId();
                            if (StrUtil.isNotEmpty((CharSequence)patientId)) {
                                saleData2.setPatientId(patientId);
                            }
                        } else {
                            List bjHosptialContrasts = bjHosptialContrastMap.getOrDefault(saleData2.getOutpatientNo(), new ArrayList());
                            if (!bjHosptialContrasts.isEmpty()) {
                                String source = ((BjHosptialContrast)bjHosptialContrasts.get(0)).getSourceHospital();
                                saleData2.setPurchaseName(source);
                            } else {
                                errorList.add(saleData2);
                                saleData2.setPurchaseName("");
                            }
                        }
                        saleData2.setSellerCode(saleCode);
                        saleData2.setSellerName(saleName);
                        saleData2.setPurchaseCode(saleCode);
                    }
                    String msg = JSONObject.toJSONString((Object)saleDataList);
                    String uuid = UUIDUtils.getRandom((int)15, (boolean)true);
                    this.rocketMQProducer.asyncSendCallback(sendDrugSellTopic, "TAG9", msg, (SendCallback)new /* Unavailable Anonymous Inner Class!! */, uuid);
                }
            }
        }
    }

    @Scheduled(cron="0 45 1 * * ?")
    public void timingUploadDrugPurchaseList() {
        Integer tenantId = 1;
        List<String> dictTypes = Arrays.asList("bj_drug_list", "org_code");
        List dictValueList = this.selectDictValueList(dictTypes, tenantId);
        if (!dictValueList.isEmpty()) {
            Map<String, List<SysDictValueEntity>> dictValueMap = dictValueList.stream().collect(Collectors.groupingBy(SysDictValueEntity::getType));
            List bjDrugList = dictValueMap.getOrDefault("bj_drug_list", new ArrayList());
            List orgDictList = dictValueMap.getOrDefault("org_code", new ArrayList());
            if (!bjDrugList.isEmpty() && !orgDictList.isEmpty()) {
                String purchaseCode = "";
                String purchaseName = "";
                String saleCode = "";
                String saleName = "";
                for (SysDictValueEntity entity2 : orgDictList) {
                    String orgCode = entity2.getValue();
                    String orgName = entity2.getLabel();
                    if ("\u5357\u660c\u4f17\u5eb7\u533b\u9662\u6709\u9650\u516c\u53f8".equals(orgName)) {
                        purchaseCode = orgCode;
                        purchaseName = orgName;
                        continue;
                    }
                    if (!"\u6c5f\u897f\u5357\u534e\u533b\u836f\u6709\u9650\u516c\u53f8".equals(orgName)) continue;
                    saleCode = orgCode;
                    saleName = orgName;
                }
                List internalCodes = bjDrugList.stream().map(entity -> {
                    try {
                        return Integer.parseInt(entity.getValue());
                    }
                    catch (NumberFormatException e) {
                        return null;
                    }
                }).filter(Objects::nonNull).collect(Collectors.toList());
                LocalDate yesterday = LocalDate.now().minusDays(1L);
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                String yesterdayStr = yesterday.format(formatter);
                InventoryDataDto dto = new InventoryDataDto();
                dto.setTenantId(tenantId);
                dto.setInternalCodes(internalCodes);
                dto.setStartDate(yesterdayStr);
                dto.setEndDate(yesterdayStr);
                List procuremDataList = this.sysDrugPharmacyMapper.selectProcuremData(dto);
                if (!procuremDataList.isEmpty()) {
                    for (ProcuremData data : procuremDataList) {
                        data.setSellerCode(saleCode);
                        data.setSellerName(saleName);
                        data.setPurchaseCode(purchaseCode);
                        data.setPurchaseName(purchaseName);
                    }
                    String msg = JSONObject.toJSONString((Object)procuremDataList);
                    String uuid = UUIDUtils.getRandom((int)15, (boolean)true);
                    this.rocketMQProducer.asyncSendCallback(sendDrugPurchaseTopic, "TAG10", msg, (SendCallback)new /* Unavailable Anonymous Inner Class!! */, uuid);
                }
            }
        }
    }

    @Scheduled(cron="0 30 22 * * ?")
    public void timingUploadDrugStockList() {
        Integer tenantId = 1;
        List<String> dictTypes = Arrays.asList("bj_drug_list", "org_code");
        List dictValueList = this.selectDictValueList(dictTypes, tenantId);
        if (!dictValueList.isEmpty()) {
            Map<String, List<SysDictValueEntity>> dictValueMap = dictValueList.stream().collect(Collectors.groupingBy(SysDictValueEntity::getType));
            List bjDrugList = dictValueMap.getOrDefault("bj_drug_list", new ArrayList());
            List orgDictList = dictValueMap.getOrDefault("org_code", new ArrayList());
            if (!bjDrugList.isEmpty() && !orgDictList.isEmpty()) {
                String orgCode = "";
                String orgName = "";
                for (SysDictValueEntity entity2 : orgDictList) {
                    if (!"\u5357\u660c\u4f17\u5eb7\u533b\u9662\u6709\u9650\u516c\u53f8".equals(entity2.getLabel())) continue;
                    orgCode = entity2.getValue();
                    orgName = entity2.getLabel();
                }
                List internalCodes = bjDrugList.stream().map(entity -> {
                    try {
                        return Integer.parseInt(entity.getValue());
                    }
                    catch (NumberFormatException e) {
                        return null;
                    }
                }).filter(Objects::nonNull).collect(Collectors.toList());
                InventoryDataDto dto = new InventoryDataDto();
                dto.setTenantId(tenantId);
                dto.setInternalCodes(internalCodes);
                List inventoryDataList = this.sysDrugPharmacyMapper.selectInVentoryData(dto);
                if (!inventoryDataList.isEmpty()) {
                    for (InventoryData data : inventoryDataList) {
                        data.setPurchaseCode(orgCode);
                        data.setPurchaseName(orgName);
                        data.setStockStatus("\u6b63\u5e38\u53ef\u9500");
                    }
                    String msg = JSONObject.toJSONString((Object)inventoryDataList);
                    String uuid = UUIDUtils.getRandom((int)15, (boolean)true);
                    this.rocketMQProducer.asyncSendCallback(sendDrugStockTopic, "TAG11", msg, (SendCallback)new /* Unavailable Anonymous Inner Class!! */, uuid);
                }
            }
        }
    }

    private List<SysDictValueEntity> selectDictValueList(List<String> dictTypes, Integer tenantId) {
        LambdaQueryWrapper dictValueQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDictValueEntity::getTenantId, (Object)tenantId)).eq(BaseEntity::getDelFlag, (Object)DelFlagEnum.NOT_FLAG.getValue())).in(SysDictValueEntity::getType, dictTypes);
        return this.sysDictValueMapper.selectList((Wrapper)dictValueQueryWrapper);
    }

    public void sysDrugPharmacySave(SysDrugPharmacySaveDto dto) {
        SysDrugPharmacyEntity entity = (SysDrugPharmacyEntity)BeanUtil.copy((Object)dto, SysDrugPharmacyEntity.class);
        int a = this.sysDrugPharmacyMapper.sysDrugPharmacySave(entity);
    }

    public List<SysDrugPharmacyVo> sysDrugPharmacySelect(SysDrugPharmacyDto dto) {
        List list = this.sysDrugPharmacyMapper.sysDrugPharmacySelect(dto);
        return list;
    }

    public void sysDrugPharmacyUpdate(SysDrugPharmacyUpdateDto dto) {
        SysDrugPharmacyEntity entity = (SysDrugPharmacyEntity)BeanUtil.copy((Object)dto, SysDrugPharmacyEntity.class);
        int a = this.sysDrugPharmacyMapper.sysDrugPharmacyUpdate(entity);
    }

    public void sysDrugPharmacyDelete(String[] ids) {
        int a = this.sysDrugPharmacyMapper.sysDrugPharmacyDelete(ids);
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }
}

