/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.PinyinUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.sys.api.dto.SysDrugDto;
import com.byh.sys.api.dto.drug.SysDrugInDto;
import com.byh.sys.api.dto.drug.drugPharmacSimple.SysDrugPharmacySimpleSaveDto;
import com.byh.sys.api.enums.DelFlagEnum;
import com.byh.sys.api.enums.DictEnums;
import com.byh.sys.api.enums.HsDrugUploadStatusEnum;
import com.byh.sys.api.enums.SysDrugTypeEnum;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.PurchaseOrderEntity;
import com.byh.sys.api.model.dict.SysDictValueEntity;
import com.byh.sys.api.model.drug.SysDrugClassificationEntity;
import com.byh.sys.api.model.drug.SysDrugClassificationMiddleEntity;
import com.byh.sys.api.model.drug.SysDrugEntity;
import com.byh.sys.api.model.drug.inventory.SysDrugInventoryCheckEntity;
import com.byh.sys.api.model.drug.inventory.SysDrugInventoryInEntity;
import com.byh.sys.api.model.drug.inventory.SysDrugInventoryInPrescriptionEntity;
import com.byh.sys.api.model.drug.inventory.SysDrugTogetherEntity;
import com.byh.sys.api.request.UploadCatalogRequest;
import com.byh.sys.api.util.ExceptionUtils;
import com.byh.sys.api.util.HttpKit;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.api.util.StringUtils;
import com.byh.sys.api.util.UUIDUtils;
import com.byh.sys.api.vo.DictValueVo;
import com.byh.sys.api.vo.SysDoctorVo;
import com.byh.sys.data.repository.SysDictMapper;
import com.byh.sys.data.repository.SysDictValueMapper;
import com.byh.sys.data.repository.SysDrugClassificationMapper;
import com.byh.sys.data.repository.SysDrugClassificationMiddleMapper;
import com.byh.sys.data.repository.SysDrugInventoryCheckMapper;
import com.byh.sys.data.repository.SysDrugInventoryInMapper;
import com.byh.sys.data.repository.SysDrugInventoryInPrescriptionMapper;
import com.byh.sys.data.repository.SysDrugMapper;
import com.byh.sys.data.repository.SysDrugPharmacySimpleMapper;
import com.byh.sys.data.repository.SysDrugTogetherMapper;
import com.byh.sys.data.repository.SysHsInfoMapper;
import com.byh.sys.web.fegin.HsServiceFeign;
import com.byh.sys.web.service.SysDrugPharmacySimpleService;
import com.byh.sys.web.service.SysDrugService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Resource;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

@Service
public class SysDrugServiceImpl
extends ServiceImpl<SysDrugMapper, SysDrugEntity>
implements SysDrugService {
    private static final Logger log = LoggerFactory.getLogger(SysDrugServiceImpl.class);
    @Autowired
    private HsServiceFeign hsServiceFeign;
    @Autowired
    private SysDrugPharmacySimpleService sysDrugPharmacySimpleService;
    @Resource
    private SysHsInfoMapper sysHsInfoMapper;
    @Resource
    private SysDrugPharmacySimpleMapper sysDrugPharmacySimpleMapper;
    @Resource
    private SysDrugInventoryCheckMapper sysDrugInventoryCheckMapper;
    @Resource
    private SysDrugInventoryInMapper sysDrugInventoryInMapper;
    @Resource
    private SysDrugInventoryInPrescriptionMapper sysDrugInventoryInPrescriptionMapper;
    @Resource
    private SysDrugTogetherMapper sysDrugTogetherMapper;
    @Resource
    private SysDrugMapper sysDrugMapper;
    @Resource
    private SysDictMapper sysDictMapper;
    @Resource
    private SysDrugClassificationMapper sysDrugClassificationMapper;
    @Resource
    private SysDrugClassificationMiddleMapper sysDrugClassificationMiddleMapper;
    @Resource
    private SysDictValueMapper sysDictValueMapper;
    @Value(value="${medicalCloudUrl}")
    private String medicalCloudUrl;
    private static final String weDosageForm = "we_dosage_form";
    private static final String cnDosageForm = "cn_dosage_form";
    private Logger logger = LoggerFactory.getLogger(SysDrugServiceImpl.class);

    @Transactional(rollbackFor={BusinessException.class})
    public void importAndUpdateSpecies(MultipartFile file, Integer tenantId) {
        try {
            InputStream inputStream = file.getInputStream();
            XSSFWorkbook workbook = new XSSFWorkbook(inputStream);
            XSSFSheet sheet = workbook.getSheetAt(0);
            ArrayList<SysDrugEntity> importList = new ArrayList<SysDrugEntity>();
            Integer count = 0;
            for (Row row : sheet) {
                if (count < 1) {
                    Integer n = count;
                    Integer n2 = count = Integer.valueOf(count + 1);
                    continue;
                }
                SysDrugEntity drug = new SysDrugEntity();
                String internalCode = row.getCell(5).getStringCellValue();
                drug.setInternalCode(Integer.valueOf(internalCode));
                String classificationName = row.getCell(12).getStringCellValue();
                drug.setClassificationName(classificationName);
                importList.add(drug);
            }
            List internalCodes = importList.stream().map(SysDrugEntity::getInternalCode).filter(Objects::nonNull).collect(Collectors.toList());
            List drugList = ((SysDrugMapper)this.baseMapper).selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysDrugEntity.class).eq(tenantId != null, SysDrugEntity::getTenantId, (Object)tenantId)).eq(SysDrugEntity::getDelFlag, (Object)DelFlagEnum.NOT_FLAG.getValue())).eq(SysDrugEntity::getStatus, (Object)"0")).in(SysDrugEntity::getInternalCode, internalCodes));
            List classList = this.sysDrugClassificationMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysDrugClassificationEntity.class).eq(tenantId != null, SysDrugClassificationEntity::getTenantId, (Object)tenantId)).eq(SysDrugClassificationEntity::getDelFlag, (Object)DelFlagEnum.NOT_FLAG.getValue()));
            Map<String, Integer> classMap = classList.stream().collect(Collectors.toMap(SysDrugClassificationEntity::getName, SysDrugClassificationEntity::getId));
            for (SysDrugEntity drug : importList) {
                Integer classId = classMap.get(drug.getClassificationName());
                if (classId == null) continue;
                drug.setClassificationId(classId);
            }
            Map importMap = importList.stream().collect(Collectors.toMap(SysDrugEntity::getInternalCode, Function.identity()));
            List drugIds = drugList.stream().map(SysDrugEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper deleteWrapper = Wrappers.lambdaQuery();
            deleteWrapper.eq(tenantId != null, SysDrugClassificationMiddleEntity::getTenantId, (Object)tenantId);
            deleteWrapper.in(SysDrugClassificationMiddleEntity::getDrugId, drugIds);
            this.sysDrugClassificationMiddleMapper.delete((Wrapper)deleteWrapper);
            ArrayList<SysDrugClassificationMiddleEntity> middleList = new ArrayList<SysDrugClassificationMiddleEntity>();
            for (SysDrugEntity drug : drugList) {
                SysDrugEntity dbDrug = (SysDrugEntity)importMap.get(drug.getInternalCode());
                if (dbDrug != null) {
                    drug.setClassificationId(dbDrug.getClassificationId());
                    drug.setClassificationName(dbDrug.getClassificationName());
                }
                drug.setUpdateTime(new Date());
                ((SysDrugMapper)this.baseMapper).updateById((Object)drug);
                SysDrugClassificationMiddleEntity middleEntity = new SysDrugClassificationMiddleEntity();
                middleEntity.setTenantId(tenantId);
                middleEntity.setDrugId(drug.getId());
                middleEntity.setClassificationId(drug.getClassificationId());
                middleList.add(middleEntity);
            }
            if (!middleList.isEmpty()) {
                this.sysDrugClassificationMiddleMapper.insertList(middleList);
            }
        }
        catch (Exception e) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)e.getMessage());
            this.logger.info(e.getMessage());
        }
    }

    public void importDualDrug(MultipartFile file, Integer tenantId) throws IOException {
        InputStream inputStream = file.getInputStream();
        XSSFWorkbook workbook = new XSSFWorkbook(inputStream);
        XSSFSheet sheet = workbook.getSheetAt(0);
        ArrayList<String> medicalInsuranceCodeList = new ArrayList<String>();
        int count = 0;
        for (Row row : sheet) {
            if (count == 0) {
                ++count;
                continue;
            }
            ++count;
            int physicalNumberOfCells = row.getPhysicalNumberOfCells();
            if (physicalNumberOfCells <= 1) continue;
            String medicalInsuranceCode = row.getCell(13).getStringCellValue();
            medicalInsuranceCodeList.add(medicalInsuranceCode);
        }
        List sysDrugEntities = this.sysDrugMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(SysDrugEntity::getMedicalInsuranceCode, medicalInsuranceCodeList));
        List collect = sysDrugEntities.stream().map(item -> item.getMedicalInsuranceCode()).collect(Collectors.toList());
        ArrayList<SysDrugEntity> insertDrugList = new ArrayList<SysDrugEntity>();
        List wePackUnits = this.sysDictValueMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDictValueEntity::getTenantId, (Object)1)).eq(SysDictValueEntity::getType, (Object)"we_pack_units"));
        Map<String, String> unitsMap = wePackUnits.stream().collect(Collectors.toMap(SysDictValueEntity::getLabel, SysDictValueEntity::getValue));
        Set<String> unitsLabelSet = unitsMap.keySet();
        ArrayList<String> unitsLabelList = new ArrayList<String>();
        unitsLabelList.addAll(unitsLabelSet);
        Collections.sort(unitsLabelList, new /* Unavailable Anonymous Inner Class!! */);
        count = 0;
        for (Row row : sheet) {
            String medicalInsuranceCode;
            if (count == 0) {
                ++count;
                continue;
            }
            ++count;
            int physicalNumberOfCells = row.getPhysicalNumberOfCells();
            if (physicalNumberOfCells <= 1 || collect.contains(medicalInsuranceCode = row.getCell(13).getStringCellValue())) continue;
            String drugName = row.getCell(1).getStringCellValue();
            System.out.println(drugName);
            String thirdCode = "";
            String specifications = row.getCell(3).getStringCellValue();
            specifications = specifications.replaceAll(" ", "").replaceAll("\\*\\*", "*");
            String manufacturer = row.getCell(4).getStringCellValue();
            double numericCellValue = 0.0;
            String approvalNumber = "";
            try {
                numericCellValue = row.getCell(5).getNumericCellValue();
                thirdCode = row.getCell(0).getStringCellValue();
                approvalNumber = row.getCell(17).getStringCellValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            String doseUnit = "";
            String packSmallUnitsLabel = "";
            String packLargeUnits = "";
            String s = "";
            try {
                String[] unitArr = new String[2];
                if (specifications.contains(":")) {
                    unitArr = specifications.split(":");
                    s = specifications.split(":")[0];
                    doseUnit = s.substring(s.length() - 2, s.length());
                } else if (specifications.contains("*")) {
                    unitArr = specifications.split("\\*");
                    s = unitArr[0];
                    doseUnit = s.substring(s.length() - 2, s.length());
                } else if (specifications.contains("x")) {
                    unitArr = specifications.split("x");
                    s = unitArr[0];
                    doseUnit = s.substring(s.length() - 2, s.length());
                } else if (specifications.contains("\u00d7")) {
                    unitArr = specifications.split("\u00d7");
                    s = unitArr[0];
                    doseUnit = s.substring(s.length() - 2, s.length());
                } else if (specifications.contains("/")) {
                    unitArr = specifications.split("/");
                    s = unitArr[0];
                    doseUnit = s.substring(s.length() - 2, s.length());
                } else if (specifications.contains("[")) {
                    unitArr = specifications.split("\\[");
                    s = unitArr[0];
                    doseUnit = s.substring(s.length() - 2, s.length());
                }
                if (!StringUtils.isBlank((String)doseUnit)) {
                    String substring = doseUnit.substring(0, 1);
                    if (substring.matches("-?\\d+(\\.\\d+)?") || substring.contains("*") || substring.contains("/") || substring.contains(" ")) {
                        doseUnit = doseUnit.substring(1, 2);
                    }
                } else {
                    s = doseUnit = specifications.replaceAll("[0-9]", "");
                }
                if (specifications.contains("/")) {
                    String[] split = specifications.split("/");
                    packLargeUnits = split[split.length - 1];
                    packSmallUnitsLabel = split[split.length - 2].length() == 1 ? split[0].substring(split[0].length() - 2, split[0].length()) : split[split.length - 2].substring(split[split.length - 2].length() - 2, split[split.length - 2].length());
                    if (packSmallUnitsLabel.equals(")") || packSmallUnitsLabel.equals("\uff09") || packSmallUnitsLabel.equals(" ")) {
                        packSmallUnitsLabel = split[split.length - 2].substring(split[split.length - 2].length() - 2, split[split.length - 2].length() - 1);
                    }
                    if (packSmallUnitsLabel.substring(0, 1).matches("-?\\d+(\\.\\d+)?") || packSmallUnitsLabel.substring(0, 1).contains("*") || packSmallUnitsLabel.substring(0, 1).contains("/") || packSmallUnitsLabel.substring(0, 1).contains(" ")) {
                        packSmallUnitsLabel = packSmallUnitsLabel.substring(1, 2);
                    }
                    if (packLargeUnits.contains(" ")) {
                        packLargeUnits = packLargeUnits.substring(1, packLargeUnits.length());
                    }
                } else if (specifications.contains("[")) {
                    packSmallUnitsLabel = unitArr[0].substring(unitArr[0].length() - 2, unitArr[0].length());
                    packLargeUnits = unitArr[0].substring(unitArr[0].length() - 2, unitArr[0].length());
                    if (packSmallUnitsLabel.substring(0, 1).matches("-?\\d+(\\.\\d+)?") || packSmallUnitsLabel.substring(0, 1).contains("*") || packSmallUnitsLabel.substring(0, 1).contains("/") || packSmallUnitsLabel.substring(0, 1).contains(" ")) {
                        packSmallUnitsLabel = packSmallUnitsLabel.substring(1, 2);
                    }
                    if (packLargeUnits.substring(0, 1).matches("-?\\d+(\\.\\d+)?") || packLargeUnits.contains("*") || packLargeUnits.contains("/") || packLargeUnits.contains(" ")) {
                        packLargeUnits = packLargeUnits.substring(1, 2);
                    }
                } else if (unitArr[0] != null) {
                    packSmallUnitsLabel = unitArr[0].substring(unitArr[0].length() - 2, unitArr[0].length());
                    packLargeUnits = unitArr[1].length() == 1 ? unitArr[2].substring(unitArr[2].length() - 2, unitArr[2].length()) : unitArr[1].substring(unitArr[1].length() - 2, unitArr[1].length());
                    if (packSmallUnitsLabel.substring(0, 1).matches("-?\\d+(\\.\\d+)?") || packSmallUnitsLabel.substring(0, 1).contains("*") || packSmallUnitsLabel.substring(0, 1).contains("/") || packSmallUnitsLabel.substring(0, 1).contains(" ")) {
                        packSmallUnitsLabel = packSmallUnitsLabel.substring(1, 2);
                    }
                    if (packLargeUnits.substring(0, 1).matches("-?\\d+(\\.\\d+)?") || packLargeUnits.substring(0, 1).contains("*") || packLargeUnits.substring(0, 1).contains("/") || packLargeUnits.substring(0, 1).contains(" ")) {
                        packLargeUnits = packLargeUnits.substring(1, 2);
                    }
                } else {
                    packSmallUnitsLabel = specifications.replaceAll("[0-9]", "");
                    packLargeUnits = specifications.replaceAll("[0-9]", "");
                }
            }
            catch (Exception e) {
                System.out.println(specifications);
                throw e;
            }
            if (!unitsLabelList.contains(doseUnit)) {
                for (String label : unitsLabelList) {
                    if (!s.contains(label)) continue;
                    doseUnit = label;
                    break;
                }
            }
            if (!unitsLabelList.contains(packSmallUnitsLabel)) {
                if (specifications.contains("/")) {
                    packSmallUnitsLabel = specifications.split("/")[0];
                }
                for (String label : unitsLabelList) {
                    if (!packSmallUnitsLabel.contains(label)) continue;
                    packSmallUnitsLabel = label;
                    break;
                }
            }
            if (!unitsLabelList.contains(packLargeUnits)) {
                for (String label : unitsLabelList) {
                    if (!packLargeUnits.contains(label)) continue;
                    packLargeUnits = label;
                    break;
                }
            }
            String packSpecification = "";
            packSpecification = specifications.contains("*") ? specifications.substring(specifications.indexOf(42), specifications.indexOf(42) + 4 > specifications.length() ? specifications.length() : specifications.indexOf(42) + 4) : (specifications.contains("x") ? specifications.substring(specifications.indexOf(120), specifications.indexOf(120) + 4 > specifications.length() ? specifications.length() : specifications.indexOf(120) + 4) : (specifications.contains("\u00d7") ? specifications.substring(specifications.indexOf(215), specifications.indexOf(215) + 4 > specifications.length() ? specifications.length() : specifications.indexOf(215) + 4) : (specifications.contains("/") ? specifications.substring(0, specifications.indexOf(47)) : (specifications.contains("[") ? "1" : (specifications.contains(":") ? "1" : "1")))));
            packSpecification = packSpecification.replaceAll("[^0-9]", "");
            System.out.println(specifications);
            System.out.println(packSpecification);
            System.out.println(doseUnit);
            System.out.println(packSmallUnitsLabel);
            System.out.println(packLargeUnits);
            System.out.println("--------------------------------------------------");
            String pinYin = PinyinUtil.getPinYin((String)drugName);
            SysDrugEntity drug = new SysDrugEntity();
            String guiID = UUIDUtils.getRandom((int)5, (boolean)true);
            drug.setId(guiID);
            drug.setDrugsName(drugName);
            drug.setTradeName(drugName);
            drug.setDrugsNamePinyinCode(pinYin);
            drug.setTradeNamePinyinCode(pinYin);
            drug.setDrugType("2");
            drug.setMedicalInsuranceCode(medicalInsuranceCode);
            drug.setMedicalInsuranceName(drugName);
            drug.setDrugClassification("1");
            drug.setFeeCategory("1");
            drug.setSpecifications(specifications);
            drug.setDrugProperties("0");
            drug.setManufacturer(manufacturer);
            drug.setThirdCode(thirdCode);
            drug.setDefaultUsageUnit(unitsMap.get(doseUnit));
            drug.setDefaultSingleDoseUnit(unitsMap.get(doseUnit));
            drug.setPackSmallUnits(unitsMap.get(packSmallUnitsLabel));
            drug.setPackSmallUnitsLabel(packSmallUnitsLabel);
            drug.setPackLargeUnits(unitsMap.get(packLargeUnits));
            drug.setPackLargeUnitsLabel(packLargeUnits);
            drug.setPackSpecification(packSpecification);
            drug.setRetailPrice(new BigDecimal(numericCellValue));
            drug.setStatus("0");
            drug.setDelFlag("0");
            drug.setTenantId(Integer.valueOf(1));
            drug.setApprovalNumber(approvalNumber);
            drug.setRemark("\u5904\u65b9\u6d41\u8f6c\u65b0\u589e\u836f\u54c1");
            insertDrugList.add(drug);
        }
        if (insertDrugList.size() > 0) {
            this.sysDrugMapper.batchInsertDualDrug(insertDrugList);
        }
        List dualDrugList = this.sysDrugMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugEntity::getTenantId, (Object)1)).in(SysDrugEntity::getMedicalInsuranceCode, medicalInsuranceCodeList));
        List drugIds = dualDrugList.stream().map(item -> item.getId()).collect(Collectors.toList());
        SysDrugPharmacySimpleSaveDto dto = new SysDrugPharmacySimpleSaveDto();
        dto.setDrugsIds(drugIds);
        dto.setTenantId(Integer.valueOf(1));
        dto.setCreateId(Integer.valueOf(1));
        ResponseData responseData = this.sysDrugPharmacySimpleService.sysDrugPharmacySimpleSaveToDual(dto);
        System.out.println("\u5b8c\u6210");
    }

    public void importUpdateDualDrug(MultipartFile file, Integer tenantId) throws IOException {
        InputStream inputStream = file.getInputStream();
        XSSFWorkbook workbook = new XSSFWorkbook(inputStream);
        XSSFSheet sheet = workbook.getSheetAt(0);
        int checkIndex = 0;
        ArrayList<int[]> indexList = new ArrayList<int[]>();
        indexList.add(new int[]{13, 1, 3, 4, 5, 0, 16, 20});
        indexList.add(new int[]{0, 6, 7, 8, 9, 4, 20});
        int[] index = (int[])indexList.get(checkIndex);
        ArrayList<String> medicalInsuranceCodeList = new ArrayList<String>();
        int count = 0;
        for (Row row : sheet) {
            if (count == 0) {
                ++count;
                continue;
            }
            ++count;
            int physicalNumberOfCells = row.getPhysicalNumberOfCells();
            if (physicalNumberOfCells <= 1) continue;
            String medicalInsuranceCode = row.getCell(index[0]).getStringCellValue();
            medicalInsuranceCodeList.add(medicalInsuranceCode);
        }
        List sysDrugEntities = this.sysDrugMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(SysDrugEntity::getMedicalInsuranceCode, medicalInsuranceCodeList)).eq(SysDrugEntity::getRemark, (Object)"\u5904\u65b9\u6d41\u8f6c\u65b0\u589e\u836f\u54c1"));
        List collect = sysDrugEntities.stream().map(item -> item.getMedicalInsuranceCode()).collect(Collectors.toList());
        ArrayList<SysDrugEntity> insertDrugList = new ArrayList<SysDrugEntity>();
        List wePackUnits = this.sysDictValueMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDictValueEntity::getTenantId, (Object)1)).eq(SysDictValueEntity::getType, (Object)"we_pack_units"));
        Map<String, String> unitsMap = wePackUnits.stream().collect(Collectors.toMap(SysDictValueEntity::getLabel, SysDictValueEntity::getValue));
        Set<String> unitsLabelSet = unitsMap.keySet();
        ArrayList<String> unitsLabelList = new ArrayList<String>();
        unitsLabelList.addAll(unitsLabelSet);
        Collections.sort(unitsLabelList, new /* Unavailable Anonymous Inner Class!! */);
        count = 0;
        for (Row row : sheet) {
            String substring;
            String medicalInsuranceCode;
            if (count == 0) {
                ++count;
                continue;
            }
            ++count;
            int physicalNumberOfCells = row.getPhysicalNumberOfCells();
            if (physicalNumberOfCells <= 1 || !collect.contains(medicalInsuranceCode = row.getCell(index[0]).getStringCellValue())) continue;
            String drugName = row.getCell(index[1]).getStringCellValue();
            System.out.println(drugName);
            String thirdCode = "";
            String specifications = row.getCell(index[2]).getStringCellValue();
            specifications = specifications.replaceAll(" ", "").replaceAll("\\*\\*", "*");
            String manufacturer = row.getCell(index[3]).getStringCellValue();
            double numericCellValue = 0.0;
            String approvalNumber = "";
            try {
                numericCellValue = row.getCell(index[4]).getNumericCellValue();
                thirdCode = (row.getCell(index[5]).getNumericCellValue() + "").replaceAll("\\.0", "");
                approvalNumber = row.getCell(index[6]).getStringCellValue();
            }
            catch (Exception e) {
                try {
                    thirdCode = row.getCell(index[5]).getStringCellValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            String doseUnit = "";
            String packSmallUnitsLabel = "";
            String packLargeUnits = "";
            String s = "";
            try {
                String[] unitArr = new String[2];
                if (specifications.contains(":")) {
                    unitArr = specifications.split(":");
                    s = specifications.split(":")[0];
                    doseUnit = s.substring(s.length() - 2, s.length());
                } else if (specifications.contains("*")) {
                    unitArr = specifications.split("\\*");
                    s = unitArr[0];
                    doseUnit = s.substring(s.length() - 2, s.length());
                } else if (specifications.contains("x")) {
                    unitArr = specifications.split("x");
                    s = unitArr[0];
                    doseUnit = s.substring(s.length() - 2, s.length());
                } else if (specifications.contains("\u00d7")) {
                    unitArr = specifications.split("\u00d7");
                    s = unitArr[0];
                    doseUnit = s.substring(s.length() - 2, s.length());
                } else if (specifications.contains("/")) {
                    unitArr = specifications.split("/");
                    s = unitArr[0];
                    doseUnit = s.substring(s.length() - 2, s.length());
                } else if (specifications.contains("[")) {
                    unitArr = specifications.split("\\[");
                    s = unitArr[0];
                    doseUnit = s.substring(s.length() - 2, s.length());
                }
                if (!StringUtils.isBlank((String)doseUnit)) {
                    substring = doseUnit.substring(0, 1);
                    if (substring.matches("-?\\d+(\\.\\d+)?") || substring.contains("*") || substring.contains("/") || substring.contains(" ")) {
                        doseUnit = doseUnit.substring(1, 2);
                    }
                } else {
                    s = doseUnit = specifications.replaceAll("[0-9]", "");
                }
                if (specifications.contains("/")) {
                    String[] split = specifications.split("/");
                    packLargeUnits = split[split.length - 1];
                    packSmallUnitsLabel = split[split.length - 2].length() == 1 ? split[0].substring(split[0].length() - 2, split[0].length()) : split[split.length - 2].substring(split[split.length - 2].length() - 2, split[split.length - 2].length());
                    if (packSmallUnitsLabel.equals(")") || packSmallUnitsLabel.equals("\uff09") || packSmallUnitsLabel.equals(" ")) {
                        packSmallUnitsLabel = split[split.length - 2].substring(split[split.length - 2].length() - 2, split[split.length - 2].length() - 1);
                    }
                    if (packSmallUnitsLabel.substring(0, 1).matches("-?\\d+(\\.\\d+)?") || packSmallUnitsLabel.substring(0, 1).contains("*") || packSmallUnitsLabel.substring(0, 1).contains("/") || packSmallUnitsLabel.substring(0, 1).contains(" ")) {
                        packSmallUnitsLabel = packSmallUnitsLabel.substring(1, 2);
                    }
                    if (packLargeUnits.contains(" ")) {
                        packLargeUnits = packLargeUnits.substring(1, packLargeUnits.length());
                    }
                } else if (specifications.contains("[")) {
                    packSmallUnitsLabel = unitArr[0].substring(unitArr[0].length() - 2, unitArr[0].length());
                    packLargeUnits = unitArr[0].substring(unitArr[0].length() - 2, unitArr[0].length());
                    if (packSmallUnitsLabel.substring(0, 1).matches("-?\\d+(\\.\\d+)?") || packSmallUnitsLabel.substring(0, 1).contains("*") || packSmallUnitsLabel.substring(0, 1).contains("/") || packSmallUnitsLabel.substring(0, 1).contains(" ")) {
                        packSmallUnitsLabel = packSmallUnitsLabel.substring(1, 2);
                    }
                    if (packLargeUnits.substring(0, 1).matches("-?\\d+(\\.\\d+)?") || packLargeUnits.contains("*") || packLargeUnits.contains("/") || packLargeUnits.contains(" ")) {
                        packLargeUnits = packLargeUnits.substring(1, 2);
                    }
                } else if (unitArr[0] != null) {
                    packSmallUnitsLabel = unitArr[0].substring(unitArr[0].length() - 2, unitArr[0].length());
                    packLargeUnits = unitArr[1].length() == 1 ? unitArr[2].substring(unitArr[2].length() - 2, unitArr[2].length()) : unitArr[1].substring(unitArr[1].length() - 2, unitArr[1].length());
                    if (packSmallUnitsLabel.substring(0, 1).matches("-?\\d+(\\.\\d+)?") || packSmallUnitsLabel.substring(0, 1).contains("*") || packSmallUnitsLabel.substring(0, 1).contains("/") || packSmallUnitsLabel.substring(0, 1).contains(" ")) {
                        packSmallUnitsLabel = packSmallUnitsLabel.substring(1, 2);
                    }
                    if (packLargeUnits.substring(0, 1).matches("-?\\d+(\\.\\d+)?") || packLargeUnits.substring(0, 1).contains("*") || packLargeUnits.substring(0, 1).contains("/") || packLargeUnits.substring(0, 1).contains(" ")) {
                        packLargeUnits = packLargeUnits.substring(1, 2);
                    }
                } else {
                    packSmallUnitsLabel = specifications.replaceAll("[0-9]", "");
                    packLargeUnits = specifications.replaceAll("[0-9]", "");
                }
            }
            catch (Exception e) {
                System.out.println(specifications);
                throw e;
            }
            if (!unitsLabelList.contains(doseUnit)) {
                for (String label : unitsLabelList) {
                    if (!s.contains(label)) continue;
                    doseUnit = label;
                    break;
                }
            }
            if (!unitsLabelList.contains(packSmallUnitsLabel)) {
                if (specifications.contains("/")) {
                    packSmallUnitsLabel = specifications.split("/")[0];
                }
                for (String label : unitsLabelList) {
                    if (!packSmallUnitsLabel.contains(label)) continue;
                    packSmallUnitsLabel = label;
                    break;
                }
            }
            if (!unitsLabelList.contains(packLargeUnits)) {
                for (String label : unitsLabelList) {
                    if (!packLargeUnits.contains(label)) continue;
                    packLargeUnits = label;
                    break;
                }
            }
            String packSpecification = "";
            packSpecification = specifications.contains("*") ? specifications.substring(specifications.indexOf(42), specifications.indexOf(42) + 4 > specifications.length() ? specifications.length() : specifications.indexOf(42) + 4) : (specifications.contains("x") ? specifications.substring(specifications.indexOf(120), specifications.indexOf(120) + 4 > specifications.length() ? specifications.length() : specifications.indexOf(120) + 4) : (specifications.contains("\u00d7") ? specifications.substring(specifications.indexOf(215), specifications.indexOf(215) + 4 > specifications.length() ? specifications.length() : specifications.indexOf(215) + 4) : (specifications.contains("/") ? specifications.substring(0, specifications.indexOf(47)) : (specifications.contains("[") ? "1" : (specifications.contains(":") ? "1" : "1")))));
            packSpecification = packSpecification.replaceAll("[^0-9]", "");
            substring = specifications.substring(0, specifications.indexOf(doseUnit));
            String defaultUsage = substring.replaceAll("[^0-9.]", "");
            if (checkIndex == 0) {
                packLargeUnits = row.getCell(index[7]).getStringCellValue();
            }
            System.out.println(specifications);
            System.out.println(packSpecification);
            System.out.println(doseUnit);
            System.out.println(packSmallUnitsLabel);
            System.out.println(packLargeUnits);
            System.out.println("--------------------------------------------------");
            String pinYin = PinyinUtil.getPinYin((String)drugName);
            SysDrugEntity drug = new SysDrugEntity();
            String guiID = UUIDUtils.getRandom((int)5, (boolean)true);
            drug.setId(guiID);
            drug.setDrugsName(drugName);
            drug.setTradeName(drugName);
            drug.setDrugsNamePinyinCode(pinYin);
            drug.setTradeNamePinyinCode(pinYin);
            drug.setDrugType("2");
            drug.setMedicalInsuranceCode(medicalInsuranceCode);
            drug.setMedicalInsuranceName(drugName);
            drug.setDrugClassification("1");
            drug.setFeeCategory("1");
            drug.setSpecifications(specifications);
            drug.setDrugProperties("0");
            drug.setManufacturer(manufacturer);
            drug.setThirdCode(thirdCode);
            drug.setDefaultUsage(defaultUsage);
            drug.setDefaultUsageUnit(unitsMap.get(doseUnit));
            drug.setDefaultSingleDoseUnit(unitsMap.get(doseUnit));
            drug.setPackSmallUnits(unitsMap.get(packSmallUnitsLabel));
            drug.setPackSmallUnitsLabel(packSmallUnitsLabel);
            drug.setPackLargeUnits(unitsMap.get(packLargeUnits));
            drug.setPackLargeUnitsLabel(packLargeUnits);
            drug.setPackSpecification(packSpecification);
            drug.setRetailPrice(new BigDecimal(numericCellValue + ""));
            drug.setStatus("0");
            drug.setDelFlag("0");
            drug.setTenantId(Integer.valueOf(1));
            drug.setApprovalNumber(approvalNumber);
            drug.setRemark("\u5904\u65b9\u6d41\u8f6c\u65b0\u589e\u836f\u54c1");
            insertDrugList.add(drug);
            this.sysDrugMapper.update((Object)drug, (Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(SysDrugEntity::getMedicalInsuranceCode, (Object)drug.getMedicalInsuranceCode())).eq(SysDrugEntity::getTenantId, (Object)1));
        }
        System.out.println("\u5b8c\u6210");
    }

    public void importDrugImg(MultipartFile file, Integer tenantId) throws IOException {
        InputStream inputStream = file.getInputStream();
        XSSFWorkbook workbook = new XSSFWorkbook(inputStream);
        XSSFSheet sheet = workbook.getSheetAt(0);
        HashMap<String, String> importList = new HashMap<String, String>();
        for (Sheet rows : workbook) {
            Integer count = 0;
            for (Row row : sheet) {
                if (count < 2) {
                    Integer n = count;
                    Integer n2 = count = Integer.valueOf(count + 1);
                    continue;
                }
                String thirdCode = row.getCell(5).getStringCellValue();
                String index = row.getCell(2).getRowIndex() - 1 + "";
                importList.put(index, thirdCode);
            }
        }
        File imgFile = new File("C:\\Users\\ASUS\\Desktop\\\u9662\u5185\u836f\u54c1\u76ee\u5f55");
        boolean flag = true;
        int count = 0;
        boolean emptyCount = false;
        for (Row listFile : imgFile.listFiles()) {
            String name = listFile.getName().split("\\.")[0];
            String thirdCode = (String)importList.get(name);
            if (!"".equals(thirdCode)) {
                ++count;
            }
            if (!thirdCode.equals("997180")) continue;
            flag = false;
        }
        boolean i = false;
    }

    private MultipartFile getMulFileByPath(String filePath) {
        DiskFileItemFactory factory = new DiskFileItemFactory(16, null);
        String textFieldName = "textField";
        int num = filePath.lastIndexOf(".");
        String extFile = filePath.substring(num);
        File newfile = new File(filePath);
        String name = newfile.getName();
        String s = name.split("\\.")[0];
        FileItem item = factory.createItem(textFieldName, "image/png", true, s + extFile);
        int bytesRead = 0;
        byte[] buffer = new byte[8192];
        try {
            FileInputStream fis = new FileInputStream(newfile);
            OutputStream os = item.getOutputStream();
            while ((bytesRead = fis.read(buffer, 0, 8192)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
            os.close();
            fis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        CommonsMultipartFile mfile = new CommonsMultipartFile(item);
        return mfile;
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void drugInventory(SysDrugInDto dto) {
        List checkList = this.sysDrugInventoryCheckMapper.selectList((Wrapper)Wrappers.lambdaQuery(SysDrugInventoryCheckEntity.class).eq(SysDrugInventoryCheckEntity::getAuditStatus, (Object)DictEnums.CHECK_ING.getCode()));
        if (!checkList.isEmpty()) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u5f53\u524d\u836f\u5e93\u6b63\u5728\u76d8\u70b9\u4e2d\uff0c\u4e0d\u80fd\u6267\u884c\u836f\u54c1\u5165\u5e93\u64cd\u4f5c\uff01");
        }
        List drugList = ((SysDrugMapper)this.baseMapper).selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysDrugEntity.class).like(SysDrugEntity::getDrugsName, (Object)dto.getDrugName())).eq(dto.getTenantId() != null, SysDrugEntity::getTenantId, (Object)dto.getTenantId()));
        List drugLists = IntStream.range(0, (drugList.size() + 99) / 100).mapToObj(i -> drugList.subList(i * 100, Math.min((i + 1) * 100, drugList.size()))).collect(Collectors.toList());
        for (List list : drugLists) {
            this.drugInOperator(list, dto);
        }
    }

    private void drugInOperator(List<SysDrugEntity> list, SysDrugInDto dto) {
        ArrayList<SysDrugInventoryInPrescriptionEntity> drugInventoryInPrescriptionList = new ArrayList<SysDrugInventoryInPrescriptionEntity>();
        String batchNumber = UUIDUtils.getRandom((int)6, (boolean)false);
        LocalDate currentDate = LocalDate.now();
        LocalDate effectiveTimeDate = currentDate.plusYears(3L);
        Date effectiveTime = Date.from(effectiveTimeDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
        BigDecimal retailAmount = new BigDecimal(0);
        BigDecimal purchaseAmount = new BigDecimal(0);
        for (SysDrugEntity drug : list) {
            SysDrugInventoryInPrescriptionEntity drugInPrescEntity = new SysDrugInventoryInPrescriptionEntity();
            drugInPrescEntity.setMedicalInsuranceCode(drug.getMedicalInsuranceCode());
            drugInPrescEntity.setMedicalInsuranceName(drug.getMedicalInsuranceName());
            drugInPrescEntity.setLevel(drug.getLevel());
            drugInPrescEntity.setDrugId(drug.getId());
            drugInPrescEntity.setDrugName(drug.getDrugsName());
            drugInPrescEntity.setSpecifications(drug.getSpecifications());
            drugInPrescEntity.setDrugNum(dto.getInNum());
            drugInPrescEntity.setUnit(drug.getDefaultUsageUnit());
            drugInPrescEntity.setRetailPrice(drug.getRetailPrice());
            drugInPrescEntity.setPurchasePrice(drug.getRetailPrice());
            BigDecimal retailOneAmount = drug.getRetailPrice().multiply(BigDecimal.valueOf(dto.getInNum().intValue()));
            BigDecimal purchaseOneAmount = drug.getRetailPrice().multiply(BigDecimal.valueOf(dto.getInNum().intValue()));
            drugInPrescEntity.setRetailAmount(retailOneAmount);
            drugInPrescEntity.setPurchaseAmount(purchaseOneAmount);
            retailAmount = retailAmount.add(retailOneAmount);
            purchaseAmount = purchaseAmount.add(purchaseOneAmount);
            drugInPrescEntity.setDrugsType(drug.getDrugsType());
            drugInPrescEntity.setDrugProperties(drug.getDrugProperties());
            drugInPrescEntity.setTenantId(drug.getTenantId());
            drugInPrescEntity.setBatchNumber(batchNumber);
            drugInPrescEntity.setEffectiveTime(effectiveTime);
            drugInventoryInPrescriptionList.add(drugInPrescEntity);
        }
        SysDrugInventoryInEntity drugIn = new SysDrugInventoryInEntity();
        drugIn.setId(UUIDUtils.getRandom((int)5, (boolean)true));
        drugIn.setWarehousingUse(dto.getWarehousingUse());
        LocalDate today = LocalDate.now();
        Date warehousingTime = Date.from(today.atStartOfDay(ZoneId.systemDefault()).toInstant());
        drugIn.setWarehousingTime(warehousingTime);
        drugIn.setWarehousingMethod(dto.getWarehousingMethod());
        if (SysDrugTypeEnum.TRADITIONAL_CHINESE_MEDICINE.getValue().equals(dto.getDrugType())) {
            drugIn.setWarehousingWarehouse("1");
        } else {
            drugIn.setWarehousingWarehouse("0");
        }
        drugIn.setSupplierId(dto.getSupplierId());
        drugIn.setSupplierName(dto.getSupplierName());
        drugIn.setAuditStatus("1");
        drugIn.setTenantId(dto.getTenantId());
        LocalDateTime now = LocalDateTime.now();
        Date createTime = Date.from(now.atZone(ZoneId.systemDefault()).toInstant());
        drugIn.setCreateTime(createTime);
        drugIn.setRetailAmount(retailAmount);
        drugIn.setPurchaseAmount(purchaseAmount);
        drugIn.setCreateId(dto.getUserId());
        this.sysDrugInventoryInMapper.insert((Object)drugIn);
        for (SysDrugInventoryInPrescriptionEntity entity : drugInventoryInPrescriptionList) {
            entity.setId(UUIDUtils.getRandom((int)5, (boolean)true));
            entity.setDrugInventoryInId(drugIn.getId());
            this.sysDrugInventoryInPrescriptionMapper.insert((Object)entity);
        }
        SysDrugTogetherEntity drugTogether = new SysDrugTogetherEntity();
        drugTogether.setId(UUIDUtils.getRandom((int)5, (boolean)true));
        drugTogether.setDrugInventoryInId(drugIn.getId());
        drugTogether.setRetailAmount(retailAmount);
        drugTogether.setPurchaseAmount(purchaseAmount);
        drugTogether.setTenantId(dto.getTenantId());
        this.sysDrugTogetherMapper.insert((Object)drugTogether);
    }

    public IPage<SysDrugEntity> pageList(Page page, SysDrugDto dto) {
        IPage drugIPage = ((SysDrugMapper)this.baseMapper).queryDrugPage(page, dto);
        return drugIPage;
    }

    public IPage<SysDrugEntity> queryDrugPageContainLZ(Page page, SysDrugDto dto) {
        IPage drugIPage = ((SysDrugMapper)this.baseMapper).queryDrugPage(page, dto);
        return drugIPage;
    }

    public List<SysDrugEntity> queryDrugByExport(SysDrugDto dto) {
        return ((SysDrugMapper)this.baseMapper).queryDrugByExport(dto);
    }

    public IPage<PurchaseOrderEntity> pageListByPurchase(Page page, SysDrugDto dto) {
        Integer tenantId = dto.getTenantId();
        IPage iPage = ((SysDrugMapper)this.baseMapper).pageListByPurchase(page, tenantId);
        return iPage;
    }

    public void saveUpdates(SysDrugEntity entity) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("internal_code", entity.getInternalCode());
        map.put("tenant_id", entity.getTenantId());
        List sysDrugList = ((SysDrugMapper)this.baseMapper).selectByMap(map);
        if (StrUtil.isEmpty((CharSequence)entity.getId())) {
            if (!sysDrugList.isEmpty()) {
                throw new BusinessException("\u9662\u5185\u7f16\u7801\u91cd\u590d\uff01{internalCode}");
            }
            if (StrUtil.isEmpty((CharSequence)entity.getDrugsType())) {
                throw new BusinessException("\u836f\u54c1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01{drugsType}");
            }
            if (StrUtil.isEmpty((CharSequence)entity.getDrugsName())) {
                throw new BusinessException("\u836f\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01{drugsName}");
            }
            if (StrUtil.isEmpty((CharSequence)entity.getFeeCategory())) {
                throw new BusinessException("\u6536\u8d39\u7c7b\u522b\u4e0d\u80fd\u4e3a\u7a7a\uff01{feeCategory}");
            }
            if (StrUtil.isEmpty((CharSequence)entity.getSpecifications())) {
                throw new BusinessException("\u89c4\u683c\u4e0d\u80fd\u4e3a\u7a7a\uff01{specifications}");
            }
            if (StrUtil.isEmpty((CharSequence)entity.getDosageForm())) {
                throw new BusinessException("\u5242\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01{dosageForm}");
            }
            if (StrUtil.isEmpty((CharSequence)entity.getDrugProperties())) {
                throw new BusinessException("\u836f\u54c1\u6027\u8d28\u4e0d\u80fd\u4e3a\u7a7a\uff01{drugProperties}");
            }
            String guiID = UUIDUtils.getRandom((int)5, (boolean)true);
            entity.setId(guiID);
            ((SysDrugMapper)this.baseMapper).insert((Object)entity);
            CompletableFuture.runAsync(() -> {
                try {
                    this.drugAsyncMedicalcloud(entity);
                }
                catch (IOException | InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            });
        } else {
            if (!sysDrugList.isEmpty() && !entity.getId().equals(((SysDrugEntity)sysDrugList.get(0)).getId())) {
                throw new BusinessException("\u9662\u5185\u7f16\u7801\u91cd\u590d\uff01{internalCode}");
            }
            ((SysDrugMapper)this.baseMapper).update((Object)entity, (Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugEntity::getId, (Object)entity.getId())).eq(SysDrugEntity::getTenantId, (Object)entity.getTenantId()));
            CompletableFuture.runAsync(() -> {
                try {
                    this.drugAsyncMedicalcloud(entity);
                }
                catch (IOException | InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        this.uploadDrugContrast(entity);
    }

    private void drugAsyncMedicalcloud(SysDrugEntity entity) throws IOException, ExecutionException, InterruptedException {
        SysDoctorVo dutiesDTO = new SysDoctorVo();
        if (StrUtil.isNotEmpty((CharSequence)entity.getDrugsType())) {
            if ("1".equals(entity.getDrugsType()) || "2".equals(entity.getDrugsType())) {
                dutiesDTO.setType(weDosageForm);
            } else if ("3".equals(entity.getDrugsType())) {
                dutiesDTO.setType(cnDosageForm);
            } else {
                dutiesDTO.setType(weDosageForm);
            }
        }
        dutiesDTO.setParameters(entity.getDosageForm());
        DictValueVo dutiesOne = this.sysDictMapper.querySysDictValue(dutiesDTO);
        if (ObjectUtil.isNotNull((Object)dutiesOne)) {
            entity.setDosageForm(dutiesOne.getLabel());
        }
        String url = this.medicalCloudUrl + "/api/manage/drugItem/synchronization/sys/cloudDrug";
        this.logger.info("\u836f\u54c1\u540c\u6b65\u533b\u836f\u4e91url\uff1a{},\u5165\u53c2\uff1a{}", (Object)url, (Object)JSONObject.toJSONString((Object)entity));
        String result = HttpKit.post((String)url, (String)JSON.toJSONString((Object)entity));
        this.logger.info("\u836f\u54c1\u540c\u6b65\u533b\u836f\u4e91\u8fd4\u56de\uff1a{}", (Object)result);
    }

    private void uploadDrugContrast(SysDrugEntity entity) {
        log.info("\u4e0a\u4f20\u533b\u4fdd\u5bf9\u7167" + JSONObject.toJSONString((Object)entity));
        SysDrugEntity sysDrugEntity = (SysDrugEntity)((SysDrugMapper)this.baseMapper).selectById((Serializable)((Object)entity.getId()));
        if (ObjectUtil.isNotNull((Object)sysDrugEntity) && !Objects.equals(sysDrugEntity.getMedicalInsuranceCode(), entity.getMedicalInsuranceCode())) {
            return;
        }
        if (StrUtil.isNotEmpty((CharSequence)entity.getMedicalInsuranceCode()) && StrUtil.isNotEmpty((CharSequence)entity.getMedicalInsuranceName())) {
            UploadCatalogRequest uploadCatalogRequest = new UploadCatalogRequest();
            uploadCatalogRequest.setFixmedins_hilist_id(ObjectUtil.isNull((Object)entity.getInternalCode()) ? entity.getId() : String.valueOf(entity.getInternalCode()));
            uploadCatalogRequest.setFixmedins_hilist_name(entity.getDrugsName());
            switch (entity.getDrugsType()) {
                case "3": {
                    uploadCatalogRequest.setList_type("102");
                    break;
                }
                default: {
                    uploadCatalogRequest.setList_type("101");
                }
            }
            uploadCatalogRequest.setMed_list_codg(entity.getMedicalInsuranceCode());
            LocalDateTime currentTime = LocalDateTime.now();
            LocalDateTime nextYear = currentTime.plusYears(1L);
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            uploadCatalogRequest.setBegndate(currentTime.format(formatter));
            uploadCatalogRequest.setEnddate(nextYear.format(formatter));
            uploadCatalogRequest.setTenantId(entity.getTenantId());
            uploadCatalogRequest.setSign_no(entity.getSignNo());
            uploadCatalogRequest.setOpter(String.valueOf(entity.getUserId()));
            uploadCatalogRequest.setOpter_name(entity.getUserName());
            uploadCatalogRequest.setOpter_type("1");
            ArrayList<UploadCatalogRequest> list = new ArrayList<UploadCatalogRequest>(1);
            list.add(uploadCatalogRequest);
            ArrayList<String> ids = new ArrayList<String>(1);
            ids.add(entity.getId());
            ResponseData responseData = this.hsServiceFeign.uploadCatalogList(list);
            log.info("\u836f\u54c1\u81ea\u52a8\u4e0a\u4f20\u533b\u4fdd:" + JSONObject.toJSONString((Object)responseData));
            if (responseData.isSuccess()) {
                this.sysHsInfoMapper.updateUploadStatus(entity.getTenantId(), ids, HsDrugUploadStatusEnum.SUCC.getValue());
            } else if (!responseData.getMsg().contains("\u8bf7\u52ff\u63d2\u5165\u91cd\u590d\u7684\u4e3b\u952e")) {
                this.sysHsInfoMapper.updateUploadStatus(entity.getTenantId(), ids, HsDrugUploadStatusEnum.FAIL.getValue());
            }
        }
    }

    public Boolean removeSysDrug(String[] ids) {
        if (ObjectUtils.isEmpty((Object[])ids)) {
            throw new BusinessException("\u836f\u54c1\u6279\u91cf\u5220\u9664id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Boolean removed = ((SysDrugMapper)this.baseMapper).removeSysDrug(ids);
        CompletableFuture.runAsync(() -> {
            try {
                this.drugDelAsyncMedicalcloud(ids);
            }
            catch (IOException | InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        });
        return removed;
    }

    private void drugDelAsyncMedicalcloud(String[] ids) throws IOException, ExecutionException, InterruptedException {
        for (String id : ids) {
            SysDrugEntity entity = (SysDrugEntity)((SysDrugMapper)this.baseMapper).selectById((Serializable)((Object)id));
            if (!ObjectUtil.isNotNull((Object)entity)) continue;
            String url = this.medicalCloudUrl + "/api/manage/drugItem/del/sys/cloudDrug";
            this.logger.info("\u836f\u54c1\u5220\u9664\u540c\u6b65\u533b\u836f\u4e91url\uff1a{},\u5165\u53c2\uff1a{}", (Object)url, (Object)JSONObject.toJSONString((Object)entity));
            String result = HttpKit.post((String)url, (String)JSON.toJSONString((Object)entity));
            this.logger.info("\u836f\u54c1\u5220\u9664\u540c\u6b65\u533b\u836f\u4e91\u8fd4\u56de\uff1a{}", (Object)result);
        }
    }

    public SysDrugEntity details(SysDrugEntity entity) {
        if (StrUtil.isEmpty((CharSequence)entity.getId())) {
            throw new BusinessException("\u836f\u54c1\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff01{id}");
        }
        return (SysDrugEntity)((SysDrugMapper)this.baseMapper).selectById((Serializable)entity);
    }

    public Boolean drugStatus(SysDrugEntity entity) {
        String id = entity.getId();
        if (StrUtil.isEmpty((CharSequence)id)) {
            throw new BusinessException("\u5f53\u524d\u836f\u54c1id,\u4e0d\u80fd\u4e3a\u7a7a\uff01" + id);
        }
        String status = entity.getStatus();
        if (StrUtil.isEmpty((CharSequence)status)) {
            throw new BusinessException("\u5f53\u524d\u836f\u54c1\u72b6\u6001,\u4e0d\u80fd\u4e3a\u7a7a\uff01" + status);
        }
        ((SysDrugMapper)this.baseMapper).updateById((Object)entity);
        return true;
    }

    public void updateByClassification(SysDrugEntity sysDrugEntity, List<String> collect) {
        ((SysDrugMapper)this.baseMapper).updateByClassification(sysDrugEntity, collect);
    }
}

