/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.service.impl;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.sys.api.dto.treatmentItem.CheckSameFlagDto;
import com.byh.sys.api.dto.treatmentItem.OutTreatmentItemDto;
import com.byh.sys.api.dto.treatmentItem.SysTreatmentItemDto;
import com.byh.sys.api.enums.ApplyGenderEnum;
import com.byh.sys.api.enums.ChargeItemSourceEnum;
import com.byh.sys.api.enums.MedicalInsuranceCheckStatusEnum;
import com.byh.sys.api.enums.StatusEnum;
import com.byh.sys.api.excel.CustomMergeStrategy;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.SysCategorySettingEntity;
import com.byh.sys.api.model.base.BaseEntity;
import com.byh.sys.api.model.base.BasePageEntity;
import com.byh.sys.api.model.chargeItem.SysChargeItemEntity;
import com.byh.sys.api.model.department.SysDepartmentEntity;
import com.byh.sys.api.model.dict.SysDictValueEntity;
import com.byh.sys.api.model.templateManage.SysTemplateManageDetailEntity;
import com.byh.sys.api.model.templateManage.SysTemplateManageEntity;
import com.byh.sys.api.model.treatmentItem.SysTreatmentChargeEntity;
import com.byh.sys.api.model.treatmentItem.SysTreatmentItemEntity;
import com.byh.sys.api.util.ExceptionUtils;
import com.byh.sys.api.util.StringPinYinUtil;
import com.byh.sys.api.util.StringWubiUtil;
import com.byh.sys.api.util.UUIDUtils;
import com.byh.sys.api.vo.treatmentItem.CheckSameDetailVo;
import com.byh.sys.api.vo.treatmentItem.CheckSameFlagVo;
import com.byh.sys.api.vo.treatmentItem.ExportTreatmentCharge;
import com.byh.sys.api.vo.treatmentItem.ExportTreatmentItem;
import com.byh.sys.api.vo.treatmentItem.OutTreatmentItemVo;
import com.byh.sys.api.vo.treatmentItem.SysTreatmentChargeVo;
import com.byh.sys.api.vo.treatmentItem.SysTreatmentItemVo;
import com.byh.sys.data.repository.SysCategorySettingMapper;
import com.byh.sys.data.repository.SysChargeItemMapper;
import com.byh.sys.data.repository.SysDepartmentMapper;
import com.byh.sys.data.repository.SysDictValueMapper;
import com.byh.sys.data.repository.SysTemplateManageDetailMapper;
import com.byh.sys.data.repository.SysTemplateManageMapper;
import com.byh.sys.data.repository.SysTreatmentChargeMapper;
import com.byh.sys.data.repository.SysTreatmentItemMapper;
import com.byh.sys.web.service.SysChargeItemService;
import com.byh.sys.web.service.SysTreatmentItemService;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class SysTreatmentItemServiceImpl
extends ServiceImpl<SysTreatmentItemMapper, SysTreatmentItemEntity>
implements SysTreatmentItemService {
    @Resource
    private SysTreatmentItemMapper sysTreatmentItemMapper;
    @Resource
    private SysTreatmentChargeMapper sysTreatmentChargeMapper;
    @Resource
    private SysChargeItemMapper sysChargeItemMapper;
    @Resource
    private SysTemplateManageMapper sysTemplateManageMapper;
    @Resource
    private SysTemplateManageDetailMapper sysTemplateManageDetailMapper;
    @Resource
    private SysDictValueMapper sysDictValueMapper;
    @Resource
    private SysDepartmentMapper sysDepartmentMapper;
    @Resource
    private SysCategorySettingMapper sysCategorySettingMapper;
    @Autowired
    private SysChargeItemService sysChargeItemService;
    private Logger logger = LoggerFactory.getLogger(SysTreatmentItemServiceImpl.class);

    public CheckSameFlagVo checkToBePaidItems(OutTreatmentItemDto dto) {
        CheckSameFlagVo checkSameFlagVo = new CheckSameFlagVo();
        List treatmentItemVos = this.sysTreatmentItemMapper.selectOutTreatmentItemList(dto);
        if (!treatmentItemVos.isEmpty()) {
            String remark = "\u5b58\u5728\u5f85\u7f34\u8d39\u7684\u60a3\u8005\uff1a<br>";
            for (OutTreatmentItemVo vo : treatmentItemVos) {
                remark = remark + vo.getPatientName() + "\uff08" + vo.getPatientCardNo() + "\uff09<br>";
            }
            checkSameFlagVo.setFlag(true);
            remark = remark.substring(0, remark.length() - 1);
            checkSameFlagVo.setRemark(remark);
        }
        return checkSameFlagVo;
    }

    public CheckSameFlagVo checkSameFlag(CheckSameFlagDto dto) {
        CheckSameFlagVo vo = new CheckSameFlagVo();
        Integer treatmentId = dto.getTreatmentId();
        List oldTreatmentIds = dto.getOldTreatmentIds();
        if (oldTreatmentIds.isEmpty() || treatmentId == null) {
            return vo;
        }
        List voList = this.sysTreatmentItemMapper.checkSameFlag(dto);
        Map<String, List<CheckSameDetailVo>> groupByType = voList.stream().collect(Collectors.groupingBy(CheckSameDetailVo::getType));
        List oldList = groupByType.getOrDefault("1", new ArrayList());
        List newList = groupByType.getOrDefault("2", new ArrayList());
        Map<String, List<CheckSameDetailVo>> newMap = newList.stream().collect(Collectors.groupingBy(CheckSameDetailVo::getChargeItemCode));
        LinkedHashMap<String, List> sameMap = new LinkedHashMap<String, List>();
        for (CheckSameDetailVo detailVo : oldList) {
            List detailVos = newMap.getOrDefault(detailVo.getChargeItemCode(), new ArrayList());
            if (detailVos.isEmpty()) continue;
            sameMap.computeIfAbsent(detailVo.getItemName(), k -> new ArrayList()).addAll(detailVos);
        }
        String remark = "";
        for (Map.Entry entry : sameMap.entrySet()) {
            String itemName = (String)entry.getKey();
            List detailVos = (List)entry.getValue();
            String info = "";
            for (CheckSameDetailVo detailVo : detailVos) {
                info = info + "\uff08" + detailVo.getChargeItemCode() + "\uff09" + detailVo.getChargeItemName() + "\uff5c";
            }
            if (StrUtil.isNotEmpty((CharSequence)info)) {
                info = info.substring(0, info.length() - 1);
            }
            remark = remark + info + " \u5728\u8bca\u7597\u9879\u76ee\uff08" + itemName + "\uff09\u4e2d\u5df2\u5b58\u5728\uff0c";
        }
        if (StrUtil.isNotEmpty((CharSequence)remark)) {
            remark = remark.substring(0, remark.length() - 1);
            remark = remark + "\uff0c\u662f\u5426\u4ecd\u8981\u6dfb\u52a0\uff1f";
            vo.setFlag(true);
            vo.setRemark(remark);
        }
        return vo;
    }

    public void exportTreatmentItemExcel(HttpServletResponse response, Integer tenantId) {
        List exportTreatmentItemList = this.sysTreatmentItemMapper.selectExportList(tenantId);
        List treatmentIds = exportTreatmentItemList.stream().map(ExportTreatmentItem::getId).distinct().collect(Collectors.toList());
        List exportTreatmentChargeList = this.sysTreatmentChargeMapper.selectExportList(treatmentIds);
        try (ServletOutputStream out = response.getOutputStream();){
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setCharacterEncoding("utf-8");
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206ss\u79d2");
            String format = LocalDateTime.now(ZoneOffset.ofHours(8)).format(dateTimeFormatter);
            String fileName = URLEncoder.encode("\u8bca\u7597\u9879\u76ee" + format, "UTF-8").replaceAll("\\+", "%20");
            response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
            try (ExcelWriter excelWriter = EasyExcelFactory.write((OutputStream)out).build();){
                WriteSheet writeSheet1 = ((ExcelWriterSheetBuilder)EasyExcelFactory.writerSheet((Integer)0, (String)"\u8bca\u7597\u9879\u76ee").head(ExportTreatmentItem.class)).build();
                excelWriter.write((Collection)exportTreatmentItemList, writeSheet1);
                WriteSheet writeSheet2 = ((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)EasyExcelFactory.writerSheet((Integer)1, (String)"\u8bca\u7597\u6536\u8d39\u5173\u8054").head(ExportTreatmentCharge.class)).registerWriteHandler((WriteHandler)new CustomMergeStrategy(Integer.valueOf(exportTreatmentChargeList.size()), new int[]{0}))).registerWriteHandler((WriteHandler)new CustomMergeStrategy(Integer.valueOf(exportTreatmentChargeList.size()), new int[]{5}))).build();
                excelWriter.write((Collection)exportTreatmentChargeList, writeSheet2);
            }
            out.flush();
        }
        catch (Exception e) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)e.getMessage());
        }
    }

    private static List<String> getTypeList() {
        ArrayList<String> typeList = new ArrayList<String>();
        typeList.add("diagnosis_treatment_type");
        typeList.add("charge_unit");
        typeList.add("execute_dept_flag");
        typeList.add("medical_insurance_type");
        typeList.add("project_type");
        typeList.add("examine_type");
        typeList.add("inspect_type");
        typeList.add("therapeutic_nature");
        typeList.add("patrol_car_examine_type");
        typeList.add("examine_position");
        typeList.add("specimen");
        typeList.add("patrol_car_item");
        typeList.add("fee_category");
        return typeList;
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void importTreatmentItemExcel(MultipartFile file, Integer tenantId, Integer userId, String userName) {
        try {
            List dbList;
            Object itemCode;
            String treatmentItemName;
            InputStream inputStream = file.getInputStream();
            XSSFWorkbook workbook = new XSSFWorkbook(inputStream);
            int sheetCount = workbook.getNumberOfSheets();
            List typeList = SysTreatmentItemServiceImpl.getTypeList();
            List dictValueList = this.getDictValueList(typeList);
            HashMap<String, Map> map = new HashMap<String, Map>();
            for (SysDictValueEntity entity : dictValueList) {
                map.computeIfAbsent(entity.getType(), k -> new HashMap()).put(entity.getLabel(), entity.getValue());
            }
            ArrayList<SysTreatmentItemEntity> treatmentItemList = new ArrayList<SysTreatmentItemEntity>();
            ArrayList<SysTreatmentChargeEntity> treatmentChargeList = new ArrayList<SysTreatmentChargeEntity>();
            ArrayList<SysChargeItemEntity> chargeItemList = new ArrayList<SysChargeItemEntity>();
            for (int i = 0; i < sheetCount; ++i) {
                String chargeItemName;
                XSSFSheet sheet = workbook.getSheetAt(i);
                int readCount = 0;
                Map<Object, Object> categorySettingMap = new HashMap();
                if (i == 0) {
                    HashSet<String> categoryNames = new HashSet<String>();
                    int count = 0;
                    for (Row row : sheet) {
                        String categoryName;
                        if (count <= 1) {
                            ++count;
                            continue;
                        }
                        if (StrUtil.isEmpty((CharSequence)row.getCell(2).getStringCellValue())) {
                            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u5bfc\u5165\u8bca\u7597\u9879\u76ee\u65f6\uff0csheet(\u8bca\u7597\u9879\u76ee)\u4e2d\u7684\u9879\u76ee\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a\uff01");
                        }
                        if (!StrUtil.isNotEmpty((CharSequence)(categoryName = row.getCell(4).getStringCellValue()))) continue;
                        categoryNames.add(categoryName);
                    }
                    List categorySettingList = this.sysCategorySettingMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysCategorySettingEntity.class).in(!categoryNames.isEmpty(), SysCategorySettingEntity::getCategoryName, categoryNames)).in(categoryNames.isEmpty(), SysCategorySettingEntity::getCategoryName, new Object[]{-1})).eq(tenantId != null, SysCategorySettingEntity::getTenantId, (Object)tenantId));
                    categorySettingMap = categorySettingList.stream().collect(Collectors.toMap(SysCategorySettingEntity::getCategoryName, Function.identity()));
                } else if (i == 1) {
                    int count = 0;
                    for (Row row : sheet) {
                        if (count <= 1) {
                            ++count;
                            continue;
                        }
                        treatmentItemName = row.getCell(0).getStringCellValue();
                        if (StrUtil.isEmpty((CharSequence)treatmentItemName)) {
                            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u5bfc\u5165\u8bca\u7597\u9879\u76ee\u65f6\uff0csheet\uff08\u8bca\u7597\u6536\u8d39\u5173\u8054\uff09\u4e2d\u7684\u7ec4\u5957\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a\uff01");
                        }
                        if (!StrUtil.isEmpty((CharSequence)(chargeItemName = row.getCell(1).getStringCellValue()))) continue;
                        ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u5bfc\u5165\u8bca\u7597\u9879\u76ee\u65f6\uff0csheet\uff08\u8bca\u7597\u6536\u8d39\u5173\u8054\uff09\u4e2d\u7684\u660e\u7ec6\u9879\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a\uff01");
                    }
                } else if (i == 2) {
                    int count = 0;
                    for (Row row : sheet) {
                        if (count <= 1) {
                            ++count;
                            continue;
                        }
                        String itemName = row.getCell(1).getStringCellValue();
                        if (!StrUtil.isEmpty((CharSequence)itemName)) continue;
                        ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u5bfc\u5165\u8bca\u7597\u9879\u76ee\u65f6\uff0csheet\uff08\u6536\u8d39\u9879\u76ee\uff09\u4e2d\u7684\u9879\u76ee\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a\uff01");
                    }
                }
                for (Row row : sheet) {
                    String statusCode;
                    String statusName;
                    String applyGenderCode;
                    String applyGenderName;
                    if (readCount <= 1) {
                        ++readCount;
                        continue;
                    }
                    if (i == 0) {
                        SysTreatmentItemEntity treatmentItem = new SysTreatmentItemEntity();
                        itemCode = StrUtil.isEmpty((CharSequence)row.getCell(0).getStringCellValue()) ? UUIDUtils.getNumberRandom((int)9) : row.getCell(0).getStringCellValue();
                        treatmentItem.setItemCode((String)itemCode);
                        String itemEnglishName = this.getString(row.getCell(1).getStringCellValue());
                        treatmentItem.setItemEnglishName(itemEnglishName);
                        String itemName = row.getCell(2).getStringCellValue();
                        treatmentItem.setItemName(itemName);
                        applyGenderName = row.getCell(3).getStringCellValue();
                        applyGenderCode = Optional.ofNullable(ApplyGenderEnum.getEnumValue((String)applyGenderName)).map(ApplyGenderEnum::getValue).orElse(null);
                        treatmentItem.setApplyGenderCode(StrUtil.isEmpty((CharSequence)applyGenderCode) ? ApplyGenderEnum.NO_LIMITATION.getValue() : applyGenderCode);
                        treatmentItem.setApplyGenderName(StrUtil.isEmpty((CharSequence)applyGenderCode) ? ApplyGenderEnum.NO_LIMITATION.getLabel() : applyGenderName);
                        String categorySettingName = row.getCell(4).getStringCellValue();
                        Integer categorySettingId = Optional.ofNullable(categorySettingMap.get(categorySettingName)).map(SysCategorySettingEntity::getId).orElse(null);
                        treatmentItem.setCategoryId(categorySettingId);
                        String isContainServiceFeeLabel = row.getCell(5).getStringCellValue();
                        treatmentItem.setIsContainServiceFee("\u5305\u542b".equals(isContainServiceFeeLabel) ? "1" : "0");
                        String itemTypeLabel = row.getCell(6).getStringCellValue();
                        treatmentItem.setItemType(this.getMapValue(map, "project_type", itemTypeLabel));
                        String serviceObject = this.getString(row.getCell(7).getStringCellValue());
                        treatmentItem.setServiceObjectCode(serviceObject);
                        statusName = row.getCell(8).getStringCellValue();
                        statusCode = Optional.ofNullable(StatusEnum.getEnumValue((String)statusName)).map(StatusEnum::getValue).orElse(null);
                        treatmentItem.setStatusCode(StrUtil.isEmpty((CharSequence)statusCode) ? StatusEnum.ENABLED.getValue() : statusCode);
                        treatmentItem.setStatusName(StrUtil.isEmpty((CharSequence)statusCode) ? StatusEnum.ENABLED.getLabel() : statusName);
                        String treatmentTypeLabel = row.getCell(9).getStringCellValue();
                        treatmentItem.setTreatmentTypeCode(this.getMapValue(map, "diagnosis_treatment_type", treatmentTypeLabel));
                        treatmentItem.setTreatmentTypeName(StrUtil.isEmpty((CharSequence)treatmentItem.getTreatmentTypeCode()) ? null : treatmentTypeLabel);
                        String unitLabel = row.getCell(10).getStringCellValue();
                        treatmentItem.setUnit(this.getMapValue(map, "charge_unit", unitLabel));
                        String executeDeptFlagLabel = row.getCell(11).getStringCellValue();
                        treatmentItem.setExecuteDeptFlag(this.getMapValue(map, "execute_dept_flag", executeDeptFlagLabel));
                        if ("1".equals(treatmentItem.getTreatmentTypeCode())) {
                            String examineTypeLabel = row.getCell(12).getStringCellValue();
                            treatmentItem.setInspectType(this.getMapValue(map, "examine_type", examineTypeLabel));
                            String examinePositionLabel = row.getCell(13).getStringCellValue();
                            treatmentItem.setSpecimen(this.getMapValue(map, "examine_position", examinePositionLabel));
                        } else if ("2".equals(treatmentItem.getTreatmentTypeCode())) {
                            String inspectTypeLabel = row.getCell(14).getStringCellValue();
                            treatmentItem.setInspectType(this.getMapValue(map, "inspect_type", inspectTypeLabel));
                            String specimenLabel = row.getCell(15).getStringCellValue();
                            treatmentItem.setSpecimen(this.getMapValue(map, "specimen", specimenLabel));
                        } else if ("3".equals(treatmentItem.getTreatmentTypeCode())) {
                            String healNatureLabel = row.getCell(16).getStringCellValue();
                            treatmentItem.setInspectType(this.getMapValue(map, "therapeutic_nature", healNatureLabel));
                        } else if ("10".equals(treatmentItem.getTreatmentTypeCode())) {
                            String patrolCarExamineTypeLabel = row.getCell(17).getStringCellValue();
                            treatmentItem.setInspectType(this.getMapValue(map, "patrol_car_examine_type", patrolCarExamineTypeLabel));
                            String patrolCarItemLabel = row.getCell(18).getStringCellValue();
                            treatmentItem.setSpecimen(this.getMapValue(map, "patrol_car_item", patrolCarItemLabel));
                        }
                        treatmentItemList.add(treatmentItem);
                        continue;
                    }
                    if (i == 1) {
                        SysTreatmentChargeEntity treatmentCharge = new SysTreatmentChargeEntity();
                        treatmentItemName = row.getCell(0).getStringCellValue();
                        treatmentCharge.setTreatmentItemName(treatmentItemName);
                        chargeItemName = row.getCell(1).getStringCellValue();
                        treatmentCharge.setChargeItemName(chargeItemName);
                        Integer quantity = (int)row.getCell(2).getNumericCellValue();
                        treatmentCharge.setQuantity(quantity);
                        treatmentChargeList.add(treatmentCharge);
                        continue;
                    }
                    if (i != 2) continue;
                    SysChargeItemEntity chargeItem = new SysChargeItemEntity();
                    itemCode = row.getCell(0).getStringCellValue();
                    chargeItem.setChargeItemCode((String)itemCode);
                    String itemName = row.getCell(1).getStringCellValue();
                    chargeItem.setChargeItemName(itemName);
                    String treatmentTypeLabel = row.getCell(2).getStringCellValue();
                    chargeItem.setTreatmentTypeCode(this.getMapValue(map, "diagnosis_treatment_type", treatmentTypeLabel));
                    chargeItem.setTreatmentTypeName(StrUtil.isEmpty((CharSequence)chargeItem.getTreatmentTypeCode()) ? null : treatmentTypeLabel);
                    applyGenderName = row.getCell(3).getStringCellValue();
                    applyGenderCode = Optional.ofNullable(ApplyGenderEnum.getEnumValue((String)applyGenderName)).map(ApplyGenderEnum::getValue).orElse(null);
                    chargeItem.setApplyGenderCode(StrUtil.isEmpty((CharSequence)applyGenderCode) ? ApplyGenderEnum.NO_LIMITATION.getValue() : applyGenderCode);
                    chargeItem.setApplyGenderName(StrUtil.isEmpty((CharSequence)applyGenderCode) ? ApplyGenderEnum.NO_LIMITATION.getLabel() : applyGenderName);
                    BigDecimal itemPrice = BigDecimal.valueOf(row.getCell(4).getNumericCellValue());
                    chargeItem.setItemPrice(itemPrice);
                    String unitLabel = row.getCell(5).getStringCellValue();
                    chargeItem.setUnit(this.getMapValue(map, "charge_unit", unitLabel));
                    String chargeCategoryLabel = row.getCell(6).getStringCellValue();
                    chargeItem.setChargeItemId(this.getMapValue(map, "fee_category", chargeCategoryLabel));
                    String sourceName = row.getCell(7).getStringCellValue();
                    String sourceCode = Optional.ofNullable(ChargeItemSourceEnum.getEnumValue((String)sourceName)).map(ChargeItemSourceEnum::getValue).orElse(null);
                    chargeItem.setSourceCode(StrUtil.isEmpty((CharSequence)sourceCode) ? ChargeItemSourceEnum.STANDARD_LIBRARY.getValue() : sourceCode);
                    chargeItem.setSourceName(StrUtil.isEmpty((CharSequence)sourceCode) ? ChargeItemSourceEnum.STANDARD_LIBRARY.getLabel() : sourceName);
                    statusName = row.getCell(8).getStringCellValue();
                    statusCode = Optional.ofNullable(StatusEnum.getEnumValue((String)statusName)).map(StatusEnum::getValue).orElse(null);
                    chargeItem.setStatusCode(StrUtil.isEmpty((CharSequence)statusCode) ? StatusEnum.ENABLED.getValue() : statusCode);
                    chargeItem.setStatusName(StrUtil.isEmpty((CharSequence)statusCode) ? StatusEnum.ENABLED.getLabel() : statusName);
                    String medicalInsuranceCheckName = row.getCell(9).getStringCellValue();
                    String medicalInsuranceCheckCode = Optional.ofNullable(MedicalInsuranceCheckStatusEnum.getEnumValue((String)medicalInsuranceCheckName)).map(MedicalInsuranceCheckStatusEnum::getValue).orElse(null);
                    chargeItem.setMedicalInsuranceCheckStatusCode(StrUtil.isEmpty((CharSequence)medicalInsuranceCheckCode) ? MedicalInsuranceCheckStatusEnum.NO_UPLOAD.getValue() : medicalInsuranceCheckCode);
                    chargeItem.setMedicalInsuranceCheckStatusName(StrUtil.isEmpty((CharSequence)medicalInsuranceCheckCode) ? MedicalInsuranceCheckStatusEnum.NO_UPLOAD.getLabel() : medicalInsuranceCheckName);
                    String isMergeLabel = row.getCell(10).getStringCellValue();
                    chargeItem.setIsMergeChargeItem("\u662f".equals(isMergeLabel) ? "1" : "0");
                    String isUseLabel = row.getCell(11).getStringCellValue();
                    chargeItem.setIsUserMedicalInsuranceIdPay("\u662f".equals(isUseLabel) ? "1" : "0");
                    String medicalInsuranceTypeLabel = row.getCell(12).getStringCellValue();
                    chargeItem.setMedicalInsuranceTypeCode(this.getMapValue(map, "medical_insurance_type", medicalInsuranceTypeLabel));
                    chargeItem.setMedicalInsuranceTypeName(StrUtil.isEmpty((CharSequence)chargeItem.getMedicalInsuranceTypeCode()) ? null : medicalInsuranceTypeLabel);
                    String medicalInsuranceCode = this.getString(row.getCell(13).getStringCellValue());
                    String medicalInsuranceName = this.getString(row.getCell(14).getStringCellValue());
                    chargeItem.setMedicalInsuranceCode(medicalInsuranceCode);
                    chargeItem.setMedicalInsuranceName(medicalInsuranceName);
                    String placeMedicalInsuranceCode = this.getString(row.getCell(15).getStringCellValue());
                    String placeMedicalInsuranceName = this.getString(row.getCell(16).getStringCellValue());
                    chargeItem.setPlaceMedicalInsuranceCode(placeMedicalInsuranceCode);
                    chargeItem.setPlaceMedicalInsuranceName(placeMedicalInsuranceName);
                    String feeLevel = this.getString(row.getCell(17).getStringCellValue());
                    chargeItem.setChargeItemLevel(feeLevel);
                    String drugSpec = this.getString(row.getCell(18).getStringCellValue());
                    chargeItem.setDrugSpec(drugSpec);
                    String manufacture = this.getString(row.getCell(19).getStringCellValue());
                    chargeItem.setManufacturer(manufacture);
                    String productCode = this.getString(row.getCell(20).getStringCellValue());
                    String productName = this.getString(row.getCell(21).getStringCellValue());
                    String payStandard = this.getString(row.getCell(22).getStringCellValue());
                    String drugType = this.getString(row.getCell(23).getStringCellValue());
                    chargeItem.setProductCode(productCode);
                    chargeItem.setProductName(productName);
                    chargeItem.setPayStandard(payStandard);
                    chargeItem.setDrugType(drugType);
                    chargeItemList.add(chargeItem);
                }
            }
            boolean dbFlag = false;
            String errorInfo = "";
            if (!chargeItemList.isEmpty()) {
                Map<String, List<SysChargeItemEntity>> nameGroups = chargeItemList.stream().collect(Collectors.groupingBy(SysChargeItemEntity::getChargeItemName));
                dbList = nameGroups.values().stream().filter(list -> list.size() > 1).flatMap(Collection::stream).collect(Collectors.toList());
                List dbChargeItemNames = dbList.stream().map(SysChargeItemEntity::getChargeItemName).distinct().collect(Collectors.toList());
                StringBuilder chargeItemNamesBuffer = new StringBuilder();
                int dbCount = 0;
                for (String name : dbChargeItemNames) {
                    dbFlag = true;
                    if (++dbCount == dbChargeItemNames.size()) {
                        chargeItemNamesBuffer.append(name).append("\u3002");
                        continue;
                    }
                    chargeItemNamesBuffer.append(name).append("\u3001");
                }
                if (dbCount > 0) {
                    errorInfo = "\u6536\u8d39\u9879\u76ee\u540d\u79f0\u4e0d\u53ef\u91cd\u590d\uff01\u91cd\u590d\u9879\u76ee\u540d\u79f0\uff1a" + chargeItemNamesBuffer.toString();
                }
            }
            if (!treatmentItemList.isEmpty()) {
                Map<String, List<SysTreatmentItemEntity>> nameGroups = treatmentItemList.stream().collect(Collectors.groupingBy(SysTreatmentItemEntity::getItemName));
                dbList = nameGroups.values().stream().filter(list -> list.size() > 1).flatMap(Collection::stream).collect(Collectors.toList());
                List dbTreatmentItemNames = dbList.stream().map(SysTreatmentItemEntity::getItemName).distinct().collect(Collectors.toList());
                StringBuilder treatmentItemNamesBuffer = new StringBuilder();
                int dbCount = 0;
                itemCode = dbTreatmentItemNames.iterator();
                while (itemCode.hasNext()) {
                    String name;
                    name = (String)itemCode.next();
                    dbFlag = true;
                    if (++dbCount == dbTreatmentItemNames.size()) {
                        treatmentItemNamesBuffer.append(name).append("\u3002");
                        continue;
                    }
                    treatmentItemNamesBuffer.append(name).append("\u3001");
                }
                if (dbCount > 0) {
                    errorInfo = errorInfo + "\u8bca\u7597\u9879\u76ee\u540d\u79f0\u4e0d\u53ef\u91cd\u590d\uff01\u91cd\u590d\u9879\u76ee\u540d\u79f0\uff1a" + treatmentItemNamesBuffer.toString();
                }
            }
            if (dbFlag) {
                ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)errorInfo);
            }
            HashMap<String, Integer> insertChargeItemMap = new HashMap<String, Integer>();
            if (!chargeItemList.isEmpty()) {
                List chargeItemNames = chargeItemList.stream().map(SysChargeItemEntity::getChargeItemName).distinct().collect(Collectors.toList());
                this.sysChargeItemService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysChargeItemEntity.class).eq(SysChargeItemEntity::getTenantId, (Object)tenantId)).in(SysChargeItemEntity::getChargeItemName, chargeItemNames));
                for (SysChargeItemEntity entity : chargeItemList) {
                    entity.setTenantId(tenantId);
                    entity.setPyCode(StringPinYinUtil.toFirstChar((String)entity.getChargeItemName()));
                    entity.setWbCode(StringWubiUtil.getWbCode((String)entity.getChargeItemName()));
                    this.sysChargeItemMapper.insert((Object)entity);
                    insertChargeItemMap.put(entity.getChargeItemName(), entity.getId());
                }
            }
            HashMap<String, Integer> insertTreatmentItemMap = new HashMap<String, Integer>();
            if (!treatmentItemList.isEmpty()) {
                List treatmentItemNames = treatmentItemList.stream().map(SysTreatmentItemEntity::getItemName).distinct().collect(Collectors.toList());
                this.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysTreatmentItemEntity.class).eq(SysTreatmentItemEntity::getTenantId, (Object)tenantId)).in(SysTreatmentItemEntity::getItemName, treatmentItemNames));
                for (SysTreatmentItemEntity entity : treatmentItemList) {
                    entity.setTenantId(tenantId);
                    entity.setPyCode(StringPinYinUtil.toFirstChar((String)entity.getItemName()));
                    entity.setWbCode(StringWubiUtil.getWbCode((String)entity.getItemName()));
                    this.sysTreatmentItemMapper.insert((Object)entity);
                    insertTreatmentItemMap.put(entity.getItemName(), entity.getId());
                }
            }
            if (!treatmentChargeList.isEmpty()) {
                this.sysTreatmentChargeMapper.delete((Wrapper)Wrappers.lambdaQuery(SysTreatmentChargeEntity.class).eq(SysTreatmentChargeEntity::getTenantId, (Object)tenantId));
            }
            Map<String, List<SysTreatmentChargeEntity>> insertTreatmentChargeMap = treatmentChargeList.stream().collect(Collectors.groupingBy(SysTreatmentChargeEntity::getTreatmentItemName));
            for (Map.Entry<String, List<SysTreatmentChargeEntity>> entries : insertTreatmentChargeMap.entrySet()) {
                treatmentItemName = entries.getKey();
                Integer treatmentId = (Integer)insertTreatmentItemMap.get(treatmentItemName);
                if (treatmentId == null) continue;
                List<SysTreatmentChargeEntity> treatmentCharges = entries.getValue();
                for (SysTreatmentChargeEntity entity : treatmentCharges) {
                    Integer chargeId = (Integer)insertChargeItemMap.get(entity.getChargeItemName());
                    if (chargeId == null) continue;
                    entity.setTenantId(tenantId);
                    entity.setTreatmentId(treatmentId);
                    entity.setChargeId(chargeId);
                    this.sysTreatmentChargeMapper.insert((Object)entity);
                }
            }
        }
        catch (Exception e) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)e.getMessage());
            this.logger.info(e.getMessage());
        }
    }

    private String getString(String value) {
        String label = StrUtil.isEmpty((CharSequence)value) ? null : value;
        return label;
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void insert(SysTreatmentItemDto dto) {
        String statusCode;
        String statusName;
        if (StrUtil.isEmpty((CharSequence)dto.getItemName())) {
            throw new BusinessException("10000", "\u65b0\u589e\u8bca\u7597\u9879\u76ee\u65f6\uff0c\u8bca\u7597\u9879\u76ee\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        SysTreatmentItemEntity entity = new SysTreatmentItemEntity();
        BeanUtils.copyProperties((Object)dto, (Object)entity);
        SysTreatmentItemEntity dbEntity = (SysTreatmentItemEntity)this.sysTreatmentItemMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysTreatmentItemEntity.class).eq(SysTreatmentItemEntity::getItemName, (Object)entity.getItemName())).eq(entity.getTenantId() != null, SysTreatmentItemEntity::getTenantId, (Object)entity.getTenantId()));
        if (dbEntity != null) {
            throw new BusinessException("10001", "\u8bca\u7597\u9879\u76ee\u5df2\u5b58\u5728\uff0c\u65b0\u589e\u5931\u8d25\uff01");
        }
        entity.setPyCode(StringPinYinUtil.toFirstChar((String)entity.getItemName()));
        entity.setWbCode(StringWubiUtil.getWbCode((String)entity.getItemName()));
        entity.setItemCode(UUIDUtils.getNumberRandom((int)9));
        String applyGenderCode = entity.getApplyGenderCode();
        String applyGenderName = Optional.ofNullable(ApplyGenderEnum.getEnumLabel((String)applyGenderCode)).map(ApplyGenderEnum::getLabel).orElse(null);
        entity.setApplyGenderCode(StrUtil.isEmpty((CharSequence)applyGenderName) ? ApplyGenderEnum.NO_LIMITATION.getValue() : applyGenderCode);
        entity.setApplyGenderName(StrUtil.isEmpty((CharSequence)applyGenderName) ? ApplyGenderEnum.NO_LIMITATION.getLabel() : applyGenderName);
        if (StrUtil.isNotEmpty((CharSequence)entity.getStatusCode()) && "2".equals(entity.getStatusCode())) {
            entity.setStatusCode(StatusEnum.UN_ENABLED.getValue());
        }
        entity.setStatusCode(StrUtil.isEmpty((CharSequence)(statusName = (String)Optional.ofNullable(StatusEnum.getEnumLabel((String)(statusCode = entity.getStatusCode()))).map(StatusEnum::getLabel).orElse(null))) ? StatusEnum.ENABLED.getValue() : statusCode);
        entity.setStatusName(StrUtil.isEmpty((CharSequence)statusName) ? StatusEnum.ENABLED.getLabel() : statusName);
        entity.setIsContainServiceFee(StrUtil.isEmpty((CharSequence)entity.getIsContainServiceFee()) ? "0" : entity.getIsContainServiceFee());
        if ("2".equals(entity.getExecuteDeptFlag())) {
            entity.setExecuteDeptId(null);
        }
        int insertCount = this.sysTreatmentItemMapper.insert((Object)entity);
        ExceptionUtils.createException((Logger)this.logger, (int)insertCount, (String)"10002", (String)"\u8bca\u7597\u9879\u76ee\u65b0\u589e\u5931\u8d25\uff01");
        if (dto.getRelationList() != null && !dto.getRelationList().isEmpty()) {
            dto.getRelationList().forEach(sysTreatmentChargeDto -> {
                SysTreatmentChargeEntity sysTreatmentChargeEntity = new SysTreatmentChargeEntity();
                sysTreatmentChargeEntity.setTenantId(entity.getTenantId());
                sysTreatmentChargeEntity.setTreatmentId(entity.getId());
                sysTreatmentChargeEntity.setChargeId(sysTreatmentChargeDto.getChargeId());
                sysTreatmentChargeEntity.setQuantity(sysTreatmentChargeDto.getQuantity());
                int relationCount = this.sysTreatmentChargeMapper.insert((Object)sysTreatmentChargeEntity);
                ExceptionUtils.createException((Logger)this.logger, (int)relationCount, (String)"10003", (String)"\u8bca\u7597\u9879\u76ee\u5185\u7684\u6536\u8d39\u9879\u76ee\u65b0\u589e\u5931\u8d25\uff01");
            });
        }
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void update(SysTreatmentItemDto dto) {
        if (dto.getId() == null || StrUtil.isEmpty((CharSequence)dto.getId().toString())) {
            throw new BusinessException("10000", "\u7f16\u8f91\u8bca\u7597\u9879\u76ee\u65f6\uff0c\u8bca\u7597\u9879\u76ee\u4e3b\u952eID\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        if (StrUtil.isNotEmpty((CharSequence)dto.getItemName())) {
            SysTreatmentItemEntity dbEntity = (SysTreatmentItemEntity)this.sysTreatmentItemMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysTreatmentItemEntity.class).eq(SysTreatmentItemEntity::getItemName, (Object)dto.getItemName())).eq(dto.getTenantId() != null, SysTreatmentItemEntity::getTenantId, (Object)dto.getTenantId()));
            if (dbEntity != null && !dbEntity.getId().equals(dto.getId())) {
                ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u8bca\u7597\u9879\u76ee\u5df2\u5b58\u5728\uff01");
            }
            dto.setPyCode(StringPinYinUtil.toFirstChar((String)dto.getItemName()));
            dto.setWbCode(StringWubiUtil.getWbCode((String)dto.getItemName()));
        }
        SysTreatmentItemEntity entity = new SysTreatmentItemEntity();
        BeanUtils.copyProperties((Object)dto, (Object)entity);
        if (StrUtil.isNotEmpty((CharSequence)entity.getApplyGenderCode())) {
            String applyGenderName = Optional.ofNullable(ApplyGenderEnum.getEnumLabel((String)entity.getApplyGenderCode())).map(ApplyGenderEnum::getLabel).orElse(null);
            entity.setApplyGenderName(applyGenderName);
        }
        if (StrUtil.isNotEmpty((CharSequence)entity.getStatusCode())) {
            if ("2".equals(entity.getStatusCode())) {
                entity.setStatusCode(StatusEnum.UN_ENABLED.getValue());
            }
            if (StatusEnum.UN_ENABLED.getValue().equals(entity.getStatusCode())) {
                Integer[] ids = new Integer[]{entity.getId()};
                this.checkStatus(ids, Integer.valueOf(1));
            }
            String statusName = Optional.ofNullable(StatusEnum.getEnumLabel((String)entity.getStatusCode())).map(StatusEnum::getLabel).orElse(null);
            entity.setStatusName(statusName);
        }
        if ("2".equals(entity.getExecuteDeptFlag())) {
            entity.setExecuteDeptId(null);
        }
        int updateCount = this.sysTreatmentItemMapper.updateById((Object)entity);
        ExceptionUtils.createException((Logger)this.logger, (int)updateCount, (String)"10001", (String)"\u7f16\u8f91\u8bca\u7597\u9879\u76ee\u5931\u8d25\uff01");
        if (dto.getRelationList() != null && dto.getRelationList().size() > 0) {
            this.sysTreatmentChargeMapper.deleteByTreatmentId(entity.getId());
            dto.getRelationList().forEach(sysTreatmentChargeDto -> {
                SysTreatmentChargeEntity sysTreatmentChargeEntity = new SysTreatmentChargeEntity();
                sysTreatmentChargeEntity.setTenantId(entity.getTenantId());
                sysTreatmentChargeEntity.setTreatmentId(entity.getId());
                sysTreatmentChargeEntity.setChargeId(sysTreatmentChargeDto.getChargeId());
                sysTreatmentChargeEntity.setQuantity(sysTreatmentChargeDto.getQuantity());
                int insertCount = this.sysTreatmentChargeMapper.insert((Object)sysTreatmentChargeEntity);
                ExceptionUtils.createException((Logger)this.logger, (int)insertCount, (String)"10003", (String)"\u7f16\u8f91\u8bca\u7597\u9879\u76ee\u65f6\uff0c\u65b0\u589e\u5173\u8054\u8868\u5931\u8d25\uff01");
            });
        }
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void updateList(List<SysTreatmentItemDto> dtoList) {
        if (dtoList == null || dtoList.isEmpty()) {
            throw new BusinessException("10000", "\u6279\u91cf\u7f16\u8f91\u8bca\u7597\u9879\u76ee\u65f6\uff0c\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        dtoList.forEach(dto -> {
            if (dto.getId() == null || StrUtil.isEmpty((CharSequence)dto.getId().toString())) {
                throw new BusinessException("10001", "\u6279\u91cf\u7f16\u8f91\u8bca\u7597\u9879\u76ee\u65f6\uff0c\u8bca\u7597\u9879\u76ee\u4e3b\u952eID\u4e0d\u53ef\u4e3a\u7a7a\uff01");
            }
        });
        dtoList.forEach(arg_0 -> this.update(arg_0));
    }

    public void deleteDetailListByIds(Integer[] ids) {
        if (ArrayUtil.isEmpty((Object[])ids)) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u5220\u9664\u6536\u8d39\u9879\u76ee\u660e\u7ec6\u65f6\uff0c\u4e3b\u952eID\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        int deleteCount = this.sysTreatmentChargeMapper.deleteByIds(ids);
        ExceptionUtils.createException((Logger)this.logger, (int)deleteCount, (String)"500", (String)"\u5220\u9664\u6536\u8d39\u660e\u7ec6\u9879\u5931\u8d25\uff01");
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void deleteListByIds(Integer[] ids) {
        if (ArrayUtil.isEmpty((Object[])ids)) {
            throw new BusinessException("10000", "\u5220\u9664\u8bca\u7597\u9879\u76ee\u65f6\uff0c\u4e3b\u952eID\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        int deleteCount = this.sysTreatmentItemMapper.deleteListByIds(ids);
        ExceptionUtils.createException((Logger)this.logger, (int)deleteCount, (String)"10001", (String)"\u8bca\u7597\u9879\u76ee\u5220\u9664\u5931\u8d25\uff01");
        this.checkStatus(ids, Integer.valueOf(2));
        int deleteRelationCount = this.sysTreatmentChargeMapper.deleteByTreatmentIds(ids);
        ExceptionUtils.createException((Logger)this.logger, (int)deleteRelationCount, (String)"10002", (String)"\u8bca\u7597\u9879\u76ee\u5173\u8054\u8868\u5220\u9664\u5931\u8d25\uff01");
    }

    public Page<SysTreatmentItemVo> selectPageList(SysTreatmentItemDto dto) {
        if (StrUtil.isNotEmpty((CharSequence)dto.getStatusCode()) && "2".equals(dto.getStatusCode())) {
            dto.setStatusCode(StatusEnum.UN_ENABLED.getValue());
        }
        if (StrUtil.isNotEmpty((CharSequence)dto.getTreatmentTypeCode())) {
            dto.setTreatmentTypeCodes(this.splitTreatmentTypeCode(dto.getTreatmentTypeCode()));
        }
        Page page = new Page((long)dto.getCurrent(), (long)dto.getSize());
        List list = dto.getIsFiltration() != false ? this.sysTreatmentItemMapper.selectPageList(page, dto, Integer.valueOf(1)) : this.sysTreatmentItemMapper.selectPageList(page, dto, Integer.valueOf(0));
        if (list != null && list.size() > 0) {
            list = this.getTreatmentItemList(list);
            list = this.getDictLabel(list);
        }
        page.setRecords(list);
        return page;
    }

    public List<SysTreatmentItemVo> selectList(Integer[] ids) {
        List list = this.sysTreatmentItemMapper.selectListByIds(ids);
        list = this.getDictLabel(list);
        return list;
    }

    public List<SysTreatmentItemVo> selectListWithChargeItems(Integer[] ids) {
        List list = this.sysTreatmentItemMapper.selectListByIds(ids);
        if (list != null && list.size() > 0) {
            list = this.getTreatmentItemList(list);
            list = this.getDictLabel(list);
        }
        return list;
    }

    public List<SysTreatmentItemVo> selectListByTypes(SysTreatmentItemDto dto) {
        List list;
        if (StrUtil.isNotEmpty((CharSequence)dto.getTreatmentTypeCode())) {
            dto.setTreatmentTypeCodes(this.splitTreatmentTypeCode(dto.getTreatmentTypeCode()));
        }
        if ((list = this.sysTreatmentItemMapper.selectListByTypes(dto)) != null && list.size() > 0) {
            list = this.getTreatmentItemList(list);
            list = this.getDictLabel(list);
        }
        return list;
    }

    private List<SysDictValueEntity> getDictValueList(List<String> typeList) {
        List dictValueList = this.sysDictValueMapper.selectList((Wrapper)Wrappers.lambdaQuery(SysDictValueEntity.class).in(SysDictValueEntity::getType, typeList));
        return dictValueList;
    }

    private Map<String, Map<String, String>> getDictValueMap(List<SysDictValueEntity> list) {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        for (SysDictValueEntity entity : list) {
            map.computeIfAbsent(entity.getType(), k -> new HashMap()).put(entity.getValue(), entity.getLabel());
        }
        return map;
    }

    private List<SysTreatmentItemVo> getDictLabel(List<SysTreatmentItemVo> list) {
        List executeDeptIds = list.stream().map(SysTreatmentItemVo::getExecuteDeptId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<Object, Object> deptMap = new HashMap();
        if (!executeDeptIds.isEmpty()) {
            List deptList = this.sysDepartmentMapper.selectList((Wrapper)Wrappers.lambdaQuery(SysDepartmentEntity.class).in(BaseEntity::getId, executeDeptIds));
            deptMap = deptList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
        }
        ArrayList<String> dictTypes = new ArrayList<String>();
        dictTypes.add("examine_type");
        dictTypes.add("inspect_type");
        dictTypes.add("therapeutic_nature");
        dictTypes.add("patrol_car_examine_type");
        dictTypes.add("examine_position");
        dictTypes.add("specimen");
        dictTypes.add("patrol_car_item");
        dictTypes.add("diagnosis_treatment_type");
        List dictValueList = this.getDictValueList(dictTypes);
        Map map = this.getDictValueMap(dictValueList);
        for (SysTreatmentItemVo vo : list) {
            SysDepartmentEntity deptEntity;
            if (StrUtil.isNotEmpty((CharSequence)vo.getTreatmentTypeCode())) {
                vo.setTreatmentTypeName(this.getMapValue(map, "diagnosis_treatment_type", vo.getTreatmentTypeCode()));
                if ("1".equals(vo.getTreatmentTypeCode())) {
                    vo.setInspectTypeLabel(this.getMapValue(map, "examine_type", vo.getInspectType()));
                    vo.setSpecimenLabel(this.getMapValue(map, "examine_position", vo.getSpecimen()));
                } else if ("2".equals(vo.getTreatmentTypeCode())) {
                    vo.setInspectTypeLabel(this.getMapValue(map, "inspect_type", vo.getInspectType()));
                    vo.setSpecimenLabel(this.getMapValue(map, "specimen", vo.getSpecimen()));
                } else if ("3".equals(vo.getTreatmentTypeCode())) {
                    vo.setInspectTypeLabel(this.getMapValue(map, "therapeutic_nature", vo.getInspectType()));
                } else if ("10".equals(vo.getTreatmentTypeCode())) {
                    vo.setInspectTypeLabel(this.getMapValue(map, "patrol_car_examine_type", vo.getInspectType()));
                    vo.setSpecimenLabel(this.getMapValue(map, "patrol_car_item", vo.getSpecimen()));
                }
            }
            vo.setExecuteDeptName((deptEntity = (SysDepartmentEntity)deptMap.get(vo.getExecuteDeptId())) == null ? null : deptEntity.getDepartmentName());
            vo.setExecuteDeptPosition(deptEntity == null ? null : deptEntity.getPosition());
        }
        return list;
    }

    private String getMapValue(Map<String, Map<String, String>> map, String type, String key) {
        Map detailMap = map.getOrDefault(type, Collections.emptyMap());
        return detailMap.getOrDefault(key, null);
    }

    private void checkStatus(Integer[] ids, Integer typeFlag) {
        List templateManageDetailEntityList = this.sysTemplateManageDetailMapper.selectList((Wrapper)Wrappers.lambdaQuery(SysTemplateManageDetailEntity.class).in(SysTemplateManageDetailEntity::getTreatmentId, (Object[])ids));
        if (!templateManageDetailEntityList.isEmpty()) {
            List templateIds = templateManageDetailEntityList.stream().map(SysTemplateManageDetailEntity::getTemplateId).distinct().collect(Collectors.toList());
            List templateManageEntityList = this.sysTemplateManageMapper.selectList((Wrapper)Wrappers.lambdaQuery(SysTemplateManageEntity.class).in(SysTemplateManageEntity::getId, templateIds));
            boolean flag = false;
            StringJoiner joiner = new StringJoiner("\uff0c", "", "\u3002");
            for (SysTemplateManageEntity entity : templateManageEntityList) {
                if (!StatusEnum.ENABLED.getValue().equals(entity.getStatusCode())) continue;
                flag = true;
                joiner.add(entity.getTemplateName());
            }
            if (flag) {
                String errorInfoItemName = joiner.toString();
                if (typeFlag == 1) {
                    ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)("\u8be5\u8bca\u7597\u9879\u76ee\u5df2\u88ab\u6a21\u7248\u4f7f\u7528\uff0c\u9879\u76ee\u65e0\u6cd5\u88ab\u505c\u7528\uff01\u5bf9\u5e94\u6a21\u7248\uff1a" + errorInfoItemName));
                } else if (typeFlag == 2) {
                    ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)("\u8be5\u8bca\u7597\u9879\u76ee\u5df2\u88ab\u6a21\u7248\u4f7f\u7528\uff0c\u9879\u76ee\u65e0\u6cd5\u88ab\u5220\u9664\uff01\u5bf9\u5e94\u6a21\u7248\uff1a" + errorInfoItemName));
                }
            }
        }
    }

    private String[] splitTreatmentTypeCode(String treatmentTypeCode) {
        String[] treatmentTypeCodes = treatmentTypeCode.split(",");
        return treatmentTypeCodes;
    }

    private List<SysTreatmentItemVo> getTreatmentItemList(List<SysTreatmentItemVo> list) {
        List treatmentIds = list.stream().map(BasePageEntity::getId).collect(Collectors.toList());
        List treatmentChargeList = this.sysTreatmentChargeMapper.selectListByTreatmentIds(treatmentIds);
        if (treatmentChargeList != null && !treatmentChargeList.isEmpty()) {
            Map<Integer, List<SysTreatmentChargeVo>> treatmentChargeMap = treatmentChargeList.stream().collect(Collectors.groupingBy(SysTreatmentChargeVo::getTreatmentId));
            List chargeIds = treatmentChargeList.stream().map(SysTreatmentChargeVo::getChargeId).collect(Collectors.toList());
            List chargeItemList = this.sysChargeItemMapper.selectList((Wrapper)Wrappers.lambdaQuery(SysChargeItemEntity.class).in(SysChargeItemEntity::getId, chargeIds));
            Map chargeItemMap = chargeItemList.stream().collect(Collectors.toMap(SysChargeItemEntity::getId, Function.identity()));
            for (Map.Entry<Integer, List<SysTreatmentChargeVo>> entry : treatmentChargeMap.entrySet()) {
                for (SysTreatmentChargeVo vo : entry.getValue()) {
                    SysChargeItemEntity chargeItem = (SysChargeItemEntity)chargeItemMap.get(vo.getChargeId());
                    if (chargeItem == null) continue;
                    vo.setChargeItemCode(chargeItem.getChargeItemCode());
                    vo.setChargeItemName(chargeItem.getChargeItemName());
                    vo.setTreatmentTypeCode(chargeItem.getTreatmentTypeCode());
                    vo.setTreatmentTypeName(chargeItem.getTreatmentTypeName());
                    vo.setItemPrice(chargeItem.getItemPrice());
                    vo.setUnit(chargeItem.getUnit());
                    vo.setMedicalInsuranceTypeCode(chargeItem.getMedicalInsuranceTypeCode());
                    vo.setMedicalInsuranceTypeName(chargeItem.getMedicalInsuranceTypeName());
                    vo.setMedicalInsuranceCode(chargeItem.getMedicalInsuranceCode());
                    vo.setMedicalInsuranceName(chargeItem.getMedicalInsuranceName());
                    vo.setPlaceMedicalInsuranceCode(chargeItem.getPlaceMedicalInsuranceCode());
                    vo.setPlaceMedicalInsuranceName(chargeItem.getPlaceMedicalInsuranceName());
                    vo.setChargeItemLevel(chargeItem.getChargeItemLevel());
                    vo.setChargeItemId(chargeItem.getChargeItemId());
                }
            }
            for (SysTreatmentItemVo vo : list) {
                List treatmentChargeVos = Optional.ofNullable(treatmentChargeMap.get(vo.getId())).orElse(new ArrayList());
                if (treatmentChargeVos.isEmpty()) continue;
                BigDecimal totalPrice = treatmentChargeVos.stream().map(treatmentCharge -> {
                    BigDecimal itemPrice = treatmentCharge.getItemPrice() == null ? new BigDecimal(0) : treatmentCharge.getItemPrice();
                    Integer quantity = treatmentCharge.getQuantity() == null ? 0 : treatmentCharge.getQuantity();
                    return itemPrice.multiply(new BigDecimal(quantity));
                }).reduce(BigDecimal.ZERO, BigDecimal::add);
                vo.setTotalPrice(totalPrice);
                vo.setSysTreatmentChargeVoList(treatmentChargeVos);
            }
        }
        return list;
    }
}

