/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.mvc.controller;

import com.byh.sys.api.model.PatientEntity;
import com.byh.sys.api.util.BeanUtil;
import com.byh.sys.api.util.EasyExcelUtil;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.api.vo.PatientImportVo;
import com.byh.sys.api.vo.PatientListener;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.PatientService;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/patient"})
public class PatientController {
    private static final Logger log = LoggerFactory.getLogger(PatientController.class);
    @Autowired
    private PatientService patientService;
    @Autowired
    private CommonRequest commonRequest;

    @PostMapping(value={"/importPatientExcel"})
    @ApiOperation(value="\u5bfc\u5165\u60a3\u8005\u6863\u6848", httpMethod="GET", notes="\u5bfc\u5165\u60a3\u8005\u6863\u6848")
    public ResponseData importPatientExcel(@RequestParam(value="file") MultipartFile file) throws IOException {
        Integer tenant = this.commonRequest.getTenant();
        List importVos = EasyExcelUtil.importExcel((MultipartFile)file, (Object)new PatientImportVo(), (Object)new PatientListener());
        importVos.forEach(item -> {
            String ageStr = item.getAgeStr();
            item.setAge(Integer.valueOf(Integer.parseInt(ageStr)));
            item.setCardType("01");
        });
        List patientList = BeanUtil.copyList((List)importVos, PatientEntity.class);
        patientList.forEach(item -> {
            item.setTenantId(tenant);
            item.setBirthday(item.getBirthday().replace(".", "-"));
        });
        return this.patientService.insertImport(patientList);
    }
}

