/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.mvc.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.sys.api.model.SysCategorySettingEntity;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.api.util.StringPinYinUtil;
import com.byh.sys.api.util.UUIDUtils;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.SysCategorySettingService;
import java.util.Date;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SysCategorySettingController {
    @Autowired
    private SysCategorySettingService sysCategorySettingService;
    @Autowired
    private CommonRequest commonRequest;

    @RequestMapping(value={"/sys/category/setting/save"})
    public ResponseData sysCategorySettingSave(@RequestBody @Valid SysCategorySettingEntity entity) {
        Integer userId = this.commonRequest.getUserId();
        String userName = this.commonRequest.getUserName();
        Integer tenant = this.commonRequest.getTenant();
        Date date = new Date();
        if (entity.getParentId() == null) {
            entity.setParentId("0");
        }
        entity.setTenantId(tenant);
        entity.setCreateId(userId);
        entity.setCreateName(userName);
        entity.setCreateTime(date);
        entity.setUpdateId(userId);
        entity.setUpdateName(userName);
        entity.setUpdateTime(date);
        String firstChar = StringPinYinUtil.toFirstChar((String)entity.getCategoryName());
        entity.setPyCode(firstChar);
        entity.setCategoryCode(UUIDUtils.getRandom((int)0, (boolean)true));
        SysCategorySettingEntity sysCategorySettingEntity = new SysCategorySettingEntity();
        sysCategorySettingEntity.setCategoryName(entity.getCategoryName());
        sysCategorySettingEntity.setParentId(entity.getParentId());
        sysCategorySettingEntity.setTenantId(tenant);
        IPage sysCategorySettingEntityIPage = this.sysCategorySettingService.sysCategorySettingSelectPage(new Page(), sysCategorySettingEntity);
        if (sysCategorySettingEntityIPage.getTotal() == 0L) {
            if (entity.getParentName() == null || entity.getParentName().equals("")) {
                SysCategorySettingEntity selName = new SysCategorySettingEntity();
                selName.setTenantId(tenant);
                selName.setCategoryCode(entity.getParentId());
                IPage getName = this.sysCategorySettingService.sysCategorySettingSelectPage(new Page(), selName);
                if (getName.getTotal() > 0L) {
                    String categoryName = ((SysCategorySettingEntity)getName.getRecords().get(0)).getCategoryName();
                    entity.setParentName(categoryName);
                } else if (!entity.getParentId().equals("0")) {
                    return ResponseData.error((String)"\u7236\u7c7b\u4e0d\u5b58\u5728");
                }
            }
            this.sysCategorySettingService.sysCategorySettingSave(entity);
            return ResponseData.success();
        }
        return ResponseData.error((String)"\u7c7b\u76ee\u540d\u79f0\u91cd\u590d");
    }

    @GetMapping(value={"/sys/category/setting/select"})
    public ResponseData sysCategorySettingSelect(SysCategorySettingEntity entity) {
        if (entity.getParentId() == null) {
            entity.setParentId("0");
        }
        if (entity.getTenantId() == null) {
            entity.setTenantId(this.commonRequest.getTenant());
        }
        List list = this.sysCategorySettingService.sysCategorySettingSelect(entity.getParentId());
        return ResponseData.success((Object)list);
    }

    @GetMapping(value={"/sys/category/setting/selectPage"})
    public ResponseData sysCategorySettingSelectPage(Page page, SysCategorySettingEntity entity) {
        IPage list = this.sysCategorySettingService.sysCategorySettingSelectPage(page, entity);
        return ResponseData.success((Object)list);
    }

    @RequestMapping(value={"/sys/category/setting/update"})
    public ResponseData sysCategorySettingUpdate(@RequestBody @Valid SysCategorySettingEntity entity) {
        Integer userId = this.commonRequest.getUserId();
        String userName = this.commonRequest.getUserName();
        Date date = new Date();
        entity.setUpdateId(userId);
        entity.setUpdateName(userName);
        entity.setUpdateTime(date);
        if (entity.getCategoryName() != null && entity.getCreateName() != "") {
            entity.setPyCode(StringPinYinUtil.toFirstChar((String)entity.getCategoryName()));
        }
        this.sysCategorySettingService.sysCategorySettingUpdate(entity);
        return ResponseData.success();
    }

    @RequestMapping(value={"/sys/category/setting/delete"})
    public ResponseData sysCategorySettingDelete(@RequestBody @Valid SysCategorySettingEntity entity) {
        this.sysCategorySettingService.sysCategorySettingDelete(entity);
        return ResponseData.success();
    }
}

