/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.mvc.controller;

import com.byh.sys.api.dto.sysException.SysExceptionDto;
import com.byh.sys.api.dto.sysException.SysExceptionSaveDto;
import com.byh.sys.api.model.SysExceptionEntity;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.SysExceptionService;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SysExceptionController {
    @Autowired
    private SysExceptionService sysExceptionService;
    @Autowired
    private CommonRequest commonRequest;

    @RequestMapping(value={"/sys/exception/save"})
    public ResponseData sysExceptionSave(@RequestBody @Valid SysExceptionSaveDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        this.sysExceptionService.sysExceptionSave(dto);
        return ResponseData.success().save();
    }

    @RequestMapping(value={"/sys/exception/select"})
    public ResponseData sysExceptionSelect(@RequestBody @Valid SysExceptionDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        List list = this.sysExceptionService.sysExceptionSelect(dto);
        return ResponseData.success((Object)list);
    }

    @RequestMapping(value={"/sys/exception/update"})
    public ResponseData sysExceptionUpdate(@RequestBody @Valid SysExceptionEntity entity) {
        this.sysExceptionService.sysExceptionUpdate(entity);
        return ResponseData.success().update();
    }

    @RequestMapping(value={"/sys/exception/delete"})
    public ResponseData sysExceptionDelete(@RequestBody @Valid SysExceptionEntity entity) {
        this.sysExceptionService.sysExceptionDelete(entity);
        return ResponseData.success().delete();
    }
}

