/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.mvc.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.byh.sys.api.annotation.AntiRefresh;
import com.byh.sys.api.annotation.UserOptLogger;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.SysMenuEntity;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.SysMenuService;
import enums.ConstantsEnums;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"sysMenu"})
public class SysMenuController {
    private static final Logger log = LoggerFactory.getLogger(SysMenuController.class);
    private static Logger logger = LoggerFactory.getLogger(SysMenuController.class);
    private final SysMenuService sysMenuService;
    @Autowired
    private CommonRequest commonRequest;

    @ApiOperation(value="\u5217\u8868", httpMethod="GET", notes="\u5217\u8868")
    @GetMapping(value={"/querySysMenuTree"})
    @AntiRefresh
    public ResponseData querySysMenuTree(SysMenuEntity sysMenuEntity) {
        return ResponseData.success((Object)this.sysMenuService.querySysMenuTree(sysMenuEntity));
    }

    @ApiOperation(value="\u8be6\u60c5", httpMethod="GET", notes="\u8be6\u60c5")
    @GetMapping(value={"/getInfo"})
    @AntiRefresh
    public ResponseData getInfo(Integer menuId) {
        if (StrUtil.isEmpty((CharSequence)String.valueOf(menuId))) {
            throw new BusinessException("\u83dc\u5355\u4e3b\u952emenuId\u4e0d\u80fd\u4e3a\u7a7a\uff01{id}" + menuId);
        }
        return ResponseData.success((Object)this.sysMenuService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysMenuEntity::getId, (Object)menuId)).eq(SysMenuEntity::getDelFlag, (Object)ConstantsEnums.DEL_FLAG_ZERO.getValue())));
    }

    @UserOptLogger(operation="\u83dc\u5355\u6a21\u5757")
    @PostMapping(value={"/saveUpdate"})
    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539", httpMethod="POST", notes="\u65b0\u589e\u6216\u4fee\u6539")
    public ResponseData saveUpdate(@RequestBody SysMenuEntity sysMenuEntity) {
        sysMenuEntity.setTenantId(this.commonRequest.getTenant());
        if (StrUtil.isEmpty((CharSequence)sysMenuEntity.getParentId())) {
            throw new BusinessException("\u7236\u7ea7parentId\u4e0d\u80fd\u4e3a\u7a7a\uff01{parentId}" + sysMenuEntity.getParentId());
        }
        if (StrUtil.isEmpty((CharSequence)sysMenuEntity.getName())) {
            throw new BusinessException("\u83dc\u5355\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01{name}\uff01" + sysMenuEntity.getName());
        }
        return ResponseData.success((Object)this.sysMenuService.saveOrUpdate((Object)sysMenuEntity)).msg("\u4fdd\u5b58\u6216\u4fee\u6539\u6210\u529f");
    }

    @UserOptLogger(operation="\u83dc\u5355\u6a21\u5757")
    @PostMapping(value={"/removeSysMenu"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", httpMethod="POST", notes="\u6279\u91cf\u5220\u9664")
    public ResponseData removeSysMenu(@ApiParam(value="\u4e3b\u952e\u96c6\u5408", required=true) @RequestBody Long[] ids) {
        return ResponseData.success((Object)this.sysMenuService.removeSysMenu(ids));
    }

    public SysMenuController(SysMenuService sysMenuService) {
        this.sysMenuService = sysMenuService;
    }
}

