/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.mvc.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.byh.sys.api.annotation.AntiRefresh;
import com.byh.sys.api.annotation.UserOptLogger;
import com.byh.sys.api.dto.SysEasyEntity;
import com.byh.sys.api.dto.SysUserDto;
import com.byh.sys.api.enums.DelFlagEnum;
import com.byh.sys.api.enums.SysParamTypeEnum;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.SysMenuEntity;
import com.byh.sys.api.model.SysParamEntity;
import com.byh.sys.api.model.SysUserEntity;
import com.byh.sys.api.util.Base64Util;
import com.byh.sys.api.util.IpUtils;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.api.vo.SysUserVo;
import com.byh.sys.api.vo.user.UserLoginReqVO;
import com.byh.sys.data.repository.SysParamMapper;
import com.byh.sys.data.repository.SysUserMapper;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.SysMenuService;
import com.byh.sys.web.service.SysUserService;
import enums.ConstantsEnums;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"sysUser"})
public class SysUserController {
    private static final Logger log = LoggerFactory.getLogger(SysUserController.class);
    private static Logger logger = LoggerFactory.getLogger(SysUserController.class);
    private final SysUserService sysUserService;
    private final SysMenuService sysMenuService;
    @Resource
    private SysUserMapper sysUserMapper;
    @Resource
    private SysParamMapper sysParamMapper;
    @Resource
    private HttpServletRequest request;
    @Resource
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private CommonRequest commonRequest;

    @ApiOperation(value="\u83b7\u53d6\u56fe\u6587\u9a8c\u8bc1\u7801", httpMethod="GET", notes="\u83b7\u53d6\u56fe\u6587\u9a8c\u8bc1\u7801")
    @GetMapping(value={"/getVerCode"})
    public ResponseData getVercode(@RequestParam(required=false, defaultValue="100") int width, @RequestParam(required=false, defaultValue="40") int height) {
        return this.sysUserService.getVerCode(width, height);
    }

    @UserOptLogger(operation="\u7528\u6237\u6a21\u5757")
    @ApiOperation(value="\u7528\u6237\u767b\u5f55", httpMethod="POST", notes="\u7528\u6237\u767b\u5f55")
    @PostMapping(value={"/login"})
    public ResponseData loginV2(@RequestBody @Valid UserLoginReqVO userLoginReqVO) {
        String headerIp = IpUtils.getIpAddr((HttpServletRequest)this.request);
        userLoginReqVO.setLoginIp(headerIp);
        return this.sysUserService.loginV2(userLoginReqVO, "integrated_management");
    }

    @ApiOperation(value="\u7528\u6237\u5217\u8868", httpMethod="GET", notes="\u7528\u6237\u5217\u8868")
    @GetMapping(value={"/pageList"})
    @AntiRefresh
    public ResponseData pageList(SysUserDto sysUserDto) {
        sysUserDto.setTenantId(this.commonRequest.getTenant());
        return ResponseData.success((Object)this.sysUserService.pageList(sysUserDto));
    }

    @PostMapping(value={"/saveUpdate"})
    @UserOptLogger(operation="\u7528\u6237\u6a21\u5757")
    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539", httpMethod="POST", notes="\u65b0\u589e\u6216\u4fee\u6539")
    public ResponseData saveUpdate(@RequestBody SysUserEntity sysUserEntity) {
        sysUserEntity.setTenantId(this.commonRequest.getTenant());
        if (StrUtil.isEmpty((CharSequence)sysUserEntity.getUserName())) {
            throw new BusinessException("\u7528\u6237\u540d\u79f0userName\u4e0d\u80fd\u4e3a\u7a7a\uff01{userName}" + sysUserEntity.getUserName());
        }
        String password = sysUserEntity.getPassword();
        if (StrUtil.isEmpty((CharSequence)password)) {
            throw new BusinessException("\u7528\u6237\u5bc6\u7801password\u4e0d\u80fd\u4e3a\u7a7a\uff01{password}" + sysUserEntity.getPassword());
        }
        SysUserEntity one = (SysUserEntity)this.sysUserService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysUserEntity::getDelFlag, (Object)ConstantsEnums.DEL_FLAG_ZERO.getValue())).eq(SysUserEntity::getUserName, (Object)sysUserEntity.getUserName()));
        if (!StrUtil.isEmptyIfStr((Object)one)) {
            throw new BusinessException("\u7528\u6237\u540d\u79f0\u4e0d\u80fd\u91cd\u590d\uff01{one}" + one);
        }
        if (null == sysUserEntity.getId()) {
            sysUserEntity.setCreateTime(new Date());
        }
        byte[] bytes = password.getBytes();
        String encode = Base64Util.encode((byte[])bytes);
        sysUserEntity.setPassword(encode);
        return ResponseData.success((Object)this.sysUserService.saveOrUpdate((Object)sysUserEntity)).msg("\u4fdd\u5b58\u6216\u4fee\u6539\u6210\u529f");
    }

    @PostMapping(value={"/editPwd"})
    @UserOptLogger(operation="\u7528\u6237\u6a21\u5757")
    @ApiOperation(value="\u4fee\u6539\u5bc6\u7801", httpMethod="POST", notes="\u4fee\u6539\u5bc6\u7801")
    public ResponseData resetPwd(@RequestBody SysUserDto dto) {
        if (dto.getId() == null) {
            Integer userId = this.commonRequest.getUserId();
            dto.setId(userId);
        }
        String password = "";
        Integer editType = dto.getEditType();
        if (editType != null && editType == 0) {
            password = "H123456";
        } else if (editType == 1 && StrUtil.isEmpty((CharSequence)(password = dto.getPassword()))) {
            throw new BusinessException("\u7528\u6237\u5bc6\u7801password\u4e0d\u80fd\u4e3a\u7a7a\uff01{password}" + dto.getPassword());
        }
        byte[] bytes = password.getBytes();
        String encode = Base64Util.encode((byte[])bytes);
        dto.setPassword(encode);
        SysUserEntity sysUserEntity = new SysUserEntity();
        BeanUtils.copyProperties((Object)dto, (Object)sysUserEntity);
        return ResponseData.success((Object)this.sysUserService.updateById((Object)sysUserEntity)).msg("\u5bc6\u7801\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u8be6\u60c5", httpMethod="GET", notes="\u8be6\u60c5")
    @GetMapping(value={"/getInfo"})
    @AntiRefresh
    public ResponseData getInfo(Integer id) {
        if (StrUtil.isEmpty((CharSequence)String.valueOf(id))) {
            throw new BusinessException("\u7528\u6237\u4e3b\u952eId\u4e0d\u80fd\u4e3a\u7a7a\uff01{id}" + id);
        }
        SysUserVo one = this.sysUserMapper.getUserInfo(id);
        Integer tenantId = this.commonRequest.getTenant();
        LambdaQueryWrapper paramQueryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)paramQueryWrapper.eq(tenantId != null, SysParamEntity::getTenantId, (Object)tenantId)).eq(SysParamEntity::getDelFlag, (Object)DelFlagEnum.NOT_FLAG.getValue())).eq(SysParamEntity::getType, (Object)SysParamTypeEnum.SYSTEM_PARAMETER.getValue());
        List paramList = this.sysParamMapper.selectList((Wrapper)paramQueryWrapper);
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        for (SysParamEntity param : paramList) {
            paramMap.put(param.getName(), param.getValue());
        }
        one.setParamMap(paramMap);
        if (!StrUtil.isBlankIfStr((Object)one)) {
            byte[] decode = Base64Util.decode((String)one.getPassword());
            String str = new String(decode);
            one.setPassword(str);
        }
        return ResponseData.success((Object)one);
    }

    @ApiOperation(value="\u8be6\u60c5-\u7ebf\u4e0b\u95e8\u8bca\u8c03\u7528", httpMethod="POST", notes="\u8be6\u60c5-\u7ebf\u4e0b\u95e8\u8bca\u8c03\u7528")
    @PostMapping(value={"/getInfoTooutpatient"})
    public ResponseData getInfoTooutpatient(@RequestBody SysEasyEntity entity) {
        if (StrUtil.isEmpty((CharSequence)String.valueOf(entity.getId()))) {
            throw new BusinessException("\u7528\u6237\u4e3b\u952eId\u4e0d\u80fd\u4e3a\u7a7a\uff01{id}" + entity.getId());
        }
        SysUserVo one = this.sysUserMapper.getUserInfo(Integer.valueOf(entity.getId()));
        if (!StrUtil.isBlankIfStr((Object)one)) {
            byte[] decode = Base64Util.decode((String)one.getPassword());
            String str = new String(decode);
            one.setPassword(str);
        }
        return ResponseData.success((Object)one);
    }

    @UserOptLogger(operation="\u7528\u6237\u6a21\u5757")
    @PostMapping(value={"/removeSysUser"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", httpMethod="POST", notes="\u6279\u91cf\u5220\u9664")
    public ResponseData removeSysUser(@ApiParam(value="\u4e3b\u952e\u96c6\u5408", required=true) @RequestBody Long[] ids) {
        return ResponseData.success((Object)this.sysUserService.removeSysUser(ids)).msg("\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u8be6\u60c5", httpMethod="GET", notes="\u8be6\u60c5")
    @GetMapping(value={"/getPurview"})
    @AntiRefresh
    public ResponseData getPurview() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        SysUserEntity sysUserEntity = (SysUserEntity)this.sysUserService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysUserEntity::getUserName, (Object)"admin")).eq(SysUserEntity::getTenantId, (Object)this.commonRequest.getTenant())).eq(SysUserEntity::getDelFlag, (Object)ConstantsEnums.DEL_FLAG_ZERO.getValue())).last(" limit 1"));
        map.put("sysUser", sysUserEntity);
        SysMenuEntity menuEntity = new SysMenuEntity();
        List sysMenuVos = this.sysMenuService.querySysMenuTree(menuEntity);
        map.put("sysMenu", sysMenuVos);
        return ResponseData.success(map);
    }

    @PostMapping(value={"/getCurrent/userInfo"})
    @AntiRefresh
    public ResponseData getCurrentUserInfo() {
        String token = this.request.getHeader("detailToken");
        SysUserEntity entity = (SysUserEntity)this.redisTemplate.opsForValue().get((Object)token);
        return ResponseData.success((Object)entity);
    }

    public SysUserController(SysUserService sysUserService, SysMenuService sysMenuService) {
        this.sysUserService = sysUserService;
        this.sysMenuService = sysMenuService;
    }
}

