/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.mvc.controller;

import com.byh.sys.api.annotation.UserOptLogger;
import com.byh.sys.api.dto.ward.QueryWardPageDto;
import com.byh.sys.api.model.ward.SysWardEntity;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.SysWardService;
import io.swagger.annotations.ApiOperation;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sysWard"})
public class SysWardController {
    @Autowired
    private CommonRequest commonRequest;
    @Autowired
    private SysWardService sysWardService;

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5bf9\u5e94\u7684\u75c5\u533a\u6811\u5f62\u5217\u8868\u4fe1\u606f")
    @PostMapping(value={"/selectTreeList"})
    public ResponseData selectTreeList(@RequestBody QueryWardPageDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        return ResponseData.success((Object)this.sysWardService.selectTreeList(dto));
    }

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5bf9\u5e94\u7684\u75c5\u533a\u5206\u9875\u5217\u8868\u4fe1\u606f")
    @PostMapping(value={"/selectPageList"})
    public ResponseData selectPageList(@RequestBody QueryWardPageDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        return ResponseData.success((Object)this.sysWardService.selectPageList(dto));
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u75c5\u533a\uff08\u903b\u8f91\u5220\u9664\uff09")
    @UserOptLogger(operation="\u6279\u91cf\u5220\u9664\u75c5\u533a\uff08\u903b\u8f91\u5220\u9664\uff09")
    @PostMapping(value={"/deleteList"})
    public ResponseData deleteList(@RequestBody Integer[] ids) {
        this.sysWardService.deleteList(ids, this.commonRequest.getTenant());
        return ResponseData.success((Object)"\u6279\u91cf\u5220\u9664\u75c5\u533a\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u7f16\u8f91\u75c5\u533a")
    @UserOptLogger(operation="\u7f16\u8f91\u75c5\u533a")
    @PostMapping(value={"/update"})
    public ResponseData update(@RequestBody @Valid SysWardEntity entity) {
        entity.setTenantId(this.commonRequest.getTenant());
        entity.setUpdateId(this.commonRequest.getUserId());
        entity.setUpdateName(this.commonRequest.getUserName());
        this.sysWardService.update(entity);
        return ResponseData.success((Object)"\u7f16\u8f91\u75c5\u533a\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u65b0\u589e\u75c5\u533a")
    @UserOptLogger(operation="\u65b0\u589e\u75c5\u533a")
    @PostMapping(value={"/insert"})
    public ResponseData insert(@RequestBody @Valid SysWardEntity entity) {
        entity.setTenantId(this.commonRequest.getTenant());
        entity.setCreateId(this.commonRequest.getUserId());
        entity.setCreateName(this.commonRequest.getUserName());
        this.sysWardService.insert(entity);
        return ResponseData.success((Object)"\u65b0\u589e\u75c5\u533a\u6210\u529f\uff01");
    }
}

