/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.mvc.controller.drug;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.sys.api.annotation.AntiRefresh;
import com.byh.sys.api.annotation.UserOptLogger;
import com.byh.sys.api.dto.SysEasyEntity;
import com.byh.sys.api.dto.drug.drugPharmacyCheck.SysDrugPharmacyCheckDto;
import com.byh.sys.api.dto.drug.drugPharmacyCheck.SysDrugPharmacyCheckSaveDto;
import com.byh.sys.api.dto.drug.drugPharmacyCheck.SysDrugPharmacyCheckUpdateDto;
import com.byh.sys.api.dto.drug.drugPharmacyCheck.SysDrugPharmacyCheckUpdateStatusDto;
import com.byh.sys.api.model.drug.pharmacy.SysDrugPharmacyCheckEntity;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.api.util.StringUtils;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.SysDrugPharmacyCheckService;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/sysDrug/PharmacyCheck"})
public class SysDrugPharmacyCheckController {
    @Autowired
    private SysDrugPharmacyCheckService sysDrugPharmacyCheckService;
    @Autowired
    private CommonRequest commonRequest;

    @RequestMapping(value={"/save"})
    @ApiOperation(value="\u836f\u623f\u76d8\u70b9\u4e3b\u8868-\u65b0\u589e")
    public ResponseData sysDrugPharmacyCheckSave(@RequestBody @Valid SysDrugPharmacyCheckSaveDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        if (StringUtils.isBlank((String)dto.getWarehouse())) {
            dto.setWarehouse(this.commonRequest.getDrugRoomId());
        }
        SysDrugPharmacyCheckEntity entity = this.sysDrugPharmacyCheckService.sysDrugPharmacyCheckSave(dto);
        return ResponseData.success((Object)entity).save();
    }

    @GetMapping(value={"/select"})
    @ApiOperation(value="\u836f\u623f\u76d8\u70b9\u4e3b\u8868-\u5206\u9875\u67e5\u8be2")
    @AntiRefresh
    public ResponseData sysDrugPharmacyCheckSelect(Page page, SysDrugPharmacyCheckDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        if (StringUtils.isBlank((String)dto.getWarehouse())) {
            dto.setWarehouse(this.commonRequest.getDrugRoomId());
        }
        IPage list = this.sysDrugPharmacyCheckService.sysDrugPharmacyCheckSelect(page, dto);
        return ResponseData.success((Object)list);
    }

    @RequestMapping(value={"/update"})
    @ApiOperation(value="\u836f\u623f\u76d8\u70b9\u4e3b\u8868-\u66f4\u65b0")
    public ResponseData sysDrugPharmacyCheckUpdate(@RequestBody @Valid SysDrugPharmacyCheckUpdateDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        this.sysDrugPharmacyCheckService.sysDrugPharmacyCheckUpdate(dto);
        return ResponseData.success().update();
    }

    @RequestMapping(value={"/delete"})
    @ApiOperation(value="\u836f\u623f\u76d8\u70b9\u4e3b\u8868-\u5220\u9664")
    public ResponseData sysDrugPharmacyCheckDelete(@RequestBody SysEasyEntity entity) {
        this.sysDrugPharmacyCheckService.sysDrugPharmacyCheckDelete(entity.getId());
        return ResponseData.success().delete();
    }

    @GetMapping(value={"/search"})
    @ApiOperation(value="\u836f\u623f\u76d8\u70b9-\u67e5\u8be2\u836f\u54c1")
    @AntiRefresh
    public ResponseData sysDrugPharmacyCheckSearch(Page page, SysDrugPharmacyCheckDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        if (StringUtils.isBlank((String)dto.getWarehouse())) {
            dto.setWarehouse(this.commonRequest.getDrugRoomId());
        }
        IPage list = this.sysDrugPharmacyCheckService.sysDrugPharmacyCheckSearch(page, dto);
        return ResponseData.success((Object)list);
    }

    @RequestMapping(value={"/update/status"})
    @UserOptLogger(operation="\u836f\u623f\u76d8\u70b9\u4e3b\u8868\u6a21\u5757")
    @ApiOperation(value="\u836f\u623f\u76d8\u70b9\u4e3b\u8868-\u66f4\u65b0\u76d8\u70b9\u72b6\u6001")
    public ResponseData sysDrugPharmacyCheckUpdateStatus(@RequestBody @Valid SysDrugPharmacyCheckUpdateStatusDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        SysDrugPharmacyCheckEntity entity = this.sysDrugPharmacyCheckService.sysDrugPharmacyCheckUpdateStatus(dto);
        return ResponseData.success((Object)entity).alreadyUpdateStatus();
    }

    @RequestMapping(value={"/confirm"})
    @UserOptLogger(operation="\u836f\u623f\u76d8\u70b9\u4e3b\u8868\u6a21\u5757")
    @ApiOperation(value="\u836f\u623f\u76d8\u70b9\u4e3b\u8868-\u786e\u8ba4\u5f53\u524d\u76d8\u70b9\u6570\u636e\u72b6\u6001")
    public ResponseData sysDrugPharmacyCheckConfirm(@RequestBody SysEasyEntity entity) {
        this.sysDrugPharmacyCheckService.sysDrugPharmacyCheckConfirm(entity.getId(), this.commonRequest.getTenant(), this.commonRequest.getDrugRoomId());
        return ResponseData.success().confirm();
    }

    @GetMapping(value={"/export"})
    @ApiOperation(value="\u5bfc\u51faExcel", httpMethod="GET", notes="\u5bfc\u51faExcel")
    public void sysDrugPharmacyCheckExport(HttpServletResponse response, Page page, SysDrugPharmacyCheckDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        if (StringUtils.isBlank((String)dto.getWarehouse())) {
            dto.setWarehouse(this.commonRequest.getDrugRoomId());
        }
        this.sysDrugPharmacyCheckService.sysDrugPharmacyCheckExport(response, page, dto);
    }

    @UserOptLogger(operation="\u64a4\u9500\u836f\u623f\u5bfc\u5165\u76d8\u70b9")
    @RequestMapping(value={"/check/revoke"})
    @ApiOperation(value="\u64a4\u9500\u836f\u623f\u5bfc\u5165\u76d8\u70b9", httpMethod="POST", notes="\u64a4\u9500\u836f\u623f\u5bfc\u5165\u76d8\u70b9")
    public ResponseData revokeCheckImport(@RequestBody SysEasyEntity entity) {
        entity.setTenantId(this.commonRequest.getTenant());
        if (StringUtils.isBlank((String)entity.getWarehouse())) {
            entity.setWarehouse(this.commonRequest.getDrugRoomId());
        }
        this.sysDrugPharmacyCheckService.revokeCheckImport(entity);
        return ResponseData.success();
    }

    @UserOptLogger(operation="\u836f\u623f\u5bfc\u5165\u76d8\u70b9")
    @PostMapping(value={"/check/import"})
    @ApiOperation(value="\u836f\u623f\u5bfc\u5165\u76d8\u70b9", httpMethod="POST", notes="\u836f\u623f\u5bfc\u5165\u76d8\u70b9")
    public ResponseData sysDrugPharmacyCheckImport(@RequestPart(value="file") MultipartFile file) throws Exception {
        this.sysDrugPharmacyCheckService.sysDrugPharmacyCheckImport(file, this.commonRequest.getDrugRoomId());
        return ResponseData.success();
    }
}

