/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.mvc.controller.drug;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.sys.api.annotation.AntiRefresh;
import com.byh.sys.api.annotation.UserOptLogger;
import com.byh.sys.api.dto.SysEasyEntity;
import com.byh.sys.api.dto.drug.drugPharmacyStorage.SysDrugPharmacyStorageDto;
import com.byh.sys.api.dto.drug.drugPharmacyStorage.SysDrugPharmacyStorageSaveDto;
import com.byh.sys.api.dto.drug.drugPharmacyStorage.SysDrugPharmacyStorageUpdateDto;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.SysDrugPharmacyStorageService;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sysDrug/pharmacy/storage"})
public class SysDrugPharmacyStorageController {
    @Autowired
    private SysDrugPharmacyStorageService sysDrugPharmacyStorageService;
    @Autowired
    private CommonRequest commonRequest;

    @RequestMapping(value={"/save"})
    @UserOptLogger(operation="\u836f\u623f\u5217\u8868\u7ba1\u7406\u6a21\u5757")
    @ApiOperation(value="\u65b0\u589e\u836f\u623f\u5217\u8868")
    public ResponseData sysDrugStorageSave(@RequestBody @Valid SysDrugPharmacyStorageSaveDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        this.sysDrugPharmacyStorageService.sysDrugPharmacyStorageSave(dto);
        return ResponseData.success().save();
    }

    @GetMapping(value={"/select"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u836f\u623f\u5217\u8868")
    @AntiRefresh
    public ResponseData sysDrugStorageSelect(Page page, SysDrugPharmacyStorageDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        dto.setRelationId(this.commonRequest.getUserId());
        IPage list = this.sysDrugPharmacyStorageService.sysDrugPharmacyStorageSelect(page, dto);
        return ResponseData.success((Object)list);
    }

    @PostMapping(value={"/withoutSelectPage"})
    public ResponseData withoutSelectPage(@RequestBody SysDrugPharmacyStorageDto dto) {
        Page page = new Page();
        page.setSize((long)dto.getSize());
        page.setCurrent((long)dto.getCurrent());
        IPage list = this.sysDrugPharmacyStorageService.sysDrugPharmacyStorageSelect(page, dto);
        return ResponseData.success((Object)list);
    }

    @GetMapping(value={"/queryList"})
    @ApiOperation(value="\u67e5\u8be2\u836f\u623f\u5217\u8868(\u65e0\u5206\u9875)")
    public ResponseData sysDrugStorageSelect() {
        Integer tenant = this.commonRequest.getTenant();
        List list = this.sysDrugPharmacyStorageService.sysDrugPharmacyStorageList(tenant);
        return ResponseData.success((Object)list);
    }

    @RequestMapping(value={"/update"})
    @UserOptLogger(operation="\u836f\u623f\u5217\u8868\u7ba1\u7406\u6a21\u5757")
    @ApiOperation(value="\u66f4\u65b0\u836f\u623f\u5217\u8868")
    public ResponseData sysDrugStorageUpdate(@RequestBody @Valid SysDrugPharmacyStorageUpdateDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        this.sysDrugPharmacyStorageService.sysDrugPharmacyStorageUpdate(dto);
        return ResponseData.success().update();
    }

    @RequestMapping(value={"/delete"})
    @ApiOperation(value="\u5220\u9664\u836f\u623f\u5217\u8868")
    public ResponseData sysDrugStorageDelete(@RequestBody SysEasyEntity entity) {
        this.sysDrugPharmacyStorageService.sysDrugPharmacyStorageDelete(entity.getIds());
        return ResponseData.success().delete();
    }

    @RequestMapping(value={"/lock/and/unlock"})
    public ResponseData lockAndUnLock(@RequestBody SysDrugPharmacyStorageUpdateDto dto) {
        this.sysDrugPharmacyStorageService.lockAndUnLock(dto);
        return ResponseData.success().update();
    }
}

