/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.mvc.controller.drug;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.sys.api.annotation.AntiRefresh;
import com.byh.sys.api.annotation.UserOptLogger;
import com.byh.sys.api.dto.drugStorage.SysDrugStorageDto;
import com.byh.sys.api.dto.drugStorage.SysDrugStorageSaveDto;
import com.byh.sys.api.dto.drugStorage.SysDrugStorageUpdateDto;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.SysDrugStorageService;
import io.swagger.annotations.ApiOperation;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sysDrug/storage"})
public class SysDrugStorageController {
    @Autowired
    private SysDrugStorageService sysDrugStorageService;
    @Autowired
    private CommonRequest commonRequest;

    @RequestMapping(value={"/save"})
    @UserOptLogger(operation="\u836f\u5e93\u7ba1\u7406\u6a21\u5757")
    @ApiOperation(value="\u65b0\u589e\u836f\u5e93")
    public ResponseData sysDrugStorageSave(@RequestBody @Valid SysDrugStorageSaveDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        this.sysDrugStorageService.sysDrugStorageSave(dto);
        return ResponseData.success().save();
    }

    @GetMapping(value={"/select"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u836f\u5e93")
    @AntiRefresh
    public ResponseData sysDrugStorageSelect(Page page, SysDrugStorageDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        IPage list = this.sysDrugStorageService.sysDrugStorageSelect(page, dto);
        return ResponseData.success((Object)list);
    }

    @RequestMapping(value={"/update"})
    @UserOptLogger(operation="\u836f\u5e93\u7ba1\u7406\u6a21\u5757")
    @ApiOperation(value="\u66f4\u65b0\u836f\u5e93")
    public ResponseData sysDrugStorageUpdate(@RequestBody @Valid SysDrugStorageUpdateDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        this.sysDrugStorageService.sysDrugStorageUpdate(dto);
        return ResponseData.success().update();
    }

    @RequestMapping(value={"/delete"})
    @ApiOperation(value="\u5220\u9664\u836f\u5e93")
    public ResponseData sysDrugStorageDelete(@RequestBody Integer[] ids) {
        this.sysDrugStorageService.sysDrugStorageDelete(ids);
        return ResponseData.success().delete();
    }
}

