/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.mvc.controller.drug;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.sys.api.annotation.AntiRefresh;
import com.byh.sys.api.dto.drug.SysDrugQcQmDto;
import com.byh.sys.api.dto.drug.SysDrugSubstanceDto;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.util.EasyExcelUtil;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.api.vo.drug.ExportDrugQcQm;
import com.byh.sys.api.vo.drug.ExportDrugSubstance;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.SysDrugQcQmService;
import com.byh.sys.web.service.SysDrugSubstanceService;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/drugSubstance"})
public class SysDrugSubstanceController {
    private static final Logger log = LoggerFactory.getLogger(SysDrugSubstanceController.class);
    private static Logger logger = LoggerFactory.getLogger(SysDrugSubstanceController.class);
    private final CommonRequest commonRequest;
    private final SysDrugSubstanceService drugSubstanceService;
    private final SysDrugQcQmService drugQcQmService;

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u5bfc\u51fa\u51fa\u5165\u5e93\u660e\u7ec6")
    @PostMapping(value={"/exportDrugSubstance"})
    @AntiRefresh
    public void exportDrugSubstance(HttpServletResponse response, @RequestBody SysDrugSubstanceDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        String excelName = "\u51fa\u5165\u5e93\u660e\u7ec6";
        String sheetName = null;
        String inOutType = dto.getInOutType();
        if (StrUtil.isEmpty((CharSequence)inOutType)) {
            throw new BusinessException("\u51fa\u5165\u5e93\u660e\u7ec6\u4e0d\u80fd\u4e3a\u4e3a\u7a7a\uff01{inOutType}");
        }
        if ("1".equals(inOutType)) {
            sheetName = "\u5165\u5e93\u660e\u7ec6";
        }
        if ("2".equals(inOutType)) {
            sheetName = "\u51fa\u5e93\u660e\u7ec6";
        }
        List exportList = this.drugSubstanceService.exportDrugSubstance(dto);
        EasyExcelUtil.exportExcelSheet((HttpServletResponse)response, (String)excelName, (String)sheetName, (Object)new ExportDrugSubstance(), (List)exportList, null);
    }

    @ApiOperation(value="\u51fa\u5165\u5e93\u660e\u7ec6\u5206\u9875", httpMethod="GET", notes="\u51fa\u5165\u5e93\u660e\u7ec6\u5206\u9875")
    @GetMapping(value={"/pageDetail"})
    @AntiRefresh
    public ResponseData pageDetail(Page page, SysDrugSubstanceDto dto) {
        Integer tenantId = this.commonRequest.getTenant();
        dto.setTenantId(tenantId);
        return ResponseData.success((Object)this.drugSubstanceService.pageDetail(page, dto));
    }

    @ApiOperation(value="\u51fa\u5165\u5e93\u6c47\u603b\u5206\u9875", httpMethod="GET", notes="\u51fa\u5165\u5e93\u6c47\u603b\u5206\u9875")
    @GetMapping(value={"/pageSummary"})
    @AntiRefresh
    public ResponseData pageSummary(Page page, SysDrugSubstanceDto dto) {
        Integer tenantId = this.commonRequest.getTenant();
        dto.setTenantId(tenantId);
        return ResponseData.success((Object)this.drugSubstanceService.pageSummary(page, dto));
    }

    @ApiOperation(value="\u8fdb\u9500\u5b58\u6c47\u603b\u5206\u9875", httpMethod="GET", notes="\u8fdb\u9500\u5b58\u6c47\u603b\u5206\u9875")
    @GetMapping(value={"/pageInOutSummary"})
    @AntiRefresh
    public ResponseData pageInOutSummary(Page page, SysDrugQcQmDto dto) {
        Integer tenantId = this.commonRequest.getTenant();
        dto.setTenantId(tenantId);
        return ResponseData.success((Object)this.drugQcQmService.pageInOutSummary(page, dto));
    }

    @ApiOperation(value="\u8fdb\u9500\u5b58\u6c47\u603b\u5bfc\u51fa", httpMethod="GET", notes="\u8fdb\u9500\u5b58\u6c47\u603b\u5bfc\u51fa")
    @GetMapping(value={"/exportInOutSummary"})
    @AntiRefresh
    public void exportInOutSummary(HttpServletResponse response, SysDrugQcQmDto dto) {
        Integer tenantId = this.commonRequest.getTenant();
        dto.setTenantId(tenantId);
        List exportList = this.drugQcQmService.exportInOutSummary(dto);
        String excelName = "\u8fdb\u9500\u5b58\u6c47\u603b";
        String sheetName = "\u8fdb\u9500\u5b58\u6c47\u603b";
        EasyExcelUtil.exportExcelSheet((HttpServletResponse)response, (String)excelName, (String)sheetName, (Object)new ExportDrugQcQm(), (List)exportList, null);
    }

    public SysDrugSubstanceController(CommonRequest commonRequest, SysDrugSubstanceService drugSubstanceService, SysDrugQcQmService drugQcQmService) {
        this.commonRequest = commonRequest;
        this.drugSubstanceService = drugSubstanceService;
        this.drugQcQmService = drugQcQmService;
    }
}

