/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.mvc.utils;

import cn.hutool.core.util.StrUtil;
import com.byh.sys.api.enums.SystemEnum;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.SysUserEntity;
import com.byh.sys.api.util.ExceptionUtils;
import com.byh.sys.data.repository.SysUserMapper;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CommonRequest {
    private static final Logger log = LoggerFactory.getLogger(CommonRequest.class);
    @Autowired
    private HttpServletRequest request;
    @Resource
    private SysUserMapper sysUserMapper;

    public Integer getTenant() {
        String tenantId = this.request.getHeader("tenantId");
        if (StrUtil.isNotEmpty((CharSequence)tenantId)) {
            return Integer.parseInt(tenantId);
        }
        return null;
    }

    public String getDrugRoomId() {
        String drugRoomId = this.request.getHeader("drugRoomId");
        if (StrUtil.isNotEmpty((CharSequence)drugRoomId)) {
            return drugRoomId;
        }
        throw new BusinessException(SystemEnum.DRUG_ROOM_ID_IS_NOT_NULL.getCode(), SystemEnum.DRUG_ROOM_ID_IS_NOT_NULL.getMsg());
    }

    public Integer getUserId() {
        String userId = this.request.getHeader("userId");
        if (StrUtil.isNotEmpty((CharSequence)userId)) {
            return Integer.parseInt(userId);
        }
        throw new BusinessException(SystemEnum.USER_ID_IS_NOT_NULL.getCode(), SystemEnum.USER_ID_IS_NOT_NULL.getMsg());
    }

    public SysUserEntity getUserInfo() {
        Integer usId = null;
        String userId = this.request.getHeader("userId");
        if (StrUtil.isNotEmpty((CharSequence)userId)) {
            usId = Integer.parseInt(userId);
        }
        SysUserEntity user = (SysUserEntity)this.sysUserMapper.selectById((Serializable)usId);
        return user;
    }

    public String getUserName() {
        try {
            return URLDecoder.decode(this.request.getHeader("userName"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return this.request.getHeader("userName");
        }
    }

    public String getSignNo() {
        return Objects.isNull(this.request.getHeader("signNo")) ? "99999" : this.request.getHeader("signNo");
    }

    public void checkNumber(String errorCode, String errorMsg, Integer ... number) {
        for (Integer i : number) {
            ExceptionUtils.createException((Logger)log, (i < 0 ? 1 : 0) != 0, (String)errorCode, (String)errorMsg);
        }
    }
}

