/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.byh.sys.api.dto.purchaseOrderDetail.PurchaseOrderDetailDto;
import com.byh.sys.api.dto.purchaseOrderDetail.PurchaseOrderDetailSaveDto;
import com.byh.sys.api.dto.purchaseOrderDetail.PurchaseOrderDetailUpdateDto;
import com.byh.sys.api.dto.syt.CompanyOrderDto;
import com.byh.sys.api.dto.syt.SytDto;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.PurchaseOrderDetailEntity;
import com.byh.sys.api.model.PurchaseOrderEntity;
import com.byh.sys.api.model.drug.SysDrugEntity;
import com.byh.sys.api.model.drug.inventory.SysDrugInventoryInPrescriptionEntity;
import com.byh.sys.api.util.BeanUtil;
import com.byh.sys.api.util.DateUtils;
import com.byh.sys.api.util.ExceptionUtils;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.api.vo.PurchaseOrderDetailVo;
import com.byh.sys.data.repository.PurchaseOrderDetailMapper;
import com.byh.sys.data.repository.PurchaseOrderMapper;
import com.byh.sys.data.repository.SysDrugMapper;
import com.byh.sys.web.fegin.SdkServiceFeign;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.mvc.utils.JsonUtils;
import com.byh.sys.web.service.PurchaseOrderDetailService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PurchaseOrderDetailServiceImpl
implements PurchaseOrderDetailService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseOrderDetailServiceImpl.class);
    @Resource
    private PurchaseOrderDetailMapper purchaseOrderDetailMapper;
    @Autowired
    private PurchaseOrderMapper purchaseOrderMapper;
    @Autowired
    private SysDrugMapper sysDrugMapper;
    @Autowired
    private SdkServiceFeign sdkServiceFeign;
    @Autowired
    private CommonRequest commonRequest;

    @Transactional(rollbackFor={BusinessException.class})
    public void purchaseOrderDetailSave(PurchaseOrderDetailSaveDto dto) {
        PurchaseOrderDetailEntity entity = (PurchaseOrderDetailEntity)BeanUtil.copy((Object)dto, PurchaseOrderDetailEntity.class);
        int a = this.purchaseOrderDetailMapper.insert((Object)entity);
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void purchaseOrderDetailSaveBatch(List<PurchaseOrderDetailSaveDto> dto) {
        int a = this.purchaseOrderDetailMapper.purchaseOrderDetailSaveBatch(dto);
    }

    public List<PurchaseOrderDetailVo> purchaseOrderDetailSelect(PurchaseOrderDetailDto dto) {
        List list = this.purchaseOrderDetailMapper.purchaseOrderDetailSelect(dto);
        return list;
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void purchaseOrderDetailUpdate(PurchaseOrderDetailUpdateDto dto) {
        PurchaseOrderDetailEntity entity = (PurchaseOrderDetailEntity)BeanUtil.copy((Object)dto, PurchaseOrderDetailEntity.class);
        int a = this.purchaseOrderDetailMapper.update((Object)entity, (Wrapper)Wrappers.lambdaUpdate().eq(PurchaseOrderDetailEntity::getOrderdtlid, (Object)dto.getOrderdtlid()));
    }

    public void purchaseOrderDetailDelete(PurchaseOrderDetailEntity entity) {
        int a = this.purchaseOrderDetailMapper.purchaseOrderDetailDelete(entity);
    }

    public List<SysDrugInventoryInPrescriptionEntity> purchaseOrderPreIn(String orderid, Integer tenant, String orderSelectType) {
        if ("1".equals(orderSelectType)) {
            List list = this.purchaseOrderDetailMapper.purchaseOrderPreIn(orderid, tenant);
            if (CollectionUtils.isEmpty((Collection)list)) {
                PurchaseOrderEntity purchaseOrderEntity = (PurchaseOrderEntity)this.purchaseOrderMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(PurchaseOrderEntity::getOrderid, (Object)orderid)).eq(PurchaseOrderEntity::getTenantId, (Object)tenant));
                return this.purchaseOrderDetailMapper.selectDetailList(purchaseOrderEntity.getOrderid(), tenant);
            }
            return list;
        }
        if ("2".equals(orderSelectType)) {
            List list = this.getPdaDrugInfo(orderid);
            for (SysDrugInventoryInPrescriptionEntity n : list) {
                List sysDrugEntities = this.sysDrugMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugEntity::getSytDrugName, (Object)n.getSytDrugName())).eq(SysDrugEntity::getDelFlag, (Object)"0"));
                if (sysDrugEntities.size() != 1) continue;
                SysDrugEntity sysDrugEntity = (SysDrugEntity)sysDrugEntities.get(0);
                n.setDrugId(sysDrugEntity.getId());
                n.setDrugName(sysDrugEntity.getDrugsName());
                n.setSpecifications(sysDrugEntity.getSpecifications());
                n.setDrugType(sysDrugEntity.getDrugsType());
                n.setDrugProperties(sysDrugEntity.getDrugProperties());
                n.setMedicalInsuranceCode(sysDrugEntity.getMedicalInsuranceCode());
                n.setMedicalInsuranceName(sysDrugEntity.getMedicalInsuranceName());
                n.setThirdCode(sysDrugEntity.getThirdCode());
                n.setInternalCode(String.valueOf(sysDrugEntity.getInternalCode()));
                n.setUnit(sysDrugEntity.getPackLargeUnits());
                n.setRetailPrice(sysDrugEntity.getRetailPrice());
                n.setRetailAmount(sysDrugEntity.getRetailPrice().multiply(new BigDecimal(n.getDrugNum())));
                n.setManufacturer(sysDrugEntity.getManufacturer());
                n.setLevel(sysDrugEntity.getLevel());
                n.setTenantId(this.commonRequest.getTenant());
            }
            return list;
        }
        return new ArrayList<SysDrugInventoryInPrescriptionEntity>();
    }

    private List<SysDrugInventoryInPrescriptionEntity> getPdaDrugInfo(String orderid) {
        ResponseData responseData = this.sdkServiceFeign.getCompanyOrder(new CompanyOrderDto(orderid));
        ExceptionUtils.createException((Logger)log, (!"200".equals(responseData.getCode()) ? 1 : 0) != 0, (String)responseData.getCode(), (String)responseData.getMsg());
        JsonUtils result = JsonUtils.create((Object)responseData.getData()).getObjectValue("result").getObjectValue("bills").getArrayValue("codes", "bill_code", orderid).concatArrayValue("code");
        SytDto sytDto = new SytDto();
        sytDto.setCodes(result.getConcatValues());
        CompanyOrderDto dto = new CompanyOrderDto();
        dto.setBill_code(orderid);
        ResponseData response = this.sdkServiceFeign.getCompanyOrderDetail(dto);
        JSONObject jsonObject = (JSONObject)JsonUtils.create((Object)response.getData()).getObjectValue("result").getObjectValue("bills").getArrayValue().getList().get(0);
        List list = JsonUtils.create((Object)jsonObject).getObjectValue("drugs").getArrayValue().getList();
        ExceptionUtils.createException((Logger)log, (!"200".equals(responseData.getCode()) ? 1 : 0) != 0, (String)responseData.getCode(), (String)responseData.getMsg());
        ArrayList<SysDrugInventoryInPrescriptionEntity> resultList = new ArrayList<SysDrugInventoryInPrescriptionEntity>();
        for (JSONObject json : list) {
            String drugsName = (String)json.get((Object)"physicname");
            String prepnSpec = (String)json.get((Object)"prepnspec");
            String pkgSpec = (String)json.get((Object)"pkgspec");
            String approveNo = (String)json.get((Object)"certificate");
            String prodId = (String)json.get((Object)"prod_id");
            SysDrugInventoryInPrescriptionEntity entity = new SysDrugInventoryInPrescriptionEntity();
            JsonUtils jsonUtils = JsonUtils.create((Object)json).getObjectValue("codes").concatArrayValue("code");
            entity.setDrugTracCodg(jsonUtils.getConcatValues());
            entity.setDrugName(drugsName);
            entity.setBatchNumber(String.valueOf(json.get((Object)"batch_no")));
            entity.setDrugNum(Integer.valueOf(Integer.parseInt(String.valueOf(json.get((Object)"pkg_amount")))));
            entity.setApprovalNumber(approveNo);
            entity.setTempSpe(prepnSpec + "*" + pkgSpec);
            entity.setSytDrugName(prodId + "-" + entity.getDrugName() + "-" + entity.getTempSpe());
            entity.setEffectiveTime(DateUtils.stringTimeToDate2((String)String.valueOf(json.get((Object)"expire_date")), (String)"yyyyMMdd", (String)"yyyy-MM-dd HH:mm:ss"));
            resultList.add(entity);
        }
        return resultList;
    }
}

