/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.service.impl;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.sys.api.dto.chargeCategory.SysChargeCategoryDto;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.chargeCategory.SysChargeCategoryEntity;
import com.byh.sys.api.util.ExceptionUtils;
import com.byh.sys.api.util.StringPinYinUtil;
import com.byh.sys.api.vo.chargeCategory.SysChargeCategoryVo;
import com.byh.sys.data.repository.SysChargeCategoryMapper;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.SysChargeCategoryService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysChargeCategoryServiceImpl
extends ServiceImpl<SysChargeCategoryMapper, SysChargeCategoryEntity>
implements SysChargeCategoryService {
    @Resource
    private SysChargeCategoryMapper sysChargeCategoryMapper;
    @Autowired
    private CommonRequest commonRequest;
    private Logger logger = LoggerFactory.getLogger(SysChargeCategoryServiceImpl.class);

    public Page<SysChargeCategoryVo> selectPageList(SysChargeCategoryDto dto) {
        Page page = new Page((long)dto.getCurrent(), (long)dto.getSize());
        List list = this.sysChargeCategoryMapper.selectListPage(page, dto);
        page.setRecords(list);
        return page;
    }

    public List<SysChargeCategoryVo> selectTreeList(SysChargeCategoryDto dto) {
        List list = this.sysChargeCategoryMapper.selectListByDto(dto);
        HashMap<Integer, SysChargeCategoryVo> entityMap = new HashMap<Integer, SysChargeCategoryVo>();
        for (SysChargeCategoryVo vo : list) {
            entityMap.put(vo.getId(), vo);
        }
        ArrayList<SysChargeCategoryVo> treeList = new ArrayList<SysChargeCategoryVo>();
        for (Map.Entry entries : entityMap.entrySet()) {
            SysChargeCategoryVo currentVo = (SysChargeCategoryVo)entries.getValue();
            SysChargeCategoryVo parentVo = (SysChargeCategoryVo)entityMap.get(currentVo.getParentId());
            if (parentVo != null) {
                ArrayList<SysChargeCategoryVo> childrens = parentVo.getChildrens();
                if (childrens == null) {
                    childrens = new ArrayList<SysChargeCategoryVo>();
                }
                childrens.add(currentVo);
                parentVo.setChildrens(childrens);
                continue;
            }
            treeList.add(currentVo);
        }
        return treeList;
    }

    public void insert(SysChargeCategoryDto dto) {
        SysChargeCategoryEntity sysChargeCategoryEntity = new SysChargeCategoryEntity();
        BeanUtils.copyProperties((Object)dto, (Object)sysChargeCategoryEntity);
        if (StrUtil.isNotEmpty((CharSequence)sysChargeCategoryEntity.getChargeCategoryName())) {
            sysChargeCategoryEntity.setPyCode(StringPinYinUtil.toFirstChar((String)sysChargeCategoryEntity.getChargeCategoryName()));
        }
        int insertCount = this.sysChargeCategoryMapper.insert((Object)sysChargeCategoryEntity);
        ExceptionUtils.createException((Logger)this.logger, (int)insertCount, (String)"10000", (String)"\u6536\u8d39\u7c7b\u522b\u65b0\u589e\u5931\u8d25\uff01");
    }

    public void update(SysChargeCategoryDto dto) {
        if (dto.getId() == null || StrUtil.isEmpty((CharSequence)dto.getId().toString())) {
            throw new BusinessException("10000", "\u7f16\u8f91\u6536\u8d39\u7c7b\u522b\u65f6\uff0c\u6536\u8d39\u7c7b\u522b\u4e3b\u952eID\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        SysChargeCategoryEntity sysChargeCategoryEntity = new SysChargeCategoryEntity();
        BeanUtils.copyProperties((Object)dto, (Object)sysChargeCategoryEntity);
        if (StrUtil.isNotEmpty((CharSequence)sysChargeCategoryEntity.getChargeCategoryName())) {
            sysChargeCategoryEntity.setPyCode(StringPinYinUtil.toFirstChar((String)sysChargeCategoryEntity.getChargeCategoryName()));
        }
        int updateCount = this.sysChargeCategoryMapper.updateById((Object)sysChargeCategoryEntity);
        ExceptionUtils.createException((Logger)this.logger, (int)updateCount, (String)"10001", (String)"\u7f16\u8f91\u6536\u8d39\u7c7b\u522b\u5931\u8d25\uff01");
    }

    public void deleteList(Integer[] ids) {
        if (ArrayUtil.isEmpty((Object[])ids)) {
            throw new BusinessException("10000", "\u5220\u9664\u6536\u8d39\u7c7b\u522b\u65f6\uff0c\u6536\u8d39\u7c7b\u522b\u4e3b\u952eID\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        int deleteCount = this.sysChargeCategoryMapper.deleteListByIds(ids);
        ExceptionUtils.createException((Logger)this.logger, (int)deleteCount, (String)"10001", (String)"\u5220\u9664\u6536\u8d39\u7c7b\u522b\u5931\u8d25\uff01");
    }
}

