/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.service.impl;

import cn.hutool.core.util.ArrayUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.sys.api.dto.department.SysDepartmentDTO;
import com.byh.sys.api.dto.department.SysDepartmentSaveDTO;
import com.byh.sys.api.dto.department.SysDepartmentUpdateDTO;
import com.byh.sys.api.enums.DelFlagEnum;
import com.byh.sys.api.enums.StatusEnum;
import com.byh.sys.api.enums.SysCommonEnum;
import com.byh.sys.api.enums.SysDepartmentEnum;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.SysDoctorEntity;
import com.byh.sys.api.model.base.BaseEntity;
import com.byh.sys.api.model.department.SysDepartmentEntity;
import com.byh.sys.api.model.ward.SysWardDepartmentEntity;
import com.byh.sys.api.model.ward.SysWardEntity;
import com.byh.sys.api.util.ExceptionUtils;
import com.byh.sys.api.util.TreeUtils;
import com.byh.sys.api.vo.department.SysDepartmentVo;
import com.byh.sys.data.repository.SysDepartmentMapper;
import com.byh.sys.data.repository.SysDoctorMapper;
import com.byh.sys.data.repository.SysWardDepartmentMapper;
import com.byh.sys.data.repository.SysWardMapper;
import com.byh.sys.web.call_function.HsUploadExtend;
import com.byh.sys.web.service.SysDepartmentService;
import enums.ConstantsEnums;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysDepartmentServiceImpl
extends ServiceImpl<SysDepartmentMapper, SysDepartmentEntity>
implements SysDepartmentService {
    @Resource
    private SysDepartmentMapper sysDepartmentMapper;
    @Resource
    private SysDoctorMapper sysDoctorMapper;
    @Resource
    private SysWardDepartmentMapper sysWardDepartmentMapper;
    @Resource
    private SysWardMapper sysWardMapper;
    private Logger logger = LoggerFactory.getLogger(SysDepartmentServiceImpl.class);
    @Autowired
    private HsUploadExtend hsUploadExtend;

    public List<SysDepartmentEntity> selectDeptList(SysDepartmentDTO dto) {
        List list = this.sysDepartmentMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysDepartmentEntity.class).eq(SysDepartmentEntity::getDepartmentType, (Object)dto.getDepartmentType())).eq(dto.getTenantId() != null, SysDepartmentEntity::getTenantId, (Object)dto.getTenantId()));
        return list;
    }

    public void sysDepartmentSave(SysDepartmentSaveDTO dto) {
        this.checkDepartmentName(dto.getDepartmentName(), dto.getTenantId());
        SysDepartmentEntity entity = new SysDepartmentEntity();
        BeanUtils.copyProperties((Object)dto, (Object)entity);
        int a = this.sysDepartmentMapper.insert((Object)entity);
        ExceptionUtils.createException((Logger)this.logger, (int)a, (String)SysDepartmentEnum.SYS_DEPARTMENT_INSERT_ERROR.getCode(), (String)SysDepartmentEnum.SYS_DEPARTMENT_INSERT_ERROR.getName());
        if (dto.getWardIds() != null && !dto.getWardIds().isEmpty()) {
            this.insertWardDeptList(dto.getWardIds(), entity.getId(), entity.getTenantId(), dto.getCreateId(), dto.getCreateName());
        }
        this.hsUploadExtend.uploadDeptContrastNewContext(entity.getId());
    }

    private void insertWardDeptList(List<Integer> wardIds, Integer deptId, Integer tenantId, Integer operatorId, String operatorName) {
        List deptWardList = wardIds.stream().map(wardId -> {
            SysWardDepartmentEntity deptWard = new SysWardDepartmentEntity();
            deptWard.setTenantId(tenantId);
            deptWard.setDeptId(deptId);
            deptWard.setWardId(wardId);
            deptWard.setOperatorId(operatorId);
            deptWard.setOperatorName(operatorName);
            return deptWard;
        }).collect(Collectors.toList());
        this.sysWardDepartmentMapper.insertList(deptWardList);
    }

    public List<SysDepartmentVo> sysDepartmentSelect(SysDepartmentDTO dto) {
        List list = this.sysDepartmentMapper.sysDepartmentSelect(dto);
        Integer tenantId = dto.getTenantId();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            List deptIds = list.stream().map(SysDepartmentVo::getId).collect(Collectors.toList());
            list = this.getWardList(list, tenantId, deptIds);
            List doctorList = this.sysDoctorMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysDoctorEntity.class).eq(tenantId != null, SysDoctorEntity::getTenantId, (Object)tenantId)).eq(SysDoctorEntity::getDelFlag, (Object)DelFlagEnum.NOT_FLAG.getValue())).eq(SysDoctorEntity::getStatus, (Object)"0")).in(SysDoctorEntity::getDepartmentId, deptIds));
            Map<String, List<SysDoctorEntity>> doctorMap = doctorList.stream().collect(Collectors.groupingBy(SysDoctorEntity::getDepartmentId));
            for (SysDepartmentVo vo : list) {
                List doctors = doctorMap.getOrDefault(vo.getId().toString(), new ArrayList());
                vo.setDoctorList(doctors);
            }
            if (list.size() == 1) {
                return list;
            }
            ArrayList<SysDepartmentVo> tempList = new ArrayList<SysDepartmentVo>();
            tempList.addAll(list);
            this.arrangeData(list, tempList);
            return tempList;
        }
        return list;
    }

    public List<SysDepartmentVo> getWardList(List<SysDepartmentVo> list, Integer tenantId, List<Integer> deptIds) {
        List relationList = this.sysWardDepartmentMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysWardDepartmentEntity.class).eq(tenantId != null, SysWardDepartmentEntity::getTenantId, (Object)tenantId)).in(SysWardDepartmentEntity::getDeptId, deptIds)).eq(SysWardDepartmentEntity::getDelFlag, (Object)DelFlagEnum.NOT_FLAG.getValue()));
        Map<Integer, List<SysWardDepartmentEntity>> relationMap = relationList.stream().collect(Collectors.groupingBy(SysWardDepartmentEntity::getDeptId));
        List wardIds = relationList.stream().map(SysWardDepartmentEntity::getWardId).distinct().filter(Objects::nonNull).collect(Collectors.toList());
        if (!wardIds.isEmpty()) {
            List relations;
            List wardList = this.sysWardMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysWardEntity.class).eq(tenantId != null, SysWardEntity::getTenantId, (Object)tenantId)).eq(SysWardEntity::getDelFlag, (Object)DelFlagEnum.NOT_FLAG.getValue())).eq(SysWardEntity::getEnableStatus, (Object)StatusEnum.ENABLED.getValue())).in(SysWardEntity::getId, wardIds));
            Map wardMap = wardList.stream().collect(Collectors.toMap(SysWardEntity::getId, Function.identity()));
            for (Map.Entry<Integer, List<SysWardDepartmentEntity>> entry : relationMap.entrySet()) {
                relations = entry.getValue();
                for (SysWardDepartmentEntity relation : relations) {
                    SysWardEntity wardEntity = (SysWardEntity)wardMap.get(relation.getWardId());
                    if (wardEntity == null) continue;
                    relation.setWardEntity(wardEntity);
                }
            }
            for (SysDepartmentVo vo : list) {
                relations = relationMap.getOrDefault(vo.getId(), new ArrayList());
                List wards = relations.stream().map(SysWardDepartmentEntity::getWardEntity).filter(Objects::nonNull).collect(Collectors.toList());
                vo.setWardList(wards);
            }
        }
        return list;
    }

    public List<SysDepartmentVo> sysDepartmentSelectFast(SysDepartmentDTO dto) {
        Integer tenantId = dto.getTenantId();
        List list = this.sysDepartmentMapper.normalSelect(dto);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            List doctorEntityList = this.sysDoctorMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(tenantId != null, SysDoctorEntity::getTenantId, (Object)tenantId)).eq(SysDoctorEntity::getDelFlag, (Object)"0"));
            Map<String, List<SysDoctorEntity>> doctorMap = doctorEntityList.stream().collect(Collectors.groupingBy(SysDoctorEntity::getDepartmentId));
            for (SysDepartmentVo n : list) {
                List nDoctorList = doctorMap.getOrDefault(n.getId().toString(), new ArrayList());
                n.setDoctorList(nDoctorList);
            }
            List deptIds = list.stream().map(SysDepartmentVo::getId).collect(Collectors.toList());
            list = this.getWardList(list, tenantId, deptIds);
            list = new TreeUtils().treeList(list, new String[]{"id", "departmentParentId", "children"});
        }
        return list;
    }

    public List<SysDepartmentVo> sysDepartmentGetOneLevel(Integer id) {
        SysDepartmentDTO dto = new SysDepartmentDTO();
        dto.setDepartmentParentId(Integer.valueOf(0));
        dto.setHospitalId(id);
        List list = this.sysDepartmentMapper.normalSelect(dto);
        return list;
    }

    public List<SysDepartmentVo> sysDepartmentSelectList(SysDepartmentDTO dto) {
        List list = this.sysDepartmentMapper.sysDepartmentSelect(dto);
        return list;
    }

    public SysDepartmentVo queryById(Integer id) {
        SysDepartmentEntity sysDepartmentEntity = (SysDepartmentEntity)this.sysDepartmentMapper.selectById((Serializable)id);
        if (Objects.nonNull(sysDepartmentEntity)) {
            SysDepartmentVo sysDepartmentVo = new SysDepartmentVo();
            BeanUtils.copyProperties((Object)sysDepartmentEntity, (Object)sysDepartmentVo);
            return sysDepartmentVo;
        }
        return null;
    }

    public SysDepartmentEntity selectDepartmentByRefId(Integer departmentId) {
        return this.sysDepartmentMapper.selectDepartmentByRefId(departmentId);
    }

    public List<SysDepartmentVo> sysDepartmentAndDoctorSelect(SysDepartmentDTO dto) {
        List<SysDepartmentVo> list = this.sysDepartmentSelectFast(dto);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            list = list.stream().collect(Collectors.groupingBy(SysDepartmentVo::getDepartmentParentId)).get(0);
            List doctorList = this.sysDoctorMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(SysDoctorEntity::getDelFlag, (Object)"0"));
            Map<Object, Object> doctorMap = new HashMap(10);
            if (!CollectionUtils.isEmpty((Collection)doctorList)) {
                doctorMap = doctorList.stream().collect(Collectors.groupingBy(SysDoctorEntity::getDepartmentId));
            }
            this.arrangeDeptAndDoctorData(list, doctorMap);
            return list;
        }
        return list;
    }

    public void sysDepartmentUpdate(SysDepartmentUpdateDTO dto) {
        SysDepartmentEntity oldEntity = (SysDepartmentEntity)this.sysDepartmentMapper.selectById((Serializable)dto.getId());
        if (!oldEntity.getDepartmentName().equals(dto.getDepartmentName())) {
            this.checkDepartmentName(dto.getDepartmentName(), dto.getTenantId());
        }
        SysDepartmentEntity entity = new SysDepartmentEntity();
        BeanUtils.copyProperties((Object)dto, (Object)entity);
        entity.setUpdateTime(new Date());
        int a = this.sysDepartmentMapper.updateById((Object)entity);
        ExceptionUtils.createException((Logger)this.logger, (int)a, (String)SysDepartmentEnum.SYS_DEPARTMENT_INSERT_ERROR.getCode(), (String)SysDepartmentEnum.SYS_DEPARTMENT_INSERT_ERROR.getName());
        LambdaQueryWrapper deleteWrapper = Wrappers.lambdaQuery();
        deleteWrapper.eq(dto.getTenantId() != null, SysWardDepartmentEntity::getTenantId, (Object)dto.getTenantId());
        deleteWrapper.eq(SysWardDepartmentEntity::getDeptId, (Object)dto.getId());
        this.sysWardDepartmentMapper.delete((Wrapper)deleteWrapper);
        if (dto.getWardIds() != null && !dto.getWardIds().isEmpty()) {
            this.insertWardDeptList(dto.getWardIds(), dto.getId(), dto.getTenantId(), dto.getUpdateId(), dto.getUpdateName());
        }
        this.hsUploadExtend.updateDeptContrastNewContext(entity.getId());
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void sysDepartmentDelete(Integer[] ids, Integer tenantId) {
        if (ArrayUtil.isEmpty((Object[])ids)) {
            throw new BusinessException(SysCommonEnum.ARRAY_LENGTH_IS_ZERO.getCode(), SysCommonEnum.ARRAY_LENGTH_IS_ZERO.getName());
        }
        this.checkDeptByUseDoctor(ids);
        this.checkDeptHaveChild(ids);
        this.checkRelationWard(ids, tenantId);
        int a = this.sysDepartmentMapper.sysDepartmentDelete(ids);
        ExceptionUtils.createException((Logger)this.logger, (int)a, (String)SysDepartmentEnum.SYS_DEPARTMENT_INSERT_ERROR.getCode(), (String)SysDepartmentEnum.SYS_DEPARTMENT_INSERT_ERROR.getName());
        this.sysWardDepartmentMapper.deleteListByDeptIds(ids, tenantId);
    }

    private void checkRelationWard(Integer[] ids, Integer tenantId) {
        List deptWards = this.sysWardDepartmentMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysWardDepartmentEntity.class).eq(SysWardDepartmentEntity::getDelFlag, (Object)DelFlagEnum.NOT_FLAG.getValue())).in(SysWardDepartmentEntity::getDeptId, (Object[])ids));
        if (!deptWards.isEmpty()) {
            List wardIds = deptWards.stream().map(SysWardDepartmentEntity::getWardId).distinct().filter(Objects::nonNull).collect(Collectors.toList());
            List wardList = this.sysWardMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysWardEntity.class).eq(SysWardEntity::getDelFlag, (Object)DelFlagEnum.NOT_FLAG.getValue())).eq(SysWardEntity::getEnableStatus, (Object)StatusEnum.ENABLED.getValue())).in(SysWardEntity::getId, wardIds));
            if (!wardList.isEmpty()) {
                ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u5b58\u5728\u5173\u8054\u7684\u75c5\u533a\uff01\u5220\u9664\u5931\u8d25\uff01");
            }
        }
    }

    public List<Integer> sysDepartmentGetAllIds(Integer id) {
        SysDepartmentDTO dto = new SysDepartmentDTO();
        dto.setId(id);
        List list = this.sysDepartmentMapper.sysDepartmentSelect(dto);
        ArrayList<Integer> ids = new ArrayList<Integer>();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            this.getAllId(list, ids);
            return ids;
        }
        return ids;
    }

    public void checkDeptByUseDoctor(Integer[] ids) {
        List doctorList = this.sysDoctorMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(SysDoctorEntity::getDepartmentId, (Object[])ids)).eq(SysDoctorEntity::getDelFlag, (Object)ConstantsEnums.DEL_FLAG_ZERO.getValue())).groupBy(SysDoctorEntity::getDepartmentId));
        if (!CollectionUtils.isEmpty((Collection)doctorList)) {
            ArrayList<Integer> idList = new ArrayList<Integer>();
            for (SysDoctorEntity n : doctorList) {
                idList.add(Integer.parseInt(n.getDepartmentId()));
            }
            this.getDeptAndException(idList, "\u5b58\u5728\u7528\u6237\uff0c\u4e0d\u53ef\u5220\u9664;");
        }
    }

    public void checkDeptHaveChild(Integer[] ids) {
        List list = this.sysDepartmentMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(SysDepartmentEntity::getDepartmentParentId, Arrays.asList(ids))).eq(BaseEntity::getDelFlag, (Object)ConstantsEnums.DEL_FLAG_ZERO.getValue()));
        if (!CollectionUtils.isEmpty((Collection)list)) {
            ArrayList<Integer> idList = new ArrayList<Integer>();
            for (SysDepartmentEntity n : list) {
                idList.add(n.getDepartmentParentId());
            }
            this.getDeptAndException(idList, "\u6709\u5b50\u79d1\u5ba4\uff0c\u4e0d\u53ef\u5220\u9664\uff01");
        }
    }

    public void getDeptAndException(List<Integer> idList, String text) {
        List pList = this.sysDepartmentMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(BaseEntity::getId, idList)).eq(BaseEntity::getDelFlag, (Object)ConstantsEnums.DEL_FLAG_ZERO.getValue()));
        StringBuilder builder = new StringBuilder();
        for (SysDepartmentEntity n : pList) {
            builder.append("\u3010").append(n.getDepartmentName()).append("\u3011" + text);
        }
        ExceptionUtils.createException((Logger)this.logger, (boolean)Boolean.TRUE, (String)SysDepartmentEnum.SYS_DEPARTMENT_DELETE_ERROR.getCode(), (String)builder.toString());
    }

    public void getAllId(List<SysDepartmentVo> list, List<Integer> ids) {
        for (SysDepartmentVo n : list) {
            ids.add(n.getId());
            if (CollectionUtils.isEmpty((Collection)n.getChildren())) continue;
            this.getAllId(n.getChildren(), ids);
        }
    }

    public void arrangeData(List<SysDepartmentVo> list, List<SysDepartmentVo> tempList) {
        for (SysDepartmentVo n : list) {
            if (CollectionUtils.isEmpty((Collection)n.getChildren())) continue;
            for (SysDepartmentVo m : n.getChildren()) {
                Iterator<SysDepartmentVo> iterator = tempList.iterator();
                while (iterator.hasNext()) {
                    SysDepartmentVo next = iterator.next();
                    if (!m.getId().equals(next.getId())) continue;
                    iterator.remove();
                }
            }
            this.arrangeData(n.getChildren(), tempList);
        }
    }

    private SysDepartmentEntity checkDepartmentName(String deptName, Integer tenantId) {
        SysDepartmentEntity sysDepartmentEntity = (SysDepartmentEntity)this.sysDepartmentMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDepartmentEntity::getDepartmentName, (Object)deptName)).eq(SysDepartmentEntity::getTenantId, (Object)tenantId)).eq(BaseEntity::getDelFlag, (Object)ConstantsEnums.DEL_FLAG_ZERO.getValue()));
        if (null != sysDepartmentEntity) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)Boolean.TRUE, (String)SysDepartmentEnum.SYS_DEPARTMENT_NAME_ALREADY_EXISTS.getCode(), (String)SysDepartmentEnum.SYS_DEPARTMENT_NAME_ALREADY_EXISTS.getName());
        }
        return sysDepartmentEntity;
    }

    public void arrangeDeptAndDoctorData(List<SysDepartmentVo> list, Map<String, List<SysDoctorEntity>> doctorMap) {
        for (SysDepartmentVo n : list) {
            n.setDoctorList(doctorMap.get(n.getId().toString()));
            if (CollectionUtils.isEmpty((Collection)n.getChildren())) continue;
            this.arrangeDeptAndDoctorData(n.getChildren(), doctorMap);
        }
    }

    public List<SysDepartmentVo> setChildren(Map<Integer, List<SysDepartmentVo>> mapList, List<SysDepartmentVo> parentList) {
        for (SysDepartmentVo n : parentList) {
            List<SysDepartmentVo> li = mapList.get(n.getId());
            if (!CollectionUtils.isEmpty(li)) {
                n.setChildren(li);
                this.setChildren(mapList, li);
                continue;
            }
            return parentList;
        }
        return parentList;
    }
}

