/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.sys.api.dto.drug.SysDrugInventoryOutDto;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.drug.inventory.SysDrugInventoryOutEntity;
import com.byh.sys.data.repository.SysDrugInventoryOutMapper;
import com.byh.sys.web.service.SysDrugInventoryOutService;
import enums.ConstantsEnums;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class SysDrugInventoryOutServiceImpl
extends ServiceImpl<SysDrugInventoryOutMapper, SysDrugInventoryOutEntity>
implements SysDrugInventoryOutService {
    private static final Logger log = LoggerFactory.getLogger(SysDrugInventoryOutServiceImpl.class);

    public IPage<SysDrugInventoryOutEntity> pageList(Page<SysDrugInventoryOutEntity> page, SysDrugInventoryOutDto dto) {
        LambdaQueryWrapper qw = Wrappers.lambdaQuery();
        qw.eq(SysDrugInventoryOutEntity::getDelFlag, (Object)ConstantsEnums.DEL_FLAG_ZERO.getValue());
        if (StrUtil.isNotEmpty((CharSequence)dto.getSearch())) {
            qw.and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)wrapper.like(SysDrugInventoryOutEntity::getId, (Object)dto.getSearch());
            });
        }
        if (StrUtil.isNotEmpty((CharSequence)dto.getOutboundWarehouse())) {
            qw.eq(SysDrugInventoryOutEntity::getOutboundWarehouse, (Object)dto.getOutboundWarehouse());
        }
        if (StrUtil.isNotEmpty((CharSequence)dto.getOutboundMethod())) {
            qw.eq(SysDrugInventoryOutEntity::getOutboundMethod, (Object)dto.getOutboundMethod());
        }
        if (StrUtil.isNotEmpty((CharSequence)dto.getStartTime()) && StrUtil.isNotEmpty((CharSequence)dto.getEndTime())) {
            dto.setStartTime(dto.getStartTime() + " 00:00:00");
            dto.setEndTime(dto.getEndTime() + " 23:59:59");
            qw.between(SysDrugInventoryOutEntity::getOutboundTime, (Object)dto.getStartTime(), (Object)dto.getEndTime());
        }
        if (StrUtil.isNotEmpty((CharSequence)dto.getAuditStatus())) {
            qw.eq(SysDrugInventoryOutEntity::getAuditStatus, (Object)dto.getAuditStatus());
        }
        if (StrUtil.isNotEmpty((CharSequence)dto.getSupplierId())) {
            qw.eq(SysDrugInventoryOutEntity::getSupplierId, (Object)dto.getSupplierId());
        }
        qw.eq(SysDrugInventoryOutEntity::getTenantId, (Object)dto.getTenantId());
        qw.orderByDesc(SysDrugInventoryOutEntity::getCreateTime);
        return ((SysDrugInventoryOutMapper)this.baseMapper).selectPage(page, (Wrapper)qw);
    }

    @Transactional(rollbackFor={Exception.class})
    public Boolean removeDrugInventoryOut(String[] ids) {
        if (ObjectUtils.isEmpty((Object[])ids)) {
            throw new BusinessException("\u836f\u5e93\u51fa\u5e93id\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ((SysDrugInventoryOutMapper)this.baseMapper).removeDrugInventoryOut(ids);
        ((SysDrugInventoryOutMapper)this.baseMapper).removeDrugInventoryOutPre(ids);
        return true;
    }
}

