/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.sys.api.dto.drug.temp.SysDrugInventoryOutTempDto;
import com.byh.sys.api.dto.drug.temp.SysDrugInventoryOutTempUpdateDto;
import com.byh.sys.api.enums.SysDrugEnum;
import com.byh.sys.api.model.drug.SysDrugInventoryOutTempEntity;
import com.byh.sys.api.model.drug.inventory.SysDrugInventoryOutEntity;
import com.byh.sys.api.model.drug.inventory.SysDrugInventoryOutPrescriptionEntity;
import com.byh.sys.api.util.BeanUtil;
import com.byh.sys.api.util.ExceptionUtils;
import com.byh.sys.api.util.UUIDUtils;
import com.byh.sys.api.vo.drug.SysDrugInventoryOutTempVo;
import com.byh.sys.data.repository.SysDrugInventoryOutPrescriptionMapper;
import com.byh.sys.data.repository.SysDrugInventoryOutTempMapper;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.SysDrugInventoryOutTempService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysDrugInventoryOutTempServiceImpl
implements SysDrugInventoryOutTempService {
    private static final Logger log = LoggerFactory.getLogger(SysDrugInventoryOutTempServiceImpl.class);
    @Resource
    private SysDrugInventoryOutTempMapper sysDrugInventoryOutTempMapper;
    @Autowired
    private SysDrugInventoryOutPrescriptionMapper sysDrugInventoryOutPrescriptionMapper;
    @Autowired
    private CommonRequest commonRequest;

    public void sysDrugInventoryOutTempSave(SysDrugInventoryOutTempEntity entity) {
        int a = this.sysDrugInventoryOutTempMapper.sysDrugInventoryOutTempSave(entity);
    }

    public void sysDrugInventoryOutTempSave(SysDrugInventoryOutEntity entity) {
        SysDrugInventoryOutTempEntity entry = (SysDrugInventoryOutTempEntity)BeanUtil.copy((Object)entity, SysDrugInventoryOutTempEntity.class);
        entry.setDrugInventoryOutId(entity.getId());
        entry.setId(UUIDUtils.getRandom((int)5, (boolean)true));
        entry.setTenantId(this.commonRequest.getTenant());
        entry.setWarehouse(entity.getWarehouse());
        int a = this.sysDrugInventoryOutTempMapper.insert((Object)entry);
        ExceptionUtils.createException((Logger)log, (int)a, (String)SysDrugEnum.SYS_DRUG_OUT_TEMP_INSERT_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_OUT_TEMP_INSERT_ERROR.getName());
    }

    public IPage<SysDrugInventoryOutTempVo> sysDrugInventoryOutTempSelect(Page page, SysDrugInventoryOutTempDto dto) {
        IPage list = this.sysDrugInventoryOutTempMapper.sysDrugInventoryOutTempSelect(page, dto);
        List records = list.getRecords();
        if (!CollectionUtils.isEmpty((Collection)records)) {
            List outIds = records.stream().map(SysDrugInventoryOutTempVo::getDrugInventoryOutId).collect(Collectors.toList());
            List prescriptionList = this.sysDrugInventoryOutPrescriptionMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(SysDrugInventoryOutPrescriptionEntity::getDrugInventoryOutId, outIds)).eq(SysDrugInventoryOutPrescriptionEntity::getTenantId, (Object)dto.getTenantId()));
            Map<String, List<SysDrugInventoryOutPrescriptionEntity>> prescriptionMap = prescriptionList.stream().collect(Collectors.groupingBy(SysDrugInventoryOutPrescriptionEntity::getDrugInventoryOutId));
            for (SysDrugInventoryOutTempVo n : records) {
                n.setList(prescriptionMap.get(n.getDrugInventoryOutId()));
            }
            list.setRecords(records);
        }
        return list;
    }

    public void sysDrugInventoryOutTempUpdate(SysDrugInventoryOutTempUpdateDto dto) {
        SysDrugInventoryOutTempEntity entity = (SysDrugInventoryOutTempEntity)BeanUtil.copy((Object)dto, SysDrugInventoryOutTempEntity.class);
        int a = this.sysDrugInventoryOutTempMapper.update((Object)entity, (Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(SysDrugInventoryOutTempEntity::getId, (Object)dto.getId())).eq(SysDrugInventoryOutTempEntity::getTenantId, (Object)dto.getTenantId()));
        ExceptionUtils.createException((Logger)log, (int)a, (String)SysDrugEnum.SYS_DRUG_OUT_TEMP_UPDATE_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_OUT_TEMP_UPDATE_ERROR.getName());
    }

    public void sysDrugInventoryOutTempDelete(SysDrugInventoryOutTempEntity entity) {
        int a = this.sysDrugInventoryOutTempMapper.sysDrugInventoryOutTempDelete(entity);
    }
}

