/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.sys.api.dto.SysEasyEntity;
import com.byh.sys.api.dto.drug.drugPharmacy.SysDrugPharmacySaveDto;
import com.byh.sys.api.dto.drug.drugPharmacyCheck.SysDrugPharmacyCheckDto;
import com.byh.sys.api.dto.drug.drugPharmacyCheck.SysDrugPharmacyCheckExcel;
import com.byh.sys.api.dto.drug.drugPharmacyCheck.SysDrugPharmacyCheckSaveDto;
import com.byh.sys.api.dto.drug.drugPharmacyCheck.SysDrugPharmacyCheckUpdateDto;
import com.byh.sys.api.dto.drug.drugPharmacyCheck.SysDrugPharmacyCheckUpdateStatusDto;
import com.byh.sys.api.dto.drug.drugPharmacyCheckPrescip.SysDrugPharmacyCheckPrescriptionExcel;
import com.byh.sys.api.dto.drug.drugPharmacyCheckPrescip.SysDrugPharmacyCheckPrescriptionSaveDto;
import com.byh.sys.api.dto.drug.drugPharmacyCheckPrescip.SysDrugPharmacyCheckPrescriptionUpdateDto;
import com.byh.sys.api.enums.DictEnums;
import com.byh.sys.api.enums.SysDrugEnum;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.SysUserEntity;
import com.byh.sys.api.model.base.NoIdBaseEntity;
import com.byh.sys.api.model.drug.SysDrugEntity;
import com.byh.sys.api.model.drug.pharmacy.SysDrugPharmacyCheckEntity;
import com.byh.sys.api.model.drug.pharmacy.SysDrugPharmacyCheckPrescriptionEntity;
import com.byh.sys.api.model.drug.pharmacy.SysDrugPharmacyEntity;
import com.byh.sys.api.model.drug.pharmacy.SysDrugPharmacySimpleEntity;
import com.byh.sys.api.model.drug.pharmacy.SysDrugPharmacyStorageEntity;
import com.byh.sys.api.util.BeanUtil;
import com.byh.sys.api.util.EasyExcelUtil;
import com.byh.sys.api.util.ExceptionUtils;
import com.byh.sys.api.util.StringUtils;
import com.byh.sys.api.util.UUIDUtils;
import com.byh.sys.api.vo.drug.SimpleExportByDrugVo;
import com.byh.sys.api.vo.drug.SysDrugPharmacyCheckVo;
import com.byh.sys.api.vo.drug.SysDrugPharmacyVo;
import com.byh.sys.data.repository.SysDrugMapper;
import com.byh.sys.data.repository.SysDrugPharmacyCheckMapper;
import com.byh.sys.data.repository.SysDrugPharmacyCheckPrescriptionMapper;
import com.byh.sys.data.repository.SysDrugPharmacyMapper;
import com.byh.sys.data.repository.SysDrugPharmacySimpleMapper;
import com.byh.sys.data.repository.SysDrugPharmacyStorageMapper;
import com.byh.sys.data.repository.SysUserMapper;
import com.byh.sys.web.call_function.ExtendServiceImpl;
import com.byh.sys.web.call_function.HsUploadExtend;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.SysDrugPharmacyCheckPrescriptionService;
import com.byh.sys.web.service.SysDrugPharmacyCheckService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SysDrugPharmacyCheckServiceImpl
implements SysDrugPharmacyCheckService {
    private static final Logger log = LoggerFactory.getLogger(SysDrugPharmacyCheckServiceImpl.class);
    @Resource
    private SysDrugPharmacyCheckMapper sysDrugPharmacyCheckMapper;
    @Resource
    private SysDrugPharmacyCheckPrescriptionMapper sysDrugPharmacyCheckPrescriptionMapper;
    @Autowired
    private CommonRequest commonRequest;
    @Resource
    private SysDrugPharmacySimpleMapper sysDrugPharmacySimpleMapper;
    @Resource
    private SysDrugPharmacyMapper sysDrugPharmacyMapper;
    @Autowired
    private SysDrugPharmacyCheckPrescriptionService sysDrugPharmacyCheckPrescriptionService;
    @Autowired
    @Lazy
    private SysDrugPharmacyCheckService sysDrugPharmacyCheckService;
    @Autowired
    private SysUserMapper sysUserMapper;
    @Autowired
    private HsUploadExtend hsUploadExtend;
    @Autowired
    private ExtendServiceImpl extendServiceImpl;
    @Autowired
    private SysDrugMapper sysDrugMapper;
    @Autowired
    private SysDrugPharmacyStorageMapper sysDrugPharmacyStorageMapper;

    @Transactional(rollbackFor={BusinessException.class})
    public SysDrugPharmacyCheckEntity sysDrugPharmacyCheckSave(SysDrugPharmacyCheckSaveDto dto) {
        BigDecimal rootPurchasePricePl = new BigDecimal(0);
        BigDecimal rootRetailPricePl = new BigDecimal(0);
        SysDrugPharmacyCheckEntity entity = (SysDrugPharmacyCheckEntity)BeanUtil.copy((Object)dto, SysDrugPharmacyCheckEntity.class);
        String checkId = UUIDUtils.getRandom((int)6, (boolean)true);
        if (!StringUtils.isBlank((String)dto.getId())) {
            entity.setId(dto.getId());
        } else {
            entity.setId(checkId);
        }
        entity.setCheckUse(this.commonRequest.getUserId().toString());
        entity.setCheckNumber(Integer.valueOf(dto.getPrescripList().size()));
        if (null == dto.getAuditStatus()) {
            entity.setAuditStatus(DictEnums.CHECK_READY.getCode());
        }
        List prescripList = dto.getPrescripList();
        for (SysDrugPharmacyCheckPrescriptionSaveDto n : prescripList) {
            n.setTenantId(dto.getTenantId());
            n.setDrugPharmacyCheckId(entity.getId());
            n.setId(UUIDUtils.getRandom((int)6, (boolean)true));
            n.setPlNumber(Integer.valueOf(n.getRealityInventory() - n.getBookInventory()));
            n.setPurchasePricePl(new BigDecimal(n.getPlNumber()).multiply(n.getPurchasePrice()));
            rootPurchasePricePl = rootPurchasePricePl.add(n.getPurchasePricePl());
            n.setRetailPricePl(new BigDecimal(n.getPlNumber()).multiply(n.getRetailPrice()));
            rootRetailPricePl = rootRetailPricePl.add(n.getRetailPricePl());
        }
        entity.setPurchasePricePl(rootPurchasePricePl);
        entity.setRetailPricePl(rootRetailPricePl);
        int a = this.sysDrugPharmacyCheckMapper.insert((Object)entity);
        ExceptionUtils.createException((Logger)log, (int)a, (String)SysDrugEnum.SYS_DRUG_PHARMACY_CHECK_INSERT_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_CHECK_INSERT_ERROR.getName());
        this.sysDrugPharmacyCheckPrescriptionMapper.sysDrugPharmacyCheckPrescriptionSaveBatch(prescripList);
        SysDrugPharmacyCheckEntity entry = (SysDrugPharmacyCheckEntity)this.sysDrugPharmacyCheckMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugPharmacyCheckEntity::getId, (Object)entity.getId())).eq(SysDrugPharmacyCheckEntity::getTenantId, (Object)dto.getTenantId()));
        entry.setPrescripList(prescripList);
        return entry;
    }

    public IPage<SysDrugPharmacyCheckVo> sysDrugPharmacyCheckSelect(Page page, SysDrugPharmacyCheckDto dto) {
        IPage list = this.sysDrugPharmacyCheckMapper.sysDrugPharmacyCheckSelect(page, dto);
        List checkVoList = list.getRecords();
        if (!CollectionUtils.isEmpty((Collection)checkVoList)) {
            List ids = checkVoList.stream().map(SysDrugPharmacyCheckVo::getAuditUse).collect(Collectors.toList());
            List userList = this.sysUserMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(SysUserEntity::getId, ids));
            if (!CollectionUtils.isEmpty((Collection)userList)) {
                Map<Integer, List<SysUserEntity>> userIdMap = userList.stream().collect(Collectors.groupingBy(SysUserEntity::getId));
                for (SysDrugPharmacyCheckVo n : checkVoList) {
                    List<SysUserEntity> sysUserEntities;
                    if ("".equals(n.getAuditUse()) || CollectionUtils.isEmpty(sysUserEntities = userIdMap.get(Integer.parseInt(n.getAuditUse())))) continue;
                    n.setAuditUse(sysUserEntities.get(0).getUserName());
                }
            }
        }
        return list;
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void sysDrugPharmacyCheckUpdate(SysDrugPharmacyCheckUpdateDto dto) {
        BigDecimal rootPurchasePricePl = new BigDecimal(0);
        BigDecimal rootRetailPricePl = new BigDecimal(0);
        SysDrugPharmacyCheckEntity entity = (SysDrugPharmacyCheckEntity)BeanUtil.copy((Object)dto, SysDrugPharmacyCheckEntity.class);
        List list = dto.getPrescripList();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (SysDrugPharmacyCheckPrescriptionUpdateDto n : list) {
                n.setPlNumber(Integer.valueOf(n.getRealityInventory() - n.getBookInventory()));
                n.setPurchasePricePl(new BigDecimal(n.getPlNumber()).multiply(n.getPurchasePrice()));
                rootPurchasePricePl = rootPurchasePricePl.add(n.getPurchasePricePl());
                n.setRetailPricePl(new BigDecimal(n.getPlNumber()).multiply(n.getRetailPrice()));
                rootRetailPricePl = rootRetailPricePl.add(n.getRetailPricePl());
            }
            entity.setPurchasePricePl(rootPurchasePricePl);
            entity.setRetailPricePl(rootRetailPricePl);
            entity.setCheckNumber(Integer.valueOf(list.size()));
            if ("4".equals(dto.getAuditStatus()) || "5".equals(dto.getAuditStatus())) {
                entity.setAuditUse(this.commonRequest.getUserId().toString());
            }
            for (SysDrugPharmacyCheckPrescriptionUpdateDto n : list) {
                n.setTenantId(dto.getTenantId());
                this.sysDrugPharmacyCheckPrescriptionService.sysDrugPharmacyCheckPrescriptionUpdate(n);
            }
        }
        int a = this.sysDrugPharmacyCheckMapper.update((Object)entity, (Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(SysDrugPharmacyCheckEntity::getTenantId, (Object)dto.getTenantId())).eq(SysDrugPharmacyCheckEntity::getId, (Object)dto.getId()));
        ExceptionUtils.createException((Logger)log, (int)a, (String)SysDrugEnum.SYS_DRUG_PHARMACY_CHECK_UPDATE_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_CHECK_UPDATE_ERROR.getName());
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void sysDrugPharmacyCheckDelete(String id) {
        List list = this.sysDrugPharmacyCheckPrescriptionMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugPharmacyCheckPrescriptionEntity::getDrugPharmacyCheckId, (Object)id)).eq(SysDrugPharmacyCheckPrescriptionEntity::getTenantId, (Object)this.commonRequest.getTenant()));
        ExceptionUtils.createException((Logger)log, (boolean)CollectionUtils.isEmpty((Collection)list), (String)SysDrugEnum.SYS_DRUG_PHARMACY_CHECK_PRESCRIPTION_SELECT_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_CHECK_PRESCRIPTION_SELECT_ERROR.getName());
        List ids = list.stream().map(SysDrugPharmacyCheckPrescriptionEntity::getId).collect(Collectors.toList());
        int a = this.sysDrugPharmacyCheckPrescriptionMapper.deleteBatchIds(ids);
        ExceptionUtils.createException((Logger)log, (int)a, (String)SysDrugEnum.SYS_DRUG_PHARMACY_CHECK_PRESCRIPTION_DELETE_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_CHECK_PRESCRIPTION_DELETE_ERROR.getName());
        int b = this.sysDrugPharmacyCheckMapper.deleteById((Serializable)((Object)id));
        ExceptionUtils.createException((Logger)log, (int)b, (String)SysDrugEnum.SYS_DRUG_PHARMACY_CHECK_DELETE_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_CHECK_DELETE_ERROR.getName());
    }

    @Transactional(rollbackFor={BusinessException.class})
    public IPage<SysDrugPharmacyVo> sysDrugPharmacyCheckSearch(Page page, SysDrugPharmacyCheckDto dto) {
        IPage list = this.extendServiceImpl.getDrugCheckSearch(page, dto);
        return list;
    }

    @Transactional(rollbackFor={BusinessException.class})
    public SysDrugPharmacyCheckEntity sysDrugPharmacyCheckUpdateStatus(SysDrugPharmacyCheckUpdateStatusDto dto) {
        Date date = null;
        ExceptionUtils.createException((Logger)log, (boolean)DictEnums.CHECK_ALREADY_CONFIRM.getCode().equals(dto.getAuditStatus()), (String)SysDrugEnum.SYS_DRUG_PHARMACY_CHECK_ALREADY_CONFIRM_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_CHECK_ALREADY_CONFIRM_ERROR.getName());
        SysDrugPharmacyCheckEntity entity = (SysDrugPharmacyCheckEntity)BeanUtil.copy((Object)dto, SysDrugPharmacyCheckEntity.class);
        if (DictEnums.CHECK_ING.getCode().equals(dto.getAuditStatus())) {
            date = new Date();
            entity.setCheckTime(date);
        }
        int a = this.sysDrugPharmacyCheckMapper.update((Object)entity, (Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(SysDrugPharmacyCheckEntity::getId, (Object)entity.getId())).eq(SysDrugPharmacyCheckEntity::getTenantId, (Object)entity.getTenantId()));
        ExceptionUtils.createException((Logger)log, (int)a, (String)SysDrugEnum.SYS_DRUG_PHARMACY_CHECK_UPDATE_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_CHECK_UPDATE_ERROR.getName());
        return entity;
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void sysDrugPharmacyCheckConfirm(String id, Integer tenantId, String warehouse) {
        SysDrugPharmacyCheckEntity entity = new SysDrugPharmacyCheckEntity();
        entity.setAuditStatus(DictEnums.CHECK_ALREADY_CONFIRM.getCode());
        SysUserEntity userInfo = this.commonRequest.getUserInfo();
        if (null != userInfo) {
            entity.setAuditUse(userInfo.getId().toString());
        }
        int a = this.sysDrugPharmacyCheckMapper.update((Object)entity, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(SysDrugPharmacyCheckEntity::getTenantId, (Object)tenantId)).eq(SysDrugPharmacyCheckEntity::getWarehouse, (Object)warehouse)).eq(SysDrugPharmacyCheckEntity::getId, (Object)id));
        ExceptionUtils.createException((Logger)log, (int)a, (String)SysDrugEnum.SYS_DRUG_PHARMACY_CHECK_UPDATE_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_CHECK_UPDATE_ERROR.getName());
        List list = this.sysDrugPharmacyCheckPrescriptionMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugPharmacyCheckPrescriptionEntity::getTenantId, (Object)tenantId)).eq(SysDrugPharmacyCheckPrescriptionEntity::getDrugPharmacyCheckId, (Object)id));
        for (SysDrugPharmacyCheckPrescriptionEntity n : list) {
            if (n.getPlNumber() == 0) continue;
            SysDrugPharmacySimpleEntity simple = (SysDrugPharmacySimpleEntity)this.sysDrugPharmacySimpleMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugPharmacySimpleEntity::getTenantId, (Object)tenantId)).eq(SysDrugPharmacySimpleEntity::getWarehouse, (Object)warehouse)).eq(SysDrugPharmacySimpleEntity::getDrugsId, (Object)n.getDrugsId()));
            if (null == simple) {
                ExceptionUtils.createException((Logger)log, (int)a, (String)SysDrugEnum.SYS_DRUG_PHARMACY_SIMPLE_SELECT_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_SIMPLE_SELECT_ERROR.getName());
            }
            simple.setActualInventory(Integer.valueOf(simple.getActualInventory() + n.getPlNumber()));
            simple.setPurchaseAmount(simple.getPurchaseAmount().add(new BigDecimal(n.getPlNumber()).multiply(n.getPurchasePrice())));
            int b = this.sysDrugPharmacySimpleMapper.update((Object)simple, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(SysDrugPharmacySimpleEntity::getTenantId, (Object)tenantId)).eq(SysDrugPharmacySimpleEntity::getWarehouse, (Object)warehouse)).eq(SysDrugPharmacySimpleEntity::getDrugsId, (Object)n.getDrugsId()));
            ExceptionUtils.createException((Logger)log, (int)b, (String)SysDrugEnum.SYS_DRUG_PHARMACY_UPDATE_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_UPDATE_ERROR.getName());
            ArrayList saveDtoList = new ArrayList();
            this.insertDrugPharmacy(n, saveDtoList, warehouse);
            this.sysDrugPharmacyMapper.sysDrugPharmacySaveBatch(saveDtoList);
            this.hsUploadExtend.medicationInventoryUploadContext(saveDtoList, this.commonRequest.getTenant());
        }
        this.extendServiceImpl.drugCheckPositionShelf(tenantId, warehouse, list);
    }

    private void insertDrugPharmacy(SysDrugPharmacyCheckPrescriptionEntity n, List<SysDrugPharmacySaveDto> saveDtoList, String warehouse) {
        SysDrugPharmacySaveDto saveDto = (SysDrugPharmacySaveDto)BeanUtil.copy((Object)n, SysDrugPharmacySaveDto.class);
        saveDto.setBatchNumber(n.getBatchNumber());
        saveDto.setId(UUIDUtils.getRandom((int)5, (boolean)true));
        saveDto.setInventoryId(n.getId());
        saveDto.setActualInventory(n.getPlNumber());
        saveDto.setPurchaseAmount(new BigDecimal(n.getPlNumber()).multiply(n.getPurchasePrice()));
        saveDto.setInOutType(DictEnums.IN_OUT_TYPE_CHECK.getCode());
        saveDto.setWarehouse(warehouse);
        saveDto.setInOutTime(new Date());
        if (n.getPlNumber() > 0) {
            saveDto.setInOutMethod("14");
        } else if (n.getPlNumber() < 0) {
            saveDto.setInOutMethod("15");
        }
        saveDtoList.add(saveDto);
    }

    public void sysDrugPharmacyCheckStatus(String warehouse) {
        List list = this.sysDrugPharmacyCheckMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugPharmacyCheckEntity::getTenantId, (Object)this.commonRequest.getTenant())).eq(SysDrugPharmacyCheckEntity::getAuditStatus, (Object)DictEnums.CHECK_ING.getCode())).eq(NoIdBaseEntity::getDelFlag, (Object)"0")).eq(SysDrugPharmacyCheckEntity::getWarehouse, (Object)warehouse));
        ExceptionUtils.createException((Logger)log, (!CollectionUtils.isEmpty((Collection)list) ? 1 : 0) != 0, (String)SysDrugEnum.SYS_DRUG_PHARMACY_CHECK_ING_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_CHECK_ING_ERROR.getName());
        List warehouseList = this.sysDrugPharmacyStorageMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugPharmacyStorageEntity::getTenantId, (Object)this.commonRequest.getTenant())).eq(NoIdBaseEntity::getDelFlag, (Object)"0")).eq(SysDrugPharmacyStorageEntity::getId, (Object)warehouse)).eq(SysDrugPharmacyStorageEntity::getLockStatus, (Object)"1"));
        ExceptionUtils.createException((Logger)log, (!CollectionUtils.isEmpty((Collection)warehouseList) ? 1 : 0) != 0, (String)("\u836f\u623f\uff1a" + warehouse + "\u9501\u5e93\u4e86\uff0c\u8bf7\u5148\u89e3\u9501"));
    }

    public void sysDrugPharmacyCheckExport(HttpServletResponse response, Page page, SysDrugPharmacyCheckDto dto) {
        List list = this.sysDrugPharmacyCheckSelect(page, dto).getRecords();
        ExceptionUtils.createException((Logger)log, (boolean)CollectionUtils.isEmpty((Collection)list), (String)SysDrugEnum.SYS_DRUG_PHARMACY_CHECK_EXPORT_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_CHECK_EXPORT_ERROR.getName());
        SysDrugPharmacyCheckExcel ex = (SysDrugPharmacyCheckExcel)BeanUtil.copy(list.get(0), SysDrugPharmacyCheckExcel.class);
        ex.setRetailPricePlAmount(((SysDrugPharmacyCheckVo)list.get(0)).getRetailPricePl());
        ex.setPurchasePricePlAmount(((SysDrugPharmacyCheckVo)list.get(0)).getPurchasePricePl());
        if (DictEnums.DRUG_PHARMACY_CHECK_TYPE_0.getCode().equals(ex.getCheckType())) {
            ex.setCheckType(DictEnums.DRUG_PHARMACY_CHECK_TYPE_0.getMsg());
        } else if (DictEnums.DRUG_PHARMACY_CHECK_TYPE_1.getCode().equals(ex.getCheckType())) {
            ex.setCheckType(DictEnums.DRUG_PHARMACY_CHECK_TYPE_1.getMsg());
        } else if (DictEnums.DRUG_PHARMACY_CHECK_TYPE_2.getCode().equals(ex.getCheckType())) {
            ex.setCheckType(DictEnums.DRUG_PHARMACY_CHECK_TYPE_2.getMsg());
        }
        BigDecimal retailPriceAmount = new BigDecimal(0);
        List preList = this.sysDrugPharmacyCheckPrescriptionMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(SysDrugPharmacyCheckPrescriptionEntity::getDrugPharmacyCheckId, (Object)dto.getId()));
        List ps = BeanUtil.copyList((List)preList, SysDrugPharmacyCheckPrescriptionExcel.class);
        for (SysDrugPharmacyCheckPrescriptionExcel n : ps) {
            retailPriceAmount = retailPriceAmount.add(new BigDecimal(n.getRealityInventory()).multiply(n.getRetailPrice()));
        }
        ex.setRetailPriceAmount(retailPriceAmount);
        ArrayList<SysDrugPharmacyCheckExcel> excels = new ArrayList<SysDrugPharmacyCheckExcel>();
        excels.add(ex);
        String excelName = "\u836f\u623f\u76d8\u70b9\u660e\u7ec6";
        String sheetName = "\u836f\u623f\u5165\u5e93";
        EasyExcelUtil.customTemplateExport((HttpServletResponse)response, (String)excelName, excels, (List)ps);
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void revokeCheckImport(SysEasyEntity entity) {
        SysDrugPharmacyStorageEntity storageEntity = (SysDrugPharmacyStorageEntity)this.sysDrugPharmacyStorageMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(SysDrugPharmacyStorageEntity::getId, (Object)entity.getWarehouse()));
        ExceptionUtils.createException((Logger)log, (null == storageEntity || "0".equals(storageEntity.getLockStatus()) ? 1 : 0) != 0, (String)"\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u76d8\u70b9\u836f\u623f\uff0c\u6216\u5f53\u524d\u836f\u623f\u672a\u4e0a\u9501");
        SysDrugPharmacyCheckEntity check = (SysDrugPharmacyCheckEntity)this.sysDrugPharmacyCheckMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(SysDrugPharmacyCheckEntity::getId, (Object)entity.getId()));
        ExceptionUtils.createException((Logger)log, (null == check ? 1 : 0) != 0, (String)"\u672a\u67e5\u8be2\u5230\u5230\u6307\u5b9a\u7ed9\u76d8\u70b9\u5355");
        ExceptionUtils.createException((Logger)log, (boolean)"6".equals(check.getAuditStatus()), (String)"\u5f53\u524d\u76d8\u70b9\u5355\u5df2\u64a4\u9500");
        List pharmacyList = this.sysDrugPharmacyMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugPharmacyEntity::getTenantId, (Object)entity.getTenantId())).eq(SysDrugPharmacyEntity::getWarehouse, (Object)entity.getWarehouse())).eq(SysDrugPharmacyEntity::getInventoryId, (Object)entity.getId()));
        ExceptionUtils.createException((Logger)log, (boolean)CollectionUtils.isEmpty((Collection)pharmacyList), (String)"\u5f53\u524d\u76d8\u70b9\u5355\u672a\u67e5\u8be2\u5230\u51fa\u5165\u5e93\u6279\u6b21\u8be6\u60c5");
        List ids = pharmacyList.stream().map(SysDrugPharmacyEntity::getDrugsId).collect(Collectors.toList());
        List drugList = this.sysDrugPharmacySimpleMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugPharmacySimpleEntity::getTenantId, (Object)entity.getTenantId())).eq(SysDrugPharmacySimpleEntity::getWarehouse, (Object)entity.getWarehouse())).in(SysDrugPharmacySimpleEntity::getDrugsId, ids));
        block0: for (SysDrugPharmacyEntity item : pharmacyList) {
            for (int i = 0; i < drugList.size(); ++i) {
                SysDrugPharmacySimpleEntity drug = (SysDrugPharmacySimpleEntity)drugList.get(i);
                if (item.getDrugsId().equals(drug.getDrugsId())) {
                    drug.setActualInventory(Integer.valueOf(drug.getActualInventory() - item.getActualInventory()));
                    int a = this.sysDrugPharmacySimpleMapper.updateById((Object)drug);
                    ExceptionUtils.createException((Logger)log, (int)a, (String)("\u836f\u54c1\uff1a" + drug.getDrugsId() + "\u64a4\u9500\u5e93\u5b58\u6570\u636e\u5f02\u5e38"));
                    continue block0;
                }
                ExceptionUtils.createException((Logger)log, (i == drugList.size() - 1 ? 1 : 0) != 0, (String)("\u836f\u54c1\uff1a" + drug.getDrugsId() + "\u5728\u67e5\u8be2\u51fa\u6765\u7684\u5e93\u5b58\u6570\u636e\u4e2d\u672a\u67e5\u8be2\u5230"));
            }
        }
        int b = this.sysDrugPharmacyMapper.delete((Wrapper)Wrappers.lambdaQuery().eq(SysDrugPharmacyEntity::getInventoryId, (Object)entity.getId()));
        ExceptionUtils.createException((Logger)log, (int)b, (String)("\u6839\u636e\u5355\u53f7\uff1a" + entity.getId() + "\u5220\u9664\u6279\u6b21\u6570\u636e\u5f02\u5e38"));
        SysDrugPharmacyCheckEntity checkEntity = new SysDrugPharmacyCheckEntity();
        checkEntity.setId(entity.getId());
        checkEntity.setAuditStatus("6");
        int c = this.sysDrugPharmacyCheckMapper.updateById((Object)checkEntity);
        ExceptionUtils.createException((Logger)log, (int)c, (String)("\u6839\u636e\u5355\u53f7\uff1a" + entity.getId() + "\u64a4\u9500\u76d8\u70b9\u5355\u5f02\u5e38"));
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void sysDrugPharmacyCheckImport(MultipartFile file, String warehouse) {
        SysDrugPharmacyStorageEntity storageEntity = (SysDrugPharmacyStorageEntity)this.sysDrugPharmacyStorageMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(SysDrugPharmacyStorageEntity::getId, (Object)warehouse));
        ExceptionUtils.createException((Logger)log, (null == storageEntity || "0".equals(storageEntity.getLockStatus()) ? 1 : 0) != 0, (String)"\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u76d8\u70b9\u836f\u623f\uff0c\u6216\u5f53\u524d\u836f\u623f\u672a\u4e0a\u9501");
        try {
            String st = EasyExcelUtil.importExcelMerge((MultipartFile)file, (Object)new SimpleExportByDrugVo());
            List list = JSON.parseArray((String)st, SimpleExportByDrugVo.class);
            List ids = list.stream().map(SimpleExportByDrugVo::getDrugsId).collect(Collectors.toList());
            List sysDrugPharmacyVos = this.sysDrugPharmacyCheckMapper.getDrugBatch(ids, warehouse, this.commonRequest.getTenant());
            List drugList = this.sysDrugMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(SysDrugEntity::getId, ids));
            Map<String, List<SysDrugEntity>> drugMap = drugList.stream().collect(Collectors.groupingBy(SysDrugEntity::getId));
            Map<String, List<SysDrugPharmacyVo>> pharmacyMap = sysDrugPharmacyVos.stream().collect(Collectors.groupingBy(SysDrugPharmacyVo::getDrugsId));
            String inventoryId = UUIDUtils.getRandom((int)5, (boolean)true);
            ArrayList saveDtoList = new ArrayList();
            for (SimpleExportByDrugVo l : list) {
                this.setPharmacy(l, pharmacyMap, inventoryId, drugMap, warehouse, saveDtoList);
            }
            this.setCheck(warehouse, saveDtoList, inventoryId);
            this.updateDrugSimple(warehouse, saveDtoList);
            this.sysDrugPharmacyMapper.sysDrugPharmacySaveBatch(saveDtoList);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("500", e.getMessage());
        }
    }

    public void setPharmacy(SimpleExportByDrugVo l, Map<String, List<SysDrugPharmacyVo>> pharmacyMap, String inventoryId, Map<String, List<SysDrugEntity>> drugMap, String warehouse, List<SysDrugPharmacySaveDto> saveDtoList) {
        List<SysDrugEntity> sysDrugEntities = drugMap.get(l.getDrugsId());
        ExceptionUtils.createException((Logger)log, (boolean)CollectionUtils.isEmpty(sysDrugEntities), (String)("\u836f\u54c1id\uff1a" + l.getDrugsId() + "\u672a\u5728\u836f\u54c1\u57fa\u672c\u4fe1\u606f\u4e2d\u67e5\u8be2\u5230\u836f\u54c1"));
        List<SysDrugPharmacyVo> batchList = pharmacyMap.get(l.getDrugsId());
        for (SysDrugPharmacyVo drug : batchList) {
            SysDrugPharmacySaveDto sysDrugPharmacySaveDto = new SysDrugPharmacySaveDto();
            sysDrugPharmacySaveDto.setInventoryId(inventoryId);
            sysDrugPharmacySaveDto.setCreateId(Integer.valueOf(999999));
            sysDrugPharmacySaveDto.setBookInventory(drug.getActualInventory());
            sysDrugPharmacySaveDto.setMedicalInsuranceCode(sysDrugEntities.get(0).getMedicalInsuranceCode());
            sysDrugPharmacySaveDto.setMedicalInsuranceName(sysDrugEntities.get(0).getMedicalInsuranceName());
            sysDrugPharmacySaveDto.setBatchNumber(drug.getBatchNumber());
            sysDrugPharmacySaveDto.setInOutTime(new Date());
            sysDrugPharmacySaveDto.setWarehouse(warehouse);
            sysDrugPharmacySaveDto.setPurchasePrice(drug.getPurchasePrice());
            sysDrugPharmacySaveDto.setRetailPrice(drug.getRetailPrice());
            sysDrugPharmacySaveDto.setInternalCode(String.valueOf(sysDrugEntities.get(0).getInternalCode()));
            sysDrugPharmacySaveDto.setThirdCode(String.valueOf(sysDrugEntities.get(0).getThirdCode()));
            sysDrugPharmacySaveDto.setTenantId(this.commonRequest.getTenant());
            sysDrugPharmacySaveDto.setEffectiveTime(drug.getEffectiveTime());
            sysDrugPharmacySaveDto.setClassificationId(String.valueOf(sysDrugEntities.get(0).getClassificationId()));
            sysDrugPharmacySaveDto.setClassificationName(sysDrugEntities.get(0).getClassificationName());
            sysDrugPharmacySaveDto.setInOutType("3");
            sysDrugPharmacySaveDto.setLevel(sysDrugEntities.get(0).getLevel());
            sysDrugPharmacySaveDto.setDrugsId(l.getDrugsId());
            sysDrugPharmacySaveDto.setDrugsName(l.getDrugsName());
            sysDrugPharmacySaveDto.setSpecifications(sysDrugEntities.get(0).getSpecifications());
            sysDrugPharmacySaveDto.setManufacturer(sysDrugEntities.get(0).getManufacturer());
            sysDrugPharmacySaveDto.setUnit(sysDrugEntities.get(0).getPackLargeUnitsLabel());
            sysDrugPharmacySaveDto.setWarehouseName(drug.getWarehouseName());
            sysDrugPharmacySaveDto.setId(UUIDUtils.getRandom((int)5, (boolean)true));
            if (l.getPlNumber() >= 0) {
                sysDrugPharmacySaveDto.setActualInventory(l.getPlNumber());
                sysDrugPharmacySaveDto.setPurchaseAmount(new BigDecimal(l.getPlNumber()).multiply(drug.getPurchasePrice()));
                sysDrugPharmacySaveDto.setInOutMethod("14");
                saveDtoList.add(sysDrugPharmacySaveDto);
                l.setPlNumber(Integer.valueOf(0));
                break;
            }
            if (l.getPlNumber() >= 0 || drug.getActualInventory() <= 0) continue;
            sysDrugPharmacySaveDto.setInOutMethod("15");
            if (l.getPlNumber() + drug.getActualInventory() >= 0) {
                sysDrugPharmacySaveDto.setActualInventory(l.getPlNumber());
                sysDrugPharmacySaveDto.setPurchaseAmount(new BigDecimal(sysDrugPharmacySaveDto.getActualInventory()).multiply(drug.getPurchasePrice()));
                saveDtoList.add(sysDrugPharmacySaveDto);
                l.setPlNumber(Integer.valueOf(0));
                break;
            }
            if (l.getPlNumber() + drug.getActualInventory() < 0) {
                l.setPlNumber(Integer.valueOf(l.getPlNumber() + drug.getActualInventory()));
                sysDrugPharmacySaveDto.setActualInventory(Integer.valueOf(-drug.getActualInventory().intValue()));
                sysDrugPharmacySaveDto.setPurchaseAmount(new BigDecimal(sysDrugPharmacySaveDto.getActualInventory()).multiply(drug.getPurchasePrice()));
            }
            saveDtoList.add(sysDrugPharmacySaveDto);
        }
        ExceptionUtils.createException((Logger)log, (l.getPlNumber() != 0 ? 1 : 0) != 0, (String)(l.getDrugsName() + "\u6279\u6b21\u6263\u51cf\u5f02\u5e38\uff0c\u5269\u4f59\uff1a" + l.getPlNumber()));
    }

    public void setCheck(String warehouse, List<SysDrugPharmacySaveDto> saveDtoList, String inventoryId) {
        SysDrugPharmacyCheckSaveDto sysDrugPharmacyCheckSaveDto = new SysDrugPharmacyCheckSaveDto();
        sysDrugPharmacyCheckSaveDto.setId(inventoryId);
        sysDrugPharmacyCheckSaveDto.setCheckTime(new Date());
        sysDrugPharmacyCheckSaveDto.setInventoryName(saveDtoList.get(0).getWarehouseName());
        sysDrugPharmacyCheckSaveDto.setCheckType("1");
        sysDrugPharmacyCheckSaveDto.setCheckNumber(Integer.valueOf(saveDtoList.size()));
        sysDrugPharmacyCheckSaveDto.setAuditUse(String.valueOf(this.commonRequest.getUserId()));
        sysDrugPharmacyCheckSaveDto.setCheckUse(String.valueOf(this.commonRequest.getUserId()));
        sysDrugPharmacyCheckSaveDto.setAuditStatus("4");
        sysDrugPharmacyCheckSaveDto.setTenantId(this.commonRequest.getTenant());
        sysDrugPharmacyCheckSaveDto.setWarehouse(warehouse);
        ArrayList<SysDrugPharmacyCheckPrescriptionSaveDto> checkPrescriptionSaveList = new ArrayList<SysDrugPharmacyCheckPrescriptionSaveDto>();
        for (SysDrugPharmacySaveDto saveDto : saveDtoList) {
            SysDrugPharmacyCheckPrescriptionSaveDto checkSaveDto = new SysDrugPharmacyCheckPrescriptionSaveDto();
            checkSaveDto.setId(UUIDUtils.getRandom((int)5, (boolean)true));
            checkSaveDto.setDrugsId(saveDto.getDrugsId());
            checkSaveDto.setDrugsName(saveDto.getDrugsName());
            checkSaveDto.setDrugPharmacyCheckId(inventoryId);
            checkSaveDto.setSpecifications(saveDto.getSpecifications());
            checkSaveDto.setBookInventory(saveDto.getBookInventory());
            checkSaveDto.setPlNumber(saveDto.getActualInventory());
            checkSaveDto.setBatchNumber(saveDto.getBatchNumber());
            checkSaveDto.setPurchasePrice(saveDto.getPurchasePrice());
            checkSaveDto.setPurchasePricePl(checkSaveDto.getPurchasePrice().multiply(new BigDecimal(checkSaveDto.getPlNumber())));
            checkSaveDto.setRetailPrice(saveDto.getRetailPrice());
            checkSaveDto.setRetailPricePl(checkSaveDto.getRetailPrice().multiply(new BigDecimal(checkSaveDto.getPlNumber())));
            checkSaveDto.setManufacturer(saveDto.getManufacturer());
            checkSaveDto.setEffectiveTime(saveDto.getEffectiveTime());
            checkSaveDto.setTenantId(saveDto.getTenantId());
            checkSaveDto.setRealityInventory(Integer.valueOf(checkSaveDto.getBookInventory() + checkSaveDto.getPlNumber()));
            checkPrescriptionSaveList.add(checkSaveDto);
        }
        sysDrugPharmacyCheckSaveDto.setPrescripList(checkPrescriptionSaveList);
        this.sysDrugPharmacyCheckSave(sysDrugPharmacyCheckSaveDto);
    }

    public void updateDrugSimple(String warehouse, List<SysDrugPharmacySaveDto> saveDtoList) {
        List simpleList = this.sysDrugPharmacySimpleMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(SysDrugPharmacySimpleEntity::getWarehouse, (Object)warehouse));
        Map<String, List<SysDrugPharmacySimpleEntity>> simpleMap = simpleList.stream().collect(Collectors.groupingBy(SysDrugPharmacySimpleEntity::getDrugsId));
        for (SysDrugPharmacySaveDto sysDrugPharmacySaveDto : saveDtoList) {
            List<SysDrugPharmacySimpleEntity> list = simpleMap.get(sysDrugPharmacySaveDto.getDrugsId());
            ExceptionUtils.createException((Logger)log, (list.size() > 1 ? 1 : 0) != 0, (String)(warehouse + "\u4e2d\u51fa\u73b0\u91cd\u590d\u836f\u54c1id\uff1a" + sysDrugPharmacySaveDto.getDrugsId()));
            ExceptionUtils.createException((Logger)log, (boolean)CollectionUtils.isEmpty(list), (String)(warehouse + "\u672a\u67e5\u8be2\u5230\u6307\u5b9a\u836f\u54c1id\uff1a" + sysDrugPharmacySaveDto.getDrugsId()));
            SysDrugPharmacySimpleEntity simpleEntity = list.get(0);
            simpleEntity.setActualInventory(Integer.valueOf(simpleEntity.getActualInventory() + sysDrugPharmacySaveDto.getActualInventory()));
            this.sysDrugPharmacySimpleMapper.updateById((Object)simpleEntity);
        }
    }
}

