/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.sys.api.dto.drug.SysDrugSubstanceDto;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.drug.inventory.SysDrugSubstanceEntity;
import com.byh.sys.api.vo.drug.ExportDrugSubstance;
import com.byh.sys.api.vo.drug.SysDrugSubstanceVo;
import com.byh.sys.data.repository.SysDictValueMapper;
import com.byh.sys.data.repository.SysDrugSubstanceMapper;
import com.byh.sys.web.service.SysDrugSubstanceService;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SysDrugSubstanceServiceImpl
extends ServiceImpl<SysDrugSubstanceMapper, SysDrugSubstanceEntity>
implements SysDrugSubstanceService {
    private static final Logger log = LoggerFactory.getLogger(SysDrugSubstanceServiceImpl.class);
    @Resource
    private SysDictValueMapper sysDictValueMapper;

    public IPage<SysDrugSubstanceEntity> pageDetail(Page<SysDrugSubstanceEntity> page, SysDrugSubstanceDto dto) {
        IPage sysDrugSubstanceEntityIPage = ((SysDrugSubstanceMapper)this.baseMapper).pageDetail(page, dto);
        SysDrugSubstanceEntity sysDrugSubstanceEntity = ((SysDrugSubstanceMapper)this.baseMapper).pageDetailTotal(dto);
        Integer drugNum = sysDrugSubstanceEntity.getDrugNum();
        BigDecimal retailAmount = sysDrugSubstanceEntity.getRetailAmount();
        BigDecimal purchaseAmount = sysDrugSubstanceEntity.getPurchaseAmount();
        List records = sysDrugSubstanceEntityIPage.getRecords();
        for (SysDrugSubstanceEntity record : records) {
            record.setDrugNumTotal(drugNum);
            record.setRetailAmountTotal(retailAmount);
            record.setPurchaseAmountTotal(purchaseAmount);
        }
        return sysDrugSubstanceEntityIPage;
    }

    public List<ExportDrugSubstance> exportDrugSubstance(SysDrugSubstanceDto dto) {
        List list = ((SysDrugSubstanceMapper)this.baseMapper).exportDrugSubstance(dto);
        return list;
    }

    public IPage<SysDrugSubstanceVo> pageSummary(Page<SysDrugSubstanceEntity> page, SysDrugSubstanceDto dto) {
        HashMap map = new HashMap();
        String inOutType = dto.getInOutType();
        if (StrUtil.isEmpty((CharSequence)inOutType)) {
            throw new BusinessException("\u51fa\u5165\u5e93\u6c47\u603b\u4e0d\u80fd\u4e3a\u4e3a\u7a7a\uff01{inOutType}");
        }
        if ("1".equals(inOutType)) {
            dto.setFieldType("warehousing_method");
        }
        if ("2".equals(inOutType)) {
            dto.setFieldType("outbound_method");
        }
        IPage substanceVoIPage = ((SysDrugSubstanceMapper)this.baseMapper).pageSummary(page, dto);
        return substanceVoIPage;
    }
}

