/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.service.impl;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.sys.api.dto.department.SysDepartmentDTO;
import com.byh.sys.api.dto.hospital.SysHospitalDTO;
import com.byh.sys.api.dto.hospital.SysHospitalSaveDTO;
import com.byh.sys.api.dto.hospital.SysHospitalUpdateDTO;
import com.byh.sys.api.dto.organhos.SysOranHospitalSaveDto;
import com.byh.sys.api.enums.SysCommonEnum;
import com.byh.sys.api.enums.SysHospitalEnum;
import com.byh.sys.api.enums.SysOrganHospitalEnum;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.SysDoctorEntity;
import com.byh.sys.api.model.SysOranHospitalEntity;
import com.byh.sys.api.model.SysRoleEntity;
import com.byh.sys.api.model.SysUserEntity;
import com.byh.sys.api.model.SysUserRoleEntity;
import com.byh.sys.api.model.base.BaseEntity;
import com.byh.sys.api.model.dict.SysDictValueEntity;
import com.byh.sys.api.model.hospital.SysHospitalEntity;
import com.byh.sys.api.model.hospital.SysHospitalUserEntity;
import com.byh.sys.api.util.Base64Util;
import com.byh.sys.api.util.BeanUtil;
import com.byh.sys.api.util.ExceptionUtils;
import com.byh.sys.api.util.SystemConstants;
import com.byh.sys.api.vo.SysUserVo;
import com.byh.sys.api.vo.hospital.SysHospitalVo;
import com.byh.sys.data.repository.SysDictValueMapper;
import com.byh.sys.data.repository.SysDoctorMapper;
import com.byh.sys.data.repository.SysHospitalMapper;
import com.byh.sys.data.repository.SysHospitalUserMapper;
import com.byh.sys.data.repository.SysOranHospitalMapper;
import com.byh.sys.data.repository.SysRoleMapper;
import com.byh.sys.data.repository.SysUserMapper;
import com.byh.sys.data.repository.SysUserRoleMapper;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.SysDepartmentService;
import com.byh.sys.web.service.SysHospitalService;
import com.byh.sys.web.service.SysOranHospitalService;
import enums.ConstantsEnums;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysHospitalServiceImpl
extends ServiceImpl<SysHospitalMapper, SysHospitalEntity>
implements SysHospitalService {
    private static final String password = "H123456";
    Logger logger = LoggerFactory.getLogger(SysHospitalServiceImpl.class);
    @Resource
    private SysHospitalMapper sysHospitalMapper;
    @Resource
    private SysDepartmentService sysDepartmentService;
    @Resource
    private RedisTemplate<String, Object> redisTemplate;
    @Resource
    private SysUserMapper sysUserMapper;
    @Resource
    private SysDoctorMapper sysDoctorMapper;
    @Resource
    private SysRoleMapper sysRoleMapper;
    @Resource
    private SysUserRoleMapper sysUserRoleMapper;
    @Resource
    private SysHospitalUserMapper sysHospitalUserMapper;
    @Resource
    private SysDictValueMapper sysDictValueMapper;
    @Resource
    private CommonRequest commonRequest;
    @Resource
    private SysOranHospitalService sysOranHospitalService;
    @Resource
    private SysOranHospitalMapper sysOranHospitalMapper;

    @Transactional(rollbackFor={BusinessException.class})
    public void sysHospitalSave(SysHospitalSaveDTO dto) {
        this.checkHospitalName(dto.getHospitalName(), dto.getTenantId());
        SysHospitalEntity entity = new SysHospitalEntity();
        BeanUtils.copyProperties((Object)dto, (Object)entity);
        if (null != dto.getHospitalPicture()) {
            entity.setHospitalPicture(JSON.toJSONString((Object)dto.getHospitalPicture()));
        }
        if (null != dto.getPracticingLicense()) {
            entity.setPracticingLicense(JSON.toJSONString((Object)dto.getPracticingLicense()));
        }
        if (null != dto.getBusinessLicense()) {
            entity.setBusinessLicense(JSON.toJSONString((Object)dto.getBusinessLicense()));
        }
        int a = this.sysHospitalMapper.insert((Object)entity);
        ExceptionUtils.createException((Logger)this.logger, (int)a, (String)SysHospitalEnum.SYS_HOSPITAL_INSERT_ERROR.getCode(), (String)SysHospitalEnum.SYS_HOSPITAL_INSERT_ERROR.getName());
        int tenantId = this.insertOrganHospital(entity);
        entity.setTenantId(Integer.valueOf(tenantId));
        int b = this.sysHospitalMapper.updateById((Object)entity);
        ExceptionUtils.createException((Logger)this.logger, (int)b, (String)SysHospitalEnum.SYS_HOSPITAL_UPDATE_TENANT_ID_ERROR.getCode(), (String)SysHospitalEnum.SYS_HOSPITAL_UPDATE_TENANT_ID_ERROR.getName());
        dto.setTenantId(Integer.valueOf(tenantId));
        SysUserEntity sysUserEntity = this.insertUser(dto);
        this.insertHospitalUser(sysUserEntity, entity);
        this.insertDoctor(dto, sysUserEntity);
        SysRoleEntity sysRoleEntity = this.insertRole(entity);
        this.insertUserRole(sysUserEntity, sysRoleEntity);
    }

    public IPage<SysHospitalVo> sysHospitalSelect(Page page, SysHospitalDTO dto) {
        List typeList = this.sysDictValueMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDictValueEntity::getType, (Object)"sys_hospital_type")).and(w -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)w.eq(SysDictValueEntity::getTenantId, (Object)dto.getTenantId())).or()).eq(SysDictValueEntity::getCommon, (Object)"0");
        }));
        System.out.println(typeList);
        Map<String, List<SysDictValueEntity>> collect = typeList.stream().collect(Collectors.groupingBy(SysDictValueEntity::getValue));
        IPage sysHospitalVoIPage = this.sysHospitalMapper.sysHospitalQuery(page, dto);
        for (SysHospitalVo e : sysHospitalVoIPage.getRecords()) {
            List<SysDictValueEntity> sysDictValueEntities = collect.get(e.getHospitalType());
            e.setHospitalTypeName(sysDictValueEntities.get(0).getLabel());
        }
        return sysHospitalVoIPage;
    }

    public void sysHospitalUpdate(SysHospitalUpdateDTO dto) {
        SysHospitalEntity oldEntity = (SysHospitalEntity)this.sysHospitalMapper.selectById((Serializable)dto.getId());
        if (!oldEntity.getHospitalName().equals(oldEntity.getHospitalName())) {
            this.checkHospitalName(dto.getHospitalName(), dto.getTenantId());
        }
        SysHospitalEntity entity = new SysHospitalEntity();
        BeanUtils.copyProperties((Object)dto, (Object)entity);
        if (null != dto.getHospitalPicture()) {
            entity.setHospitalPicture(JSON.toJSONString((Object)dto.getHospitalPicture()));
        }
        if (null != dto.getPracticingLicense()) {
            entity.setPracticingLicense(JSON.toJSONString((Object)dto.getPracticingLicense()));
        }
        if (null != dto.getBusinessLicense()) {
            entity.setBusinessLicense(JSON.toJSONString((Object)dto.getBusinessLicense()));
        }
        int a = this.sysHospitalMapper.updateById((Object)entity);
        ExceptionUtils.createException((Logger)this.logger, (int)a, (String)SysHospitalEnum.SYS_HOSPITAL_UPDATE_ERROR.getCode(), (String)SysHospitalEnum.SYS_HOSPITAL_UPDATE_ERROR.getName());
    }

    public void sysHospitalDelete(Integer[] ids) {
        if (ArrayUtil.isEmpty((Object[])ids)) {
            throw new BusinessException(SysCommonEnum.ARRAY_LENGTH_IS_ZERO.getCode(), SysCommonEnum.ARRAY_LENGTH_IS_ZERO.getName());
        }
        int a = this.sysHospitalMapper.sysHospitalDelete(ids);
        ExceptionUtils.createException((Logger)this.logger, (int)a, (String)SysHospitalEnum.SYS_HOSPITAL_UPDATE_ERROR.getCode(), (String)SysHospitalEnum.SYS_HOSPITAL_UPDATE_ERROR.getName());
    }

    public void checkHospitalName(String name, Integer tenantId) {
        List sysHospitalEntity = this.sysHospitalMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysHospitalEntity::getHospitalName, (Object)name)).eq(SysHospitalEntity::getTenantId, (Object)tenantId)).eq(BaseEntity::getDelFlag, (Object)ConstantsEnums.DEL_FLAG_ZERO.getValue()));
        if (!CollectionUtils.isEmpty((Collection)sysHospitalEntity)) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)Boolean.TRUE, (String)SysHospitalEnum.SYS_HOSPITAL_NAME_ALREADY_EXISTS.getCode(), (String)SysHospitalEnum.SYS_HOSPITAL_NAME_ALREADY_EXISTS.getName());
        }
    }

    public List<SysHospitalVo> getBigTree(SysHospitalDTO hosdto) {
        String key = JSON.toJSONString((Object)hosdto);
        Object object = this.redisTemplate.opsForValue().get((Object)key);
        if (null != object) {
            this.redisTemplate.opsForValue().set((Object)key, object, (long)SystemConstants.REDIS_EXPIRE_TIME.intValue(), TimeUnit.SECONDS);
            return (List)object;
        }
        Page page = new Page(1L, -1L);
        List hosList = this.sysHospitalMapper.sysHospitalSelect(page, hosdto);
        SysDepartmentDTO deptDTO = new SysDepartmentDTO();
        if (!CollectionUtils.isEmpty((Collection)hosList)) {
            for (SysHospitalVo n : hosList) {
                deptDTO.setHospitalId(n.getId());
                List deptList = this.sysDepartmentService.sysDepartmentAndDoctorSelect(deptDTO);
                n.setDeptList(deptList);
            }
        }
        this.redisTemplate.opsForValue().set((Object)key, (Object)hosList, (long)SystemConstants.REDIS_EXPIRE_TIME.intValue(), TimeUnit.SECONDS);
        return hosList;
    }

    public void deleteHospitalAdmin(Integer id) {
        Integer hospitalId = 0;
        SysHospitalUserEntity hospitalUserEntity = (SysHospitalUserEntity)this.sysHospitalUserMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(SysHospitalUserEntity::getUserId, (Object)id));
        if (!StrUtil.isEmptyIfStr((Object)hospitalUserEntity)) {
            hospitalId = hospitalUserEntity.getHospitalId();
        }
        SysHospitalEntity hospitalEntity = new SysHospitalEntity();
        hospitalEntity.setStatus("1");
        ((SysHospitalMapper)this.baseMapper).update((Object)hospitalEntity, (Wrapper)Wrappers.lambdaQuery().eq(BaseEntity::getId, (Object)hospitalId));
        int a = this.sysHospitalUserMapper.delete((Wrapper)Wrappers.lambdaQuery().eq(SysHospitalUserEntity::getUserId, (Object)id));
    }

    public IPage<SysUserVo> getHospitalAdmin(Page<SysUserVo> page, Integer id) {
        IPage list = this.sysHospitalMapper.getHospitalAdmin(page, id);
        return list;
    }

    private int insertOrganHospital(SysHospitalEntity entity) {
        SysOranHospitalSaveDto dto = new SysOranHospitalSaveDto();
        dto.setOrganId(entity.getOrganId());
        dto.setHospitalId(entity.getId());
        SysOranHospitalEntity ohEntity = (SysOranHospitalEntity)BeanUtil.copy((Object)dto, SysOranHospitalEntity.class);
        int a = this.sysOranHospitalMapper.insert((Object)ohEntity);
        ExceptionUtils.createException((Logger)this.logger, (int)a, (String)SysOrganHospitalEnum.SYS_ORGAN_HOSPITAL_INSERT_ERROR.getCode(), (String)SysHospitalEnum.SYS_HOSPITAL_INSERT_ERROR.getName());
        return ohEntity.getId();
    }

    private SysUserEntity insertUser(SysHospitalSaveDTO dto) {
        List sysUserEntities = this.sysUserMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysUserEntity::getDelFlag, (Object)ConstantsEnums.DEL_FLAG_ZERO.getValue())).eq(SysUserEntity::getPhone, (Object)dto.getUserPhone()));
        if (!CollectionUtils.isEmpty((Collection)sysUserEntities)) {
            throw new BusinessException("\u9080\u8bf7\u9ed8\u8ba4\u7ba1\u7406\u5458\u624b\u673a\u53f7\u5df2\u5b58\u5728\uff01");
        }
        SysUserEntity sysUserEntity = new SysUserEntity();
        sysUserEntity.setUserName(dto.getUserName());
        sysUserEntity.setNickName(dto.getUserName());
        sysUserEntity.setPhone(dto.getUserPhone());
        sysUserEntity.setTenantId(dto.getTenantId());
        sysUserEntity.setPassword(Base64Util.passwordEncode((String)password));
        int sysUserCount = this.sysUserMapper.insert((Object)sysUserEntity);
        ExceptionUtils.createException((Logger)this.logger, (int)sysUserCount, (String)SysHospitalEnum.SYS_HOSPITAL_ADD_ADMIN_ERROR.getCode(), (String)SysHospitalEnum.SYS_HOSPITAL_ADD_ADMIN_ERROR.getName());
        return sysUserEntity;
    }

    private void insertHospitalUser(SysUserEntity sysUserEntity, SysHospitalEntity entity) {
        SysHospitalUserEntity sysHospitalUserEntity = new SysHospitalUserEntity();
        sysHospitalUserEntity.setUserId(sysUserEntity.getId());
        sysHospitalUserEntity.setHospitalId(entity.getId());
        sysHospitalUserEntity.setTenantId(sysUserEntity.getTenantId());
        sysHospitalUserEntity.setCreateTime(new Date());
        sysHospitalUserEntity.setUpdateTime(new Date());
        int hospitalUserCount = this.sysHospitalUserMapper.insert((Object)sysHospitalUserEntity);
        ExceptionUtils.createException((Logger)this.logger, (int)hospitalUserCount, (String)SysHospitalEnum.SYS_HOSPITAL_ADD_HOSPITAL_USER_ERROR.getCode(), (String)SysHospitalEnum.SYS_HOSPITAL_ADD_HOSPITAL_USER_ERROR.getName());
    }

    private void insertDoctor(SysHospitalSaveDTO dto, SysUserEntity sysUserEntity) {
        SysDoctorEntity sysDoctorEntity = new SysDoctorEntity();
        sysDoctorEntity.setUserId(sysUserEntity.getId());
        sysDoctorEntity.setUserName(dto.getUserName());
        sysDoctorEntity.setPhone(dto.getUserPhone());
        sysDoctorEntity.setTenantId(dto.getTenantId());
        int sysDoctorCount = this.sysDoctorMapper.insert((Object)sysDoctorEntity);
        ExceptionUtils.createException((Logger)this.logger, (int)sysDoctorCount, (String)SysHospitalEnum.SYS_HOSPITAL_ADD_DOCTOR_ERROR.getCode(), (String)SysHospitalEnum.SYS_HOSPITAL_ADD_DOCTOR_ERROR.getName());
    }

    private SysRoleEntity insertRole(SysHospitalEntity entity) {
        SysRoleEntity sysRoleEntity = new SysRoleEntity();
        sysRoleEntity.setRoleName(entity.getHospitalName() + "-\u7ba1\u7406\u5458");
        sysRoleEntity.setTenantId(entity.getTenantId());
        int sysRoleCount = this.sysRoleMapper.insert((Object)sysRoleEntity);
        ExceptionUtils.createException((Logger)this.logger, (int)sysRoleCount, (String)SysHospitalEnum.SYS_HOSPITAL_ADD_ROLE_ERROR.getCode(), (String)SysHospitalEnum.SYS_HOSPITAL_ADD_ROLE_ERROR.getName());
        return sysRoleEntity;
    }

    private void insertUserRole(SysUserEntity sysUserEntity, SysRoleEntity sysRoleEntity) {
        SysUserRoleEntity sysUserRoleEntity = new SysUserRoleEntity();
        sysUserRoleEntity.setUserId(sysUserEntity.getId());
        sysUserRoleEntity.setRoleId(sysRoleEntity.getId());
        sysUserRoleEntity.setTenantId(sysUserEntity.getTenantId());
        int sysUserRoleCount = this.sysUserRoleMapper.insert((Object)sysUserRoleEntity);
        ExceptionUtils.createException((Logger)this.logger, (int)sysUserRoleCount, (String)SysHospitalEnum.SYS_HOSPITAL_ADD_USER_ROLE_ERROR.getCode(), (String)SysHospitalEnum.SYS_HOSPITAL_ADD_USER_ROLE_ERROR.getName());
    }
}

