/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.SysMenuEntity;
import com.byh.sys.api.util.BeanUtil;
import com.byh.sys.api.util.TreeBuilder;
import com.byh.sys.api.vo.SysMenuVo;
import com.byh.sys.data.repository.SysMenuMapper;
import com.byh.sys.web.service.SysMenuService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class SysMenuServiceImpl
extends ServiceImpl<SysMenuMapper, SysMenuEntity>
implements SysMenuService {
    public List<SysMenuVo> querySysMenuTree(SysMenuEntity sysMenuEntity) {
        List entities = ((SysMenuMapper)this.baseMapper).finAllMenu(sysMenuEntity);
        ArrayList<SysMenuVo> nodes = new ArrayList<SysMenuVo>();
        List sysMenuVos1 = BeanUtil.copyList((List)entities, SysMenuVo.class);
        for (SysMenuEntity entity : entities) {
            SysMenuVo node = new SysMenuVo();
            node.setId(entity.getId());
            node.setParentId(entity.getParentId());
            node.setName(entity.getName());
            nodes.add(node);
        }
        List sysMenuVos = TreeBuilder.buildTree((List)sysMenuVos1);
        return sysMenuVos;
    }

    private List<SysMenuVo> buildChildTree(List<SysMenuVo> listVo, Integer pid) {
        if (CollectionUtil.isNotEmpty(listVo)) {
            listVo.forEach(a -> {
                if (a.getParentId().equals(pid.toString())) {
                    this.buildChildTree(a.getChildren(), a.getId());
                    a.setHasChildren(Boolean.valueOf(a.getChildren().size() > 0));
                }
            });
        }
        return listVo;
    }

    public Boolean removeSysMenu(Long[] ids) {
        if (ObjectUtils.isEmpty((Object[])ids)) {
            throw new BusinessException("\u83dc\u5355\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u4e3a\u7a7a\uff01{ids}\uff01" + ids);
        }
        for (Long pid : ids) {
            int id = pid.intValue();
            List longs = this.querySqlTree(Integer.valueOf(id));
            if (!CollectionUtil.isNotEmpty((Collection)longs) || 1 == longs.size()) continue;
            throw new BusinessException("\u8bf7\u5148\u5220\u9664\u5b50\u7ea7");
        }
        return ((SysMenuMapper)this.baseMapper).removeSysMenu(ids);
    }

    public List<Integer> querySqlTree(Integer pid) {
        List listVo = ((SysMenuMapper)this.baseMapper).querySqlTree(pid);
        List children = ((SysMenuVo)listVo.get(0)).getChildren();
        ArrayList childrenIds = new ArrayList();
        List ids = this.moduleRecursion(childrenIds, children, pid);
        ids.add(pid);
        return ids;
    }

    private List<Integer> moduleRecursion(List<Integer> childrenIds, List<SysMenuVo> listVo, Integer pid) {
        if (!ObjectUtils.isEmpty(listVo)) {
            listVo.forEach(a -> {
                if (a.getParentId().equals(pid.toString())) {
                    this.moduleRecursion(childrenIds, listVo, a.getId());
                    childrenIds.add(a.getId());
                }
            });
        }
        return childrenIds;
    }
}

