/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.service.impl;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.sys.api.dto.purchasePlan.GeneratePurchasePlanDto;
import com.byh.sys.api.dto.purchasePlan.SelectPurchasePlanDetailPageDto;
import com.byh.sys.api.dto.purchasePlan.SelectPurchasePlanPageDto;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.SysInventoryAlertEntity;
import com.byh.sys.api.model.purchasePlan.SysPurchasePlanDetailEntity;
import com.byh.sys.api.model.purchasePlan.SysPurchasePlanEntity;
import com.byh.sys.api.util.BeanUtil;
import com.byh.sys.api.util.EasyExcelUtil;
import com.byh.sys.api.util.ExceptionUtils;
import com.byh.sys.api.vo.purchasePlan.ExportPurchaseDetailPlanVo;
import com.byh.sys.api.vo.purchasePlan.GeneratePurchasePlanVo;
import com.byh.sys.data.repository.SysInventoryAlertMapper;
import com.byh.sys.data.repository.SysPurchasePlanDetailMapper;
import com.byh.sys.data.repository.SysPurchasePlanMapper;
import com.byh.sys.web.service.SysPurchasePlanService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysPurchasePlanServiceImpl
extends ServiceImpl<SysPurchasePlanMapper, SysPurchasePlanEntity>
implements SysPurchasePlanService {
    private Logger logger = LoggerFactory.getLogger(SysPurchasePlanServiceImpl.class);
    @Resource
    private SysPurchasePlanMapper sysPurchasePlanMapper;
    @Resource
    private SysPurchasePlanDetailMapper sysPurchasePlanDetailMapper;
    @Resource
    private SysInventoryAlertMapper sysInventoryAlertMapper;

    public void exportPurchasePlanList(HttpServletResponse response, SelectPurchasePlanDetailPageDto dto) {
        List exportList = this.sysPurchasePlanDetailMapper.exportPurchasePlanList(dto);
        EasyExcelUtil.exportExcelSheet((HttpServletResponse)response, (String)"\u836f\u54c1\u91c7\u8d2d\u8ba1\u5212", (String)"\u836f\u54c1\u91c7\u8d2d\u8ba1\u5212", (Object)new ExportPurchaseDetailPlanVo(), (List)exportList, null);
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void updatePlan(SysPurchasePlanEntity entity) {
        List detailList;
        Integer id = entity.getId();
        if (id == null) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u7f16\u8f91\u836f\u54c1\u91c7\u8d2d\u8ba1\u5212\u65f6\uff0c\u4e3b\u952eID\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        if ((detailList = entity.getDetailList()) != null && !detailList.isEmpty()) {
            String errorDrugNames = detailList.stream().filter(detail -> detail.getPurchaseNum() == null || detail.getPurchaseNum().compareTo(BigDecimal.ZERO) == 0).map(SysPurchasePlanDetailEntity::getDrugName).filter(Objects::nonNull).collect(Collectors.joining("\u3001"));
            if (StrUtil.isNotEmpty((CharSequence)errorDrugNames)) {
                String errorInfo = errorDrugNames + " \u8fd9\u4e9b\u836f\u54c1\u7684\u91c7\u8d2d\u6570\u91cf\u4e0d\u53ef\u4e3a\u7a7a\uff01";
                ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)errorInfo);
            }
            LambdaQueryWrapper detailDeleteWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysPurchasePlanDetailEntity::getPurchasePlanId, (Object)id);
            this.sysPurchasePlanDetailMapper.delete((Wrapper)detailDeleteWrapper);
            this.sysPurchasePlanDetailMapper.insertList(detailList);
            BigDecimal purchaseTotalAmount = detailList.stream().filter(detail -> detail.getPurchaseAmount() != null && detail.getPurchaseAmount().compareTo(BigDecimal.ZERO) != 0).map(SysPurchasePlanDetailEntity::getPurchaseAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal retailTotalAmount = detailList.stream().filter(detail -> detail.getRetailAmount() != null && detail.getRetailAmount().compareTo(BigDecimal.ZERO) != 0).map(SysPurchasePlanDetailEntity::getRetailAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            entity.setPurchaseAmount(purchaseTotalAmount);
            entity.setRetailAmount(retailTotalAmount);
        }
        entity.setUpdateId(entity.getUpdateId());
        entity.setUpdateName(entity.getUpdateName());
        this.sysPurchasePlanMapper.updateById((Object)entity);
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void deletePlanList(Integer[] ids) {
        if (ArrayUtil.isEmpty((Object[])ids)) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u6279\u91cf\u5220\u9664\u91c7\u8d2d\u8ba1\u5212\u65f6\uff0c\u4e3b\u952eID\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        int deleteCount = this.sysPurchasePlanMapper.deletePlanList(ids);
        ExceptionUtils.createException((Logger)this.logger, (int)deleteCount, (String)"500", (String)"\u6279\u91cf\u5220\u9664\u91c7\u8d2d\u8ba1\u5212\u5931\u8d25\uff01");
    }

    public Page<SysPurchasePlanDetailEntity> selectPageDetailList(SelectPurchasePlanDetailPageDto dto) {
        Page page = new Page((long)dto.getCurrent(), (long)dto.getSize());
        List list = this.sysPurchasePlanDetailMapper.selectPageList(page, dto);
        page.setRecords(list);
        return page;
    }

    public Page<SysPurchasePlanEntity> selectPageList(SelectPurchasePlanPageDto dto) {
        Page page = new Page((long)dto.getCurrent(), (long)dto.getSize());
        List list = this.sysPurchasePlanMapper.selectPageList(page, dto);
        page.setRecords(list);
        return page;
    }

    @Scheduled(cron="0 0 18 * * ?")
    @Transactional(rollbackFor={BusinessException.class})
    public void timingGeneratePurchasePlan() {
        GeneratePurchasePlanDto dto = new GeneratePurchasePlanDto();
        this.generatePurchasePlan(dto);
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void generatePurchasePlan(GeneratePurchasePlanDto dto) {
        Integer tenantId = Optional.ofNullable(dto.getTenantId()).orElse(1);
        dto.setTenantId(tenantId);
        Integer operatorId = Optional.ofNullable(dto.getOperatorId()).orElse(1);
        String operatorName = Optional.ofNullable(dto.getOperatorName()).filter(StrUtil::isNotEmpty).orElse("\u7cfb\u7edf\u81ea\u52a8\u751f\u6210");
        if (dto.getMaxOutDays() == null && dto.getMinOutDays() == null) {
            LambdaQueryWrapper alertQueryWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysInventoryAlertEntity::getTenantId, (Object)tenantId);
            SysInventoryAlertEntity alertEntity = (SysInventoryAlertEntity)this.sysInventoryAlertMapper.selectOne((Wrapper)alertQueryWrapper);
            if (alertEntity == null) {
                ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u8bf7\u5148\u8bbe\u7f6e\u5e93\u5b58\u9884\u8b66\uff01");
            }
            dto.setMaxOutDays(alertEntity.getMaxInventory());
            dto.setMinOutDays(alertEntity.getMinInventory());
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate maxDaysAgo = LocalDate.now().minusDays(dto.getMaxOutDays().intValue());
        LocalDate minDaysAgo = LocalDate.now().minusDays(dto.getMinOutDays().intValue());
        LocalDate today = LocalDate.now();
        String maxDaysStr = maxDaysAgo.format(formatter);
        String minDaysStr = minDaysAgo.format(formatter);
        String todayStr = today.format(formatter);
        dto.setMaxOutDayStr(maxDaysStr);
        dto.setMinOutDayStr(minDaysStr);
        dto.setTodayStr(todayStr);
        List planList = this.sysPurchasePlanMapper.getPurchasePlanList(dto);
        if (!planList.isEmpty()) {
            ArrayList<GeneratePurchasePlanVo> detailVoList = new ArrayList<GeneratePurchasePlanVo>();
            for (GeneratePurchasePlanVo vo : planList) {
                boolean flag = false;
                if (vo.getStockNum().compareTo(BigDecimal.ZERO) <= 0) {
                    flag = true;
                    vo.setPurchaseNum(vo.getMaxOutNum());
                } else {
                    BigDecimal purchaseNum = vo.getMaxOutNum().subtract(vo.getStockNum());
                    if (purchaseNum.compareTo(BigDecimal.ZERO) > 0) {
                        flag = true;
                        vo.setPurchaseNum(purchaseNum);
                    }
                }
                if (!flag) continue;
                detailVoList.add(vo);
            }
            if (!detailVoList.isEmpty()) {
                SysPurchasePlanEntity planEntity = new SysPurchasePlanEntity();
                planEntity.setTenantId(tenantId);
                planEntity.setCreateId(operatorId);
                planEntity.setCreateName(operatorName);
                planEntity.setDelFlag("0");
                BigDecimal retailTotalAmount = detailVoList.stream().filter(plan -> plan.getRetailPrice() != null && plan.getPurchaseNum() != null).map(plan -> plan.getRetailPrice().multiply(plan.getPurchaseNum())).reduce(BigDecimal.ZERO, BigDecimal::add);
                planEntity.setRetailAmount(retailTotalAmount);
                this.sysPurchasePlanMapper.insert((Object)planEntity);
                Integer planId = planEntity.getId();
                ArrayList<SysPurchasePlanDetailEntity> detailList = new ArrayList<SysPurchasePlanDetailEntity>();
                for (GeneratePurchasePlanVo vo : detailVoList) {
                    SysPurchasePlanDetailEntity detailEntity = new SysPurchasePlanDetailEntity();
                    BeanUtil.copy((Object)vo, (Object)detailEntity);
                    detailEntity.setTenantId(tenantId);
                    detailEntity.setPurchasePlanId(planId);
                    if (detailEntity.getStockNum().compareTo(BigDecimal.ZERO) < 0) {
                        detailEntity.setStockNum(BigDecimal.ZERO);
                    }
                    BigDecimal retailPrice = detailEntity.getRetailPrice();
                    BigDecimal purchaseNum = detailEntity.getPurchaseNum();
                    if (retailPrice != null && purchaseNum != null) {
                        BigDecimal retailAmount = retailPrice.multiply(purchaseNum);
                        detailEntity.setRetailAmount(retailAmount);
                    } else {
                        detailEntity.setRetailAmount(BigDecimal.ZERO);
                    }
                    detailList.add(detailEntity);
                }
                this.sysPurchasePlanDetailMapper.insertList(detailList);
            }
        }
    }
}

