/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.sys.api.dto.SysRoleDto;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.SysDoctorEntity;
import com.byh.sys.api.model.SysRoleEntity;
import com.byh.sys.api.vo.SysDoctorVo;
import com.byh.sys.data.repository.SysRoleMapper;
import com.byh.sys.data.repository.SysUserRoleMapper;
import com.byh.sys.web.service.SysRoleService;
import enums.ConstantsEnums;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class SysRoleServiceImpl
extends ServiceImpl<SysRoleMapper, SysRoleEntity>
implements SysRoleService {
    private final SysUserRoleMapper userRoleMapper;

    public IPage<SysRoleEntity> page(SysRoleDto sysRoleDto) {
        Page page = new Page((long)sysRoleDto.getCurrent().intValue(), (long)sysRoleDto.getSize().intValue());
        LambdaQueryWrapper qw = Wrappers.lambdaQuery();
        qw.eq(SysRoleEntity::getDelFlag, (Object)ConstantsEnums.DEL_FLAG_ZERO.getValue());
        qw.eq(SysRoleEntity::getTenantId, (Object)sysRoleDto.getTenantId());
        if (StrUtil.isNotEmpty((CharSequence)sysRoleDto.getRoleName())) {
            qw.like(SysRoleEntity::getRoleName, (Object)sysRoleDto.getRoleName());
        }
        if (StrUtil.isNotEmpty((CharSequence)sysRoleDto.getRoleKey())) {
            qw.like(SysRoleEntity::getRoleKey, (Object)sysRoleDto.getRoleKey());
        }
        if (StrUtil.isNotEmpty((CharSequence)sysRoleDto.getStartTime()) && StrUtil.isNotEmpty((CharSequence)sysRoleDto.getEndTime())) {
            sysRoleDto.setStartTime(sysRoleDto.getStartTime() + " 00:00:00");
            sysRoleDto.setEndTime(sysRoleDto.getEndTime() + " 23:59:59");
            qw.between(SysRoleEntity::getCreateTime, (Object)sysRoleDto.getStartTime(), (Object)sysRoleDto.getEndTime());
        }
        IPage sysRoleEntityIPage = ((SysRoleMapper)this.baseMapper).selectPage((IPage)page, (Wrapper)qw);
        return sysRoleEntityIPage;
    }

    public List<SysRoleEntity> pageList(SysRoleDto sysRoleDto) {
        LambdaQueryWrapper qw = Wrappers.lambdaQuery();
        qw.eq(SysRoleEntity::getDelFlag, (Object)ConstantsEnums.DEL_FLAG_ZERO.getValue());
        qw.eq(SysRoleEntity::getTenantId, (Object)sysRoleDto.getTenantId());
        if (StrUtil.isNotEmpty((CharSequence)sysRoleDto.getRoleName())) {
            qw.like(SysRoleEntity::getRoleName, (Object)sysRoleDto.getRoleName());
        }
        if (StrUtil.isNotEmpty((CharSequence)sysRoleDto.getRoleKey())) {
            qw.like(SysRoleEntity::getRoleKey, (Object)sysRoleDto.getRoleKey());
        }
        qw.ne(SysRoleEntity::getId, (Object)1);
        if (StrUtil.isNotEmpty((CharSequence)sysRoleDto.getStartTime()) && StrUtil.isNotEmpty((CharSequence)sysRoleDto.getEndTime())) {
            sysRoleDto.setStartTime(sysRoleDto.getStartTime() + " 00:00:00");
            sysRoleDto.setEndTime(sysRoleDto.getEndTime() + " 23:59:59");
            qw.between(SysRoleEntity::getCreateTime, (Object)sysRoleDto.getStartTime(), (Object)sysRoleDto.getEndTime());
        }
        List sysRoleEntities = ((SysRoleMapper)this.baseMapper).selectList((Wrapper)qw);
        return sysRoleEntities;
    }

    public Boolean removeSysRole(Long[] ids) {
        if (ObjectUtils.isEmpty((Object[])ids)) {
            throw new BusinessException("\u89d2\u8272\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List queryList = this.userRoleMapper.queryUserRole(ids);
        if (!CollectionUtils.isEmpty((Collection)queryList)) {
            throw new BusinessException("\u8be5\u89d2\u8272\u4e0b\u6709\u6210\u5458\u4e0d\u5141\u8bb8\u5220\u9664!");
        }
        return ((SysRoleMapper)this.baseMapper).removeSysRole(ids);
    }

    public SysRoleEntity queryRole(SysDoctorEntity a) {
        return ((SysRoleMapper)this.baseMapper).queryRole(a);
    }

    public String[] queryRoleName(SysDoctorVo vo) {
        String[] str2 = null;
        List list = ((SysRoleMapper)this.baseMapper).queryRoleName(vo);
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            str2 = list.toArray(new String[0]);
        }
        return str2;
    }

    public SysRoleServiceImpl(SysUserRoleMapper userRoleMapper) {
        this.userRoleMapper = userRoleMapper;
    }
}

