/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.mvc.controller.drug;

import com.byh.sys.api.annotation.UserOptLogger;
import com.byh.sys.api.dto.UploadContrastDto;
import com.byh.sys.api.dto.drug.contrast.HsItemCodeDto;
import com.byh.sys.api.dto.drug.contrast.SysHsDrugDto;
import com.byh.sys.api.model.SysChargeItemHsInfoEntity;
import com.byh.sys.api.model.SysHsInfoEntity;
import com.byh.sys.api.model.drug.SysDrugEntity;
import com.byh.sys.api.util.ExcelUtils;
import com.byh.sys.api.util.PageResult;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.api.vo.drug.SysHsContrastExportVo;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.SysDrugContrastService;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Validated
@RequestMapping(value={"/drugContrast"})
public class SysDrugContrastController {
    private static final Logger log = LoggerFactory.getLogger(SysDrugContrastController.class);
    @Autowired
    private SysDrugContrastService drugContrastService;
    @Autowired
    private CommonRequest commonRequest;

    @PostMapping(value={"/generateHsItem"})
    @ApiOperation(value="\u5bfc\u5165\u533b\u4fdd\u8bca\u7597\u9879\u76ee\uff0c\u5e76\u6839\u636e\u5176\u5185\u5bb9\u751f\u6210\u5bf9\u5e94\u7684\u6536\u8d39\u9879\u76ee\u4ee5\u53ca\u8bca\u7597\u9879\u76ee\uff08\u4ec5\u4f9b\u540e\u7aef\u8c03\u7528\uff09")
    public ResponseData generateHsItem() {
        this.drugContrastService.generateHsItem(this.commonRequest.getTenant());
        return ResponseData.success((Object)"\u5bfc\u5165\u5e76\u751f\u6210\u6210\u529f\uff01");
    }

    @PostMapping(value={"/hsItemInfoByCodes"})
    @ApiOperation(value="\u6839\u636e\u533b\u4fdd\u7f16\u7801\u96c6\u5408\u67e5\u8be2")
    public ResponseData<List<SysHsInfoEntity>> hsItemInfoByCodes(@RequestBody List<HsItemCodeDto> dtoList) {
        return this.drugContrastService.hsItemInfoByCodes(dtoList, this.commonRequest.getTenant());
    }

    @GetMapping(value={"/hsItemInfoByCode"})
    @ApiOperation(value="\u6839\u636e\u533b\u4fdd\u7f16\u7801\u67e5\u8be2")
    public ResponseData<List<SysHsInfoEntity>> hsItemInfoByCode(@RequestParam(value="hsCode", required=true, defaultValue="") String hsCode) {
        Integer tenantId = this.commonRequest.getTenant();
        return this.drugContrastService.hsItemInfoByCode(hsCode, tenantId);
    }

    @GetMapping(value={"/delHsItemInfoById"})
    @ApiOperation(value="\u6839\u636e\u533b\u4fdd\u7f16\u7801\u5220\u9664")
    public ResponseData delHsItemInfoById(@RequestParam(value="id", required=true, defaultValue="") String id) {
        Integer tenantId = this.commonRequest.getTenant();
        return this.drugContrastService.delHsItemInfoById(id, tenantId);
    }

    @PostMapping(value={"/hsDrugInfo"})
    @ApiOperation(value="\u533b\u4fdd\u836f\u54c1\u76ee\u5f55\u67e5\u8be2")
    public ResponseData<PageResult<SysHsInfoEntity>> hsDrugInfo(@RequestBody @Valid SysHsDrugDto hsDrugDto, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        Integer tenantId = this.commonRequest.getTenant();
        hsDrugDto.setTenantId(tenantId);
        return this.drugContrastService.hsDrugInfo(hsDrugDto);
    }

    @PostMapping(value={"/hsChargeInfo"})
    @ApiOperation(value="\u6536\u8d39\u9879\u76ee\u67e5\u8be2")
    public ResponseData<PageResult<SysChargeItemHsInfoEntity>> hsChargeInfo(@RequestBody @Valid SysHsDrugDto hsDrugDto, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        Integer tenantId = this.commonRequest.getTenant();
        hsDrugDto.setTenantId(tenantId);
        return this.drugContrastService.hsChargeInfo(hsDrugDto);
    }

    @PostMapping(value={"/updateHsDrugInfo"})
    @ApiOperation(value="\u66f4\u65b0\u533b\u4fdd\u76ee\u5f55")
    public ResponseData updateHsDrugInfo(@RequestBody @Valid SysHsInfoEntity sysHsInfoEntity, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        Integer tenantId = this.commonRequest.getTenant();
        sysHsInfoEntity.setTenantId(tenantId);
        return this.drugContrastService.updateHsDrugInfo(sysHsInfoEntity);
    }

    @GetMapping(value={"/hsDrugInfoDetail"})
    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    public ResponseData<SysHsInfoEntity> hsDrugInfoDetail(@RequestParam(value="id", required=true, defaultValue="") Integer id) {
        Integer tenantId = this.commonRequest.getTenant();
        return this.drugContrastService.hsDrugInfoDetail(id, tenantId);
    }

    @PostMapping(value={"/insertHsDrug"})
    @ApiOperation(value="\u65b0\u589e\u533b\u4fdd\u836f\u54c1\u76ee\u5f55")
    public ResponseData<SysHsInfoEntity> insertHsDrug(@RequestBody SysHsInfoEntity sysHsInfoEntity) {
        Integer tenantId = this.commonRequest.getTenant();
        sysHsInfoEntity.setTenantId(tenantId);
        return this.drugContrastService.insertHsDrug(sysHsInfoEntity);
    }

    @PostMapping(value={"/uploadDrugContrast"})
    @UserOptLogger(operation="\u5bf9\u7167\u4fe1\u606f\u4e0a\u4f20\u30103301\u3011")
    @ApiOperation(value="\u5bf9\u7167\u4fe1\u606f\u4e0a\u4f20\u30103301\u3011")
    public ResponseData uploadDrugContrast(@RequestBody UploadContrastDto uploadContrastDto) {
        Integer tenantId = this.commonRequest.getTenant();
        return this.drugContrastService.uploadDrugContrast(uploadContrastDto.getIds(), tenantId, uploadContrastDto.getType(), this.commonRequest.getSignNo(), this.commonRequest.getUserId(), this.commonRequest.getUserName());
    }

    @PostMapping(value={"/queryDrugContrast"})
    @ApiOperation(value="\u67e5\u8be2\u5bf9\u7167\u4fe1\u606f")
    public ResponseData queryDrugContrast(@RequestBody SysHsDrugDto sysHsDrugDto) {
        Integer tenantId = this.commonRequest.getTenant();
        sysHsDrugDto.setTenantId(tenantId);
        return this.drugContrastService.queryDrugContrast(sysHsDrugDto);
    }

    @GetMapping(value={"/downloadContrast"})
    @ApiOperation(value="\u4e0b\u8f7d\u5bf9\u7167\u4fe1\u606f1:\u5df2\u5bf9\u7167\uff0c0:\u672a\u5bf9\u7167")
    public void downloadContrast(@RequestParam(value="isContrast", required=true, defaultValue="") String isContrast, @RequestParam(value="searchType", required=true, defaultValue="1") String searchType, HttpServletResponse response) {
        Integer tenantId = this.commonRequest.getTenant();
        this.drugContrastService.downloadContrast(isContrast, searchType, tenantId, response);
    }

    @PostMapping(value={"/importContrast"}, consumes={"multipart/form-data"})
    @ApiOperation(value="\u5bfc\u5165\u5bf9\u7167\u4fe1\u606f")
    public ResponseData importContrast(@RequestParam(value="searchType", required=true, defaultValue="") String type, MultipartFile file) {
        Integer tenantId = this.commonRequest.getTenant();
        List sysHsContrastList = new ArrayList();
        try {
            sysHsContrastList = ExcelUtils.importExcel((MultipartFile)file, (Integer)0, (Integer)1, SysHsContrastExportVo.class);
        }
        catch (IOException e) {
            return ResponseData.error((String)"\u8bfb\u53d6excel\u5f02\u5e38\uff01");
        }
        return this.drugContrastService.importContrast(type, sysHsContrastList, tenantId);
    }

    @UserOptLogger(operation="\u6279\u91cf\u8bbe\u7f6e\u5bf9\u7167\u4fe1\u606f")
    @PostMapping(value={"/batchContrast"})
    @ApiOperation(value="\u6279\u91cf\u8bbe\u7f6e\u5bf9\u7167\u4fe1\u606f")
    public ResponseData batchContrast(@RequestBody List<SysDrugEntity> drugList) {
        return this.drugContrastService.batchContrast(drugList);
    }

    @GetMapping(value={"/downloadTemplate"})
    @ApiOperation(value="\u5bfc\u51fa\u5bf9\u7167\u6a21\u677f", notes="\u5bfc\u51fa\u5bf9\u7167\u6a21\u677f")
    public void downloadImportDrugTemplate(HttpServletResponse response) throws IOException {
        log.info("\u6d4b\u8bd5\u83b7\u53d6\u767b\u5f55\u7528\u6237\u540d\uff1a" + this.commonRequest.getUserName());
        String excelName = "\u836f\u54c1\u5bf9\u7167\u76ee\u5f55";
        String sheetName = "\u836f\u54c1\u76ee\u5f55";
        ArrayList list = new ArrayList();
        ExcelUtils.exportExcel(list, (String)excelName, (String)sheetName, SysHsContrastExportVo.class, (String)excelName, (boolean)true, (HttpServletResponse)response);
    }

    @ApiOperation(value="\u533b\u4fdd\u836f\u54c1\u6279\u91cf\u4e0a\u4f20")
    @PostMapping(value={"/uploadHsDrugExcel"})
    public ResponseData uploadHsDrugExcel(@RequestParam(value="file") MultipartFile file) {
        return this.drugContrastService.hsDrugBatchUpload(file);
    }
}

