/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.mvc.controller.drug;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.sys.api.annotation.AntiRefresh;
import com.byh.sys.api.annotation.UserOptLogger;
import com.byh.sys.api.dto.drug.SysDrugInventoryInDto;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.drug.inventory.SysDrugAccessEntity;
import com.byh.sys.api.model.drug.inventory.SysDrugBatchEntity;
import com.byh.sys.api.model.drug.inventory.SysDrugInventoryCheckEntity;
import com.byh.sys.api.model.drug.inventory.SysDrugInventoryEntity;
import com.byh.sys.api.model.drug.inventory.SysDrugInventoryInEntity;
import com.byh.sys.api.model.drug.inventory.SysDrugInventoryInPrescriptionEntity;
import com.byh.sys.api.model.drug.inventory.SysDrugQcQmEntity;
import com.byh.sys.api.model.drug.inventory.SysDrugSubstanceEntity;
import com.byh.sys.api.model.drug.inventory.SysDrugTogetherEntity;
import com.byh.sys.api.util.BeanUtil;
import com.byh.sys.api.util.ExceptionUtils;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.api.util.UUIDUtils;
import com.byh.sys.data.repository.SysDrugInventoryInPrescriptionMapper;
import com.byh.sys.web.call_function.HsUploadExtend;
import com.byh.sys.web.call_function.SysDrugInventoryExtend;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.PurchaseOrderService;
import com.byh.sys.web.service.SysDrugAccessService;
import com.byh.sys.web.service.SysDrugBatchService;
import com.byh.sys.web.service.SysDrugInventoryCheckService;
import com.byh.sys.web.service.SysDrugInventoryInPrescriptionService;
import com.byh.sys.web.service.SysDrugInventoryInService;
import com.byh.sys.web.service.SysDrugInventoryService;
import com.byh.sys.web.service.SysDrugPharmacyOutTempService;
import com.byh.sys.web.service.SysDrugQcQmService;
import com.byh.sys.web.service.SysDrugSubstanceService;
import com.byh.sys.web.service.SysDrugTogetherService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/drugInventoryIn"})
public class SysDrugInventoryInController {
    private static Logger logger = LoggerFactory.getLogger(SysDrugInventoryInController.class);
    private final CommonRequest commonRequest;
    private final SysDrugInventoryInService drugInventoryInService;
    private final SysDrugInventoryInPrescriptionService drugInventoryInPrescriptionService;
    private final SysDrugInventoryService drugInventoryService;
    private final SysDrugBatchService sysDrugBatchService;
    private final SysDrugQcQmService sysDrugQcQmService;
    private final SysDrugAccessService sysDrugAccessService;
    private final SysDrugInventoryCheckService checkService;
    private final SysDrugSubstanceService drugSubstanceService;
    private final SysDrugTogetherService drugTogetherService;
    private final SysDrugPharmacyOutTempService drugPharmacyOutTempService;
    private final SysDrugInventoryExtend sysDrugInventoryExtend;
    private final HsUploadExtend hsUploadExtend;
    private final SysDrugInventoryInPrescriptionMapper sysDrugInventoryInPrescriptionMapper;
    private PurchaseOrderService purchaseOrderService;

    @ApiOperation(value="\u836f\u54c1\u5165\u5e93\u5bfc\u5165\u64cd\u4f5c")
    @PostMapping(value={"/importDrugInventoryExcel"})
    @UserOptLogger(operation="\u836f\u54c1\u5165\u5e93\u6a21\u5757")
    public ResponseData importDrugInventoryExcel(@RequestPart(value="file") MultipartFile file) throws Exception {
        Integer tenantId = this.commonRequest.getTenant();
        Integer userId = this.commonRequest.getUserId();
        String userName = this.commonRequest.getUserName();
        this.drugInventoryInService.importDrugInventoryExcel(file, tenantId, userId, userName);
        return ResponseData.success((Object)"\u5bfc\u5165\u6210\u529f");
    }

    @ApiOperation(value="\u836f\u5e93\u5165\u5e93\u5206\u9875", httpMethod="GET", notes="\u836f\u5e93\u5165\u5e93\u5206\u9875")
    @GetMapping(value={"/pageList"})
    @AntiRefresh
    public ResponseData pageList(Page page, SysDrugInventoryInDto dto) {
        Integer tenantId = this.commonRequest.getTenant();
        dto.setTenantId(tenantId);
        return ResponseData.success((Object)this.drugInventoryInService.pageList(page, dto));
    }

    @PostMapping(value={"/saveUpdate"})
    @Transactional(rollbackFor={Exception.class})
    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539", httpMethod="POST", notes="\u65b0\u589e\u6216\u4fee\u6539")
    public ResponseData saveUpdate(@RequestBody SysDrugInventoryInDto dto) {
        List list = this.checkService.list((Wrapper)Wrappers.lambdaQuery().eq(SysDrugInventoryCheckEntity::getAuditStatus, (Object)"2"));
        if (list.size() > 0) {
            throw new BusinessException("\u5f53\u524d\u836f\u5e93\u6b63\u5728\u76d8\u70b9\u4e2d\uff0c\u4e0d\u80fd\u8fdb\u884c\u5165\u5e93\u64cd\u4f5c\uff01{list}");
        }
        SysDrugInventoryInEntity entity = (SysDrugInventoryInEntity)BeanUtil.copy((Object)dto, SysDrugInventoryInEntity.class);
        Integer tenantId = this.commonRequest.getTenant();
        Integer userId = this.commonRequest.getUserId();
        String userName = this.commonRequest.getUserName();
        if (StrUtil.isEmpty((CharSequence)entity.getId())) {
            this.sysDrugInventoryExtend.checkDrugInventorySave(entity.getOrderid());
            String guiID = UUIDUtils.getRandom((int)5, (boolean)true);
            if (StrUtil.isEmpty((CharSequence)dto.getSupplierId()) && StrUtil.isEmpty((CharSequence)dto.getSupplierName())) {
                throw new BusinessException("\u4f9b\u5e94\u5546id\u548c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01{supplierId,supplierName}");
            }
            entity.setWarehousingUse(userName);
            entity.setId(guiID);
            entity.setTenantId(tenantId);
            entity.setCreateTime(new Date());
            entity.setCreateId(userId);
            this.drugInventoryInService.save((Object)entity);
        } else {
            entity.setUpdateId(userId);
            entity.setUpdateTime(new Date());
            this.drugInventoryInService.saveOrUpdate((Object)entity);
            this.drugInventoryInPrescriptionService.remove((Wrapper)Wrappers.lambdaQuery().eq(SysDrugInventoryInPrescriptionEntity::getDrugInventoryInId, (Object)dto.getId()));
        }
        List drugInPreList = dto.getDrugInPreList();
        if (ObjectUtil.isNull((Object)drugInPreList)) {
            throw new BusinessException("\u836f\u5e93\u5165\u5e93-\u9644\u8868\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01{drugInPreList}");
        }
        drugInPreList.forEach(a -> {
            String uuID = UUIDUtils.getRandom((int)5, (boolean)true);
            a.setId(uuID);
            a.setDrugInventoryInId(entity.getId());
            a.setSupplierId(dto.getSupplierId());
            a.setSupplierName(dto.getSupplierName());
        });
        List sysDrugEntities = BeanUtil.copyList((List)drugInPreList, SysDrugInventoryInPrescriptionEntity.class);
        this.drugInventoryInPrescriptionService.saveBatch((Collection)sysDrugEntities, 2000);
        this.drugTogetherService.remove((Wrapper)Wrappers.lambdaQuery().eq(SysDrugTogetherEntity::getDrugInventoryInId, (Object)entity.getId()));
        SysDrugTogetherEntity together = new SysDrugTogetherEntity();
        String uuID = UUIDUtils.getRandom((int)5, (boolean)true);
        together.setId(uuID);
        together.setDrugInventoryInId(entity.getId());
        together.setPurchaseAmount(entity.getPurchaseAmount());
        together.setRetailAmount(entity.getRetailAmount());
        together.setTenantId(tenantId);
        together.setStatus("0");
        this.drugTogetherService.saveOrUpdate((Object)together);
        String drugPharmacyOutId = dto.getDrugPharmacyOutId();
        if (StrUtil.isNotEmpty((CharSequence)drugPharmacyOutId)) {
            this.drugPharmacyOutTempService.updateDelFlag(drugPharmacyOutId, tenantId);
        }
        return ResponseData.success().saveUpdate();
    }

    @GetMapping(value={"/details"})
    @ApiOperation(value="\u8be6\u60c5", httpMethod="GET", notes="\u8be6\u60c5")
    @AntiRefresh
    public ResponseData details(SysDrugInventoryInEntity entity) {
        entity.setTenantId(this.commonRequest.getTenant());
        List list = this.drugInventoryInPrescriptionService.inPrescriptionList(entity);
        return ResponseData.success((Object)list);
    }

    @UserOptLogger(operation="\u836f\u5e93\u5165\u5e93\u8865\u5f55\u53d1\u7968")
    @GetMapping(value={"/invoice"})
    @ApiOperation(value="\u8865\u5f55\u53d1\u7968", httpMethod="GET", notes="\u8865\u5f55\u53d1\u7968")
    public ResponseData invoice(SysDrugInventoryInEntity entity) {
        if (StrUtil.isEmpty((CharSequence)entity.getId())) {
            throw new BusinessException("\u5165\u5e93\u8868\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a\uff01{id}");
        }
        if (StrUtil.isEmpty((CharSequence)entity.getInvoiceNumber())) {
            throw new BusinessException("\u5165\u5e93\u8868\u53d1\u7968\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01{invoiceNumber}");
        }
        this.drugInventoryInService.update((Object)entity, (Wrapper)Wrappers.lambdaQuery().eq(SysDrugInventoryInEntity::getId, (Object)entity.getId()));
        return ResponseData.success().msg("\u53d1\u7968\u8865\u5f55\u6210\u529f");
    }

    @UserOptLogger(operation="\u836f\u5e93\u5165\u5e93\u5ba1\u6838\u72b6\u6001")
    @GetMapping(value={"/auditStatus"})
    @Transactional(rollbackFor={Exception.class})
    @ApiOperation(value="\u836f\u5e93\u5165\u5e93\u5ba1\u6838\u72b6\u6001", httpMethod="GET", notes="\u836f\u5e93\u5165\u5e93\u5ba1\u6838\u72b6\u6001")
    public ResponseData auditStatus(SysDrugInventoryInEntity entity) {
        if (StrUtil.isEmpty((CharSequence)entity.getId())) {
            throw new BusinessException("\u5165\u5e93\u8868\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a\uff01{id}");
        }
        entity.setTenantId(this.commonRequest.getTenant());
        Integer userId = this.commonRequest.getUserId();
        String userName = this.commonRequest.getUserName();
        String auditStatus = entity.getAuditStatus();
        if ("2".equals(auditStatus)) {
            SysDrugInventoryInEntity byId = (SysDrugInventoryInEntity)this.drugInventoryInService.getById((Serializable)entity);
            Date date = new Date();
            SysDrugInventoryInEntity one = (SysDrugInventoryInEntity)this.drugInventoryInService.getOne((Wrapper)Wrappers.lambdaQuery().eq(SysDrugInventoryInEntity::getId, (Object)entity.getId()));
            ExceptionUtils.createException((Logger)logger, (boolean)Objects.isNull(one), (String)"500", (String)("\u836f\u5e93\u5165\u5e93\u786e\u8ba4\u3010\u5355\u53f7\uff1a" + byId + "\u3011\u672a\u627e\u5230"));
            ExceptionUtils.createException((Logger)logger, (boolean)"2".equals(one.getAuditStatus()), (String)"500", (String)"\u5df2\u7ecf\u786e\u8ba4\u8fc7,\u8fd4\u56de\u5165\u5e93\u7ba1\u7406\u67e5\u770b\u72b6\u6001");
            this.sysDrugInventoryExtend.confirmPurchaseOrderIn(one.getOrderid());
            ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            RequestContextHolder.setRequestAttributes((RequestAttributes)servletRequestAttributes, (boolean)true);
            CompletableFuture.runAsync(() -> {
                try {
                    this.hsUploadExtend.medicationInContext(one.getId(), userName);
                }
                catch (Exception e) {
                    logger.info("\u5165\u5e93\u4e4b\u540e\u5411\u533b\u4fdd\u63a8\u9001\u6570\u636e\u8fd4\u56de\u7ed3\u679c\u96c6=======================================" + e.getMessage());
                    throw new RuntimeException(e.getMessage());
                }
            });
            if (StrUtil.isEmptyIfStr((Object)byId)) {
                return ResponseData.success().notQuery();
            }
            List listP = this.drugInventoryInPrescriptionService.inPrescList(entity);
            List drugSubstanceList = BeanUtil.copyList((List)listP, SysDrugSubstanceEntity.class);
            this.drugSubstanceService.saveBatch((Collection)drugSubstanceList, 2000);
            List drugAccessList = BeanUtil.copyList((List)listP, SysDrugAccessEntity.class);
            drugAccessList.forEach(a -> {
                a.setId(UUIDUtils.getRandom((int)5, (boolean)true));
                a.setWayTime(date);
            });
            this.sysDrugAccessService.saveBatch((Collection)drugAccessList);
            if (ObjectUtil.isNotNull((Object)listP)) {
                listP.forEach(a -> {
                    logger.info("============\u5f00\u59cb==========\u63d2\u5165\u836f\u5e93\u8868\u3010sys_drug_inventory\u3011==============");
                    this.saveDrugInventory(a, byId);
                    logger.info("============\u5f00\u59cb==========\u63d2\u5165\u671f\u521d\u671f\u672b\u8868\u3010sys_drug_qc_qm\u3011==============");
                    this.saveDrugQcQm(a);
                    logger.info("============\u5f00\u59cb==========\u63d2\u5165 \u836f\u5e93\u6279\u6b21\u8868\u3010sys_drug_batch\u3011==============");
                    this.saveDrugBatch(a, byId.getWarehousingWarehouse(), byId.getId());
                });
            }
            SysDrugTogetherEntity together = new SysDrugTogetherEntity();
            together.setStatus("1");
            together.setConfirmTime(date);
            this.drugTogetherService.saveOrUpdate((Object)together, (Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugTogetherEntity::getDrugInventoryInId, (Object)entity.getId())).eq(SysDrugTogetherEntity::getTenantId, (Object)this.commonRequest.getTenant()));
            entity.setConfirmTime(date);
        }
        entity.setReviewedBy(userName);
        this.drugInventoryInService.update((Object)entity, (Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugInventoryInEntity::getId, (Object)entity.getId())).eq(SysDrugInventoryInEntity::getTenantId, (Object)this.commonRequest.getTenant()));
        logger.info("-----\u6574\u4f53------\u7ed3\u675f----------");
        return ResponseData.success().alreadyUpdateStatus();
    }

    private void saveDrugSubstance(SysDrugInventoryInPrescriptionEntity a, SysDrugInventoryInEntity byId) {
        if (!StrUtil.isEmptyIfStr((Object)byId)) {
            String id = byId.getId();
            Date warehousingTime = byId.getWarehousingTime();
            String warehousingMethod = byId.getWarehousingMethod();
            String supplierId = byId.getSupplierId();
            String supplierName = byId.getSupplierName();
            String warehousingWarehouse = byId.getWarehousingWarehouse();
            BigDecimal purchasePrice = a.getPurchasePrice();
            BigDecimal retailPrice = a.getRetailPrice();
            Integer drugNum = a.getDrugNum();
            BigDecimal purchaseJ = purchasePrice.multiply(BigDecimal.valueOf(drugNum.intValue()));
            BigDecimal retailJ = retailPrice.multiply(BigDecimal.valueOf(drugNum.intValue()));
            SysDrugSubstanceEntity substanceEntity = new SysDrugSubstanceEntity();
            substanceEntity.setOddNumbers(id);
            substanceEntity.setWarehousingTime(warehousingTime);
            substanceEntity.setDrugId(a.getDrugId());
            substanceEntity.setDrugName(a.getDrugName());
            substanceEntity.setSpecifications(a.getSpecifications());
            substanceEntity.setDrugType(a.getDrugsType());
            substanceEntity.setWarehousingMethod(warehousingMethod);
            substanceEntity.setSupplierDepartmentId(supplierId);
            substanceEntity.setSupplierDepartmentName(supplierName);
            substanceEntity.setDrugNum(drugNum);
            substanceEntity.setUnit(a.getUnit());
            substanceEntity.setPurchasePrice(purchasePrice);
            substanceEntity.setRetailPrice(retailPrice);
            substanceEntity.setPurchaseAmount(purchaseJ);
            substanceEntity.setRetailAmount(retailJ);
            substanceEntity.setBatchNumber(a.getBatchNumber());
            substanceEntity.setOperateTime(new Date());
            substanceEntity.setEffectiveTime(a.getEffectiveTime());
            substanceEntity.setWarehousingWarehouse(warehousingWarehouse);
            substanceEntity.setTenantId(this.commonRequest.getTenant());
            this.drugSubstanceService.save((Object)substanceEntity);
        }
    }

    private void saveDruAccess(SysDrugInventoryInPrescriptionEntity a, SysDrugInventoryInEntity byId) {
        String warehousingMethod = byId.getWarehousingMethod();
        String uuid = UUIDUtils.getRandom((int)5, (boolean)true);
        Integer tenantId = this.commonRequest.getTenant();
        SysDrugAccessEntity drugAccessEntity = new SysDrugAccessEntity();
        drugAccessEntity.setId(uuid);
        drugAccessEntity.setWayType(warehousingMethod);
        drugAccessEntity.setWayTime(byId.getWarehousingTime());
        drugAccessEntity.setWayNom(byId.getId());
        drugAccessEntity.setNumber(a.getDrugNum());
        drugAccessEntity.setUnit(a.getUnit());
        drugAccessEntity.setBatchNumber(a.getBatchNumber());
        drugAccessEntity.setEffectiveTime(a.getEffectiveTime());
        drugAccessEntity.setTenantId(tenantId);
        drugAccessEntity.setDrugId(a.getDrugId());
        drugAccessEntity.setDrugName(a.getDrugName());
        this.sysDrugAccessService.save((Object)drugAccessEntity);
    }

    private void saveDrugBatch(SysDrugInventoryInPrescriptionEntity a, String warehousingWarehouse, String id) {
        Integer tenantId = this.commonRequest.getTenant();
        Integer userId = this.commonRequest.getUserId();
        SysDrugBatchEntity batchEntity = new SysDrugBatchEntity();
        String uuid = UUIDUtils.getRandom((int)5, (boolean)true);
        Integer drugNum = a.getDrugNum();
        BigDecimal purchasePrice = a.getPurchasePrice();
        BigDecimal retailPrice = a.getRetailPrice();
        SysDrugBatchEntity one = (SysDrugBatchEntity)this.sysDrugBatchService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugBatchEntity::getDrugInventoryInId, (Object)id)).eq(SysDrugBatchEntity::getDrugId, (Object)a.getDrugId())).eq(SysDrugBatchEntity::getPurchasePrice, (Object)a.getPurchasePrice())).eq(SysDrugBatchEntity::getEffectiveTime, (Object)a.getEffectiveTime())).eq(SysDrugBatchEntity::getBatchNumber, (Object)a.getBatchNumber())).last("limit 1"));
        if (StrUtil.isEmptyIfStr((Object)one)) {
            BigDecimal purchaseAmount = purchasePrice.multiply(BigDecimal.valueOf(drugNum.intValue()));
            BigDecimal retailAmount = retailPrice.multiply(BigDecimal.valueOf(drugNum.intValue()));
            batchEntity.setId(uuid);
            batchEntity.setDrugId(a.getDrugId());
            batchEntity.setDrugName(a.getDrugName());
            batchEntity.setBatchNumber(a.getBatchNumber());
            batchEntity.setEffectiveTime(a.getEffectiveTime());
            batchEntity.setBookInventory(drugNum);
            batchEntity.setPurchasePrice(purchasePrice);
            batchEntity.setPurchaseAmount(purchaseAmount);
            batchEntity.setRetailPrice(retailPrice);
            batchEntity.setRetailAmount(retailAmount);
            batchEntity.setTenantId(tenantId);
            batchEntity.setCreateId(userId);
            batchEntity.setCreateTime(new Date());
            batchEntity.setUpdateId(userId);
            batchEntity.setUpdateTime(new Date());
            batchEntity.setMedicalInsuranceCode(a.getMedicalInsuranceCode());
            batchEntity.setMedicalInsuranceName(a.getMedicalInsuranceName());
            batchEntity.setLevel(a.getLevel());
            batchEntity.setUnit(a.getUnit());
            batchEntity.setManufacturer(a.getManufacturer());
            batchEntity.setSpecifications(a.getSpecifications());
            batchEntity.setDrugsType(a.getDrugsType());
            batchEntity.setWarehousingWarehouse(warehousingWarehouse);
            batchEntity.setDrugInventoryInId(id);
            batchEntity.setApprovalNumber(a.getApprovalNumber());
            batchEntity.setSupplierId(a.getSupplierId());
            batchEntity.setSupplierName(a.getSupplierName());
            batchEntity.setInternalCode(a.getInternalCode());
            batchEntity.setThirdCode(a.getThirdCode());
            this.sysDrugBatchService.save((Object)batchEntity);
        } else {
            Integer bookInventory = one.getBookInventory();
            int num = bookInventory + drugNum;
            BigDecimal purchaseAmount = purchasePrice.multiply(BigDecimal.valueOf(num));
            BigDecimal retailAmount = retailPrice.multiply(BigDecimal.valueOf(num));
            batchEntity.setBookInventory(Integer.valueOf(num));
            batchEntity.setPurchaseAmount(purchaseAmount);
            batchEntity.setRetailAmount(retailAmount);
            this.sysDrugBatchService.update((Object)batchEntity, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugBatchEntity::getDrugInventoryInId, (Object)id)).eq(SysDrugBatchEntity::getDrugId, (Object)a.getDrugId())).eq(SysDrugBatchEntity::getBatchNumber, (Object)a.getBatchNumber())).eq(SysDrugBatchEntity::getEffectiveTime, (Object)a.getEffectiveTime())).eq(SysDrugBatchEntity::getPurchasePrice, (Object)a.getPurchasePrice()));
        }
    }

    private void saveDrugQcQm(SysDrugInventoryInPrescriptionEntity a) {
        SysDrugQcQmEntity cm = new SysDrugQcQmEntity();
        Integer tenantId = this.commonRequest.getTenant();
        Integer userId = this.commonRequest.getUserId();
        String uuid = UUIDUtils.getRandom((int)5, (boolean)true);
        LocalDate currentDate = LocalDate.now();
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String dateString = currentDate.format(dtf);
        String startTime = dateString + " 00:00:00";
        String endTime = dateString + " 23:59:59";
        SysDrugQcQmEntity one = (SysDrugQcQmEntity)this.sysDrugQcQmService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugQcQmEntity::getDrugId, (Object)a.getDrugId())).eq(SysDrugQcQmEntity::getTenantId, (Object)tenantId)).between(SysDrugQcQmEntity::getInTime, (Object)startTime, (Object)endTime)).last(" limit 1"));
        if (StrUtil.isEmptyIfStr((Object)one)) {
            cm.setId(uuid);
            cm.setDrugId(a.getDrugId());
            cm.setDrugName(a.getDrugName());
            cm.setDrugProperties(a.getDrugProperties());
            cm.setSpecifications(a.getSpecifications());
            cm.setManufacturer(a.getManufacturer());
            cm.setUnit(a.getUnit());
            Integer drugNum = a.getDrugNum();
            BigDecimal purchasePrice = a.getPurchasePrice();
            BigDecimal purchaseAmount = purchasePrice.multiply(BigDecimal.valueOf(drugNum.intValue()));
            BigDecimal retailPrice = a.getRetailPrice();
            BigDecimal multiplyAmount = retailPrice.multiply(BigDecimal.valueOf(drugNum.intValue()));
            cm.setInNum(drugNum);
            cm.setInProcureAmount(purchaseAmount);
            cm.setInRetailAmount(multiplyAmount);
            cm.setOutNum(Integer.valueOf(0));
            cm.setOutProcureAmount(BigDecimal.ZERO);
            cm.setOutRetailAmount(BigDecimal.ZERO);
            cm.setOpening(Integer.valueOf(0));
            cm.setOpeningProcureAmount(BigDecimal.ZERO);
            cm.setOpeningRetailAmount(BigDecimal.ZERO);
            cm.setTerminal(Integer.valueOf(0));
            cm.setTerminalProcureAmount(BigDecimal.ZERO);
            cm.setTerminalRetailAmount(BigDecimal.ZERO);
            cm.setWeightedMean(BigDecimal.ZERO);
            cm.setTenantId(tenantId);
            cm.setCreateTime(new Date());
            cm.setInTime(new Date());
            cm.setCreateId(userId);
            this.sysDrugQcQmService.save((Object)cm);
        } else {
            Integer drugNum = a.getDrugNum();
            BigDecimal purchasePrice = a.getPurchasePrice();
            BigDecimal purchaseAmount = purchasePrice.multiply(BigDecimal.valueOf(drugNum.intValue()));
            BigDecimal retailPrice = a.getRetailPrice();
            BigDecimal multiplyAmount = retailPrice.multiply(BigDecimal.valueOf(drugNum.intValue()));
            BigDecimal inP = one.getInProcureAmount().add(purchaseAmount);
            BigDecimal inR = one.getInRetailAmount().add(multiplyAmount);
            Integer in = one.getInNum() + drugNum;
            cm.setInNum(in);
            cm.setInProcureAmount(inP);
            cm.setInRetailAmount(inR);
            cm.setInTime(new Date());
            this.sysDrugQcQmService.update((Object)cm, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugQcQmEntity::getDrugId, (Object)a.getDrugId())).between(SysDrugQcQmEntity::getInTime, (Object)startTime, (Object)endTime)).last(" limit 1"));
        }
    }

    private void saveDrugInventory(SysDrugInventoryInPrescriptionEntity a, SysDrugInventoryInEntity byId) {
        Integer tenantId = this.commonRequest.getTenant();
        Integer userId = this.commonRequest.getUserId();
        SysDrugInventoryEntity one = (SysDrugInventoryEntity)this.drugInventoryService.getOne((Wrapper)Wrappers.lambdaQuery().eq(SysDrugInventoryEntity::getDrugId, (Object)a.getDrugId()));
        SysDrugInventoryEntity copy = (SysDrugInventoryEntity)BeanUtil.copy((Object)a, SysDrugInventoryEntity.class);
        if (StrUtil.isEmptyIfStr((Object)one)) {
            String guiID = UUIDUtils.getRandom((int)5, (boolean)true);
            copy.setId(guiID);
            copy.setMedicalInsuranceCode(a.getMedicalInsuranceCode());
            copy.setMedicalInsuranceName(a.getMedicalInsuranceName());
            copy.setLevel(a.getLevel());
            copy.setDrugId(a.getDrugId());
            copy.setDrugName(a.getDrugName());
            copy.setSpecifications(a.getSpecifications());
            copy.setManufacturer(a.getManufacturer());
            copy.setActualInventory(a.getDrugNum());
            BigDecimal purchasePrice = a.getPurchasePrice();
            BigDecimal purchaseAmount = purchasePrice.multiply(BigDecimal.valueOf(a.getDrugNum().intValue()));
            BigDecimal retailPrice = a.getRetailPrice();
            BigDecimal retailPriceAmount = retailPrice.multiply(BigDecimal.valueOf(a.getDrugNum().intValue()));
            List list = this.sysDrugBatchService.list((Wrapper)Wrappers.lambdaQuery().eq(SysDrugBatchEntity::getDrugId, (Object)a.getDrugId()));
            BigDecimal countPurchase = list.stream().map(SysDrugBatchEntity::getPurchaseAmount).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            BigDecimal add = purchaseAmount.add(countPurchase);
            copy.setPurchaseAmount(add);
            copy.setPurchasePrice(purchasePrice);
            BigDecimal retailAmount = list.stream().map(SysDrugBatchEntity::getRetailAmount).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            BigDecimal add1 = retailPriceAmount.add(retailAmount);
            copy.setRetailAmount(add1);
            copy.setRetailPrice(retailPrice);
            copy.setDrugsType(a.getDrugsType());
            copy.setDrugProperties(a.getDrugProperties());
            copy.setWarehousingWarehouse(byId.getWarehousingWarehouse());
            copy.setTenantId(tenantId);
            copy.setCreateTime(new Date());
            copy.setCreateId(userId);
            copy.setLaunch(Integer.valueOf(1000));
            copy.setOffline(Integer.valueOf(0));
            this.drugInventoryService.save((Object)copy);
        } else {
            copy.setUpdateTime(new Date());
            Integer actualInventory = one.getActualInventory();
            Integer drugNum = a.getDrugNum();
            Integer realityNum = actualInventory + drugNum;
            copy.setActualInventory(realityNum);
            BigDecimal purchasePrice = a.getPurchasePrice();
            BigDecimal amountPurchase = purchasePrice.multiply(BigDecimal.valueOf(drugNum.intValue()));
            BigDecimal retailPrice = a.getRetailPrice();
            BigDecimal amountRetail = retailPrice.multiply(BigDecimal.valueOf(drugNum.intValue()));
            List list = this.sysDrugBatchService.list((Wrapper)Wrappers.lambdaQuery().eq(SysDrugBatchEntity::getDrugId, (Object)a.getDrugId()));
            BigDecimal purchaseAmount = list.stream().map(SysDrugBatchEntity::getPurchaseAmount).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            copy.setPurchaseAmount(purchaseAmount.add(amountPurchase));
            BigDecimal retailAmount = list.stream().map(SysDrugBatchEntity::getRetailAmount).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            copy.setRetailAmount(retailAmount.add(amountRetail));
            this.drugInventoryService.update((Object)copy, (Wrapper)Wrappers.lambdaQuery().eq(SysDrugInventoryEntity::getDrugId, (Object)a.getDrugId()));
        }
    }

    @UserOptLogger(operation="\u836f\u5e93\u5165\u5e93\u6a21\u5757")
    @PostMapping(value={"/removeDrugInventoryIn"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", httpMethod="POST", notes="\u6279\u91cf\u5220\u9664")
    public ResponseData removeDrugInventoryIn(@ApiParam(value="\u4e3b\u952e\u96c6\u5408", required=true) @RequestBody String[] ids) {
        return ResponseData.success((Object)this.drugInventoryInService.removeDrugInventoryIn(ids)).delete();
    }

    @UserOptLogger(operation="\u836f\u5e93\u5165\u5e93\u6a21\u5757")
    @PostMapping(value={"/in/import"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", httpMethod="POST", notes="\u6279\u91cf\u5220\u9664")
    public ResponseData sysDrugInventoryInImport(@RequestPart(value="file") MultipartFile file) throws Exception {
        List list = this.drugInventoryInService.sysDrugInventoryInImport(file);
        return ResponseData.success((Object)list);
    }

    public SysDrugInventoryInController(CommonRequest commonRequest, SysDrugInventoryInService drugInventoryInService, SysDrugInventoryInPrescriptionService drugInventoryInPrescriptionService, SysDrugInventoryService drugInventoryService, SysDrugBatchService sysDrugBatchService, SysDrugQcQmService sysDrugQcQmService, SysDrugAccessService sysDrugAccessService, SysDrugInventoryCheckService checkService, SysDrugSubstanceService drugSubstanceService, SysDrugTogetherService drugTogetherService, SysDrugPharmacyOutTempService drugPharmacyOutTempService, SysDrugInventoryExtend sysDrugInventoryExtend, HsUploadExtend hsUploadExtend, SysDrugInventoryInPrescriptionMapper sysDrugInventoryInPrescriptionMapper) {
        this.commonRequest = commonRequest;
        this.drugInventoryInService = drugInventoryInService;
        this.drugInventoryInPrescriptionService = drugInventoryInPrescriptionService;
        this.drugInventoryService = drugInventoryService;
        this.sysDrugBatchService = sysDrugBatchService;
        this.sysDrugQcQmService = sysDrugQcQmService;
        this.sysDrugAccessService = sysDrugAccessService;
        this.checkService = checkService;
        this.drugSubstanceService = drugSubstanceService;
        this.drugTogetherService = drugTogetherService;
        this.drugPharmacyOutTempService = drugPharmacyOutTempService;
        this.sysDrugInventoryExtend = sysDrugInventoryExtend;
        this.hsUploadExtend = hsUploadExtend;
        this.sysDrugInventoryInPrescriptionMapper = sysDrugInventoryInPrescriptionMapper;
    }
}

