/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.mvc.controller.drug;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.sys.api.annotation.AntiRefresh;
import com.byh.sys.api.annotation.UserOptLogger;
import com.byh.sys.api.dto.drug.SysDrugInventoryOutDto;
import com.byh.sys.api.enums.DictEnums;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.drug.inventory.SysDrugAccessEntity;
import com.byh.sys.api.model.drug.inventory.SysDrugBatchEntity;
import com.byh.sys.api.model.drug.inventory.SysDrugInventoryCheckEntity;
import com.byh.sys.api.model.drug.inventory.SysDrugInventoryEntity;
import com.byh.sys.api.model.drug.inventory.SysDrugInventoryOutEntity;
import com.byh.sys.api.model.drug.inventory.SysDrugInventoryOutPrescriptionEntity;
import com.byh.sys.api.model.drug.inventory.SysDrugQcQmEntity;
import com.byh.sys.api.model.drug.inventory.SysDrugSubstanceEntity;
import com.byh.sys.api.util.BeanUtil;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.api.util.UUIDUtils;
import com.byh.sys.web.call_function.HsUploadExtend;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.SysDrugAccessService;
import com.byh.sys.web.service.SysDrugBatchService;
import com.byh.sys.web.service.SysDrugInventoryCheckService;
import com.byh.sys.web.service.SysDrugInventoryOutPrescriptionService;
import com.byh.sys.web.service.SysDrugInventoryOutService;
import com.byh.sys.web.service.SysDrugInventoryOutTempService;
import com.byh.sys.web.service.SysDrugInventoryService;
import com.byh.sys.web.service.SysDrugQcQmService;
import com.byh.sys.web.service.SysDrugSubstanceService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/drugInventoryOut"})
public class SysDrugInventoryOutController {
    private final SysDrugInventoryOutTempService sysDrugInventoryOutTempService;
    private static Logger logger = LoggerFactory.getLogger(SysDrugInventoryOutController.class);
    private final CommonRequest commonRequest;
    private final SysDrugInventoryOutService drugInventoryOutService;
    private final SysDrugInventoryOutPrescriptionService outPrescriptionService;
    private final SysDrugInventoryService drugInventoryService;
    private final SysDrugQcQmService sysDrugQcQmService;
    private final SysDrugBatchService sysDrugBatchService;
    private final SysDrugAccessService sysDrugAccessService;
    private final SysDrugInventoryCheckService checkService;
    private final SysDrugSubstanceService drugSubstanceService;
    private final HsUploadExtend hsUploadExtend;

    @ApiOperation(value="\u836f\u5e93\u51fa\u5e93\u5206\u9875", httpMethod="GET", notes="\u836f\u5e93\u51fa\u5e93\u5206\u9875")
    @GetMapping(value={"/pageList"})
    @AntiRefresh
    public ResponseData pageList(Page page, SysDrugInventoryOutDto dto) {
        Integer tenantId = this.commonRequest.getTenant();
        dto.setTenantId(tenantId);
        return ResponseData.success((Object)this.drugInventoryOutService.pageList(page, dto));
    }

    @PostMapping(value={"/saveUpdate"})
    @Transactional(rollbackFor={Exception.class})
    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539", httpMethod="POST", notes="\u65b0\u589e\u6216\u4fee\u6539")
    public ResponseData saveUpdate(@RequestBody SysDrugInventoryOutDto dto) {
        List list = this.checkService.list((Wrapper)Wrappers.lambdaQuery().eq(SysDrugInventoryCheckEntity::getAuditStatus, (Object)"2"));
        if (list.size() > 0) {
            throw new BusinessException("\u5f53\u524d\u836f\u5e93\u6b63\u5728\u76d8\u70b9\u4e2d\uff0c\u4e0d\u80fd\u8fdb\u884c\u51fa\u5e93\u64cd\u4f5c\uff01{list}");
        }
        SysDrugInventoryOutEntity entity = (SysDrugInventoryOutEntity)BeanUtil.copy((Object)dto, SysDrugInventoryOutEntity.class);
        Integer tenantId = this.commonRequest.getTenant();
        String userName = this.commonRequest.getUserName();
        if (StrUtil.isEmpty((CharSequence)entity.getId())) {
            String guiID = UUIDUtils.getRandom((int)5, (boolean)true);
            entity.setId(guiID);
            entity.setCreateTime(new Date());
            entity.setTenantId(tenantId);
            entity.setOutboundUse(userName);
            this.drugInventoryOutService.save((Object)entity);
        } else {
            this.drugInventoryOutService.saveOrUpdate((Object)entity);
            this.outPrescriptionService.remove((Wrapper)Wrappers.lambdaQuery().eq(SysDrugInventoryOutPrescriptionEntity::getDrugInventoryOutId, (Object)dto.getId()));
        }
        List drugOutPreList = dto.getDrugInPreList();
        if (drugOutPreList.size() <= 0) {
            throw new BusinessException("\u836f\u5e93\u51fa\u5e93-\u9644\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01{drugOutPreList}");
        }
        drugOutPreList.forEach(a -> {
            String uuID = UUIDUtils.getRandom((int)5, (boolean)true);
            a.setId(uuID);
            a.setTenantId(tenantId);
            a.setDrugInventoryOutId(entity.getId());
        });
        List sysDrugEntities = BeanUtil.copyList((List)drugOutPreList, SysDrugInventoryOutPrescriptionEntity.class);
        this.outPrescriptionService.saveBatch((Collection)sysDrugEntities, 2000);
        return ResponseData.success().saveUpdate();
    }

    @GetMapping(value={"/details"})
    @ApiOperation(value="\u8be6\u60c5", httpMethod="GET", notes="\u8be6\u60c5")
    @AntiRefresh
    public ResponseData details(SysDrugInventoryOutEntity entity) {
        List list = this.outPrescriptionService.list((Wrapper)Wrappers.lambdaQuery().eq(SysDrugInventoryOutPrescriptionEntity::getDrugInventoryOutId, (Object)entity.getId()));
        return ResponseData.success((Object)list);
    }

    @GetMapping(value={"/auditStatus"})
    @Transactional(rollbackFor={Exception.class})
    @ApiOperation(value="\u836f\u5e93\u51fa\u5e93\u5ba1\u6838\u72b6\u6001", httpMethod="GET", notes="\u836f\u5e93\u51fa\u5e93\u5ba1\u6838\u72b6\u6001")
    public ResponseData auditStatus(SysDrugInventoryOutEntity entity) {
        if (StrUtil.isEmpty((CharSequence)entity.getId())) {
            throw new BusinessException("\u51fa\u5e93\u8868\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a\uff01{id}");
        }
        String auditStatus = entity.getAuditStatus();
        if ("2".equals(auditStatus)) {
            SysDrugInventoryOutEntity byId = (SysDrugInventoryOutEntity)this.drugInventoryOutService.getById((Serializable)entity);
            Date date = new Date();
            SysDrugInventoryOutEntity one = (SysDrugInventoryOutEntity)this.drugInventoryOutService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugInventoryOutEntity::getId, (Object)byId.getId())).eq(SysDrugInventoryOutEntity::getAuditStatus, (Object)"2"));
            if (!StrUtil.isEmptyIfStr((Object)one)) {
                return ResponseData.success().msg("\u5df2\u7ecf\u786e\u8ba4\u8fc7,\u8fd4\u56de\u51fa\u5e93\u7ba1\u7406\u67e5\u770b\u72b6\u6001");
            }
            if (DictEnums.OUT_BOUND_METHOD_1.getCode().equals(entity.getOutboundMethod())) {
                this.sysDrugInventoryOutTempService.sysDrugInventoryOutTempSave(byId);
            }
            if (DictEnums.OUT_BOUND_METHOD_10.getCode().equals(entity.getOutboundMethod())) {
                this.hsUploadExtend.purchaseReturnContext(byId);
            }
            List listP = this.outPrescriptionService.outPrescList(entity);
            List drugSubstanceList = BeanUtil.copyList((List)listP, SysDrugSubstanceEntity.class);
            this.drugSubstanceService.saveBatch((Collection)drugSubstanceList, 2000);
            List drugAccessList = BeanUtil.copyList((List)listP, SysDrugAccessEntity.class);
            drugAccessList.forEach(a -> {
                a.setId(UUIDUtils.getRandom((int)5, (boolean)true));
                a.setWayTime(date);
            });
            this.sysDrugAccessService.saveBatch((Collection)drugAccessList);
            if (ObjectUtil.isNotNull((Object)listP)) {
                listP.forEach(a -> {
                    logger.info("============\u5f00\u59cb==========\u4fee\u6539\u836f\u5e93\u8868\u3010sys_drug_inventory\u3011==============");
                    this.updateDrugInventory(a);
                    logger.info("============\u5f00\u59cb==========\u671f\u521d\u671f\u672b\u8868\u3010sys_drug_qc_qm\u3011==============");
                    this.updateDrugQcQm(a, byId);
                    logger.info("============\u5f00\u59cb==========\u836f\u5e93\u6279\u6b21\u8868\u3010sys_drug_batch\u3011==============");
                    this.updateDrugBatch(a);
                });
            }
            entity.setConfirmTime(date);
        }
        String userName = this.commonRequest.getUserName();
        entity.setCompositeUse(userName);
        this.drugInventoryOutService.update((Object)entity, (Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugInventoryOutEntity::getId, (Object)entity.getId())).eq(SysDrugInventoryOutEntity::getTenantId, (Object)this.commonRequest.getTenant()));
        return ResponseData.success().alreadyUpdateStatus();
    }

    private void saveDrugSubstance(SysDrugInventoryOutPrescriptionEntity a, SysDrugInventoryOutEntity byId) {
        String id = byId.getId();
        Date outboundTime = byId.getOutboundTime();
        String outboundMethod = byId.getOutboundMethod();
        String supplierId = byId.getSupplierId();
        String supplierName = byId.getSupplierName();
        String outboundWarehouse = byId.getOutboundWarehouse();
        BigDecimal purchasePrice = a.getPurchasePrice();
        BigDecimal retailPrice = a.getRetailPrice();
        Integer drugNum = a.getDrugNum();
        BigDecimal purchaseJ = purchasePrice.multiply(BigDecimal.valueOf(drugNum.intValue()));
        BigDecimal retailJ = retailPrice.multiply(BigDecimal.valueOf(drugNum.intValue()));
        SysDrugSubstanceEntity substanceEntity = new SysDrugSubstanceEntity();
        substanceEntity.setOddNumbers(id);
        substanceEntity.setWarehousingTime(outboundTime);
        substanceEntity.setDrugId(a.getDrugId());
        substanceEntity.setDrugName(a.getDrugName());
        substanceEntity.setSpecifications(a.getSpecifications());
        substanceEntity.setDrugType(a.getDrugsType());
        substanceEntity.setOutboundMethod(outboundMethod);
        substanceEntity.setSupplierDepartmentId(supplierId);
        substanceEntity.setSupplierDepartmentName(supplierName);
        substanceEntity.setDrugNum(drugNum);
        substanceEntity.setUnit(a.getUnit());
        substanceEntity.setPurchasePrice(purchasePrice);
        substanceEntity.setRetailPrice(retailPrice);
        substanceEntity.setPurchaseAmount(purchaseJ);
        substanceEntity.setRetailAmount(retailJ);
        substanceEntity.setBatchNumber(a.getBatchNumber());
        substanceEntity.setOperateTime(new Date());
        substanceEntity.setEffectiveTime(a.getEffectiveTime());
        substanceEntity.setWarehousingWarehouse(outboundWarehouse);
        substanceEntity.setTenantId(this.commonRequest.getTenant());
        this.drugSubstanceService.save((Object)substanceEntity);
    }

    private void saveDruAccess(SysDrugInventoryOutPrescriptionEntity a, SysDrugInventoryOutEntity byId) {
        String outboundMethod = byId.getOutboundMethod();
        String uuid = UUIDUtils.getRandom((int)5, (boolean)true);
        Integer tenantId = this.commonRequest.getTenant();
        SysDrugAccessEntity drugAccessEntity = new SysDrugAccessEntity();
        drugAccessEntity.setId(uuid);
        drugAccessEntity.setWayType(outboundMethod);
        drugAccessEntity.setWayTime(byId.getOutboundTime());
        drugAccessEntity.setWayNom(byId.getId());
        drugAccessEntity.setNumber(a.getDrugNum());
        drugAccessEntity.setUnit(a.getUnit());
        drugAccessEntity.setBatchNumber(a.getBatchNumber());
        drugAccessEntity.setEffectiveTime(a.getEffectiveTime());
        drugAccessEntity.setTenantId(tenantId);
        drugAccessEntity.setDrugId(a.getDrugId());
        drugAccessEntity.setDrugName(a.getDrugName());
        this.sysDrugAccessService.save((Object)drugAccessEntity);
    }

    private void updateDrugBatch(SysDrugInventoryOutPrescriptionEntity a) {
        Integer drugNum = a.getDrugNum();
        SysDrugBatchEntity one = (SysDrugBatchEntity)this.sysDrugBatchService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugBatchEntity::getDrugInventoryInId, (Object)a.getDrugInventoryInId())).eq(SysDrugBatchEntity::getDrugId, (Object)a.getDrugId())).eq(SysDrugBatchEntity::getPurchasePrice, (Object)a.getPurchasePrice())).eq(SysDrugBatchEntity::getEffectiveTime, (Object)a.getEffectiveTime())).eq(SysDrugBatchEntity::getBatchNumber, (Object)a.getBatchNumber())).last("limit 1"));
        Integer residue = one.getBookInventory();
        Integer i2 = residue - drugNum;
        BigDecimal purchasePrice = one.getPurchasePrice();
        BigDecimal retailPrice = one.getRetailPrice();
        BigDecimal purchaseAmount = purchasePrice.multiply(BigDecimal.valueOf(i2.intValue()));
        BigDecimal retailAmount = retailPrice.multiply(BigDecimal.valueOf(i2.intValue()));
        one.setBookInventory(i2);
        one.setPurchaseAmount(purchaseAmount);
        one.setRetailAmount(retailAmount);
        one.setUpdateId(this.commonRequest.getUserId());
        one.setUpdateTime(new Date());
        this.sysDrugBatchService.update((Object)one, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugBatchEntity::getDrugInventoryInId, (Object)a.getDrugInventoryInId())).eq(SysDrugBatchEntity::getDrugId, (Object)a.getDrugId())).eq(SysDrugBatchEntity::getBatchNumber, (Object)a.getBatchNumber())).eq(SysDrugBatchEntity::getPurchasePrice, (Object)a.getPurchasePrice())).eq(SysDrugBatchEntity::getEffectiveTime, (Object)a.getEffectiveTime()));
    }

    private void updateDrugQcQm(SysDrugInventoryOutPrescriptionEntity a, SysDrugInventoryOutEntity entity) {
        SysDrugQcQmEntity cm = new SysDrugQcQmEntity();
        Integer tenantId = this.commonRequest.getTenant();
        Integer userId = this.commonRequest.getUserId();
        String uuid = UUIDUtils.getRandom((int)5, (boolean)true);
        LocalDate currentDate = LocalDate.now();
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String dateString = currentDate.format(dtf);
        String startTime = dateString + " 00:00:00";
        String endTime = dateString + " 23:59:59";
        SysDrugQcQmEntity oneIn = (SysDrugQcQmEntity)this.sysDrugQcQmService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugQcQmEntity::getDrugId, (Object)a.getDrugId())).eq(SysDrugQcQmEntity::getTenantId, (Object)tenantId)).between(SysDrugQcQmEntity::getInTime, (Object)startTime, (Object)endTime)).last(" limit 1"));
        SysDrugQcQmEntity oneOut = (SysDrugQcQmEntity)this.sysDrugQcQmService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugQcQmEntity::getDrugId, (Object)a.getDrugId())).eq(SysDrugQcQmEntity::getTenantId, (Object)tenantId)).between(SysDrugQcQmEntity::getOutTime, (Object)startTime, (Object)endTime)).last(" limit 1"));
        if (StrUtil.isEmptyIfStr((Object)oneIn)) {
            if (StrUtil.isEmptyIfStr((Object)oneOut)) {
                cm.setId(uuid);
                cm.setDrugId(a.getDrugId());
                cm.setDrugName(a.getDrugName());
                cm.setDrugProperties(a.getDrugProperties());
                cm.setSpecifications(a.getSpecifications());
                cm.setManufacturer(a.getManufacturer());
                cm.setUnit(a.getUnit());
                Integer drugNum = a.getDrugNum();
                BigDecimal purchasePrice = a.getPurchasePrice();
                BigDecimal purchaseAmount = purchasePrice.multiply(BigDecimal.valueOf(drugNum.intValue()));
                BigDecimal retailPrice = a.getRetailPrice();
                BigDecimal multiplyAmount = retailPrice.multiply(BigDecimal.valueOf(drugNum.intValue()));
                cm.setOutNum(drugNum);
                cm.setOutProcureAmount(purchaseAmount);
                cm.setOutRetailAmount(multiplyAmount);
                cm.setInNum(Integer.valueOf(0));
                cm.setInProcureAmount(BigDecimal.ZERO);
                cm.setInRetailAmount(BigDecimal.ZERO);
                cm.setOpening(Integer.valueOf(0));
                cm.setOpeningProcureAmount(BigDecimal.ZERO);
                cm.setOpeningRetailAmount(BigDecimal.ZERO);
                cm.setTerminal(Integer.valueOf(0));
                cm.setTerminalProcureAmount(BigDecimal.ZERO);
                cm.setTerminalRetailAmount(BigDecimal.ZERO);
                cm.setWeightedMean(BigDecimal.ZERO);
                cm.setTenantId(tenantId);
                cm.setCreateTime(new Date());
                cm.setOutTime(new Date());
                cm.setCreateId(userId);
                this.sysDrugQcQmService.save((Object)cm);
            } else {
                Integer drugNum = a.getDrugNum();
                BigDecimal purchasePrice = a.getPurchasePrice();
                BigDecimal purchaseAmount = purchasePrice.multiply(BigDecimal.valueOf(drugNum.intValue()));
                BigDecimal retailPrice = a.getRetailPrice();
                BigDecimal multiplyAmount = retailPrice.multiply(BigDecimal.valueOf(drugNum.intValue()));
                BigDecimal inP = oneOut.getOutProcureAmount().add(purchaseAmount);
                BigDecimal inR = oneOut.getOutRetailAmount().add(multiplyAmount);
                Integer in = oneOut.getOutNum() + drugNum;
                cm.setOutNum(in);
                cm.setOutProcureAmount(inP);
                cm.setOutRetailAmount(inR);
                this.sysDrugQcQmService.update((Object)cm, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugQcQmEntity::getTenantId, (Object)tenantId)).eq(SysDrugQcQmEntity::getDrugId, (Object)a.getDrugId())).between(SysDrugQcQmEntity::getOutTime, (Object)startTime, (Object)endTime)).last(" limit 1"));
            }
        } else if (StrUtil.isEmptyIfStr((Object)oneOut)) {
            Integer drugNum = a.getDrugNum();
            BigDecimal purchasePrice = a.getPurchasePrice();
            BigDecimal purchaseAmount = purchasePrice.multiply(BigDecimal.valueOf(drugNum.intValue()));
            BigDecimal retailPrice = a.getRetailPrice();
            BigDecimal multiplyAmount = retailPrice.multiply(BigDecimal.valueOf(drugNum.intValue()));
            cm.setOutNum(drugNum);
            cm.setOutProcureAmount(purchaseAmount);
            cm.setOutRetailAmount(multiplyAmount);
            cm.setOutTime(new Date());
            this.sysDrugQcQmService.update((Object)cm, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugQcQmEntity::getTenantId, (Object)tenantId)).eq(SysDrugQcQmEntity::getDrugId, (Object)a.getDrugId())).between(SysDrugQcQmEntity::getInTime, (Object)startTime, (Object)endTime)).last(" limit 1"));
        } else {
            Integer drugNum = a.getDrugNum();
            BigDecimal purchasePrice = a.getPurchasePrice();
            BigDecimal purchaseAmount = purchasePrice.multiply(BigDecimal.valueOf(drugNum.intValue()));
            BigDecimal retailPrice = a.getRetailPrice();
            BigDecimal multiplyAmount = retailPrice.multiply(BigDecimal.valueOf(drugNum.intValue()));
            BigDecimal inP = oneOut.getOutProcureAmount().add(purchaseAmount);
            BigDecimal inR = oneOut.getOutRetailAmount().add(multiplyAmount);
            Integer in = oneOut.getOutNum() + drugNum;
            cm.setOutNum(in);
            cm.setOutProcureAmount(inP);
            cm.setOutRetailAmount(inR);
            cm.setOutTime(new Date());
            this.sysDrugQcQmService.update((Object)cm, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugQcQmEntity::getTenantId, (Object)tenantId)).eq(SysDrugQcQmEntity::getDrugId, (Object)a.getDrugId())).between(SysDrugQcQmEntity::getInTime, (Object)startTime, (Object)endTime)).last(" limit 1"));
        }
    }

    private void updateDrugInventory(SysDrugInventoryOutPrescriptionEntity a) {
        SysDrugInventoryEntity copy = (SysDrugInventoryEntity)this.drugInventoryService.getOne((Wrapper)Wrappers.lambdaQuery().eq(SysDrugInventoryEntity::getDrugId, (Object)a.getDrugId()));
        Integer actualInventory = copy.getActualInventory();
        Integer drugNum = a.getDrugNum();
        Integer realityNum = actualInventory - drugNum;
        copy.setActualInventory(realityNum);
        BigDecimal purchasePrice = copy.getPurchasePrice();
        BigDecimal purchaseAmount = purchasePrice.multiply(BigDecimal.valueOf(realityNum.intValue()));
        copy.setPurchaseAmount(purchaseAmount);
        BigDecimal retailPrice = copy.getRetailPrice();
        BigDecimal retailAmount = retailPrice.multiply(BigDecimal.valueOf(realityNum.intValue()));
        copy.setRetailAmount(retailAmount);
        this.drugInventoryService.update((Object)copy, (Wrapper)Wrappers.lambdaQuery().eq(SysDrugInventoryEntity::getDrugId, (Object)a.getDrugId()));
    }

    @UserOptLogger(operation="\u836f\u5e93\u51fa\u5e93\u6a21\u5757")
    @PostMapping(value={"/removeDrugInventoryOut"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", httpMethod="POST", notes="\u6279\u91cf\u5220\u9664")
    public ResponseData removeDrugInventoryOut(@ApiParam(value="\u4e3b\u952e\u96c6\u5408", required=true) @RequestBody String[] ids) {
        return ResponseData.success((Object)this.drugInventoryOutService.removeDrugInventoryOut(ids));
    }

    public SysDrugInventoryOutController(SysDrugInventoryOutTempService sysDrugInventoryOutTempService, CommonRequest commonRequest, SysDrugInventoryOutService drugInventoryOutService, SysDrugInventoryOutPrescriptionService outPrescriptionService, SysDrugInventoryService drugInventoryService, SysDrugQcQmService sysDrugQcQmService, SysDrugBatchService sysDrugBatchService, SysDrugAccessService sysDrugAccessService, SysDrugInventoryCheckService checkService, SysDrugSubstanceService drugSubstanceService, HsUploadExtend hsUploadExtend) {
        this.sysDrugInventoryOutTempService = sysDrugInventoryOutTempService;
        this.commonRequest = commonRequest;
        this.drugInventoryOutService = drugInventoryOutService;
        this.outPrescriptionService = outPrescriptionService;
        this.drugInventoryService = drugInventoryService;
        this.sysDrugQcQmService = sysDrugQcQmService;
        this.sysDrugBatchService = sysDrugBatchService;
        this.sysDrugAccessService = sysDrugAccessService;
        this.checkService = checkService;
        this.drugSubstanceService = drugSubstanceService;
        this.hsUploadExtend = hsUploadExtend;
    }
}

