/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.mvc.controller.drug;

import com.byh.sys.api.annotation.AntiRefresh;
import com.byh.sys.api.annotation.UserOptLogger;
import com.byh.sys.api.dto.drug.drugPharmacy.SysDrugPharmacyDto;
import com.byh.sys.api.dto.drug.drugPharmacy.SysDrugPharmacySaveDto;
import com.byh.sys.api.dto.drug.drugPharmacy.SysDrugPharmacyUpdateDto;
import com.byh.sys.api.dto.drug.drugPharmacy.UploadDrugSellDto;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.SysDrugPharmacyService;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/sysDrug/pharmacy"})
public class SysDrugPharmacyController {
    @Autowired
    private SysDrugPharmacyService sysDrugPharmacyService;
    @Autowired
    private CommonRequest commonRequest;

    @ApiOperation(value="\u6839\u636eexcel\u8fdb\u884c\u76d8\u76c8\u76d8\u4e8f\u64cd\u4f5c\uff08\u4e34\u65f6\u64cd\u4f5c\uff09")
    @PostMapping(value={"/checkTakeStockByExcel"})
    public ResponseData checkTakeStockByExcel(@RequestPart(value="file") MultipartFile file) throws Exception {
        this.sysDrugPharmacyService.checkTakeStockByExcel(file, this.commonRequest.getTenant(), this.commonRequest.getUserId());
        return ResponseData.success((Object)"\u76d8\u70b9\u6570\u636e\u751f\u6210\u6210\u529f\uff01");
    }

    @PostMapping(value={"/timingUploadDrugSellList"})
    @ApiOperation(value="\u4e0a\u4f20\u836f\u54c1\u9500\u552e\u6570\u636e\uff08\u767e\u6d4e\uff09")
    public ResponseData timingUploadDrugSellList(@RequestBody UploadDrugSellDto dto) {
        this.sysDrugPharmacyService.timingUploadDrugSellList(dto.getStartDate(), dto.getEndDate(), dto.getStartDate(), dto.getEndDate());
        return ResponseData.success((Object)"\u4e0a\u4f20\u6210\u529f\uff01");
    }

    @PostMapping(value={"/timingUploadDrugPurchaseList"})
    @ApiOperation(value="\u4e0a\u4f20\u836f\u54c1\u91c7\u8d2d\u6570\u636e\uff08\u767e\u6d4e\uff09")
    public ResponseData timingUploadDrugPurchaseList() {
        this.sysDrugPharmacyService.timingUploadDrugPurchaseList();
        return ResponseData.success((Object)"\u4e0a\u4f20\u6210\u529f\uff01");
    }

    @PostMapping(value={"/timingUploadDrugStockList"})
    @ApiOperation(value="\u4e0a\u4f20\u836f\u54c1\u5e93\u5b58\u6570\u636e\uff08\u767e\u6d4e\uff09")
    public ResponseData timingUploadDrugStockList() {
        this.sysDrugPharmacyService.timingUploadDrugStockList();
        return ResponseData.success((Object)"\u4e0a\u4f20\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/save"})
    @UserOptLogger(operation="\u836f\u623f\u6279\u6b21\u6a21\u5757")
    @ApiOperation(value="\u836f\u623f\u6279\u6b21-\u65b0\u589e")
    public ResponseData sysDrugPharmacySave(@RequestBody @Valid SysDrugPharmacySaveDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        this.sysDrugPharmacyService.sysDrugPharmacySave(dto);
        return ResponseData.success().save();
    }

    @RequestMapping(value={"/select"})
    @ApiOperation(value="\u836f\u623f\u6279\u6b21-\u67e5\u8be2")
    @AntiRefresh
    public ResponseData sysDrugPharmacySelect(@RequestBody SysDrugPharmacyDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        List list = this.sysDrugPharmacyService.sysDrugPharmacySelect(dto);
        return ResponseData.success((Object)list);
    }

    @RequestMapping(value={"/update"})
    @UserOptLogger(operation="\u836f\u623f\u6279\u6b21\u6a21\u5757")
    @ApiOperation(value="\u836f\u623f\u6279\u6b21-\u66f4\u65b0")
    public ResponseData sysDrugPharmacyUpdate(@RequestBody @Valid SysDrugPharmacyUpdateDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        this.sysDrugPharmacyService.sysDrugPharmacyUpdate(dto);
        return ResponseData.success().update();
    }

    @RequestMapping(value={"/delete"})
    @ApiOperation(value="\u836f\u623f\u6279\u6b21-\u5220\u9664")
    public ResponseData sysDrugPharmacyDelete(@RequestBody String[] ids) {
        this.sysDrugPharmacyService.sysDrugPharmacyDelete(ids);
        return ResponseData.success().delete();
    }
}

