/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.mvc.controller.drug;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.sys.api.annotation.AntiRefresh;
import com.byh.sys.api.annotation.UserOptLogger;
import com.byh.sys.api.dto.drug.SysDrugComputerPurchasePlainDto;
import com.byh.sys.api.dto.drug.drugPharmacSimple.SysDrugPharmacySimpleDto;
import com.byh.sys.api.dto.drug.drugPharmacSimple.SysDrugPharmacySimpleSaveDto;
import com.byh.sys.api.dto.drug.drugPharmacSimple.SysDrugPharmacySimpleUpdateDto;
import com.byh.sys.api.dto.drug.drugPharmacy.SysDrugPharmacyDto;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.api.util.StringUtils;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.SysDrugPharmacySimpleService;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sysDrugPharmacy/simple"})
public class SysDrugPharmacySimpleController {
    @Autowired
    private SysDrugPharmacySimpleService sysDrugPharmacySimpleService;
    @Autowired
    private CommonRequest commonRequest;

    @RequestMapping(value={"/save"})
    @UserOptLogger(operation="\u836f\u623f\u5e93\u5b58\u6570\u91cf\u6a21\u5757")
    @ApiOperation(value="\u836f\u623f\u5e93\u5b58\u6570\u91cf-\u65b0\u589e")
    public ResponseData sysDrugPharmacySimpleSave(@RequestBody @Valid SysDrugPharmacySimpleSaveDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        this.sysDrugPharmacySimpleService.sysDrugPharmacySimpleSave(dto);
        return ResponseData.success().save();
    }

    @RequestMapping(value={"/saveToDual"})
    @UserOptLogger(operation="\u836f\u623f\u5e93\u5b58\u6570\u91cf\u6a21\u5757")
    @ApiOperation(value="\u836f\u623f\u5e93\u5b58\u6570\u91cf-\u65b0\u589e")
    public ResponseData sysDrugPharmacySimpleSaveToDual(SysDrugPharmacySimpleSaveDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        String drugsId = dto.getDrugsId();
        dto.setCreateId(this.commonRequest.getUserId());
        if (StringUtils.isBlank((String)drugsId)) {
            return ResponseData.error((String)"\u836f\u54c1id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.sysDrugPharmacySimpleService.sysDrugPharmacySimpleSaveToDual(dto);
    }

    @RequestMapping(value={"/delToDual"})
    @UserOptLogger(operation="\u836f\u623f\u5e93\u5b58\u6570\u91cf\u6a21\u5757")
    @ApiOperation(value="\u836f\u623f\u5e93\u5b58\u6570\u91cf-\u5220\u9664")
    public ResponseData sysDrugPharmacySimpleDelToDual(SysDrugPharmacySimpleSaveDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        String drugsId = dto.getDrugsId();
        dto.setCreateId(this.commonRequest.getUserId());
        if (StringUtils.isBlank((String)drugsId)) {
            return ResponseData.error((String)"\u836f\u54c1id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.sysDrugPharmacySimpleService.sysDrugPharmacySimpleDelToDual(dto);
    }

    @GetMapping(value={"/select"})
    @ApiOperation(value="\u836f\u623f\u5e93\u5b58\u6570\u91cf-\u67e5\u8be2")
    @AntiRefresh
    public ResponseData sysDrugPharmacySimpleSelect(Page page, SysDrugPharmacySimpleDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        if (StringUtils.isBlank((String)dto.getWarehouse())) {
            dto.setWarehouse(this.commonRequest.getDrugRoomId());
        }
        IPage list = this.sysDrugPharmacySimpleService.sysDrugPharmacySimpleSelect(page, dto);
        return ResponseData.success((Object)list);
    }

    @RequestMapping(value={"/update"})
    @UserOptLogger(operation="\u836f\u623f\u5e93\u5b58\u6570\u91cf\u6a21\u5757")
    @ApiOperation(value="\u836f\u623f\u5e93\u5b58\u6570\u91cf-\u66f4\u65b0")
    public ResponseData sysDrugPharmacySimpleUpdate(@RequestBody @Valid SysDrugPharmacySimpleUpdateDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        this.sysDrugPharmacySimpleService.sysDrugPharmacySimpleUpdate(dto);
        return ResponseData.success().update();
    }

    @RequestMapping(value={"/delete"})
    @UserOptLogger(operation="\u836f\u623f\u5e93\u5b58\u6570\u91cf\u6a21\u5757")
    @ApiOperation(value="\u836f\u623f\u5e93\u5b58\u6570\u91cf-\u5220\u9664")
    public ResponseData sysDrugPharmacySimpleDelete(@RequestBody String[] ids) {
        this.sysDrugPharmacySimpleService.sysDrugPharmacySimpleDelete(ids);
        return ResponseData.success().delete();
    }

    @GetMapping(value={"/inOut/detail"})
    @ApiOperation(value="\u4ed3\u5e93\u8fdb\u9500\u5b58\u8be6\u60c5")
    @AntiRefresh
    public ResponseData sysMaterialInventoryInOutDetail(Page page, SysDrugPharmacyDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        if (StringUtils.isBlank((String)dto.getWarehouse())) {
            dto.setWarehouse(this.commonRequest.getDrugRoomId());
        }
        IPage list = this.sysDrugPharmacySimpleService.sysDrugPharmacyInOutDetail(page, dto);
        return ResponseData.success((Object)list);
    }

    @GetMapping(value={"/batch/detail"})
    @ApiOperation(value="\u4ed3\u5e93\u6279\u6b21\u8be6\u60c5")
    @AntiRefresh
    public ResponseData sysMaterialInventoryBatchDetail(Page page, SysDrugPharmacyDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        IPage list = this.sysDrugPharmacySimpleService.sysDrugPharmacyBatchDetail(page, dto, this.commonRequest.getDrugRoomId());
        return ResponseData.success((Object)list);
    }

    @GetMapping(value={"/export"})
    @ApiOperation(value="\u5bfc\u51faExcel", httpMethod="GET", notes="\u5bfc\u51faExcel")
    public void sysDrugPharmacySimpleExport(HttpServletResponse response, Page page, SysDrugPharmacySimpleDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        if (StringUtils.isBlank((String)dto.getWarehouse())) {
            dto.setWarehouse(this.commonRequest.getDrugRoomId());
        }
        this.sysDrugPharmacySimpleService.sysDrugPharmacySimpleExport(response, page, dto);
    }

    @GetMapping(value={"/computer/purchase/plain"})
    public ResponseData computerPurchasePlain(Page page, SysDrugComputerPurchasePlainDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        if (StringUtils.isBlank((String)dto.getWarehouse())) {
            dto.setWarehouse(this.commonRequest.getDrugRoomId());
        }
        IPage list = this.sysDrugPharmacySimpleService.computerPurchasePlain(page, dto);
        return ResponseData.success((Object)list);
    }

    @GetMapping(value={"/computer/effective/warning"})
    public ResponseData computerEffectiveWarning(Page page, SysDrugComputerPurchasePlainDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        if (StringUtils.isBlank((String)dto.getWarehouse())) {
            dto.setWarehouse(this.commonRequest.getDrugRoomId());
        }
        IPage list = this.sysDrugPharmacySimpleService.computerEffectiveWarning(page, dto);
        return ResponseData.success((Object)list);
    }

    @RequestMapping(value={"/computer/purchase/plain/count"})
    public ResponseData computerPurchasePlainCount(@RequestBody SysDrugComputerPurchasePlainDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        if (StringUtils.isBlank((String)dto.getWarehouse())) {
            dto.setWarehouse(this.commonRequest.getDrugRoomId());
        }
        Integer total = this.sysDrugPharmacySimpleService.computerPurchasePlainCount(dto);
        return ResponseData.success((Object)total.toString());
    }

    @RequestMapping(value={"/computer/effective/warning/count"})
    public ResponseData computerEffectiveWarningCount(SysDrugComputerPurchasePlainDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        if (StringUtils.isBlank((String)dto.getWarehouse())) {
            dto.setWarehouse(this.commonRequest.getDrugRoomId());
        }
        Integer total = this.sysDrugPharmacySimpleService.computerEffectiveWarningCount(dto);
        return ResponseData.success((Object)total.toString());
    }
}

