/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.mvc.controller.drug;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.byh.sys.api.dto.shelf.SysShelfPharmacyDto;
import com.byh.sys.api.model.SysUserEntity;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.SysShelfPharmacyService;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/shelf/pharmacy"})
public class SysShelfPharmacyController {
    @Autowired
    private SysShelfPharmacyService sysShelfPharmacyService;
    @Autowired
    private CommonRequest commonRequest;

    @RequestMapping(value={"/select"})
    public ResponseData sysShelfPharmacySelect(@RequestBody @Valid SysShelfPharmacyDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        IPage list = this.sysShelfPharmacyService.sysShelfPharmacySelect(dto);
        return ResponseData.success((Object)list);
    }

    @RequestMapping(value={"/print"})
    public ResponseData sysShelfPharmacyPrint(@RequestBody @Valid SysShelfPharmacyDto dto) {
        SysUserEntity userInfo = this.commonRequest.getUserInfo();
        dto.setTenantId(this.commonRequest.getTenant());
        dto.setCreateId(userInfo.getId().toString());
        dto.setCreateName(userInfo.getUserName());
        this.sysShelfPharmacyService.sysShelfPharmacyPrint(dto);
        return ResponseData.success();
    }
}

