/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.mvc.controller.invoice;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.sys.api.annotation.AntiRefresh;
import com.byh.sys.api.annotation.UserOptLogger;
import com.byh.sys.api.dto.invoice.SysInvoiceConfigDto;
import com.byh.sys.api.dto.invoice.SysInvoiceDto;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.invoice.SysInvoiceApplyForEntity;
import com.byh.sys.api.model.invoice.SysInvoiceConfigEntity;
import com.byh.sys.api.model.invoice.SysInvoiceConfirmDetailsEntity;
import com.byh.sys.api.model.invoice.SysInvoiceEntity;
import com.byh.sys.api.model.invoice.SysInvoiceImpulseRedEntity;
import com.byh.sys.api.model.invoice.SysInvoiceQueRenQueryEntity;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.mvc.utils.nuonuo.NuoNuoClientUtils;
import com.byh.sys.web.service.SysInvoiceConfigService;
import com.byh.sys.web.service.SysInvoiceService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.scheduling.annotation.Async;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/invoiceConfig"})
public class SysInvoiceConfigController {
    private static final Logger log = LoggerFactory.getLogger(SysInvoiceConfigController.class);
    private static Logger logger = LoggerFactory.getLogger(SysInvoiceConfigController.class);
    private final CommonRequest commonRequest;
    private final SysInvoiceConfigService sysInvoiceConfigService;
    private final SysInvoiceService sysInvoiceService;

    @Transactional(rollbackFor={Exception.class})
    @UserOptLogger(operation="\u53d1\u7968\u914d\u7f6e\u6a21\u5757[\u65b0\u589e/\u7f16\u8f91]")
    @PostMapping(value={"/saveUpdate"})
    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539", httpMethod="POST", notes="\u65b0\u589e\u6216\u4fee\u6539")
    public ResponseData saveUpdates(@RequestBody SysInvoiceConfigDto dto) {
        List invoiceDetail = dto.getInvoiceDetail();
        if (StrUtil.isEmptyIfStr((Object)invoiceDetail)) {
            throw new BusinessException("\u53d1\u7968\u660e\u7ec6\u914d\u7f6e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01{invoiceDetail}");
        }
        SysInvoiceConfigEntity entity = new SysInvoiceConfigEntity();
        BeanUtils.copyProperties((Object)dto, (Object)entity);
        Integer tenantId = this.commonRequest.getTenant();
        entity.setTenantId(tenantId);
        if (null == dto.getId()) {
            this.sysInvoiceConfigService.save((Object)entity);
        } else {
            this.sysInvoiceConfigService.saveOrUpdate((Object)entity);
        }
        return ResponseData.success();
    }

    @ApiOperation(value="\u53d1\u7968\u914d\u7f6e\u5217\u8868", httpMethod="GET", notes="\u53d1\u7968\u914d\u7f6e\u5217\u8868")
    @GetMapping(value={"/pageList"})
    @AntiRefresh
    public ResponseData pageList(Page page, SysInvoiceConfigDto dto) {
        Integer tenantId = this.commonRequest.getTenant();
        dto.setTenantId(tenantId);
        return ResponseData.success((Object)this.sysInvoiceConfigService.pageList(page, dto));
    }

    @Transactional(rollbackFor={Exception.class})
    @UserOptLogger(operation="\u53d1\u7968\u914d\u7f6e\u6a21\u5757[\u6279\u91cf\u5220\u9664]")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", httpMethod="POST", notes="\u6279\u91cf\u5220\u9664")
    @PostMapping(value={"/removerInvoice"})
    @AntiRefresh
    public ResponseData removerInvoice(@ApiParam(value="\u4e3b\u952e\u96c6\u5408", required=true) @RequestBody Long[] ids) {
        Integer tenantId = this.commonRequest.getTenant();
        return ResponseData.success((Object)this.sysInvoiceConfigService.removerInvoice(tenantId, ids));
    }

    @UserOptLogger(operation="\u5f00\u5177\u53d1\u7968")
    @ApiOperation(value="\u5f00\u5177\u53d1\u7968", httpMethod="POST", notes="\u5f00\u5177\u53d1\u7968")
    @PostMapping(value={"/invoicing"})
    public JSONObject invoicing(@RequestBody SysInvoiceConfigDto dto) throws InterruptedException {
        String orderNo = dto.getOrderNo();
        if (StrUtil.isEmpty((CharSequence)orderNo)) {
            throw new BusinessException("\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01{orderNo}\uff01" + orderNo);
        }
        String invoiceDate = dto.getInvoiceDate();
        if (StrUtil.isEmpty((CharSequence)invoiceDate)) {
            throw new BusinessException("\u8ba2\u5355\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01{invoiceDate}\uff01" + invoiceDate);
        }
        String departmentId = dto.getDepartmentId();
        if (StrUtil.isEmpty((CharSequence)departmentId)) {
            throw new BusinessException("\u79d1\u5ba4id\u4e0d\u80fd\u4e3a\u7a7a\uff01{invoiceDate}\uff01" + departmentId);
        }
        String remark = dto.getRemark();
        if (StrUtil.isEmpty((CharSequence)remark)) {
            throw new BusinessException("\u5907\u6ce8\u4e0d\u80fd\u4e3a\u7a7a\uff01{remark}\uff01" + remark);
        }
        Integer tenantId = this.commonRequest.getTenant();
        if (null == tenantId) {
            tenantId = dto.getTenantId();
        }
        SysInvoiceConfigEntity one = (SysInvoiceConfigEntity)this.sysInvoiceConfigService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysInvoiceConfigEntity::getId, (Object)1)).eq(SysInvoiceConfigEntity::getTenantId, (Object)tenantId));
        one.setBuyerName(dto.getPatientName());
        String buyerPhone = dto.getBuyerPhone();
        if (StrUtil.isEmpty((CharSequence)buyerPhone)) {
            one.setPushMode("-1");
        } else {
            one.setBuyerPhone(dto.getBuyerPhone());
        }
        if (StrUtil.isEmpty((CharSequence)dto.getPatientCardNo())) {
            one.setBuyerTaxNum(null);
        } else {
            one.setBuyerTaxNum(dto.getPatientCardNo());
        }
        List invoiceDetail = dto.getInvoiceDetail();
        if (StrUtil.isEmptyIfStr((Object)invoiceDetail)) {
            throw new BusinessException("\u53d1\u7968\u660e\u7ec6\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01{invoiceDetail}\uff01" + invoiceDetail);
        }
        invoiceDetail.forEach(a -> {
            a.setWithTaxFlag("0");
            a.setTaxRate("0");
            a.setInvoiceLineProperty("0");
            a.setFavouredPolicyFlag("0");
            a.setFavouredPolicyName("0");
            a.setDeduction("0");
            a.setZeroRateFlag("0");
            a.setGoodsCode("3070202");
        });
        BeanUtils.copyProperties((Object)one, (Object)dto);
        dto.setInvoiceDetail(invoiceDetail);
        HashMap<String, SysInvoiceConfigDto> map = new HashMap<String, SysInvoiceConfigDto>();
        map.put("order", dto);
        String jsonStr = NuoNuoClientUtils.requestBillingNewPro(map);
        JSONObject jsonObj = JSONObject.parseObject((String)jsonStr);
        String code = jsonObj.getString("code");
        String describe = jsonObj.getString("describe");
        String result = jsonObj.getString("result");
        if ("E0000".equals(code)) {
            JSONObject re = JSONObject.parseObject((String)result);
            String serialNum = re.getString("invoiceSerialNum");
            SysInvoiceApplyForEntity entity = new SysInvoiceApplyForEntity();
            entity.setSerialNo(serialNum);
            Thread.sleep(3000L);
            Integer tenant = this.commonRequest.getTenant();
            AtomicReference applyFor = new AtomicReference();
            CompletionStage completionStage = CompletableFuture.runAsync(() -> applyFor.set(this.listHandle(entity))).thenRun(() -> {
                logger.info("---------------\u5f02\u6b65\u7ebf\u7a0b\u56de\u8c03---------------------------");
                SysInvoiceEntity invoiceEntity = new SysInvoiceEntity();
                invoiceEntity.setImgUrls(((SysInvoiceApplyForEntity)applyFor.get()).getImgUrls());
                invoiceEntity.setOfdUrl(((SysInvoiceApplyForEntity)applyFor.get()).getOfdUrl());
                invoiceEntity.setPdfUrl(((SysInvoiceApplyForEntity)applyFor.get()).getPdfUrl());
                invoiceEntity.setTenantId(tenant);
                invoiceEntity.setSerialNo(serialNum);
                invoiceEntity.setOrderNo(dto.getOrderNo());
                invoiceEntity.setInvoiceDate(dto.getInvoiceDate());
                this.sysInvoiceService.save((Object)invoiceEntity);
            });
        }
        return jsonObj;
    }

    @ApiOperation(value="\u53d1\u7968\u8be6\u60c5", httpMethod="GET", notes="\u53d1\u7968\u8be6\u60c5")
    @GetMapping(value={"/invoiceInfo"})
    @AntiRefresh
    public ResponseData invoiceInfo(String serialNo) {
        if (StrUtil.isEmpty((CharSequence)serialNo)) {
            throw new BusinessException("\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01{orderNo}\uff01" + serialNo);
        }
        String result = this.invoiceDel(serialNo);
        JSONObject jsonObj = JSONObject.parseObject((String)result);
        return ResponseData.success((Object)jsonObj);
    }

    private String invoiceDel(String serialNo) {
        String isOfferInvoiceDetail = "1";
        String[] orderNos = new String[]{"-"};
        String[] serialNos = new String[]{serialNo};
        String result = NuoNuoClientUtils.queryInvoiceResultPro((String)isOfferInvoiceDetail, (String[])orderNos, (String[])serialNos);
        return result;
    }

    @Async
    SysInvoiceApplyForEntity listHandle(SysInvoiceApplyForEntity entity) {
        SysInvoiceApplyForEntity applyForEntity = new SysInvoiceApplyForEntity();
        String str = this.invoiceDel(entity.getSerialNo());
        JSONObject jsonObj = JSONObject.parseObject((String)str);
        String code = jsonObj.getString("code");
        if ("E0000".equals(code)) {
            String result = jsonObj.getString("result");
            JSONArray jsonArray = JSON.parseArray((String)result);
            JSONObject json = (JSONObject)jsonArray.get(0);
            String serialNo = json.getString("serialNo");
            applyForEntity.setSerialNo(serialNo);
            applyForEntity.setBlueInvoiceLine("pc");
            applyForEntity.setApplySource("0");
            String sellerTaxNo = json.getString("salerTaxNum");
            applyForEntity.setSellerTaxNo(sellerTaxNo);
            String sellerName = json.getString("saleName");
            applyForEntity.setSellerName(sellerName);
            String buyerName = json.getString("payerName");
            applyForEntity.setBuyerName(buyerName);
            String buyerTaxNo = json.getString("payerTaxNo");
            applyForEntity.setBuyerTaxNo(buyerTaxNo);
            applyForEntity.setRedReason("2");
            String blueInvoiceNumber = json.getString("invoiceNo");
            applyForEntity.setBlueInvoiceNumber(blueInvoiceNumber);
            applyForEntity.setDepartmentId(json.getString("deptId"));
            applyForEntity.setOrderNo(json.getString("orderNo"));
            applyForEntity.setBlueElecInvoiceNumber("");
            applyForEntity.setVatUsage("");
            applyForEntity.setSaleTaxUsage("");
            applyForEntity.setBlueInvoiceCode("");
            applyForEntity.setClerkId("");
            applyForEntity.setAccountStatus("");
            applyForEntity.setBillTime("");
            applyForEntity.setAutoInvoice("");
            applyForEntity.setPhone("");
            applyForEntity.setExtensionNumber("");
            applyForEntity.setBillId("");
            applyForEntity.setCallbackUrl("");
            applyForEntity.setEmail("");
            String imgUrls = json.getString("imgUrls");
            logger.info("\u7b2c\u4e09\u53d1\u7968\u7cfb\u7edf\u6210\u529f\u4e4b\u540e\u83b7\u53d6 \u7535\u5b50\u53d1\u7968\u5730\u5740 imgUrls+{imgUrls}" + imgUrls);
            String ofdUrl = json.getString("ofdUrl");
            String pdfUrl = json.getString("pdfUrl");
            applyForEntity.setImgUrls(imgUrls);
            applyForEntity.setOfdUrl(ofdUrl);
            applyForEntity.setPdfUrl(pdfUrl);
        }
        return applyForEntity;
    }

    @UserOptLogger(operation="\u53d1\u7968\u4f5c\u5e9f")
    @ApiOperation(value="\u53d1\u7968\u4f5c\u5e9f", httpMethod="POST", notes="\u53d1\u7968\u4f5c\u5e9f")
    @PostMapping(value={"/cancel"})
    @AntiRefresh
    public JSONObject cancel(@RequestBody SysInvoiceApplyForEntity entity) {
        Integer tenantId = this.commonRequest.getTenant();
        if (null == tenantId) {
            tenantId = entity.getTenantId();
        }
        SysInvoiceApplyForEntity applyForEntity = this.listHandle(entity);
        List detail = entity.getDetail();
        if (StrUtil.isEmptyIfStr((Object)detail)) {
            throw new BusinessException("\u53d1\u7968\u660e\u7ec6\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01{detail}\uff01" + detail);
        }
        String result = this.redConfirm(detail, applyForEntity);
        String s = this.queRenQuery(result);
        String kj = this.fastRed(s, applyForEntity.getOrderNo(), applyForEntity.getSellerTaxNo());
        JSONObject jsonObj = JSONObject.parseObject((String)kj);
        String code = jsonObj.getString("code");
        if ("E0000".equals(code)) {
            String result2 = jsonObj.getString("result");
            JSONObject json = JSONObject.parseObject((String)result2);
            String invoiceSerialNum = json.getString("invoiceSerialNum");
            SysInvoiceEntity invoiceEntity = new SysInvoiceEntity();
            invoiceEntity.setRedSerialNo(invoiceSerialNum);
            this.sysInvoiceService.update((Object)invoiceEntity, (Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysInvoiceEntity::getSerialNo, (Object)entity.getSerialNo())).eq(SysInvoiceEntity::getTenantId, (Object)tenantId));
        }
        return jsonObj;
    }

    private String fastRed(String s, String orderNo, String taxNum) {
        JSONObject jsonObject = JSONObject.parseObject((String)s);
        String code = jsonObject.getString("code");
        if ("E0000".equals(code)) {
            SysInvoiceImpulseRedEntity entity = new SysInvoiceImpulseRedEntity();
            String string = jsonObject.getString("result");
            JSONObject jso = JSONObject.parseObject((String)string);
            String list = jso.getString("list");
            JSONArray array = JSONArray.parseArray((String)list);
            for (Object obj : array) {
                JSONObject json = (JSONObject)obj;
                entity.setOrderNo(orderNo);
                entity.setBillUuid(json.getString("billUuid"));
                entity.setTaxNum(taxNum);
                entity.setBillNo(json.getString("billNo"));
                entity.setCallBackUrl("");
                entity.setDeptId("");
                entity.setClerkId("");
                entity.setInvoiceCode("");
                entity.setOrderTime("");
                entity.setExtensionNumber("");
                entity.setInvoiceNumber("");
                entity.setInvoiceId("");
                entity.setInvoiceLine(json.getString("blueInvoiceLine"));
            }
            return NuoNuoClientUtils.fastInvoiceRedPro((Object)entity);
        }
        return null;
    }

    private String queRenQuery(String result) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String invoiceDate = dateFormat.format(new Date());
        SysInvoiceQueRenQueryEntity queRenQuery = new SysInvoiceQueRenQueryEntity();
        queRenQuery.setBillId(result);
        queRenQuery.setBillNo("");
        queRenQuery.setBillUuid("");
        queRenQuery.setBillTimeStart(invoiceDate);
        queRenQuery.setBillTimeEnd(invoiceDate);
        queRenQuery.setIdentity("0");
        queRenQuery.setPageNo("1");
        queRenQuery.setPageSize("20");
        return NuoNuoClientUtils.queryInvoiceRedConfirmPro((Object)queRenQuery);
    }

    private String redConfirm(List<SysInvoiceConfirmDetailsEntity> detail, SysInvoiceApplyForEntity entity) {
        for (int i = 0; i < detail.size(); ++i) {
            detail.get(i).setBlueDetailIndex(String.valueOf(i + 1));
            detail.get(i).setGoodsCode("3070202");
            detail.get(i).setTaxRate("0");
            detail.get(i).setTaxExcludedAmount("-" + detail.get(i).getTaxExcludedAmount());
            detail.get(i).setNum("-" + detail.get(i).getNum());
            detail.get(i).setFavouredPolicyFlag("");
            detail.get(i).setTaxAmount("");
        }
        String s = NuoNuoClientUtils.saveInvoiceRedConfirmPro((Object)entity);
        JSONObject jsonObject = JSONObject.parseObject((String)s);
        String code = jsonObject.getString("code");
        String result = null;
        if ("E0000".equals(code)) {
            result = jsonObject.getString("result");
        }
        return result;
    }

    @ApiOperation(value="\u91cd\u65b0\u83b7\u53d6[\u83b7\u53d6\u53d1\u7968\u5730\u5740]", httpMethod="GET", notes="\u91cd\u65b0\u83b7\u53d6[\u83b7\u53d6\u53d1\u7968\u5730\u5740]")
    @GetMapping(value={"/retrieve"})
    @AntiRefresh
    public ResponseData retrieve(String serialNo) {
        Integer tenantId = this.commonRequest.getTenant();
        SysInvoiceApplyForEntity entity = new SysInvoiceApplyForEntity();
        entity.setSerialNo(serialNo);
        SysInvoiceApplyForEntity applyForEntity = this.listHandle(entity);
        SysInvoiceEntity invoiceEntity = new SysInvoiceEntity();
        BeanUtils.copyProperties((Object)applyForEntity, (Object)invoiceEntity);
        this.sysInvoiceService.update((Object)invoiceEntity, (Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysInvoiceEntity::getSerialNo, (Object)serialNo)).eq(SysInvoiceEntity::getTenantId, (Object)tenantId));
        return ResponseData.success().update();
    }

    @UserOptLogger(operation="\u65b0\u589e\u53d1\u7968")
    @ApiOperation(value="\u65b0\u589e\u53d1\u7968", httpMethod="POST", notes="\u65b0\u589e\u53d1\u7968")
    @PostMapping(value={"/addInvoice"})
    public ResponseData addInvoice(@RequestBody SysInvoiceDto dto) {
        SysInvoiceEntity sysInvoiceEntity = this.sysInvoiceService.selectInvoiceByserialNo(dto.getSerialNo());
        SysInvoiceEntity invoiceEntity = new SysInvoiceEntity();
        invoiceEntity.setImgUrls(dto.getImgUrls());
        invoiceEntity.setOfdUrl(dto.getOfdUrl());
        invoiceEntity.setPdfUrl(dto.getPdfUrl());
        invoiceEntity.setTenantId(dto.getTenantId());
        invoiceEntity.setSerialNo(dto.getSerialNo());
        invoiceEntity.setOrderNo(dto.getOrderNo());
        invoiceEntity.setInvoiceDate(dto.getInvoiceDate());
        if (sysInvoiceEntity == null) {
            this.sysInvoiceService.save((Object)invoiceEntity);
        } else {
            invoiceEntity.setId(sysInvoiceEntity.getId());
            this.sysInvoiceService.updateById((Object)invoiceEntity);
        }
        return ResponseData.success();
    }

    public SysInvoiceConfigController(CommonRequest commonRequest, SysInvoiceConfigService sysInvoiceConfigService, SysInvoiceService sysInvoiceService) {
        this.commonRequest = commonRequest;
        this.sysInvoiceConfigService = sysInvoiceConfigService;
        this.sysInvoiceService = sysInvoiceService;
    }
}

