/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.mvc.exception;

import com.byh.sys.api.dto.sysException.SysExceptionSaveDto;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.web.mvc.config.exceptionConfig.ContentCachingRequestWrapper;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.SysExceptionService;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.mybatis.spring.MyBatisSystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class ExceptionAdvice {
    public static Logger logger = LoggerFactory.getLogger(ExceptionAdvice.class);
    private static final String METHOD_GET = "GET";
    private static final String METHOD_POST = "POST";
    private static final String ATTRIBUTE_BODY = "requestBodyMessage";
    @Autowired
    private CommonRequest commonRequest;
    @Autowired
    private SysExceptionService sysExceptionService;
    @Autowired
    private HttpServletRequest request;

    @ModelAttribute
    public void getBobyInfo(HttpServletRequest request) {
        try {
            ContentCachingRequestWrapper requestWapper = null;
            if (request instanceof HttpServletRequest) {
                requestWapper = (ContentCachingRequestWrapper)request;
            }
            String body = IOUtils.toString((byte[])requestWapper.getBody(), (String)request.getCharacterEncoding());
            request.setAttribute(ATTRIBUTE_BODY, (Object)body);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @ResponseBody
    @ExceptionHandler(value={Exception.class})
    public ResponseData handleException(Exception e) {
        SysExceptionSaveDto dto = new SysExceptionSaveDto();
        logger.error("\u7cfb\u7edf\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
        e.printStackTrace();
        ResponseData responseData = new ResponseData();
        if (e instanceof BusinessException) {
            BusinessException be = (BusinessException)e;
            this.assemblyObject(ResponseData.ResponseEnum.RUN_TIME_EXCEPTION.getCode(), ResponseData.ResponseEnum.RUN_TIME_EXCEPTION.getCodeName(), e.getMessage());
            return ResponseData.error((String)be.getErrorCode(), (String)e.getMessage()).data((Object)Boolean.FALSE);
        }
        if (e instanceof MethodArgumentNotValidException) {
            MethodArgumentNotValidException me = (MethodArgumentNotValidException)e;
            FieldError field = me.getFieldError();
            me.printStackTrace();
            this.assemblyObject(ResponseData.ResponseEnum.BAD_REQUEST.getCode(), ResponseData.ResponseEnum.BAD_REQUEST.getCodeName(), me.getMessage());
            return ResponseData.error((String)ResponseData.ResponseEnum.BAD_REQUEST.getCode(), (String)field.getDefaultMessage()).data((Object)Boolean.FALSE);
        }
        if (e instanceof NullPointerException) {
            StringBuilder builder = new StringBuilder();
            NullPointerException ne = (NullPointerException)e;
            builder.append("\u3010\u51fa\u73b0\u7a7a\u6307\u9488\u5f02\u5e38\u3011").append("\u3010MESSAGE:").append(ne.getMessage()).append("\u3011");
            for (StackTraceElement stack : ne.getStackTrace()) {
                if (!stack.getClassName().contains(".sys.")) continue;
                builder.append("\u3010").append(stack.getClassName()).append("\u6587\u4ef6:").append(stack.getMethodName()).append("\u65b9\u6cd5:").append(stack.getLineNumber()).append("\u884c\u3011").append("\n");
            }
            this.assemblyObject(ResponseData.ResponseEnum.NULL_POINTER_EXCEPTION.getCode(), ResponseData.ResponseEnum.NULL_POINTER_EXCEPTION.getCodeName(), ne.getMessage());
            ne.printStackTrace();
            return ResponseData.error((String)ResponseData.ResponseEnum.NULL_POINTER_EXCEPTION.getCode(), (String)builder.toString()).data((Object)Boolean.FALSE);
        }
        if (e instanceof MyBatisSystemException) {
            StringBuilder builder = new StringBuilder();
            MyBatisSystemException ne = (MyBatisSystemException)e;
            builder.append("\u3010MESSAGE:").append(ne.getMessage()).append("\u3011");
            for (StackTraceElement stack : ne.getStackTrace()) {
                if (!stack.getClassName().contains(".sys.")) continue;
                builder.append("\u3010").append(stack.getClassName()).append("\u6587\u4ef6:").append(stack.getMethodName()).append("\u65b9\u6cd5:").append(stack.getLineNumber()).append("\u884c\u3011").append("\n");
            }
            ne.printStackTrace();
            this.assemblyObject(ResponseData.ResponseEnum.MY_BATIS_SYSTEM_EXCEPTION.getCode(), ResponseData.ResponseEnum.MY_BATIS_SYSTEM_EXCEPTION.getCodeName(), builder.toString());
            return ResponseData.error((String)ResponseData.ResponseEnum.MY_BATIS_SYSTEM_EXCEPTION.getCode(), (String)builder.toString()).data((Object)Boolean.FALSE);
        }
        dto.setCode(ResponseData.ResponseEnum.RUN_TIME_EXCEPTION.getCode());
        dto.setMessage(e.getMessage());
        responseData.setMsg(e.getMessage());
        responseData.setData((Object)Boolean.FALSE);
        this.assemblyObject(dto);
        return responseData;
    }

    private void assemblyObject(String code, String message, String detailMessage) {
        SysExceptionSaveDto dto = new SysExceptionSaveDto();
        dto.setTenantId(this.commonRequest.getTenant());
        dto.setCreateId(this.commonRequest.getUserId().toString());
        dto.setCode(code);
        dto.setMessage(message);
        dto.setDetailMessage(detailMessage);
        dto.setUrl(this.request.getRequestURI());
        dto.setMethod(this.request.getMethod());
        dto.setRemoteUser(this.request.getRemoteUser());
        this.sysExceptionService.sysExceptionSave(dto);
    }

    private void assemblyObject(SysExceptionSaveDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        dto.setCreateId(this.commonRequest.getUserId().toString());
        dto.setUrl(this.request.getRequestURI());
        dto.setMethod(this.request.getMethod());
        dto.setRemoteUser(this.request.getRemoteUser());
        this.sysExceptionService.sysExceptionSave(dto);
    }
}

