/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.sys.api.dto.drug.GenerateTakeStockDto;
import com.byh.sys.api.dto.drug.TakeStockPageDto;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.drug.DrugFlowDirectionEntity;
import com.byh.sys.api.model.drug.DrugSaleInfoEntity;
import com.byh.sys.api.model.drug.DrugTakeStockEntity;
import com.byh.sys.api.util.BeanUtil;
import com.byh.sys.api.util.EasyExcelUtil;
import com.byh.sys.api.vo.drug.ExportDrugTakeStockVo;
import com.byh.sys.api.vo.drug.GenerateTakeStockVo;
import com.byh.sys.data.repository.DrugFlowDirectionMapper;
import com.byh.sys.data.repository.DrugSaleInfoMapper;
import com.byh.sys.data.repository.DrugTakeStockMapper;
import com.byh.sys.web.service.DrugTakeStockService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DrugTakeStockServiceImpl
extends ServiceImpl<DrugTakeStockMapper, DrugTakeStockEntity>
implements DrugTakeStockService {
    private Logger logger = LoggerFactory.getLogger(DrugTakeStockServiceImpl.class);
    @Resource
    private DrugFlowDirectionMapper drugFlowDirectionMapper;
    @Resource
    private DrugSaleInfoMapper drugSaleInfoMapper;
    @Resource
    private DrugTakeStockMapper drugTakeStockMapper;

    public void exportTakeStockList(HttpServletResponse response, TakeStockPageDto dto) {
        List exportList = this.drugTakeStockMapper.selectExportList(dto);
        EasyExcelUtil.exportExcelSheet((HttpServletResponse)response, (String)"\uff08\u8fdb\u9500\u5b58\uff09\u76d8\u70b9", (String)"\uff08\u8fdb\u9500\u5b58\uff09\u76d8\u70b9", (Object)new ExportDrugTakeStockVo(), (List)exportList, null);
    }

    public Page<DrugTakeStockEntity> selectDetailPageList(TakeStockPageDto dto) {
        Page page = new Page((long)dto.getCurrent().intValue(), (long)dto.getSize().intValue());
        List list = this.drugTakeStockMapper.selectDetailPageList(page, dto);
        page.setRecords(list);
        return page;
    }

    public Page<DrugTakeStockEntity> selectGroupPageList(TakeStockPageDto dto) {
        Page page = new Page((long)dto.getCurrent().intValue(), (long)dto.getSize().intValue());
        List list = this.drugTakeStockMapper.selectGroupPageList(page, dto);
        page.setRecords(list);
        return page;
    }

    public String getLastDateForTakeStock() {
        return this.drugTakeStockMapper.getLastDateForTakeStock();
    }

    @Transactional(rollbackFor={BusinessException.class})
    public String generateTakeStockList(GenerateTakeStockDto dto) {
        List errorTakeStockList;
        String startDate = dto.getStartDate();
        String endDate = dto.getEndDate();
        List dateDtoList = this.generateDateDtoList(startDate, endDate);
        StringBuilder successInfoBuilder = new StringBuilder();
        String successInfo = "";
        boolean generateFlag = true;
        GenerateTakeStockVo vo = new GenerateTakeStockVo();
        if (!dateDtoList.isEmpty()) {
            GenerateTakeStockDto firstDateDto = (GenerateTakeStockDto)dateDtoList.get(0);
            String firstStartDate = firstDateDto.getStartDate();
            String firstEndDate = firstDateDto.getEndDate();
            LambdaQueryWrapper takeStockQueryWrapper = Wrappers.lambdaQuery();
            takeStockQueryWrapper.between(DrugTakeStockEntity::getCheckDate, (Object)firstStartDate, (Object)firstEndDate);
            List takeStockList = this.drugTakeStockMapper.selectList((Wrapper)takeStockQueryWrapper);
            Map takeStockMap = takeStockList.stream().collect(Collectors.groupingBy(e -> firstEndDate, LinkedHashMap::new, Collectors.toList()));
            vo.setTakeStockMap(takeStockMap);
            for (GenerateTakeStockDto generateTakeStockDto : dateDtoList) {
                String monthStartDate = generateTakeStockDto.getStartDate();
                String monthEndDate = generateTakeStockDto.getEndDate();
                successInfoBuilder.append(monthStartDate).append(" \u2014 ").append(monthEndDate).append("\uff0c");
                GenerateTakeStockVo generateTakeStockVo = this.getTakeStockList(generateTakeStockDto, vo);
                if (generateTakeStockVo.isFlag()) continue;
                generateFlag = false;
                break;
            }
            if (generateFlag) {
                successInfo = "\u76d8\u70b9\u6570\u636e\u5168\u90e8\u751f\u6210\uff01";
            } else if (successInfoBuilder.length() > 0) {
                successInfoBuilder.setLength(successInfoBuilder.length() - 1);
                successInfo = "\u4ee5\u4e0b\u65f6\u95f4\u8282\u70b9\u6210\u529f\u8ba1\u7b97\u51fa\u76d8\u70b9\u6570\u636e\uff1a" + successInfoBuilder.toString();
            }
        } else {
            successInfo = "\u67e5\u8be2\u65f6\u95f4\u8303\u56f4\u4e0d\u8db3\u4e00\u4e2a\u6708";
        }
        Map takeStockMap = vo.getTakeStockMap();
        List drugTakeList = takeStockMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        if (!drugTakeList.isEmpty()) {
            LambdaQueryWrapper deleteWrapper = Wrappers.lambdaQuery();
            ((LambdaQueryWrapper)deleteWrapper.between(DrugTakeStockEntity::getCheckDate, (Object)startDate, (Object)endDate)).notLike(DrugTakeStockEntity::getRemark, (Object)"\u6570\u636e\u5f02\u5e38\uff01");
            this.drugTakeStockMapper.delete((Wrapper)deleteWrapper);
            this.drugTakeStockMapper.insertList(drugTakeList);
        }
        if (!(errorTakeStockList = vo.getErrorDrugTakeList()).isEmpty()) {
            LambdaQueryWrapper deleteWrapper = Wrappers.lambdaQuery();
            ((LambdaQueryWrapper)deleteWrapper.between(DrugTakeStockEntity::getCheckDate, (Object)startDate, (Object)endDate)).like(DrugTakeStockEntity::getRemark, (Object)"\u6570\u636e\u5f02\u5e38\uff01");
            this.drugTakeStockMapper.delete((Wrapper)deleteWrapper);
            this.drugTakeStockMapper.insertList(errorTakeStockList);
        }
        return successInfo;
    }

    private GenerateTakeStockVo getTakeStockList(GenerateTakeStockDto dto, GenerateTakeStockVo vo) {
        String startDateStr = dto.getStartDate();
        String endDateStr = dto.getEndDate();
        String endDateForLastMonth = this.getLastMonthEndDate(endDateStr);
        Map takeStockMap = vo.getTakeStockMap();
        List<DrugTakeStockEntity> takeStockList = takeStockMap.getOrDefault(endDateStr, Collections.emptyList());
        if (takeStockList.isEmpty()) {
            vo.setFlag(false);
            return vo;
        }
        List thirdCodes = takeStockList.stream().map(DrugTakeStockEntity::getThirdCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (thirdCodes.isEmpty()) {
            vo.setFlag(false);
            return vo;
        }
        List drugSaleList = this.drugSaleInfoMapper.selectListByThirdCodes(thirdCodes, startDateStr, endDateStr);
        List flowDirectionList = this.drugFlowDirectionMapper.selectListByThirdCodes(thirdCodes, startDateStr, endDateStr);
        if (drugSaleList.isEmpty() && flowDirectionList.isEmpty()) {
            vo.setFlag(false);
            return vo;
        }
        Map<String, Integer> drugSaleMap = drugSaleList.stream().filter(e -> StrUtil.isNotEmpty((CharSequence)e.getThirdCode())).collect(Collectors.toMap(DrugSaleInfoEntity::getThirdCode, e -> Optional.ofNullable(e.getOutNum()).orElse(0)));
        Map<String, Integer> flowDirectionMap = flowDirectionList.stream().filter(e -> StrUtil.isNotEmpty((CharSequence)e.getThirdCode())).collect(Collectors.toMap(DrugFlowDirectionEntity::getThirdCode, e -> Optional.ofNullable(e.getInOutNum()).orElse(0)));
        ArrayList lastMonthTakeStockList = new ArrayList();
        List errorTakeStockList = vo.getErrorDrugTakeList();
        takeStockList.forEach(takeStock -> {
            Integer stockNum = takeStock.getStockNum();
            Integer realStockNum = takeStock.getRealStockNum();
            String thirdCode = takeStock.getThirdCode();
            BigDecimal retailPrice = takeStock.getRetailPrice();
            Integer flowDirectionNum = flowDirectionMap.getOrDefault(thirdCode, 0);
            Integer saleNum = drugSaleMap.getOrDefault(thirdCode, 0);
            Integer lastMonthStockNum = stockNum - (flowDirectionNum - saleNum);
            Integer lastMonthRealStockNum = realStockNum - (flowDirectionNum - saleNum);
            DrugTakeStockEntity lastMonthTakeStock = new DrugTakeStockEntity();
            BeanUtil.copy((Object)takeStock, (Object)lastMonthTakeStock);
            LocalDate checkDate = LocalDate.parse(endDateForLastMonth);
            lastMonthTakeStock.setCheckDate(Date.from(checkDate.atStartOfDay(ZoneId.systemDefault()).toInstant()));
            lastMonthTakeStock.setStockNum(lastMonthStockNum);
            BigDecimal lastTotalAmount = retailPrice.multiply(BigDecimal.valueOf(lastMonthStockNum.intValue()));
            lastMonthTakeStock.setTotalAmount(lastTotalAmount);
            lastMonthTakeStock.setRealStockNum(lastMonthRealStockNum);
            BigDecimal lastRealTotalAmount = retailPrice.multiply(BigDecimal.valueOf(lastMonthRealStockNum.intValue()));
            lastMonthTakeStock.setRealTotalAmount(lastRealTotalAmount);
            Integer discrepancy = lastMonthRealStockNum - lastMonthStockNum;
            lastMonthTakeStock.setDiscrepancy(discrepancy);
            lastMonthTakeStock.setId(null);
            if (lastMonthStockNum < 0 || lastMonthRealStockNum < 0) {
                lastMonthTakeStock.setRemark("\u6570\u636e\u5f02\u5e38\uff01");
                errorTakeStockList.add(lastMonthTakeStock);
            } else {
                lastMonthTakeStock.setRemark(endDateForLastMonth);
                lastMonthTakeStockList.add(lastMonthTakeStock);
            }
        });
        takeStockMap.put(endDateForLastMonth, lastMonthTakeStockList);
        vo.setTakeStockMap(takeStockMap);
        vo.setErrorDrugTakeList(errorTakeStockList);
        return vo;
    }

    private List<GenerateTakeStockDto> generateDateDtoList(String startDateStr, String endDateStr) {
        LocalDate realLastEndDateLocal;
        GenerateTakeStockDto lastDateDto;
        LocalDate lastEndDateLocal;
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate startDateLocal = LocalDate.parse(startDateStr, dateTimeFormatter);
        LocalDate endDateLocal = LocalDate.parse(endDateStr, dateTimeFormatter);
        ArrayList<GenerateTakeStockDto> dateDtoList = new ArrayList<GenerateTakeStockDto>();
        LocalDate currentStart = startDateLocal.withDayOfMonth(1);
        LocalDate currentEnd = currentStart.with(TemporalAdjusters.lastDayOfMonth());
        if (!startDateLocal.isBefore(currentEnd)) {
            currentEnd = startDateLocal;
        }
        GenerateTakeStockDto dto = new GenerateTakeStockDto();
        dto.setStartDate(currentStart.toString());
        dto.setEndDate(currentEnd.isAfter(endDateLocal) ? endDateLocal.toString() : currentEnd.toString());
        dateDtoList.add(dto);
        currentStart = currentStart.plusMonths(1L).withDayOfMonth(1);
        currentEnd = currentStart.with(TemporalAdjusters.lastDayOfMonth());
        while (!currentStart.isAfter(endDateLocal)) {
            dto = new GenerateTakeStockDto();
            dto.setStartDate(currentStart.toString());
            dto.setEndDate(currentEnd.isAfter(endDateLocal) ? endDateLocal.toString() : currentEnd.toString());
            dateDtoList.add(dto);
            currentStart = currentStart.plusMonths(1L).withDayOfMonth(1);
            currentEnd = currentStart.with(TemporalAdjusters.lastDayOfMonth());
        }
        if (!dateDtoList.isEmpty() && (lastEndDateLocal = LocalDate.parse((lastDateDto = (GenerateTakeStockDto)dateDtoList.get(dateDtoList.size() - 1)).getEndDate(), dateTimeFormatter)).isBefore(realLastEndDateLocal = lastEndDateLocal.with(TemporalAdjusters.lastDayOfMonth()))) {
            lastDateDto.setEndDate(realLastEndDateLocal.toString());
        }
        dateDtoList.sort(Comparator.comparing(GenerateTakeStockDto::getStartDate).reversed());
        return dateDtoList;
    }

    private String getLastMonthEndDate(String date) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate localDate = LocalDate.parse(date, formatter);
        LocalDate lastDayOfLastMonth = localDate.minusMonths(1L).with(TemporalAdjusters.lastDayOfMonth());
        return lastDayOfLastMonth.format(formatter);
    }
}

