/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.sys.api.dto.SysEasyEntity;
import com.byh.sys.api.dto.purchaseOrder.FlDataCallBackDto;
import com.byh.sys.api.dto.purchaseOrder.PurchaseOrderDto;
import com.byh.sys.api.dto.purchaseOrder.PurchaseOrderSaveDto;
import com.byh.sys.api.dto.purchaseOrder.PurchaseOrderUpdateDto;
import com.byh.sys.api.dto.purchaseOrder.PurchaseOrderUpdateStatusDto;
import com.byh.sys.api.dto.purchaseOrderDetail.PurchaseOrderDetailSaveDto;
import com.byh.sys.api.enums.PurchaseOrderEnum;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.PurchaseOrderDetailEntity;
import com.byh.sys.api.model.PurchaseOrderEntity;
import com.byh.sys.api.model.SysParamEntity;
import com.byh.sys.api.util.BeanUtil;
import com.byh.sys.api.util.ExceptionUtils;
import com.byh.sys.api.util.HttpUtils;
import com.byh.sys.api.util.StringUtils;
import com.byh.sys.api.util.UUIDUtils;
import com.byh.sys.api.vo.PurchaseOrderDetailPushVo;
import com.byh.sys.api.vo.PurchaseOrderPushVo;
import com.byh.sys.api.vo.PurchaseOrderVo;
import com.byh.sys.api.vo.drug.SysDrugOrderVo;
import com.byh.sys.api.vo.purchaseOrder.PushDownloadLocalbillVo;
import com.byh.sys.data.repository.FlDataCallBackMapper;
import com.byh.sys.data.repository.PurchaseOrderDetailMapper;
import com.byh.sys.data.repository.PurchaseOrderMapper;
import com.byh.sys.data.repository.SysParamMapper;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.PurchaseOrderDetailService;
import com.byh.sys.web.service.PurchaseOrderService;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PurchaseOrderServiceImpl
implements PurchaseOrderService {
    @Resource
    private PurchaseOrderMapper purchaseOrderMapper;
    @Resource
    private PurchaseOrderDetailService purchaseOrderDetailService;
    @Resource
    private PurchaseOrderDetailMapper purchaseOrderDetailMapper;
    private Logger logger = LoggerFactory.getLogger(PurchaseOrderServiceImpl.class);
    @Autowired
    private CommonRequest commonRequest;
    @Autowired
    private SysParamMapper sysParamMapper;
    @Autowired
    private FlDataCallBackMapper flDataCallBackMapper;

    @Transactional(rollbackFor={BusinessException.class})
    public void purchaseOrderSave(PurchaseOrderSaveDto dto) {
        SysParamEntity param = (SysParamEntity)this.sysParamMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysParamEntity::getName, (Object)"purchase_order_param")).eq(SysParamEntity::getTenantId, (Object)dto.getTenantId()));
        PurchaseOrderSaveDto order = (PurchaseOrderSaveDto)JSONObject.parseObject((String)param.getValue(), PurchaseOrderSaveDto.class);
        dto.setYwly(order.getYwly());
        dto.setCustomid(order.getCustomid());
        dto.setSamode(order.getSamode());
        dto.setFixmode(order.getFixmode());
        dto.setInvtype(order.getInvtype());
        dto.setSettletypeid(order.getSettletypeid());
        dto.setDelivermethod(order.getDelivermethod());
        PurchaseOrderEntity entity = (PurchaseOrderEntity)BeanUtil.copy((Object)dto, PurchaseOrderEntity.class);
        int a = this.purchaseOrderMapper.purchaseOrderSave(entity);
        entity.setMemo(entity.getOrderid().toString() + "-" + dto.getDelivery());
        this.purchaseOrderMapper.update((Object)entity, (Wrapper)Wrappers.lambdaQuery().eq(PurchaseOrderEntity::getOrderid, (Object)entity.getOrderid()));
        for (PurchaseOrderDetailSaveDto n : dto.getList()) {
            n.setOrderid(entity.getOrderid());
            n.setTenantId(dto.getTenantId());
        }
        this.purchaseOrderDetailService.purchaseOrderDetailSaveBatch(dto.getList());
    }

    public IPage<PurchaseOrderVo> purchaseOrderSelect(Page page, PurchaseOrderDto dto) {
        IPage list = this.purchaseOrderMapper.purchaseOrderSelect(page, dto);
        return list;
    }

    public IPage<PurchaseOrderVo> purchaseOrderPreInSelect(Page page, PurchaseOrderDto dto) {
        dto.setPushFlag("1");
        dto.setInFlag("0");
        dto.setStatus("1");
        IPage list = this.purchaseOrderMapper.purchaseOrderSelect(page, dto);
        return list;
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void purchaseOrderUpdate(PurchaseOrderUpdateDto dto) {
        this.purchaseOrderDetailMapper.delete((Wrapper)Wrappers.lambdaQuery().eq(PurchaseOrderDetailEntity::getOrderid, (Object)dto.getOrderid()));
        List purchaseOrderDetailSaveDtos = BeanUtil.copyList((List)dto.getList(), PurchaseOrderDetailSaveDto.class);
        for (PurchaseOrderDetailSaveDto n : purchaseOrderDetailSaveDtos) {
            if (null != n.getOrderdtlid()) continue;
            n.setOrderdtlid(Integer.valueOf(Integer.parseInt(UUIDUtils.getRandom((int)8, (boolean)false))));
            n.setTenantId(this.commonRequest.getTenant());
        }
        this.purchaseOrderDetailMapper.purchaseOrderDetailSaveBatch(purchaseOrderDetailSaveDtos);
        PurchaseOrderEntity entity = (PurchaseOrderEntity)BeanUtil.copy((Object)dto, PurchaseOrderEntity.class);
        entity.setMemo(entity.getOrderid() + "-" + dto.getDelivery());
        int a = this.purchaseOrderMapper.update((Object)entity, (Wrapper)Wrappers.lambdaUpdate().eq(PurchaseOrderEntity::getOrderid, (Object)dto.getOrderid()));
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void purchaseOrderUpdateStatus(PurchaseOrderUpdateStatusDto dto) {
        PurchaseOrderEntity entity = (PurchaseOrderEntity)BeanUtil.copy((Object)dto, PurchaseOrderEntity.class);
        int a = this.purchaseOrderMapper.update((Object)entity, (Wrapper)Wrappers.lambdaUpdate().eq(PurchaseOrderEntity::getOrderid, (Object)dto.getOrderid()));
        ExceptionUtils.createException((Logger)this.logger, (int)a, (String)"500", (String)"\u3010purchaseOrderUpdateStatus\u3011\u66f4\u65b0\u72b6\u6001\u5f02\u5e38");
    }

    public void purchaseOrderDelete(PurchaseOrderEntity entity) {
        int a = this.purchaseOrderMapper.purchaseOrderDelete(entity);
    }

    public void purchaseOrderPush(SysEasyEntity dto) {
        JSONObject json = new JSONObject();
        PurchaseOrderEntity purchaseOrderEntity = (PurchaseOrderEntity)this.purchaseOrderMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(PurchaseOrderEntity::getOrderid, (Object)dto.getId())).eq(PurchaseOrderEntity::getTenantId, (Object)dto.getTenantId()));
        ExceptionUtils.createException((Logger)this.logger, (boolean)"1".equals(purchaseOrderEntity.getPushFlag()), (String)PurchaseOrderEnum.PURCHASE_ORDER_ALREADY_PUSH.getCode(), (String)PurchaseOrderEnum.PURCHASE_ORDER_ALREADY_PUSH.getName());
        List details = this.purchaseOrderDetailMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(PurchaseOrderDetailEntity::getOrderid, (Object)purchaseOrderEntity.getOrderid())).eq(PurchaseOrderDetailEntity::getTenantId, (Object)dto.getTenantId()));
        PurchaseOrderPushVo vo = (PurchaseOrderPushVo)BeanUtil.copy((Object)purchaseOrderEntity, PurchaseOrderPushVo.class);
        vo.setDetails(BeanUtil.copyList((List)details, PurchaseOrderDetailPushVo.class));
        JSONArray jsonArray = new JSONArray(3);
        jsonArray.add((Object)vo);
        json.put("data", (Object)jsonArray);
        System.out.println(json.toJSONString());
        try {
            SysParamEntity url = (SysParamEntity)this.sysParamMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysParamEntity::getName, (Object)"purchase_order_url")).eq(SysParamEntity::getTenantId, (Object)dto.getTenantId()));
            String resultJson = HttpUtils.post((String)url.getValue(), (String)json.toJSONString());
            this.resultJsonFormat(resultJson, purchaseOrderEntity);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public IPage<SysDrugOrderVo> orderRelationInventory(Page page, SysEasyEntity entity) {
        IPage list = this.purchaseOrderMapper.orderRelationInventory(page, entity.getId(), entity.getTenantId());
        return list;
    }

    private void resultJsonFormat(String resultJson, PurchaseOrderEntity purchaseOrderEntity) {
        JSONObject parse;
        String code;
        if (!StringUtils.isJSONString((String)resultJson)) {
            purchaseOrderEntity.setPushFlag("2");
            this.purchaseOrderMapper.update((Object)purchaseOrderEntity, (Wrapper)Wrappers.lambdaUpdate().eq(PurchaseOrderEntity::getOrderid, (Object)purchaseOrderEntity.getOrderid()));
            ExceptionUtils.createException((Logger)this.logger, (boolean)Boolean.TRUE, (String)PurchaseOrderEnum.PURCHASE_ORDER_PUSH_FAIL.getCode(), (String)("\u3010" + PurchaseOrderEnum.PURCHASE_ORDER_PUSH_FAIL.getName() + "\u3011" + resultJson));
        }
        if ("1".equals(code = (String)(parse = (JSONObject)JSON.parse((String)resultJson)).get((Object)"returnCode"))) {
            purchaseOrderEntity.setPushFlag("1");
            this.purchaseOrderMapper.update((Object)purchaseOrderEntity, (Wrapper)Wrappers.lambdaUpdate().eq(PurchaseOrderEntity::getOrderid, (Object)purchaseOrderEntity.getOrderid()));
        } else {
            purchaseOrderEntity.setPushFlag("2");
            this.purchaseOrderMapper.update((Object)purchaseOrderEntity, (Wrapper)Wrappers.lambdaUpdate().eq(PurchaseOrderEntity::getOrderid, (Object)purchaseOrderEntity.getOrderid()));
            ExceptionUtils.createException((Logger)this.logger, (boolean)Boolean.TRUE, (String)PurchaseOrderEnum.PURCHASE_ORDER_PUSH_FAIL.getCode(), (String)("\u3010" + PurchaseOrderEnum.PURCHASE_ORDER_PUSH_FAIL.getName() + "\u3011" + resultJson));
        }
    }

    public IPage<PushDownloadLocalbillVo> selectPdaPurchaseOrder(Page page, FlDataCallBackDto dto) {
        IPage list = this.flDataCallBackMapper.select(page, dto);
        return list;
    }
}

