/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.sys.api.dto.drug.SysDrugComputerPurchasePlainDto;
import com.byh.sys.api.dto.drug.drugPharmacSimple.SysDrugPharmacySimpleDto;
import com.byh.sys.api.dto.drug.drugPharmacSimple.SysDrugPharmacySimpleExcel;
import com.byh.sys.api.dto.drug.drugPharmacSimple.SysDrugPharmacySimpleSaveDto;
import com.byh.sys.api.dto.drug.drugPharmacSimple.SysDrugPharmacySimpleUpdateDto;
import com.byh.sys.api.dto.drug.drugPharmacy.SysDrugPharmacyDto;
import com.byh.sys.api.enums.SysDrugEnum;
import com.byh.sys.api.model.SysInventoryAlertEntity;
import com.byh.sys.api.model.drug.SysDrugEntity;
import com.byh.sys.api.model.drug.pharmacy.SysDrugPharmacySimpleEntity;
import com.byh.sys.api.model.drug.pharmacy.SysDrugPharmacyStorageEntity;
import com.byh.sys.api.util.BeanUtil;
import com.byh.sys.api.util.DateUtils;
import com.byh.sys.api.util.EasyExcelUtil;
import com.byh.sys.api.util.ExceptionUtils;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.api.util.StringUtils;
import com.byh.sys.api.util.UUIDUtils;
import com.byh.sys.api.vo.drug.SimpleExportByDrugVo;
import com.byh.sys.api.vo.drug.SysDrugComputerPurchasePlainVo;
import com.byh.sys.api.vo.drug.SysDrugEffectiveWarningVo;
import com.byh.sys.api.vo.drug.SysDrugPharmacySimpleVo;
import com.byh.sys.api.vo.drug.SysDrugPharmacyVo;
import com.byh.sys.data.repository.SysDrugMapper;
import com.byh.sys.data.repository.SysDrugPharmacyCheckMapper;
import com.byh.sys.data.repository.SysDrugPharmacyInPrescriptionMapper;
import com.byh.sys.data.repository.SysDrugPharmacyMapper;
import com.byh.sys.data.repository.SysDrugPharmacySimpleMapper;
import com.byh.sys.data.repository.SysDrugPharmacyStorageMapper;
import com.byh.sys.web.call_function.ExtendServiceImpl;
import com.byh.sys.web.service.SysDrugPharmacySimpleService;
import com.byh.sys.web.service.SysInventoryAlertService;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SysDrugPharmacySimpleServiceImpl
implements SysDrugPharmacySimpleService {
    private static final Logger log = LoggerFactory.getLogger(SysDrugPharmacySimpleServiceImpl.class);
    @Resource
    private SysDrugPharmacySimpleMapper sysDrugPharmacySimpleMapper;
    @Resource
    private SysDrugPharmacyMapper sysDrugPharmacyMapper;
    @Resource
    private SysDrugMapper sysDrugMapper;
    @Resource
    private SysDrugPharmacyInPrescriptionMapper sysDrugPharmacyInPrescriptionMapper;
    @Resource
    private SysDrugPharmacyStorageMapper sysDrugPharmacyStorageMapper;
    @Autowired
    private ExtendServiceImpl extendServiceImpl;
    @Autowired
    private SysInventoryAlertService sysInventoryAlertService;
    @Autowired
    private SysDrugPharmacyCheckMapper sysDrugPharmacyCheckMapper;

    public void sysDrugPharmacySimpleSave(SysDrugPharmacySimpleSaveDto dto) {
        SysDrugPharmacySimpleEntity entity = (SysDrugPharmacySimpleEntity)BeanUtil.copy((Object)dto, SysDrugPharmacySimpleEntity.class);
        int a = this.sysDrugPharmacySimpleMapper.insert((Object)entity);
    }

    public ResponseData sysDrugPharmacySimpleSaveToDual(SysDrugPharmacySimpleSaveDto dto) {
        String drugsId;
        ArrayList<String> drugsIds = dto.getDrugsIds();
        if (drugsIds == null) {
            drugsIds = new ArrayList<String>();
        }
        if (!StringUtils.isBlank((String)(drugsId = dto.getDrugsId()))) {
            drugsIds.add(drugsId);
        }
        List list = this.sysDrugPharmacySimpleMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugPharmacySimpleEntity::getTenantId, (Object)dto.getTenantId())).in(SysDrugPharmacySimpleEntity::getDrugsId, drugsIds)).eq(SysDrugPharmacySimpleEntity::getWarehouse, (Object)"2024122210263130864"));
        for (SysDrugPharmacySimpleEntity sysDrugPharmacySimpleEntity : list) {
            String id = sysDrugPharmacySimpleEntity.getDrugsId();
            if (!drugsIds.contains(id)) continue;
            drugsIds.remove(drugsIds.indexOf(id));
        }
        ArrayList<SysDrugPharmacySimpleEntity> insertList = new ArrayList<SysDrugPharmacySimpleEntity>();
        if (drugsIds.size() > 0) {
            List sysDrugEntities = this.sysDrugMapper.selectBatchIds(drugsIds);
            for (SysDrugEntity drugEntity : sysDrugEntities) {
                SysDrugPharmacySimpleEntity entity = (SysDrugPharmacySimpleEntity)BeanUtil.copy((Object)drugEntity, SysDrugPharmacySimpleEntity.class);
                entity.setId(UUIDUtils.getRandom((int)5, (boolean)true));
                entity.setUnit(drugEntity.getPackLargeUnits());
                entity.setDrugsId(drugEntity.getId());
                entity.setActualInventory(Integer.valueOf(0));
                entity.setOccupyInventory(Integer.valueOf(0));
                entity.setPurchaseAmount(new BigDecimal(0));
                entity.setCreateId(dto.getCreateId());
                entity.setDelFlag("0");
                entity.setWarehouse("2024122210263130864");
                entity.setOffline(Integer.valueOf(0));
                entity.setVisitType("1");
                entity.setTenantId(dto.getTenantId());
                insertList.add(entity);
            }
            if (insertList.size() > 0) {
                int n = this.sysDrugPharmacySimpleMapper.batchInsert(insertList);
            }
        }
        return ResponseData.success().save();
    }

    public ResponseData sysDrugPharmacySimpleDelToDual(SysDrugPharmacySimpleSaveDto dto) {
        int delete = this.sysDrugPharmacySimpleMapper.delete((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugPharmacySimpleEntity::getTenantId, (Object)dto.getTenantId())).eq(SysDrugPharmacySimpleEntity::getDrugsId, (Object)dto.getDrugsId())).eq(SysDrugPharmacySimpleEntity::getWarehouse, (Object)"2024122210263130864"));
        if (delete == 0) {
            return ResponseData.error((String)"\u5220\u9664\u5931\u8d25!");
        }
        return ResponseData.success().delete();
    }

    public IPage<SysDrugPharmacySimpleVo> sysDrugPharmacySimpleSelect(Page page, SysDrugPharmacySimpleDto dto) {
        SysInventoryAlertEntity sysInventoryAlertEntity = new SysInventoryAlertEntity();
        sysInventoryAlertEntity.setTenantId(dto.getTenantId());
        sysInventoryAlertEntity = this.sysInventoryAlertService.sysInventoryAlertSelectOne(sysInventoryAlertEntity);
        dto.setMinInventory(sysInventoryAlertEntity.getMinInventory());
        dto.setMaxInventory(sysInventoryAlertEntity.getMaxInventory());
        String[] warehouseArray = new String[]{"2025021410061088294", "2025021410061088295"};
        if (Arrays.asList(warehouseArray).contains(dto.getWarehouse())) {
            if ("2025021410061088294".equals(dto.getWarehouse())) {
                ArrayList<String> list = new ArrayList<String>();
                list.add("1");
                list.add("2");
                dto.setDrugsTypeList(list);
            }
            if ("2025021410061088295".equals(dto.getWarehouse())) {
                dto.setDrugsType("3");
            }
            IPage voPage = this.sysDrugPharmacySimpleMapper.sysDrugPharmacySimpleSelect4(page, dto);
            voPage.getRecords().stream().forEach(item -> item.setActualInventory(Integer.valueOf(1000)));
            return voPage;
        }
        if ("2024122210263130864".equals(dto.getWarehouse())) {
            IPage voPage = this.sysDrugPharmacySimpleMapper.sysDrugPharmacySimpleSelect5(page, dto);
            voPage.getRecords().stream().forEach(item -> item.setActualInventory(Integer.valueOf(1000)));
            return voPage;
        }
        IPage list = this.sysDrugPharmacySimpleMapper.sysDrugPharmacySimpleSelect(page, dto);
        return list;
    }

    public void sysDrugPharmacySimpleUpdate(SysDrugPharmacySimpleUpdateDto dto) {
        SysDrugPharmacySimpleEntity entity = (SysDrugPharmacySimpleEntity)BeanUtil.copy((Object)dto, SysDrugPharmacySimpleEntity.class);
        int a = this.sysDrugPharmacySimpleMapper.update((Object)entity, (Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(SysDrugPharmacySimpleEntity::getId, (Object)dto.getId())).eq(SysDrugPharmacySimpleEntity::getTenantId, (Object)dto.getTenantId()));
    }

    public void sysDrugPharmacySimpleDelete(String[] ids) {
        int a = this.sysDrugPharmacySimpleMapper.sysDrugPharmacySimpleDelete(ids);
    }

    public void sysDrugPharmacySimpleUpdateEntity(SysDrugPharmacySimpleEntity entity) {
        int a = this.sysDrugPharmacySimpleMapper.update((Object)entity, (Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(SysDrugPharmacySimpleEntity::getId, (Object)entity.getId())).eq(SysDrugPharmacySimpleEntity::getTenantId, (Object)entity.getTenantId()));
        ExceptionUtils.createException((Logger)log, (int)a, (String)SysDrugEnum.SYS_DRUG_PHARMACY_SIMPLE_UPDATE_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_SIMPLE_UPDATE_ERROR.getCode());
    }

    public IPage<SysDrugPharmacyVo> sysDrugPharmacyInOutDetail(Page page, SysDrugPharmacyDto dto) {
        IPage list = this.sysDrugPharmacyMapper.sysDrugPharmacySelectNormal(page, dto);
        return list;
    }

    public IPage<SysDrugPharmacyVo> sysDrugPharmacyBatchDetail(Page page, SysDrugPharmacyDto dto, String drugRoomId) {
        IPage list = this.extendServiceImpl.getDrugBackBatchDetail(page, dto, drugRoomId);
        if (!CollectionUtils.isEmpty((Collection)list.getRecords())) {
            for (SysDrugPharmacyVo record : list.getRecords()) {
                int a = DateUtils.dateCompare((Date)record.getEffectiveTime(), (Date)new Date());
                Long days = DateUtils.computedDiffDays((Date)record.getEffectiveTime(), (Date)new Date());
                if (a < 0) {
                    record.setEffectiveTimeWarning(Integer.valueOf(Math.toIntExact(-days.longValue())));
                    continue;
                }
                if (a <= 0) continue;
                record.setEffectiveTimeWarning(Integer.valueOf(Math.toIntExact(days)));
            }
        }
        return list;
    }

    public void sysDrugPharmacySimpleExport(HttpServletResponse response, Page page, SysDrugPharmacySimpleDto dto) {
        SysInventoryAlertEntity sysInventoryAlertEntity = new SysInventoryAlertEntity();
        sysInventoryAlertEntity.setTenantId(dto.getTenantId());
        sysInventoryAlertEntity = this.sysInventoryAlertService.sysInventoryAlertSelectOne(sysInventoryAlertEntity);
        dto.setMinInventory(sysInventoryAlertEntity.getMinInventory());
        dto.setMaxInventory(sysInventoryAlertEntity.getMaxInventory());
        try {
            if ("1".equals(dto.getByBatchNumber())) {
                IPage list = this.sysDrugPharmacySimpleMapper.sysDrugPharmacySimpleSelectExport(page, dto);
                List warehouseList = this.sysDrugPharmacyStorageMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(SysDrugPharmacyStorageEntity::getTenantId, (Object)dto.getTenantId()));
                Map<String, List<SysDrugPharmacyStorageEntity>> warehouseMap = warehouseList.stream().collect(Collectors.groupingBy(SysDrugPharmacyStorageEntity::getId));
                List excels = BeanUtil.copyList((List)list.getRecords(), SysDrugPharmacySimpleExcel.class);
                this.exportSetDict(excels, warehouseMap);
                String excelName = "\u836f\u623f\u5e93\u5b58\u660e\u7ec6\u5bfc\u51fa";
                String sheetName = "\u836f\u623f\u5e93\u5b58\u660e\u7ec6";
                EasyExcelUtil.exportExcel((HttpServletResponse)response, (String)excelName, (String)sheetName, (List)excels, (Object)new SysDrugPharmacySimpleExcel());
            } else if ("0".equals(dto.getByBatchNumber())) {
                List list = this.sysDrugPharmacySimpleMapper.sysDrugPharmacySimpleSelectExportByDrug(dto);
                String excelName = "\u836f\u623f\u5e93\u5b58\u660e\u7ec6\u5bfc\u51fa";
                String sheetName = "\u836f\u623f\u5e93\u5b58\u660e\u7ec6";
                EasyExcelUtil.exportExcel((HttpServletResponse)response, (String)excelName, (String)sheetName, (List)list, (Object)new SimpleExportByDrugVo());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ExceptionUtils.createException((Logger)log, (boolean)true, (String)SysDrugEnum.SYS_DRUG_PHARMACY_SIMPLE_EXPORT_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_SIMPLE_EXPORT_ERROR.getName());
        }
    }

    private <T> void exportSetDict(List<T> objList, Map<String, List<SysDrugPharmacyStorageEntity>> warehouseMap) throws Exception {
        for (T n : objList) {
            Class<?> aClass = n.getClass();
            Field inventoryStatus = aClass.getDeclaredField("inventoryStatus");
            Field warehouse = aClass.getDeclaredField("warehouse");
            Field minActualInventory = aClass.getDeclaredField("minActualInventory");
            Field maxActualInventory = aClass.getDeclaredField("maxActualInventory");
            Field surplusQuantity = aClass.getDeclaredField("surplusQuantity");
            inventoryStatus.setAccessible(true);
            warehouse.setAccessible(true);
            minActualInventory.setAccessible(true);
            maxActualInventory.setAccessible(true);
            surplusQuantity.setAccessible(true);
            String its = (String)inventoryStatus.get(n);
            String was = (String)inventoryStatus.get(n);
            Integer minai = (Integer)minActualInventory.get(n);
            Integer maxai = (Integer)maxActualInventory.get(n);
            String spq = (String)surplusQuantity.get(n);
            List<SysDrugPharmacyStorageEntity> l = warehouseMap.get(was);
            if (!CollectionUtils.isEmpty(l)) {
                warehouse.set(n, l.get(0).getName());
            }
            if (StringUtils.isBlank((String)spq)) {
                surplusQuantity.set(n, "0");
                spq = "0";
            }
            if (Integer.parseInt(spq) > maxai) {
                inventoryStatus.set(n, "\u9ad8\u5e93\u5b58");
                continue;
            }
            if (Integer.parseInt(spq) < minai) {
                inventoryStatus.set(n, "\u4f4e\u5e93\u5b58");
                continue;
            }
            inventoryStatus.set(n, "\u6b63\u5e38");
        }
    }

    public IPage<SysDrugComputerPurchasePlainVo> computerPurchasePlain(Page page, SysDrugComputerPurchasePlainDto dto) {
        SysInventoryAlertEntity sysInventoryAlertEntity = new SysInventoryAlertEntity();
        sysInventoryAlertEntity.setTenantId(dto.getTenantId());
        sysInventoryAlertEntity = this.sysInventoryAlertService.sysInventoryAlertSelectOne(sysInventoryAlertEntity);
        dto.setMinInventory(sysInventoryAlertEntity.getMinInventory());
        dto.setMaxInventory(sysInventoryAlertEntity.getMaxInventory());
        IPage list = this.sysDrugPharmacySimpleMapper.computerPurchasePlain(page, dto);
        return list;
    }

    public IPage<SysDrugEffectiveWarningVo> computerEffectiveWarning(Page page, SysDrugComputerPurchasePlainDto dto) {
        IPage list = this.sysDrugPharmacySimpleMapper.computerEffectiveWarning(page, dto);
        return list;
    }

    public Integer computerPurchasePlainCount(SysDrugComputerPurchasePlainDto dto) {
        SysInventoryAlertEntity sysInventoryAlertEntity = new SysInventoryAlertEntity();
        sysInventoryAlertEntity.setTenantId(dto.getTenantId());
        sysInventoryAlertEntity = this.sysInventoryAlertService.sysInventoryAlertSelectOne(sysInventoryAlertEntity);
        dto.setMinInventory(sysInventoryAlertEntity.getMinInventory());
        dto.setMaxInventory(sysInventoryAlertEntity.getMaxInventory());
        Integer total = this.sysDrugPharmacySimpleMapper.computerPurchasePlainCount(dto);
        return total;
    }

    public Integer computerEffectiveWarningCount(SysDrugComputerPurchasePlainDto dto) {
        Integer count = this.sysDrugPharmacySimpleMapper.computerEffectiveWarningCount(dto);
        return count;
    }

    private void setEffectiveTimeWarning(List<Date> timeList, SysDrugPharmacySimpleVo record) {
        if (!CollectionUtils.isEmpty(timeList)) {
            List timeD = timeList.stream().sorted().limit(1L).collect(Collectors.toList());
            int a = DateUtils.dateCompare((Date)((Date)timeD.get(0)), (Date)new Date());
            Long days = DateUtils.computedDiffDays((Date)new Date(), (Date)((Date)timeD.get(0)));
            if (a < 0) {
                record.setEffectiveTimeWarning(Integer.valueOf(Math.toIntExact(-days.longValue())));
            } else if (a > 0) {
                record.setEffectiveTimeWarning(Integer.valueOf(Math.toIntExact(days)));
            }
            record.setEffectiveTime((Date)timeD.get(0));
        }
    }
}

