/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.byh.sys.api.dto.drug.contrast.HsItemCodeDto;
import com.byh.sys.api.dto.drug.contrast.SysHsDrugDto;
import com.byh.sys.api.enums.HsDrugUploadStatusEnum;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.SysChargeItemHsInfoEntity;
import com.byh.sys.api.model.SysHsInfoEntity;
import com.byh.sys.api.model.base.BaseEntity;
import com.byh.sys.api.model.chargeItem.SysChargeItemEntity;
import com.byh.sys.api.model.drug.SysDrugEntity;
import com.byh.sys.api.model.material.SysMaterialEntity;
import com.byh.sys.api.model.treatmentItem.SysTreatmentChargeEntity;
import com.byh.sys.api.model.treatmentItem.SysTreatmentItemEntity;
import com.byh.sys.api.request.UploadCatalogRequest;
import com.byh.sys.api.util.BeanUtil;
import com.byh.sys.api.util.ExcelUtils;
import com.byh.sys.api.util.PageResult;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.api.util.StringPinYinUtil;
import com.byh.sys.api.util.StringWubiUtil;
import com.byh.sys.api.util.UUIDUtils;
import com.byh.sys.api.vo.drug.SysHsContrastExportVo;
import com.byh.sys.data.repository.SysChargeItemHsInfoMapper;
import com.byh.sys.data.repository.SysChargeItemMapper;
import com.byh.sys.data.repository.SysDrugMapper;
import com.byh.sys.data.repository.SysHsInfoMapper;
import com.byh.sys.data.repository.SysMaterialMapper;
import com.byh.sys.data.repository.SysTreatmentChargeMapper;
import com.byh.sys.data.repository.SysTreatmentItemMapper;
import com.byh.sys.web.fegin.HsServiceFeign;
import com.byh.sys.web.service.SysDrugContrastService;
import com.byh.sys.web.service.impl.SysHsInfoContrastServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SysHsInfoContrastServiceImpl
implements SysDrugContrastService {
    private Logger logger = LoggerFactory.getLogger(SysHsInfoContrastServiceImpl.class);
    @Autowired
    private SysHsInfoMapper sysHsInfoMapper;
    @Autowired
    private SysChargeItemHsInfoMapper sysChargeItemHsInfoMapper;
    @Autowired
    private HsServiceFeign hsServiceFeign;
    @Autowired
    private SysDrugMapper sysDrugMapper;
    @Resource
    private SysChargeItemMapper sysChargeItemMapper;
    @Resource
    private SysTreatmentItemMapper sysTreatmentItemMapper;
    @Resource
    private SysTreatmentChargeMapper sysTreatmentChargeMapper;
    @Autowired
    private SysMaterialMapper sysMaterialMapper;
    private static final int TENANT_ID = 1;
    private static final String DATE_FORMAT = "yyyy/M/d";
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy/M/d");
    private static final Map<String, String> medicalChargeCategoryMap = new HashMap();

    @Transactional(rollbackFor={BusinessException.class})
    public void generateHsItem(Integer tenantId) {
        ArrayList<String> types = new ArrayList<String>(Arrays.asList("\u8bca\u5bdf\u8d39", "\u6cbb\u7597\u8d39"));
        List chargeItemHsInfoList = this.sysChargeItemHsInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysChargeItemHsInfoEntity::getTenantId, (Object)tenantId)).in(SysChargeItemHsInfoEntity::getExtendContent, types)).eq(SysChargeItemHsInfoEntity::getVersion, (Object)"1"));
        if (!chargeItemHsInfoList.isEmpty()) {
            ArrayList<SysChargeItemEntity> chargeItemList = new ArrayList<SysChargeItemEntity>();
            ArrayList<SysTreatmentItemEntity> treatmentItemList = new ArrayList<SysTreatmentItemEntity>();
            ArrayList<SysTreatmentChargeEntity> treatmentChargeList = new ArrayList<SysTreatmentChargeEntity>();
            for (SysChargeItemHsInfoEntity hsItem : chargeItemHsInfoList) {
                String itemName = hsItem.getHsDrugName().replace("\\s+", "");
                SysChargeItemEntity chargeItem = new SysChargeItemEntity();
                chargeItem.setTenantId(tenantId);
                chargeItem.setChargeItemCode(UUIDUtils.getNumberRandom((int)9));
                chargeItem.setInHosptialCode(Integer.valueOf(chargeItem.getChargeItemCode()));
                chargeItem.setChargeItemName(itemName);
                chargeItem.setPyCode(StringPinYinUtil.toFirstChar((String)chargeItem.getChargeItemName()));
                chargeItem.setWbCode(StringWubiUtil.getWbCode((String)chargeItem.getChargeItemName()));
                chargeItem.setTreatmentTypeCode("3");
                chargeItem.setTreatmentTypeName("\u6cbb\u7597");
                chargeItem.setApplyGenderCode("3");
                chargeItem.setApplyGenderName("\u4e0d\u9650");
                chargeItem.setItemPrice(new BigDecimal(hsItem.getOneLevelPay()));
                chargeItem.setUnit("295");
                chargeItem.setChargeItemId("19");
                chargeItem.setSourceCode("1");
                chargeItem.setSourceName("\u6807\u51c6\u5e93");
                chargeItem.setStatusCode("1");
                chargeItem.setStatusName("\u542f\u7528\u4e2d");
                chargeItem.setMedicalInsuranceCheckStatusCode("1");
                chargeItem.setMedicalInsuranceCheckStatusName("\u672a\u4e0a\u4f20");
                chargeItem.setIsMergeChargeItem("0");
                chargeItem.setIsUserMedicalInsuranceIdPay("0");
                chargeItem.setMedicalInsuranceTypeCode("3");
                chargeItem.setMedicalInsuranceTypeName("\u5e02\u533b\u4fdd");
                chargeItem.setMedicalInsuranceCode(hsItem.getHsDrugCode());
                chargeItem.setMedicalInsuranceName(itemName);
                if (!"\u81ea\u8d39".equals(hsItem.getFeeLevel())) {
                    chargeItem.setChargeItemLevel(hsItem.getFeeLevel());
                }
                chargeItem.setCreateId(Integer.valueOf(1));
                chargeItem.setCreateName("\u7cfb\u7edf\u5bfc\u5165\u751f\u6210");
                chargeItemList.add(chargeItem);
                this.sysChargeItemMapper.insert((Object)chargeItem);
                Integer chargeId = chargeItem.getId();
                SysTreatmentItemEntity treatmentItem = new SysTreatmentItemEntity();
                treatmentItem.setTenantId(tenantId);
                treatmentItem.setItemCode(UUIDUtils.getNumberRandom((int)9));
                treatmentItem.setItemName(itemName);
                treatmentItem.setPyCode(chargeItem.getPyCode());
                treatmentItem.setWbCode(chargeItem.getWbCode());
                treatmentItem.setTreatmentTypeCode("3");
                treatmentItem.setTreatmentTypeName("\u6cbb\u7597");
                treatmentItem.setItemType("0");
                treatmentItem.setUnit("295");
                treatmentItem.setServiceObjectCode("\u95e8\u8bca");
                treatmentItem.setServiceObjectName("\u95e8\u8bca");
                treatmentItem.setExecuteDeptFlag("2");
                treatmentItem.setApplyGenderCode("3");
                treatmentItem.setApplyGenderName("\u4e0d\u9650");
                treatmentItem.setIsContainServiceFee("0");
                treatmentItem.setStatusCode("1");
                treatmentItem.setStatusName("\u542f\u7528\u4e2d");
                treatmentItem.setCreateId(Integer.valueOf(1));
                treatmentItem.setCreateName("\u7cfb\u7edf\u5bfc\u5165\u751f\u6210");
                treatmentItemList.add(treatmentItem);
                this.sysTreatmentItemMapper.insert((Object)treatmentItem);
                Integer treatmentId = treatmentItem.getId();
                SysTreatmentChargeEntity treatmentCharge = new SysTreatmentChargeEntity();
                treatmentCharge.setTenantId(tenantId);
                treatmentCharge.setTreatmentId(treatmentId);
                treatmentCharge.setChargeId(chargeId);
                treatmentCharge.setQuantity(Integer.valueOf(1));
                treatmentChargeList.add(treatmentCharge);
                this.sysTreatmentChargeMapper.insert((Object)treatmentCharge);
            }
        }
    }

    private boolean isRowEmpty(Row row) {
        for (Cell cell : row) {
            if (cell == null || cell.getCellType() == CellType.BLANK) continue;
            return false;
        }
        return true;
    }

    private String getCellStringValue(Row row, Integer num) {
        String value = Optional.ofNullable(row.getCell(num.intValue())).map(cell -> {
            switch (2.$SwitchMap$org$apache$poi$ss$usermodel$CellType[cell.getCellType().ordinal()]) {
                case 1: {
                    return cell.getStringCellValue();
                }
                case 2: {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                        return dateFormat.format(cell.getDateCellValue());
                    }
                    return String.valueOf(cell.getNumericCellValue());
                }
                case 3: {
                    return String.valueOf(cell.getBooleanCellValue());
                }
                case 4: {
                    return cell.getCellFormula();
                }
            }
            return "";
        }).orElse(null);
        return value;
    }

    public ResponseData<List<SysHsInfoEntity>> hsItemInfoByCodes(List<HsItemCodeDto> dtoList, Integer tenantId) {
        List hsCodes = dtoList.stream().distinct().filter(Objects::nonNull).map(HsItemCodeDto::getHsCode).collect(Collectors.toList());
        Map<String, String> map = dtoList.stream().filter(dto -> dto.getHsCode() != null && StrUtil.isNotEmpty((CharSequence)dto.getHsCode())).collect(Collectors.toMap(dto -> dto.getHsCode() + "," + dto.getHsId(), dto -> dto.getHsCode()));
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(tenantId != null, SysHsInfoEntity::getTenantId, (Object)tenantId);
        queryWrapper.in(!hsCodes.isEmpty(), SysHsInfoEntity::getHsDrugCode, hsCodes);
        queryWrapper.eq(hsCodes.isEmpty(), SysHsInfoEntity::getHsDrugCode, (Object)"-1");
        List list = this.sysHsInfoMapper.selectList((Wrapper)queryWrapper);
        Map<String, SysHsInfoEntity> restrictMap = list.stream().filter(sysHsInfoEntity -> StrUtil.isNotEmpty((CharSequence)sysHsInfoEntity.getRemark())).collect(Collectors.toMap(SysHsInfoEntity::getHsDrugCode, sysHsInfoEntity -> sysHsInfoEntity));
        ArrayList<SysHsInfoEntity> queryList = new ArrayList<SysHsInfoEntity>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            int commaIndex = key.indexOf(",");
            String hsId = key.substring(commaIndex + 1);
            String value = entry.getValue();
            SysHsInfoEntity entity = restrictMap.get(value);
            if (entity == null) continue;
            SysHsInfoEntity dbEntity = new SysHsInfoEntity();
            BeanUtil.copy((Object)entity, (Object)dbEntity);
            dbEntity.setHsId(hsId);
            queryList.add(dbEntity);
        }
        return ResponseData.success(queryList);
    }

    public ResponseData<List<SysHsInfoEntity>> hsItemInfoByCode(String hsCode, Integer tenantId) {
        String[] hsCodeArray = hsCode.split(",");
        List<String> hsCodeList = Arrays.asList(hsCodeArray);
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(tenantId != null, SysHsInfoEntity::getTenantId, (Object)tenantId);
        queryWrapper.in(!hsCodeList.isEmpty(), SysHsInfoEntity::getHsDrugCode, hsCodeList);
        queryWrapper.eq(hsCodeList.isEmpty(), SysHsInfoEntity::getHsDrugCode, (Object)"-1");
        List list = this.sysHsInfoMapper.selectList((Wrapper)queryWrapper);
        return ResponseData.success((Object)list);
    }

    public ResponseData delHsItemInfoById(String id, Integer tenantId) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(tenantId != null, SysHsInfoEntity::getTenantId, (Object)tenantId);
        queryWrapper.eq(BaseEntity::getId, (Object)id);
        int delete = this.sysHsInfoMapper.delete((Wrapper)queryWrapper);
        if (delete == 0) {
            return ResponseData.error((String)"").delete();
        }
        return ResponseData.success().delete();
    }

    public ResponseData<PageResult<SysHsInfoEntity>> hsDrugInfo(SysHsDrugDto hsDrugDto) {
        PageHelper.startPage((int)hsDrugDto.getCurrent(), (int)hsDrugDto.getSize());
        List hsDrugInfoList = this.sysHsInfoMapper.queryDrugInfo(hsDrugDto);
        PageInfo pageInfo = new PageInfo(hsDrugInfoList);
        PageResult pageResult = new PageResult(hsDrugDto.getCurrent().intValue(), hsDrugDto.getSize().intValue());
        pageResult.setTotal(Integer.parseInt(String.valueOf(pageInfo.getTotal())));
        pageResult.setPages(pageInfo.getPages());
        pageResult.setRecords(hsDrugInfoList);
        pageResult.setCurrent(hsDrugDto.getCurrent().intValue());
        pageResult.setSize(hsDrugDto.getSize().intValue());
        return ResponseData.success((Object)pageResult);
    }

    public ResponseData hsDrugBatchUpload(MultipartFile file) {
        try {
            InputStream inputStream = file.getInputStream();
            ArrayList dataList = new ArrayList();
            ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)inputStream, (ReadListener)new /* Unavailable Anonymous Inner Class!! */).sheet(Integer.valueOf(0)).headRowNumber(Integer.valueOf(1))).doRead();
            for (int i = 0; i < 10; ++i) {
                System.out.println(JSONObject.toJSONString(dataList.get(i)));
            }
            return ResponseData.success((Object)this.processData(dataList));
        }
        catch (Exception e) {
            return ResponseData.error((String)("Excel\u6587\u4ef6\u5904\u7406\u5931\u8d25: " + e.getMessage()));
        }
    }

    private ResponseData processData(List<List<String>> dataList) {
        dataList.remove(0);
        ArrayList success = new ArrayList();
        ArrayList error = new ArrayList();
        ArrayList update = new ArrayList();
        HashMap map = new HashMap();
        int threadPoolSize = 10;
        ExecutorService executor = Executors.newFixedThreadPool(threadPoolSize);
        ArrayList<Future<Map>> futures = new ArrayList<Future<Map>>();
        int chunkSize = (dataList.size() + threadPoolSize - 1) / threadPoolSize;
        for (int i = 0; i < dataList.size(); i += chunkSize) {
            int n = Math.min(i + chunkSize, dataList.size());
            List<List<String>> chunk = dataList.subList(i, n);
            futures.add(executor.submit(() -> this.processChunk(chunk)));
        }
        for (Future future : futures) {
            try {
                Map result = (Map)future.get();
                success.addAll((Collection)result.get("success"));
                error.addAll((Collection)result.get("error"));
                update.addAll((Collection)result.get("update"));
            }
            catch (InterruptedException | ExecutionException e) {
                this.logger.error("\u5904\u7406\u5931\u8d25", (Throwable)e);
            }
        }
        executor.shutdown();
        map.put("success", success);
        map.put("error", error);
        map.put("update", update);
        this.logger.info("\u4efb\u52a1\u5df2\u5168\u90e8\u6267\u884c\u5b8c\u6bd5\uff01");
        return ResponseData.success(map);
    }

    private Map<String, List<String>> processChunk(List<List<String>> chunk) {
        ArrayList<String> success = new ArrayList<String>();
        ArrayList<String> error = new ArrayList<String>();
        ArrayList<String> update = new ArrayList<String>();
        for (List<String> rows : chunk) {
            try {
                SysHsInfoEntity sysHsInfoEntity = new SysHsInfoEntity();
                sysHsInfoEntity.setHsDrugCode(rows.get(0));
                sysHsInfoEntity.setDataSorce(rows.get(4));
                sysHsInfoEntity.setRegName(rows.get(5));
                sysHsInfoEntity.setProductName(rows.get(6));
                sysHsInfoEntity.setRegDosageForm(rows.get(7));
                sysHsInfoEntity.setDosageForm(rows.get(8));
                sysHsInfoEntity.setRegSpec(rows.get(9));
                sysHsInfoEntity.setDrugSpec(rows.get(10));
                sysHsInfoEntity.setPackageMaterial(rows.get(11));
                sysHsInfoEntity.setMinPackNum(rows.get(12));
                sysHsInfoEntity.setMinPreparationUnit(rows.get(13));
                sysHsInfoEntity.setMinPackUnit(rows.get(14));
                sysHsInfoEntity.setManufacturer(rows.get(15));
                sysHsInfoEntity.setSubpackageManufacturer(rows.get(16));
                sysHsInfoEntity.setProductManufacturer(rows.get(17));
                sysHsInfoEntity.setApprovalNum(rows.get(18));
                sysHsInfoEntity.setHsDrugName(rows.get(23));
                sysHsInfoEntity.setFeeLevel(rows.get(24));
                sysHsInfoEntity.setHsDosageForm(rows.get(25));
                sysHsInfoEntity.setNumber(rows.get(26));
                sysHsInfoEntity.setRemark(rows.get(27));
                sysHsInfoEntity.setMinPreparationPayStand(rows.get(29));
                sysHsInfoEntity.setPackPayStand(rows.get(30));
                sysHsInfoEntity.setTenantId(Integer.valueOf(1));
                String categoryOfMedicalCharges = rows.get(45);
                sysHsInfoEntity.setDrugType(medicalChargeCategoryMap.getOrDefault(categoryOfMedicalCharges, "0"));
                this.logger.info("\u65b0\u589e\u836f\u54c1\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)sysHsInfoEntity));
                int updateCount = this.updateDrugInfo(rows.get(1));
                if (updateCount > 0) {
                    update.add(rows.get(0));
                }
                Integer i = this.sysHsInfoMapper.selectCount((Wrapper)Wrappers.lambdaQuery().eq(SysHsInfoEntity::getHsDrugCode, (Object)sysHsInfoEntity.getHsDrugCode()));
                int insert = 1;
                if (i == 0) {
                    insert = this.sysHsInfoMapper.insert((Object)sysHsInfoEntity);
                }
                if (insert == 0) {
                    error.add(rows.get(0));
                    continue;
                }
                success.add(rows.get(0));
            }
            catch (Exception e) {
                this.logger.info(e.getMessage());
            }
        }
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        result.put("success", success);
        result.put("error", error);
        result.put("update", update);
        return result;
    }

    private int updateDrugInfo(String originalDrugCode) {
        int update = 0;
        if (StrUtil.isNotBlank((CharSequence)originalDrugCode)) {
            String[] split = originalDrugCode.split(",");
            SysDrugEntity sysDrugEntity = null;
            for (int i = 0; i < split.length; ++i) {
                String code = split[i];
                List sysDrugEntityList = this.sysDrugMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugEntity::getMedicalInsuranceCode, (Object)code)).eq(SysDrugEntity::getTenantId, (Object)1)).eq(SysDrugEntity::getDelFlag, (Object)"0"));
                if (sysDrugEntityList == null || sysDrugEntityList.isEmpty()) continue;
                sysDrugEntity = (SysDrugEntity)sysDrugEntityList.get(0);
                SysDrugEntity updateDrugEntity = new SysDrugEntity();
                updateDrugEntity.setId(sysDrugEntity.getId());
                UpdateWrapper updateWrapper = new UpdateWrapper();
                ((UpdateWrapper)((UpdateWrapper)updateWrapper.set((Object)"medical_insurance_code", null)).set((Object)"medical_insurance_name", null)).eq((Object)"id", (Object)sysDrugEntity.getId());
                update = this.sysDrugMapper.update(null, (Wrapper)updateWrapper);
                this.logger.info("\u5f00\u59cb\u4fee\u6539sys\u836f\u54c1");
                UpdateWrapper updateHsInfo = new UpdateWrapper();
                ((UpdateWrapper)updateHsInfo.set((Object)"del_flag", (Object)Character.valueOf('0'))).eq((Object)"hs_drug_code", (Object)code);
                this.sysHsInfoMapper.update(null, (Wrapper)updateHsInfo);
            }
        }
        return update;
    }

    public ResponseData uploadDrugContrast(List<String> ids, Integer tenantId, String type, String signNo, Integer userId, String userName) {
        ArrayList uplFailDrugIds = new ArrayList();
        List<UploadCatalogRequest> drugContrastList = new ArrayList();
        drugContrastList = "1".equals(type) ? this.sysHsInfoMapper.queryUploadDrugContrast(tenantId, ids) : this.sysHsInfoMapper.queryMaterialDrugContrast(tenantId, ids);
        UploadCatalogRequest uploadCatalogRequest = (UploadCatalogRequest)drugContrastList.get(0);
        uploadCatalogRequest.setTenantId(tenantId);
        uploadCatalogRequest.setSign_no(signNo);
        uploadCatalogRequest.setOpter_type("1");
        uploadCatalogRequest.setOpter(String.valueOf(userId));
        uploadCatalogRequest.setOpter_name(userName);
        drugContrastList.set(0, uploadCatalogRequest);
        List splistList = this.averageAssign(drugContrastList, 99);
        Boolean flag = true;
        for (List uploadCatalogRequestList : splistList) {
            ((UploadCatalogRequest)uploadCatalogRequestList.get(0)).setTenantId(tenantId);
            ((UploadCatalogRequest)uploadCatalogRequestList.get(0)).setSign_no(signNo);
            ((UploadCatalogRequest)uploadCatalogRequestList.get(0)).setOpter_type("1");
            ((UploadCatalogRequest)uploadCatalogRequestList.get(0)).setOpter(String.valueOf(userId));
            ((UploadCatalogRequest)uploadCatalogRequestList.get(0)).setOpter_name(userName);
            ResponseData baseResponse = this.hsServiceFeign.uploadCatalogList(uploadCatalogRequestList);
            if (baseResponse.isSuccess()) continue;
            uplFailDrugIds.addAll(drugContrastList.stream().map(UploadCatalogRequest::getFixmedins_hilist_id).collect(Collectors.toList()));
            flag = false;
        }
        if (flag.booleanValue()) {
            if ("1".equals(type)) {
                this.sysHsInfoMapper.updateUploadStatus(tenantId, ids, HsDrugUploadStatusEnum.SUCC.getValue());
            } else {
                this.sysHsInfoMapper.updateMaterialUploadStatus(tenantId, ids, HsDrugUploadStatusEnum.SUCC.getValue());
            }
            return ResponseData.success((Object)"\u5168\u90e8\u4e0a\u4f20\u6210\u529f\uff01");
        }
        if ("1".equals(type)) {
            this.sysHsInfoMapper.updateUploadStatus(tenantId, uplFailDrugIds, HsDrugUploadStatusEnum.FAIL.getValue());
        } else {
            this.sysHsInfoMapper.updateMaterialUploadStatus(tenantId, ids, HsDrugUploadStatusEnum.FAIL.getValue());
        }
        return ResponseData.error((String)"\u4e0a\u4f20\u5931\u8d25\uff01");
    }

    private List<List<UploadCatalogRequest>> averageAssign(List<UploadCatalogRequest> source, int splitItemNum) {
        ArrayList<List<UploadCatalogRequest>> result = new ArrayList<List<UploadCatalogRequest>>();
        if (source != null && source.size() > 0 && splitItemNum > 0) {
            if (source.size() <= splitItemNum) {
                result.add(source);
            } else {
                int splitNum = source.size() % splitItemNum == 0 ? source.size() / splitItemNum : source.size() / splitItemNum + 1;
                List<UploadCatalogRequest> value = null;
                for (int i = 0; i < splitNum; ++i) {
                    value = i < splitNum - 1 ? source.subList(i * splitItemNum, (i + 1) * splitItemNum) : source.subList(i * splitItemNum, source.size());
                    result.add(value);
                }
            }
        }
        return result;
    }

    public ResponseData queryDrugContrast(SysHsDrugDto sysHsDrugDto) {
        PageHelper.startPage((int)sysHsDrugDto.getCurrent(), (int)sysHsDrugDto.getSize());
        List drugContrastList = new ArrayList();
        drugContrastList = "1".equals(sysHsDrugDto.getSearchType()) ? this.sysHsInfoMapper.queryDrugContrastByNameOrCode(sysHsDrugDto) : this.sysHsInfoMapper.queryMaterialContrastByNameOrCode(sysHsDrugDto);
        PageInfo pageInfo = new PageInfo(drugContrastList);
        PageResult pageResult = new PageResult(sysHsDrugDto.getCurrent().intValue(), sysHsDrugDto.getSize().intValue());
        pageResult.setTotal(Integer.parseInt(String.valueOf(pageInfo.getTotal())));
        pageResult.setPages(pageInfo.getPages());
        pageResult.setRecords(drugContrastList);
        pageResult.setCurrent(sysHsDrugDto.getCurrent().intValue());
        pageResult.setSize(sysHsDrugDto.getSize().intValue());
        return ResponseData.success((Object)pageResult);
    }

    public void downloadContrast(String isContrast, String searchType, Integer tenantId, HttpServletResponse response) {
        List sysHsContrastExportList = new ArrayList();
        sysHsContrastExportList = "1".equals(searchType) ? this.sysHsInfoMapper.queryExportDrugContrastInfo(isContrast, tenantId) : this.sysHsInfoMapper.queryExportMaterialContrastInfo(isContrast, tenantId);
        try {
            if ("1".equals(isContrast)) {
                List collect = sysHsContrastExportList.stream().filter(obj -> !Objects.isNull(obj.getHsDrugCode())).collect(Collectors.toList());
                String excelName = "\u836f\u54c1\u5df2\u5bf9\u7167\u76ee\u5f55";
                String sheetName = "\u836f\u54c1\u76ee\u5f55";
                ExcelUtils.exportExcel(collect, (String)excelName, (String)sheetName, SysHsContrastExportVo.class, (String)excelName, (boolean)true, (HttpServletResponse)response);
            } else {
                List collect = sysHsContrastExportList.stream().filter(obj -> Objects.isNull(obj.getHsDrugCode())).collect(Collectors.toList());
                String excelName = "\u836f\u54c1\u672a\u5bf9\u7167\u76ee\u5f55";
                String sheetName = "\u836f\u54c1\u76ee\u5f55";
                ExcelUtils.exportExcel(collect, (String)excelName, (String)sheetName, SysHsContrastExportVo.class, (String)excelName, (boolean)true, (HttpServletResponse)response);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ResponseData importContrast(String type, List<SysHsContrastExportVo> sysHsContrastList, Integer tenantId) {
        try {
            if ("1".equals(type)) {
                sysHsContrastList.stream().forEach(sysHsContrastExportVo -> {
                    SysDrugEntity sysDrugEntity = new SysDrugEntity();
                    sysDrugEntity.setId(sysHsContrastExportVo.getDrugId());
                    SysHsInfoEntity sysHsInfoEntity = this.sysHsInfoMapper.queryByHsCode(tenantId, sysHsContrastExportVo.getHsDrugCode());
                    sysDrugEntity.setMedicalHsId(sysHsInfoEntity.getId());
                    sysDrugEntity.setMedicalInsuranceCode(sysHsContrastExportVo.getHsDrugCode());
                    sysDrugEntity.setMedicalInsuranceName(sysHsInfoEntity.getHsDrugName());
                    sysDrugEntity.setLevel(sysHsInfoEntity.getFeeLevel());
                    this.sysDrugMapper.updateById((Object)sysDrugEntity);
                });
            } else {
                sysHsContrastList.stream().forEach(sysHsContrastExportVo -> {
                    SysMaterialEntity sysMaterialEntity = new SysMaterialEntity();
                    sysMaterialEntity.setId(sysHsContrastExportVo.getDrugId());
                    SysHsInfoEntity sysHsInfoEntity = this.sysHsInfoMapper.queryByHsCode(tenantId, sysHsContrastExportVo.getHsDrugCode());
                    sysMaterialEntity.setMedicalHsId(sysHsInfoEntity.getId());
                    sysMaterialEntity.setMedicalInsuranceCode(sysHsContrastExportVo.getHsDrugCode());
                    sysMaterialEntity.setMedicalInsuranceName(sysHsInfoEntity.getHsDrugName());
                    sysMaterialEntity.setLevel(sysHsInfoEntity.getFeeLevel());
                    this.sysMaterialMapper.updateById((Object)sysMaterialEntity);
                });
            }
            return ResponseData.success();
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseData.error((String)"\u5bfc\u5165\u5931\u8d25");
        }
    }

    public ResponseData batchContrast(List<SysDrugEntity> drugList) {
        drugList.stream().forEach(sysDrugEntity -> this.sysDrugMapper.updateById(sysDrugEntity));
        return ResponseData.success();
    }

    public ResponseData updateHsDrugInfo(SysHsInfoEntity sysHsInfoEntity) {
        if (this.sysHsInfoMapper.updateById((Object)sysHsInfoEntity) > 0) {
            return ResponseData.success();
        }
        return ResponseData.error((String)"\u4fee\u6539\u5931\u8d25");
    }

    public ResponseData<SysHsInfoEntity> hsDrugInfoDetail(Integer id, Integer tenantId) {
        return ResponseData.success((Object)this.sysHsInfoMapper.selectById((Serializable)id));
    }

    public ResponseData<SysHsInfoEntity> insertHsDrug(SysHsInfoEntity sysHsInfoEntity) {
        this.sysHsInfoMapper.insert((Object)sysHsInfoEntity);
        return ResponseData.success();
    }

    public ResponseData<PageResult<SysChargeItemHsInfoEntity>> hsChargeInfo(SysHsDrugDto hsDrugDto) {
        PageHelper.startPage((int)hsDrugDto.getCurrent(), (int)hsDrugDto.getSize());
        List hsDrugInfoList = this.sysChargeItemHsInfoMapper.queryChargeInfo(hsDrugDto);
        PageInfo pageInfo = new PageInfo(hsDrugInfoList);
        PageResult pageResult = new PageResult(hsDrugDto.getCurrent().intValue(), hsDrugDto.getSize().intValue());
        pageResult.setTotal(Integer.parseInt(String.valueOf(pageInfo.getTotal())));
        pageResult.setPages(pageInfo.getPages());
        pageResult.setRecords(hsDrugInfoList);
        pageResult.setCurrent(hsDrugDto.getCurrent().intValue());
        pageResult.setSize(hsDrugDto.getSize().intValue());
        return ResponseData.success((Object)pageResult);
    }

    static {
        medicalChargeCategoryMap.put("\u897f\u836f\u8d39", "1");
        medicalChargeCategoryMap.put("\u4e2d\u6210\u836f\u8d39", "2");
        medicalChargeCategoryMap.put("\u4e2d\u8349\u8d39", "3");
    }
}

