/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.sys.api.dto.SysMaterialDto;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.material.SysMaterialEntity;
import com.byh.sys.api.util.UUIDUtils;
import com.byh.sys.data.repository.SysMaterialMapper;
import com.byh.sys.web.service.SysMaterialService;
import enums.ConstantsEnums;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class SysMaterialServiceImpl
extends ServiceImpl<SysMaterialMapper, SysMaterialEntity>
implements SysMaterialService {
    private static final Logger log = LoggerFactory.getLogger(SysMaterialServiceImpl.class);

    public IPage<SysMaterialEntity> pageList(Page<SysMaterialEntity> page, SysMaterialDto dto) {
        LambdaQueryWrapper qw = Wrappers.lambdaQuery();
        qw.eq(SysMaterialEntity::getDelFlag, (Object)ConstantsEnums.DEL_FLAG_ZERO.getValue());
        if (StrUtil.isNotEmpty((CharSequence)dto.getSearch())) {
            qw.and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.like(SysMaterialEntity::getMaterialName, (Object)dto.getSearch())).or()).like(SysMaterialEntity::getMaterialPinyin, (Object)dto.getSearch())).or()).like(SysMaterialEntity::getThirdCode, (Object)dto.getSearch());
            });
        }
        if (StrUtil.isNotEmpty((CharSequence)dto.getMaterialType())) {
            qw.eq(SysMaterialEntity::getMaterialType, (Object)dto.getMaterialType());
        }
        if (StrUtil.isNotEmpty((CharSequence)dto.getStatus())) {
            qw.eq(SysMaterialEntity::getStatus, (Object)dto.getStatus());
        }
        qw.eq(SysMaterialEntity::getTenantId, (Object)dto.getTenantId());
        qw.orderByDesc(SysMaterialEntity::getCreateTime);
        IPage materialEntityIPage = ((SysMaterialMapper)this.baseMapper).selectPage(page, (Wrapper)qw);
        List list = materialEntityIPage.getRecords();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (SysMaterialEntity n : list) {
                n.setDrugsId(n.getId());
                n.setDrugsName(n.getMaterialName());
                n.setUnit(n.getPackLargeUnits());
                n.setSpecifications(n.getMaterialSpecifications());
            }
        }
        return materialEntityIPage;
    }

    public void saveUpdate(SysMaterialEntity entity) {
        if (StrUtil.isEmpty((CharSequence)entity.getId())) {
            if (StrUtil.isEmpty((CharSequence)entity.getMaterialName())) {
                throw new BusinessException("\u6750\u6599\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01{materialName}");
            }
            if (StrUtil.isEmpty((CharSequence)entity.getMaterialSpecifications())) {
                throw new BusinessException("\u6750\u6599\u89c4\u683c\u4e0d\u80fd\u4e3a\u7a7a\uff01{materialSpecifications}");
            }
            if (StrUtil.isEmpty((CharSequence)entity.getAccountingSubjects())) {
                throw new BusinessException("\u6838\u7b97\u79d1\u76ee\u4e0d\u80fd\u4e3a\u7a7a\uff01{accountingSubjects}");
            }
            if (StrUtil.isEmpty((CharSequence)entity.getMaterialType())) {
                throw new BusinessException("\u6750\u6599\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01{materialType}");
            }
            if (StrUtil.isEmpty((CharSequence)entity.getManufacturer())) {
                throw new BusinessException("\u751f\u4ea7\u5382\u5bb6\u4e0d\u80fd\u4e3a\u7a7a\uff01{manufacturer}");
            }
            if (null == entity.getRetailPrice() && "".equals(entity.getRetailPrice())) {
                throw new BusinessException("\u96f6\u552e\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\uff01{retailPrice}");
            }
            String guiID = UUIDUtils.getRandom((int)5, (boolean)true);
            entity.setId(guiID);
            ((SysMaterialMapper)this.baseMapper).insert((Object)entity);
        } else {
            ((SysMaterialMapper)this.baseMapper).updateById((Object)entity);
        }
    }

    public Boolean removeMaterial(Long[] ids) {
        if (ObjectUtils.isEmpty((Object[])ids)) {
            throw new BusinessException("\u6750\u6599\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u4e3a\u7a7a\uff01{ids}\uff01");
        }
        return ((SysMaterialMapper)this.baseMapper).removeMaterial(ids);
    }

    public SysMaterialEntity details(SysMaterialEntity entity) {
        return (SysMaterialEntity)((SysMaterialMapper)this.baseMapper).selectById((Serializable)entity);
    }
}

