/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.sys.api.dto.SysUserRoleDto;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.SysDoctorEntity;
import com.byh.sys.api.model.SysRoleEntity;
import com.byh.sys.api.model.SysUserRoleEntity;
import com.byh.sys.api.model.base.BaseEntity;
import com.byh.sys.api.model.department.SysDepartmentEntity;
import com.byh.sys.api.vo.DictValueVo;
import com.byh.sys.api.vo.SysDoctorVo;
import com.byh.sys.data.repository.SysDictMapper;
import com.byh.sys.data.repository.SysUserRoleMapper;
import com.byh.sys.web.service.SysDepartmentService;
import com.byh.sys.web.service.SysRoleService;
import com.byh.sys.web.service.SysUserRoleService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class SysUserRoleServiceImpl
extends ServiceImpl<SysUserRoleMapper, SysUserRoleEntity>
implements SysUserRoleService {
    private final SysDictMapper sysDictMapper;
    private static final String dictDuties = "sys_doctor_duties";
    private static final String doctorTitle = "sys_doctor_title";
    private final SysDepartmentService sysDepartmentService;
    private final SysRoleService sysRoleService;

    public int bindingUserRole(SysUserRoleEntity entity) {
        if (StrUtil.isEmpty((CharSequence)entity.getRoleId().toString())) {
            throw new BusinessException("\u89d2\u8272\u8868\u4e3b\u952eroleId\u4e0d\u80fd\u4e3a\u7a7a\uff01{roleId}" + entity.getRoleId());
        }
        if (StrUtil.isEmpty((CharSequence)entity.getUserId().toString())) {
            throw new BusinessException("\u7528\u6237\u8868\u4e3b\u952euserId\u4e0d\u80fd\u4e3a\u7a7a\uff01{userId}" + entity.getUserId());
        }
        SysUserRoleEntity userRoleEntity = (SysUserRoleEntity)((SysUserRoleMapper)this.baseMapper).selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysUserRoleEntity::getRoleId, (Object)entity.getRoleId())).eq(SysUserRoleEntity::getUserId, (Object)entity.getUserId()));
        if (!StrUtil.isBlankIfStr((Object)userRoleEntity)) {
            throw new BusinessException("\u5f53\u524d\u7528\u6237\u89d2\u8272\u5173\u7cfb\u5df2\u7ed1\u5b9a\u8fc7\u3002\u4e0d\u80fd\u91cd\u590d\u7ed1\u5b9a\uff01{userRoleEntity}" + userRoleEntity);
        }
        entity.setCreateTime(new Date());
        return ((SysUserRoleMapper)this.baseMapper).insert((Object)entity);
    }

    public SysUserRoleEntity details(SysUserRoleEntity entity) {
        LambdaQueryWrapper qw = Wrappers.lambdaQuery();
        if (StrUtil.isNotEmpty((CharSequence)entity.getId().toString())) {
            qw.eq(SysUserRoleEntity::getId, (Object)entity.getId());
        }
        if (StrUtil.isNotEmpty((CharSequence)entity.getUserId().toString())) {
            qw.eq(SysUserRoleEntity::getUserId, (Object)entity.getUserId());
        }
        if (StrUtil.isNotEmpty((CharSequence)entity.getRoleId().toString())) {
            qw.eq(SysUserRoleEntity::getRoleId, (Object)entity.getRoleId());
        }
        return (SysUserRoleEntity)((SysUserRoleMapper)this.baseMapper).selectOne((Wrapper)qw);
    }

    public int removeUserRole(Integer userRoleId) {
        return ((SysUserRoleMapper)this.baseMapper).delete((Wrapper)Wrappers.lambdaQuery().eq(SysUserRoleEntity::getId, (Object)userRoleId));
    }

    public IPage<SysDoctorVo> userRolePage(Page<SysDoctorVo> page, SysUserRoleDto dto) {
        IPage sysDoctorEntityIPage = ((SysUserRoleMapper)this.baseMapper).userRolePage(page, dto);
        List records = sysDoctorEntityIPage.getRecords();
        if (CollectionUtil.isNotEmpty((Collection)records)) {
            records.forEach(a -> {
                SysRoleEntity roleEntity;
                SysDepartmentEntity one;
                if (StrUtil.isNotEmpty((CharSequence)a.getDuties())) {
                    a.setType(dictDuties);
                    a.setParameters(a.getDuties());
                    DictValueVo dutiesVo = this.sysDictMapper.querySysDictValue(a);
                    if (!StrUtil.isEmptyIfStr((Object)dutiesVo)) {
                        a.setDutiesName(dutiesVo.getLabel());
                    }
                }
                if (StrUtil.isNotEmpty((CharSequence)a.getDoctorTitle())) {
                    a.setType(doctorTitle);
                    a.setParameters(a.getDoctorTitle());
                    DictValueVo doctorTitleVo = this.sysDictMapper.querySysDictValue(a);
                    if (!StrUtil.isEmptyIfStr((Object)doctorTitleVo)) {
                        a.setDoctorTitleName(doctorTitleVo.getLabel());
                    }
                }
                if (StrUtil.isNotEmpty((CharSequence)a.getDepartmentId()) && null != (one = (SysDepartmentEntity)this.sysDepartmentService.getOne((Wrapper)Wrappers.lambdaQuery().eq(BaseEntity::getId, (Object)a.getDepartmentId())))) {
                    a.setDepartmentName(one.getDepartmentName());
                }
                if (!StrUtil.isEmptyIfStr((Object)(roleEntity = this.sysRoleService.queryRole((SysDoctorEntity)a)))) {
                    a.setRoleId(roleEntity.getId().toString());
                    a.setRoleName(roleEntity.getRoleName());
                }
            });
        }
        return sysDoctorEntityIPage;
    }

    public void deleteUserRole(Integer userId) {
        ((SysUserRoleMapper)this.baseMapper).deleteUserRole(userId);
    }

    private IPage getPages(Integer currentPage, Integer pageSize, List list) {
        Page page = new Page();
        if (list == null) {
            return null;
        }
        int size = list.size();
        if (pageSize > size) {
            pageSize = size;
        }
        if (pageSize != 0) {
            int maxPage;
            int n = maxPage = size % pageSize == 0 ? size / pageSize : size / pageSize + 1;
            if (currentPage > maxPage) {
                currentPage = maxPage;
            }
        }
        int curIdx = currentPage > 1 ? (currentPage - 1) * pageSize : 0;
        ArrayList pageList = new ArrayList();
        for (int i = 0; i < pageSize && curIdx + i < size; ++i) {
            pageList.add(list.get(curIdx + i));
        }
        page.setCurrent((long)currentPage.intValue()).setSize((long)pageSize.intValue()).setTotal((long)list.size()).setRecords(pageList);
        return page;
    }

    public SysUserRoleServiceImpl(SysDictMapper sysDictMapper, SysDepartmentService sysDepartmentService, SysRoleService sysRoleService) {
        this.sysDictMapper = sysDictMapper;
        this.sysDepartmentService = sysDepartmentService;
        this.sysRoleService = sysRoleService;
    }
}

