/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.mvc.config.es;

import java.util.List;
import java.util.Map;

public class EsPage {
    private int currentPage;
    private int pageSize;
    private int recordCount;
    private List<Map<String, Object>> recordList;
    private int pageCount;
    private int beginPageIndex;
    private int endPageIndex;

    public EsPage(int currentPage, int pageSize, int recordCount, List<Map<String, Object>> recordList) {
        this.currentPage = currentPage;
        this.pageSize = pageSize;
        this.recordCount = recordCount;
        this.recordList = recordList;
        this.pageCount = (recordCount + pageSize - 1) / pageSize;
        if (this.pageCount <= 10) {
            this.beginPageIndex = 1;
            this.endPageIndex = this.pageCount;
        } else {
            this.beginPageIndex = currentPage - 4;
            this.endPageIndex = currentPage + 5;
            if (this.beginPageIndex < 1) {
                this.beginPageIndex = 1;
                this.endPageIndex = 10;
            }
            if (this.endPageIndex > this.pageCount) {
                this.endPageIndex = this.pageCount;
                this.beginPageIndex = this.pageCount - 10 + 1;
            }
        }
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public List<Map<String, Object>> getRecordList() {
        return this.recordList;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public int getBeginPageIndex() {
        return this.beginPageIndex;
    }

    public int getEndPageIndex() {
        return this.endPageIndex;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setRecordCount(int recordCount) {
        this.recordCount = recordCount;
    }

    public void setRecordList(List<Map<String, Object>> recordList) {
        this.recordList = recordList;
    }

    public void setPageCount(int pageCount) {
        this.pageCount = pageCount;
    }

    public void setBeginPageIndex(int beginPageIndex) {
        this.beginPageIndex = beginPageIndex;
    }

    public void setEndPageIndex(int endPageIndex) {
        this.endPageIndex = endPageIndex;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EsPage)) {
            return false;
        }
        EsPage other = (EsPage)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getCurrentPage() != other.getCurrentPage()) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        if (this.getRecordCount() != other.getRecordCount()) {
            return false;
        }
        List this$recordList = this.getRecordList();
        List other$recordList = other.getRecordList();
        if (this$recordList == null ? other$recordList != null : !((Object)this$recordList).equals(other$recordList)) {
            return false;
        }
        if (this.getPageCount() != other.getPageCount()) {
            return false;
        }
        if (this.getBeginPageIndex() != other.getBeginPageIndex()) {
            return false;
        }
        return this.getEndPageIndex() == other.getEndPageIndex();
    }

    protected boolean canEqual(Object other) {
        return other instanceof EsPage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCurrentPage();
        result = result * 59 + this.getPageSize();
        result = result * 59 + this.getRecordCount();
        List $recordList = this.getRecordList();
        result = result * 59 + ($recordList == null ? 43 : ((Object)$recordList).hashCode());
        result = result * 59 + this.getPageCount();
        result = result * 59 + this.getBeginPageIndex();
        result = result * 59 + this.getEndPageIndex();
        return result;
    }

    public String toString() {
        return "EsPage(currentPage=" + this.getCurrentPage() + ", pageSize=" + this.getPageSize() + ", recordCount=" + this.getRecordCount() + ", recordList=" + this.getRecordList() + ", pageCount=" + this.getPageCount() + ", beginPageIndex=" + this.getBeginPageIndex() + ", endPageIndex=" + this.getEndPageIndex() + ")";
    }
}

