/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.mvc.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.sys.api.annotation.AntiRefresh;
import com.byh.sys.api.dto.material.reportCount.SysReportCountDto;
import com.byh.sys.api.excel.MSInventoryExcel;
import com.byh.sys.api.excel.SysReportCountDetailExcel;
import com.byh.sys.api.excel.SysReportCountExcel;
import com.byh.sys.api.model.dict.SysDictValueEntity;
import com.byh.sys.api.model.excel.CardNoImportExcel;
import com.byh.sys.api.util.BeanUtil;
import com.byh.sys.api.util.EasyExcelUtil;
import com.byh.sys.api.util.HyposensitizationUtil;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.api.util.StringUtils;
import com.byh.sys.api.vo.report.OutPrescriptionReportVo;
import com.byh.sys.api.vo.report.SysOutPatientGiveDrugDetailVo;
import com.byh.sys.api.vo.report.SysReportDrugSaleVo;
import com.byh.sys.data.repository.SysDictValueMapper;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.ReportCountService;
import io.swagger.annotations.ApiImplicitParam;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/reportCount"})
public class ReportCountController {
    private static final Logger log = LoggerFactory.getLogger(ReportCountController.class);
    @Autowired
    private ReportCountService reportCountService;
    @Autowired
    private CommonRequest commonRequest;
    @Autowired
    private SysDictValueMapper sysDictValueMapper;

    @GetMapping(value={"/getMaterial/PSInventory"})
    @AntiRefresh
    public ResponseData getMaterialPSInventory(Page page, SysReportCountDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        IPage list = this.reportCountService.getMaterialPSInventory(page, dto);
        return ResponseData.success((Object)list);
    }

    @GetMapping(value={"/getMaterial/PSInventoryExport"})
    @AntiRefresh
    public void getMaterialPSInventoryExport(HttpServletResponse response, Page page, SysReportCountDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        page.setCurrent(1L);
        page.setSize(999999999999999999L);
        IPage list = this.reportCountService.getMaterialPSInventory(page, dto);
        List records = list.getRecords();
        List msInventoryExcels = BeanUtil.copyList((List)records, MSInventoryExcel.class);
        msInventoryExcels.stream().forEach(item -> {
            item.setOpenCountStr(item.getOpenCount() + "");
            item.setInQuantityStr(item.getInQuantity() + "");
            item.setOutQuantityStr(item.getOutQuantity() + "");
            item.setCloseCountStr(item.getCloseCount().toPlainString());
            item.setClosePurchaseAmountStr(item.getOpenPurchaseAmount().toPlainString());
            item.setOpenPurchaseAmountStr(item.getOpenPurchaseAmount().toPlainString());
            item.setCloseRetailPriceAmountStr(item.getCloseRetailPriceAmount().toPlainString());
            item.setInPurchasePriceAmountStr(item.getInPurchasePriceAmount().toPlainString());
            item.setInRetailPriceAmountStr(item.getInRetailPriceAmount().toPlainString());
            item.setOpenRetailPriceAmountStr(item.getOpenRetailPriceAmount().toPlainString());
            item.setOpenRetailPriceAmountStr(item.getOpenRetailPriceAmount().toPlainString());
            item.setOutPurchasePriceAmountStr(item.getOutPurchasePriceAmount().toPlainString());
            item.setOutRetailPriceAmountStr(item.getOutRetailPriceAmount().toPlainString());
        });
        EasyExcelUtil.exportExcel((HttpServletResponse)response, (String)"\u8fdb\u9500\u5b58\u6c47\u603b", (String)"\u8fdb\u9500\u5b58\u6c47\u603b", (List)msInventoryExcels, MSInventoryExcel.class);
    }

    @GetMapping(value={"/getMaterialIn"})
    @AntiRefresh
    public ResponseData getMaterialIn(Page page, SysReportCountDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        IPage list = this.reportCountService.getMaterialIn(page, dto);
        return ResponseData.success((Object)list);
    }

    @GetMapping(value={"/getMaterialOut"})
    @AntiRefresh
    public ResponseData getMaterialOut(Page page, SysReportCountDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        IPage list = this.reportCountService.getMaterialOut(page, dto);
        return ResponseData.success((Object)list);
    }

    @GetMapping(value={"/getMaterialOutExport"})
    @AntiRefresh
    public void getMaterialOutExport(HttpServletResponse response, SysReportCountDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        List materialsOutStoreType = this.sysDictValueMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(SysDictValueEntity::getType, (Object)"materials_out_store_type"));
        Map<String, String> dictMap = materialsOutStoreType.stream().collect(Collectors.toMap(SysDictValueEntity::getValue, SysDictValueEntity::getLabel));
        List list = this.reportCountService.getMaterialOutExcel(dto);
        list.forEach(item -> {
            String outboundMethod = item.getOutboundMethod();
            item.setOutboundMethod((String)dictMap.get(outboundMethod));
        });
        EasyExcelUtil.exportExcel((HttpServletResponse)response, (String)"\u51fa\u5165\u5e93\u6c47\u603b", (String)"\u51fa\u5165\u5e93\u6c47\u603b", (List)list, SysReportCountExcel.class);
    }

    @GetMapping(value={"/getMaterialInDetail"})
    @AntiRefresh
    public ResponseData getMaterialInDetail(Page page, SysReportCountDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        IPage list = this.reportCountService.getMaterialInDetail(page, dto);
        return ResponseData.success((Object)list);
    }

    @GetMapping(value={"/getMaterialInDetailExcel"})
    @AntiRefresh
    public void getMaterialInDetailExcel(HttpServletResponse response, SysReportCountDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        List materialsOutStoreType = this.sysDictValueMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(SysDictValueEntity::getType, (Object)"materials_in_store_type"));
        Map<String, String> dictMap = materialsOutStoreType.stream().collect(Collectors.toMap(SysDictValueEntity::getValue, SysDictValueEntity::getLabel));
        List unitDicts = this.sysDictValueMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(SysDictValueEntity::getType, (Object)"usage_unit"));
        Map<String, String> unitDictMap = unitDicts.stream().collect(Collectors.toMap(SysDictValueEntity::getValue, SysDictValueEntity::getLabel));
        List list = this.reportCountService.getMaterialInDetailExcel(dto);
        list.stream().forEach(item -> {
            String drugsType;
            String outboundMethod = item.getWarehousingMethod();
            item.setWarehousingMethod((String)dictMap.get(outboundMethod));
            item.setUnitName((String)unitDictMap.get(item.getUnit()));
            switch (drugsType = item.getDrugsType()) {
                case "1": {
                    item.setDrugsType("\u533b\u7597\u5668\u6750");
                    break;
                }
                case "2": {
                    item.setDrugsType("\u533b\u7528\u8017\u6750");
                    break;
                }
                case "3": {
                    item.setDrugsType("\u5b9e\u9a8c\u5ba4\u8017\u6750");
                    break;
                }
                case "4": {
                    item.setDrugsType("\u5b9e\u9a8c\u5ba4\u8bd5\u5242");
                    break;
                }
                case "5": {
                    item.setDrugsType("\u6d88\u6bd2\u7528\u54c1");
                    break;
                }
                case "6": {
                    item.setDrugsType("\u5176\u4ed6");
                }
            }
        });
        EasyExcelUtil.exportExcel((HttpServletResponse)response, (String)"\u6750\u6599\u51fa\u5165\u5e93\u660e\u7ec6\u5bfc\u51fa", (String)"\u6750\u6599\u51fa\u5165\u5e93\u660e\u7ec6\u5bfc\u51fa", (List)list, SysReportCountDetailExcel.class);
    }

    @GetMapping(value={"/getMaterialOutDetail"})
    @AntiRefresh
    public ResponseData getMaterialOutDetail(Page page, SysReportCountDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        IPage list = this.reportCountService.getMaterialOutDetail(page, dto);
        return ResponseData.success((Object)list);
    }

    @GetMapping(value={"/getMaterialOutDetailExcel"})
    @AntiRefresh
    public void getMaterialOutDetailExcel(HttpServletResponse response, SysReportCountDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        List materialsOutStoreType = this.sysDictValueMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(SysDictValueEntity::getType, (Object)"materials_out_store_type"));
        Map<String, String> dictMap = materialsOutStoreType.stream().collect(Collectors.toMap(SysDictValueEntity::getValue, SysDictValueEntity::getLabel));
        List unitDicts = this.sysDictValueMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(SysDictValueEntity::getType, (Object)"usage_unit"));
        Map<String, String> unitDictMap = unitDicts.stream().collect(Collectors.toMap(SysDictValueEntity::getValue, SysDictValueEntity::getLabel));
        List list = this.reportCountService.getMaterialOutDetailExcel(dto);
        list.stream().forEach(item -> {
            String drugsType;
            String outboundMethod = item.getWarehousingMethod();
            item.setWarehousingMethod((String)dictMap.get(outboundMethod));
            item.setUnitName((String)unitDictMap.get(item.getUnit()));
            switch (drugsType = item.getDrugsType()) {
                case "1": {
                    item.setDrugsType("\u533b\u7597\u5668\u6750");
                    break;
                }
                case "2": {
                    item.setDrugsType("\u533b\u7528\u8017\u6750");
                    break;
                }
                case "3": {
                    item.setDrugsType("\u5b9e\u9a8c\u5ba4\u8017\u6750");
                    break;
                }
                case "4": {
                    item.setDrugsType("\u5b9e\u9a8c\u5ba4\u8bd5\u5242");
                    break;
                }
                case "5": {
                    item.setDrugsType("\u6d88\u6bd2\u7528\u54c1");
                    break;
                }
                case "6": {
                    item.setDrugsType("\u5176\u4ed6");
                }
            }
        });
        EasyExcelUtil.exportExcel((HttpServletResponse)response, (String)"\u6750\u6599\u51fa\u5165\u5e93\u660e\u7ec6\u5bfc\u51fa", (String)"\u6750\u6599\u51fa\u5165\u5e93\u660e\u7ec6\u5bfc\u51fa", (List)list, SysReportCountDetailExcel.class);
    }

    @GetMapping(value={"/getDrug/PSInventory"})
    @AntiRefresh
    public ResponseData getDrugPSInventory(Page page, SysReportCountDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        IPage list = this.reportCountService.getDrugPSInventory(page, dto);
        return ResponseData.success((Object)list);
    }

    @GetMapping(value={"/drugPharmacyDispensing/count"})
    @AntiRefresh
    public ResponseData getDrugPharmacyDispensing(Page page, SysReportCountDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        IPage list = this.reportCountService.getDrugPharmacyDispensing(page, dto);
        return ResponseData.success((Object)list);
    }

    @GetMapping(value={"/getDrugPharmacyIn"})
    @AntiRefresh
    public ResponseData getDrugPharmacyIn(Page page, SysReportCountDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        IPage list = this.reportCountService.getDrugPharmacyIn(page, dto);
        return ResponseData.success((Object)list);
    }

    @GetMapping(value={"/getDrugPharmacyOut"})
    @AntiRefresh
    public ResponseData getDrugPharmacyOut(Page page, SysReportCountDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        IPage list = this.reportCountService.getDrugPharmacyOut(page, dto);
        return ResponseData.success((Object)list);
    }

    @GetMapping(value={"/getDrugPharmacyInDetail"})
    @AntiRefresh
    public ResponseData getDrugPharmacyInDetail(Page page, SysReportCountDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        IPage vo = this.reportCountService.getDrugPharmacyInDetail(page, dto);
        return ResponseData.success((Object)vo);
    }

    @GetMapping(value={"/getDrugPharmacyOutDetail"})
    @AntiRefresh
    public ResponseData getDrugPharmacyOutDetail(Page page, SysReportCountDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        IPage list = this.reportCountService.getDrugPharmacyOutDetail(page, dto);
        return ResponseData.success((Object)list);
    }

    @GetMapping(value={"/outPatientGiveDrugDetail"})
    @AntiRefresh
    public ResponseData outPatientGiveDrugDetail(Page<SysOutPatientGiveDrugDetailVo> page, SysReportCountDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        IPage list = this.reportCountService.outPatientGiveDrugDetail(page, dto);
        return ResponseData.success((Object)list);
    }

    @GetMapping(value={"/outPatientGiveDrugDetail/export"})
    @AntiRefresh
    public void outPatientGiveDrugDetailExport(HttpServletResponse response, Page page, SysReportCountDto dto) throws IOException {
        dto.setTenantId(this.commonRequest.getTenant());
        this.reportCountService.outPatientGiveDrugDetailExport(response, page, dto);
    }

    @GetMapping(value={"/drugSale"})
    public ResponseData drugSale(Page page, SysReportCountDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        IPage list = this.reportCountService.drugSale(page, dto);
        return ResponseData.success((Object)list);
    }

    @GetMapping(value={"/drugSale/count"})
    public ResponseData drugSaleCount(SysReportCountDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        SysReportDrugSaleVo list = this.reportCountService.drugSaleCount(dto);
        return ResponseData.success((Object)list);
    }

    @GetMapping(value={"/drugSale/export"})
    public void drugSaleExport(HttpServletResponse response, Page page, SysReportCountDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        this.reportCountService.drugSaleExport(response, page, dto);
    }

    @PostMapping(value={"/prescriptionDetail"})
    @AntiRefresh
    public ResponseData prescriptionDetail(Page<OutPrescriptionReportVo> page, @RequestBody SysReportCountDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        page.setSize((long)dto.getSize());
        page.setCurrent((long)dto.getCurrent());
        String cardNos = dto.getCardNos();
        if (!StringUtils.isBlank((String)cardNos)) {
            String[] split = cardNos.split(",");
            List<String> cardNoList = Arrays.asList(split);
            dto.setCardNoList(cardNoList);
        }
        IPage list = this.reportCountService.prescriptionDetail(page, dto);
        for (OutPrescriptionReportVo record : list.getRecords()) {
            String patientName = HyposensitizationUtil.hyposensitizationForName((String)record.getPatientName());
            record.setPatientName(patientName);
        }
        return ResponseData.success((Object)list);
    }

    @PostMapping(value={"/checkCardNo"})
    @AntiRefresh
    @ApiImplicitParam(name="file", value="\u6587\u4ef6\u5bf9\u8c61", dataType="File")
    public ResponseData checkCardNo(@RequestParam(value="file") MultipartFile file) throws IOException {
        StringBuilder sb = new StringBuilder("");
        String st = EasyExcelUtil.importExcelMerge((MultipartFile)file, (Object)new CardNoImportExcel());
        JSONArray objects = JSONArray.parseArray((String)st);
        for (int i = 0; i < objects.size(); ++i) {
            Object o = objects.get(i);
            Object cardNo = JSONObject.parseObject((String)o.toString()).get((Object)"cardNo");
            sb.append(cardNo);
            if (i == objects.size() - 1) continue;
            sb.append(",");
        }
        return ResponseData.success((Object)sb.toString());
    }

    @PostMapping(value={"/CardNoTemplate"})
    @AntiRefresh
    public void CardNoTemplate(HttpServletResponse response) throws IOException {
        EasyExcelUtil.customTemplateExport((HttpServletResponse)response, (String)"CardNoImport", (String)"CardNoImport");
    }

    @PostMapping(value={"/prescriptionDetail/export"})
    @AntiRefresh
    public void prescriptionDetailExport(HttpServletResponse response, Page page, @RequestBody SysReportCountDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        page.setSize((long)dto.getSize());
        page.setCurrent((long)dto.getCurrent());
        String cardNos = dto.getCardNos();
        if (!StringUtils.isBlank((String)cardNos)) {
            String[] split = cardNos.split(",");
            List<String> cardNoList = Arrays.asList(split);
            dto.setCardNoList(cardNoList);
        }
        this.reportCountService.prescriptionDetailExport(response, page, dto);
    }

    @GetMapping(value={"/getDrug/PSInventory/export"})
    @AntiRefresh
    public void getDrugPSInventoryExport(HttpServletResponse response, Page page, SysReportCountDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        this.reportCountService.getDrugPSInventoryExport(response, page, dto);
    }

    @GetMapping(value={"/getDrugPharmacyInOutDetail/export"})
    @AntiRefresh
    public void getDrugPharmacyInOutDetailExport(HttpServletResponse response, Page page, SysReportCountDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        this.reportCountService.getDrugPharmacyInOutDetailExport(response, page, dto);
    }

    @GetMapping(value={"/drugPharmacyDispensing/count/export"})
    @AntiRefresh
    public void getDrugPharmacyDispensingExport(HttpServletResponse response, Page page, SysReportCountDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        this.reportCountService.getDrugPharmacyDispensingExport(response, page, dto);
    }
}

