/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.mvc.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.sys.api.annotation.AntiRefresh;
import com.byh.sys.api.dto.SysOperLogDto;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.SysOperLogEntity;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.SysOperLogService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"sysOperLog"})
public class SysOperLogController {
    private static final Logger log = LoggerFactory.getLogger(SysOperLogController.class);
    private static Logger logger = LoggerFactory.getLogger(SysOperLogController.class);
    private final SysOperLogService sysOperLogService;
    @Autowired
    private CommonRequest commonRequest;

    @ApiOperation(value="\u64cd\u4f5c\u65e5\u5fd7\u8bb0\u5f55\u5217\u8868\u5206\u9875", httpMethod="GET", notes="\u64cd\u4f5c\u65e5\u5fd7\u8bb0\u5f55\u5217\u8868\u5206\u9875")
    @GetMapping(value={"/pageList"})
    @AntiRefresh
    public ResponseData pageList(Page page, SysOperLogDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        return ResponseData.success((Object)this.sysOperLogService.pageList(page, dto));
    }

    @ApiOperation(value="\u8be6\u60c5", httpMethod="GET", notes="\u8be6\u60c5")
    @GetMapping(value={"/getInfo"})
    @AntiRefresh
    public ResponseData getInfo(Integer operLogId) {
        if (StrUtil.isEmpty((CharSequence)String.valueOf(operLogId))) {
            throw new BusinessException("\u64cd\u4f5c\u65e5\u5fd7\u8bb0\u5f55\u8868\u4e3b\u952emenuId\u4e0d\u80fd\u4e3a\u7a7a\uff01{id}" + operLogId);
        }
        return ResponseData.success((Object)this.sysOperLogService.getOne((Wrapper)Wrappers.lambdaQuery().eq(SysOperLogEntity::getId, (Object)operLogId)));
    }

    @PostMapping(value={"/removeSysOperLog"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", httpMethod="POST", notes="\u6279\u91cf\u5220\u9664")
    public ResponseData removeSysOperLog(@ApiParam(value="\u4e3b\u952e\u96c6\u5408", required=true) @RequestBody Long[] ids) {
        return ResponseData.success((Object)this.sysOperLogService.removeSysOperLog(ids)).msg("\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/addSysOperLog"})
    @ApiOperation(value="\u5404\u81ea\u670d\u52a1\u8c03\u7528\u64cd\u4f5c\u65e5\u5fd7", httpMethod="POST", notes="\u5404\u81ea\u670d\u52a1\u8c03\u7528\u64cd\u4f5c\u65e5\u5fd7")
    public ResponseData addSysOperLog(@RequestBody SysOperLogEntity entity) {
        return ResponseData.success((Object)this.sysOperLogService.save((Object)entity));
    }

    public SysOperLogController(SysOperLogService sysOperLogService) {
        this.sysOperLogService = sysOperLogService;
    }
}

