/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.mvc.controller;

import com.byh.sys.api.annotation.AntiRefresh;
import com.byh.sys.api.annotation.UserOptLogger;
import com.byh.sys.api.dto.purchasePlan.GeneratePurchasePlanDto;
import com.byh.sys.api.dto.purchasePlan.SelectPurchasePlanDetailPageDto;
import com.byh.sys.api.dto.purchasePlan.SelectPurchasePlanPageDto;
import com.byh.sys.api.model.purchasePlan.SysPurchasePlanEntity;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.SysPurchasePlanService;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sysPurchasePlan"})
public class SysPurchasePlanController {
    @Autowired
    private CommonRequest commonRequest;
    @Autowired
    private SysPurchasePlanService sysPurchasePlanService;

    @PostMapping(value={"/exportPurchasePlanList"})
    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u5230\u5904\u836f\u54c1\u91c7\u8d2d\u8ba1\u5212\u5217\u8868")
    @UserOptLogger(operation="\u5bfc\u51fa\u836f\u54c1\u91c7\u8d2d\u8ba1\u5212")
    public void exportPurchasePlanList(HttpServletResponse response, @RequestBody @Valid SelectPurchasePlanDetailPageDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        this.sysPurchasePlanService.exportPurchasePlanList(response, dto);
    }

    @PostMapping(value={"/updatePlan"})
    @ApiOperation(value="\u7f16\u8f91\u836f\u54c1\u91c7\u8d2d\u8ba1\u5212")
    public ResponseData updatePlan(@RequestBody SysPurchasePlanEntity entity) {
        entity.setUpdateId(this.commonRequest.getUserId());
        entity.setUpdateName(this.commonRequest.getUserName());
        this.sysPurchasePlanService.updatePlan(entity);
        return ResponseData.success((Object)"\u7f16\u8f91\u6210\u529f\uff01");
    }

    @PostMapping(value={"/deletePlanList"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u836f\u54c1\u91c7\u8d2d\u8ba1\u5212\uff08\u903b\u8f91\u5220\u9664\uff09")
    public ResponseData deletePlanList(@RequestBody Integer[] ids) {
        this.sysPurchasePlanService.deletePlanList(ids);
        return ResponseData.success((Object)"\u6279\u91cf\u5220\u9664\u6210\u529f\uff01");
    }

    @PostMapping(value={"/selectPageDetailList"})
    @ApiOperation(value="\u6839\u636e\u91c7\u8d2d\u8ba1\u5212\u4e3b\u952eID\u67e5\u8be2\u5bf9\u5e94\u7684\u660e\u7ec6\u5206\u9875\u6570\u636e")
    @AntiRefresh
    public ResponseData selectPageDetailList(@RequestBody @Valid SelectPurchasePlanDetailPageDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        return ResponseData.success((Object)this.sysPurchasePlanService.selectPageDetailList(dto));
    }

    @PostMapping(value={"/selectPageList"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u836f\u54c1\u91c7\u8d2d\u8ba1\u5212")
    @AntiRefresh
    public ResponseData selectPageList(@RequestBody SelectPurchasePlanPageDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        return ResponseData.success((Object)this.sysPurchasePlanService.selectPageList(dto));
    }

    @PostMapping(value={"/generatePurchasePlan"})
    @ApiOperation(value="\u751f\u6210\u836f\u54c1\u91c7\u8d2d\u8ba1\u5212")
    @UserOptLogger(operation="\u751f\u6210\u836f\u54c1\u91c7\u8d2d\u8ba1\u5212")
    public ResponseData generatePurchasePlan(@RequestBody GeneratePurchasePlanDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        dto.setOperatorId(this.commonRequest.getUserId());
        dto.setOperatorName(this.commonRequest.getUserName());
        this.sysPurchasePlanService.generatePurchasePlan(dto);
        return ResponseData.success((Object)"\u836f\u54c1\u91c7\u8d2d\u8ba1\u5212\u751f\u6210\u6210\u529f\uff01");
    }
}

