/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.mvc.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.byh.sys.api.annotation.AntiRefresh;
import com.byh.sys.api.annotation.UserOptLogger;
import com.byh.sys.api.dto.SysRoleDto;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.SysRoleEntity;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.SysRoleService;
import enums.ConstantsEnums;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"sysRole"})
public class SysRoleController {
    private static final Logger log = LoggerFactory.getLogger(SysRoleController.class);
    private static Logger logger = LoggerFactory.getLogger(SysRoleController.class);
    private final SysRoleService sysRoleService;
    @Autowired
    private CommonRequest commonRequest;

    @ApiOperation(value="\u89d2\u8272\u5217\u8868", httpMethod="GET", notes="\u89d2\u8272\u5217\u8868")
    @GetMapping(value={"/page"})
    @AntiRefresh
    public ResponseData page(SysRoleDto sysRoleDto) {
        sysRoleDto.setTenantId(this.commonRequest.getTenant());
        return ResponseData.success((Object)this.sysRoleService.page(sysRoleDto));
    }

    @ApiOperation(value="\u89d2\u8272\u5217\u8868", httpMethod="GET", notes="\u89d2\u8272\u5217\u8868")
    @GetMapping(value={"/pageList"})
    @AntiRefresh
    public ResponseData pageList(SysRoleDto sysRoleDto) {
        sysRoleDto.setTenantId(this.commonRequest.getTenant());
        return ResponseData.success((Object)this.sysRoleService.pageList(sysRoleDto));
    }

    @UserOptLogger(operation="\u89d2\u8272\u6a21\u5757")
    @PostMapping(value={"/saveUpdate"})
    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539", httpMethod="POST", notes="\u65b0\u589e\u6216\u4fee\u6539")
    public ResponseData saveUpdate(@RequestBody SysRoleEntity sysRoleEntity) {
        sysRoleEntity.setTenantId(this.commonRequest.getTenant());
        if (StrUtil.isEmpty((CharSequence)sysRoleEntity.getRoleName())) {
            throw new BusinessException("\u89d2\u8272\u540d\u79f0userName\u4e0d\u80fd\u4e3a\u7a7a\uff01{userName}");
        }
        SysRoleEntity one = (SysRoleEntity)this.sysRoleService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysRoleEntity::getDelFlag, (Object)ConstantsEnums.DEL_FLAG_ZERO.getValue())).eq(SysRoleEntity::getRoleName, (Object)sysRoleEntity.getRoleName()));
        if (null == sysRoleEntity.getId()) {
            if (!StrUtil.isEmptyIfStr((Object)one)) {
                throw new BusinessException("\u89d2\u8272\u540d\u79f0\u4e0d\u80fd\u91cd\u590d\uff01{one}" + one);
            }
            sysRoleEntity.setCreateTime(new Date());
        }
        return ResponseData.success((Object)this.sysRoleService.saveOrUpdate((Object)sysRoleEntity)).msg("\u4fdd\u5b58\u6216\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u8be6\u60c5", httpMethod="GET", notes="\u8be6\u60c5")
    @GetMapping(value={"/getInfo"})
    @AntiRefresh
    public ResponseData getInfo(Integer roleId) {
        if (StrUtil.isEmpty((CharSequence)String.valueOf(roleId))) {
            throw new BusinessException("\u89d2\u8272\u4e3b\u952emenuId\u4e0d\u80fd\u4e3a\u7a7a\uff01{id}" + roleId);
        }
        return ResponseData.success((Object)this.sysRoleService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysRoleEntity::getId, (Object)roleId)).eq(SysRoleEntity::getDelFlag, (Object)ConstantsEnums.DEL_FLAG_ZERO.getValue())));
    }

    @UserOptLogger(operation="\u89d2\u8272\u6a21\u5757")
    @PostMapping(value={"/removeSysRole"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", httpMethod="POST", notes="\u6279\u91cf\u5220\u9664")
    public ResponseData removeSysRole(@ApiParam(value="\u4e3b\u952e\u96c6\u5408", required=true) @RequestBody Long[] ids) {
        return ResponseData.success((Object)this.sysRoleService.removeSysRole(ids)).msg("\u5220\u9664\u6210\u529f");
    }

    public SysRoleController(SysRoleService sysRoleService) {
        this.sysRoleService = sysRoleService;
    }
}

