/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.mvc.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.sys.api.annotation.AntiRefresh;
import com.byh.sys.api.annotation.UserOptLogger;
import com.byh.sys.api.dto.templateManage.SysTemplateManageDto;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.SysTemplateManageService;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sysTemplateManage"})
public class SysTemplateManageController {
    @Autowired
    private SysTemplateManageService sysTemplateManageService;
    @Autowired
    private CommonRequest commonRequest;

    @PostMapping(value={"/list/select"})
    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u6a21\u677f\u5217\u8868\u4fe1\u606f\u5e76\u643a\u5e26\u5bf9\u5e94\u7684\u6a21\u677f\u660e\u7ec6\u5217\u8868\u4fe1\u606f")
    @AntiRefresh
    public ResponseData selectList(@RequestBody SysTemplateManageDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        dto.setUserId(this.commonRequest.getUserId());
        List list = this.sysTemplateManageService.selectList(dto);
        return ResponseData.success((Object)list);
    }

    @PostMapping(value={"/page/select"})
    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u6a21\u677f\u4fe1\u606f\u5206\u9875\u5217\u8868\u6570\u636e")
    @AntiRefresh
    public ResponseData selectPageList(@RequestBody SysTemplateManageDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        dto.setUserId(this.commonRequest.getUserId());
        dto.setRoleId(this.commonRequest.getUserInfo().getRoleId());
        Page page = this.sysTemplateManageService.selectPageList(dto);
        return ResponseData.success((Object)page);
    }

    @PostMapping(value={"/insert"})
    @ApiOperation(value="\u65b0\u589e\u6a21\u677f\u4ee5\u53ca\u5bf9\u5e94\u7684\u6a21\u677f\u660e\u7ec6")
    @UserOptLogger(operation="\u6a21\u677f\u7ba1\u7406\u6a21\u5757")
    public ResponseData insert(@RequestBody @Valid SysTemplateManageDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        dto.setCreateId(this.commonRequest.getUserId());
        dto.setCreateName(this.commonRequest.getUserName());
        this.sysTemplateManageService.insert(dto);
        return ResponseData.success().save();
    }

    @DeleteMapping(value={"/deleteList"})
    @ApiOperation(value="\u5220\u9664\u6a21\u677f\u4ee5\u53ca\u5bf9\u5e94\u7684\u6a21\u677f\u660e\u7ec6")
    @UserOptLogger(operation="\u6a21\u677f\u7ba1\u7406\u6a21\u5757")
    public ResponseData deleteList(@RequestBody Integer[] ids) {
        this.sysTemplateManageService.deleteList(ids);
        return ResponseData.success((Object)Thread.currentThread().getStackTrace()[1].getMethodName());
    }

    @PutMapping(value={"/update"})
    @ApiOperation(value="\u7f16\u8f91\u6a21\u677f\u4ee5\u53ca\u5bf9\u5e94\u7684\u6a21\u677f\u660e\u7ec6")
    @UserOptLogger(operation="\u6a21\u677f\u7ba1\u7406\u6a21\u5757")
    public ResponseData update(@RequestBody SysTemplateManageDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        dto.setUpdateId(this.commonRequest.getUserId());
        dto.setUpdateName(this.commonRequest.getUserName());
        this.sysTemplateManageService.update(dto);
        return ResponseData.success((Object)Thread.currentThread().getStackTrace()[1].getMethodName());
    }
}

